/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.AttributeSet;
import android.util.Log;
import android.view.RemotableViewMethod;
import android.view.View;
import android.widget.RemoteViews;
import com.android.internal.R;
import java.io.PrintStream;

@RemoteViews.RemoteView
public class ImageView
extends View {
    private static final Matrix.ScaleToFit[] sS2FArray;
    private static final ScaleType[] sScaleTypeArray;
    private boolean mAdjustViewBounds = false;
    private int mAlpha = 255;
    private boolean mBaselineAligned;
    private ColorFilter mColorFilter;
    private boolean mColorMod = false;
    private boolean mCropToPadding;
    private Matrix mDrawMatrix = null;
    private Drawable mDrawable = null;
    private int mDrawableHeight;
    private int mDrawableWidth;
    private boolean mHaveFrame = false;
    private int mLevel = 0;
    private Matrix mMatrix;
    private int mMaxHeight;
    private int mMaxWidth = Integer.MAX_VALUE;
    private boolean mMergeState = false;
    private int mResource = 0;
    private ScaleType mScaleType;
    private int[] mState = null;
    private RectF mTempDst;
    private RectF mTempSrc;
    private Uri mUri;
    private int mViewAlphaScale = 256;

    static {
        ScaleType scaleType = ScaleType.MATRIX;
        ScaleType scaleType2 = ScaleType.FIT_XY;
        ScaleType scaleType3 = ScaleType.FIT_START;
        ScaleType scaleType4 = ScaleType.FIT_CENTER;
        ScaleType scaleType5 = ScaleType.FIT_END;
        ScaleType scaleType6 = ScaleType.CENTER;
        ScaleType scaleType7 = ScaleType.CENTER_CROP;
        ScaleType scaleType8 = ScaleType.CENTER_INSIDE;
        ScaleType[] scaleTypeArray = new ScaleType[]{scaleType, scaleType2, scaleType3, scaleType4, scaleType5, scaleType6, scaleType7, scaleType8};
        sScaleTypeArray = scaleTypeArray;
        Matrix.ScaleToFit scaleToFit = Matrix.ScaleToFit.FILL;
        Matrix.ScaleToFit scaleToFit2 = Matrix.ScaleToFit.START;
        Matrix.ScaleToFit scaleToFit3 = Matrix.ScaleToFit.CENTER;
        Matrix.ScaleToFit scaleToFit4 = Matrix.ScaleToFit.END;
        Matrix.ScaleToFit[] scaleToFitArray = new Matrix.ScaleToFit[]{scaleToFit, scaleToFit2, scaleToFit3, scaleToFit4};
        sS2FArray = scaleToFitArray;
    }

    public ImageView(Context context) {
        super(context);
        RectF rectF;
        RectF rectF2;
        this.mMaxHeight = Integer.MAX_VALUE;
        this.mTempSrc = rectF2 = new RectF();
        this.mTempDst = rectF = new RectF();
        this.mBaselineAligned = false;
        this.initImageView();
    }

    public ImageView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ImageView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        boolean bl;
        int n2;
        boolean bl2;
        RectF rectF;
        RectF rectF2;
        this.mMaxHeight = Integer.MAX_VALUE;
        this.mTempSrc = rectF2 = new RectF();
        this.mTempDst = rectF = new RectF();
        this.mBaselineAligned = false;
        this.initImageView();
        int[] nArray = R.styleable.ImageView;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, n, 0);
        Drawable drawable2 = typedArray.getDrawable(0);
        if (drawable2 != null) {
            this.setImageDrawable(drawable2);
        }
        this.mBaselineAligned = bl2 = typedArray.getBoolean(6, false);
        boolean bl3 = typedArray.getBoolean(2, false);
        this.setAdjustViewBounds(bl3);
        int n3 = typedArray.getDimensionPixelSize(3, Integer.MAX_VALUE);
        this.setMaxWidth(n3);
        int n4 = typedArray.getDimensionPixelSize(4, Integer.MAX_VALUE);
        this.setMaxHeight(n4);
        int n5 = typedArray.getInt(1, -1);
        if (n5 >= 0) {
            ScaleType scaleType = sScaleTypeArray[n5];
            this.setScaleType(scaleType);
        }
        if ((n2 = typedArray.getInt(5, 0)) != 0) {
            this.setColorFilter(n2);
        }
        this.mCropToPadding = bl = typedArray.getBoolean(7, false);
        typedArray.recycle();
    }

    private void applyColorMod() {
        Drawable drawable2;
        if (this.mDrawable == null) {
            return;
        }
        if (!this.mColorMod) {
            return;
        }
        Drawable drawable3 = this.mDrawable = (drawable2 = this.mDrawable.mutate());
        ColorFilter colorFilter = this.mColorFilter;
        drawable3.setColorFilter(colorFilter);
        Drawable drawable4 = this.mDrawable;
        int n = this.mAlpha;
        int n2 = this.mViewAlphaScale;
        int n3 = n * n2 >> 8;
        drawable4.setAlpha(n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void configureBounds() {
        float f;
        Matrix matrix;
        ScaleType scaleType;
        ScaleType scaleType2;
        if (this.mDrawable == null) {
            return;
        }
        if (!this.mHaveFrame) {
            return;
        }
        int n = this.mDrawableWidth;
        int n2 = this.mDrawableHeight;
        int n3 = this.getWidth();
        int n4 = this.mPaddingLeft;
        int n5 = n3 - n4;
        int n6 = this.mPaddingRight;
        int n7 = n5 - n6;
        int n8 = this.getHeight();
        int n9 = this.mPaddingTop;
        int n10 = n8 - n9;
        int n11 = this.mPaddingBottom;
        int n12 = n10 - n11;
        boolean bl = !(n >= 0 && n7 == n || n2 >= 0 && n12 == n2);
        if (n <= 0 || n2 <= 0 || (scaleType2 = ScaleType.FIT_XY) == (scaleType = this.mScaleType)) {
            this.mDrawable.setBounds(0, 0, n7, n12);
            this.mDrawMatrix = null;
            return;
        }
        this.mDrawable.setBounds(0, 0, n, n2);
        ScaleType scaleType3 = ScaleType.MATRIX;
        ScaleType scaleType4 = this.mScaleType;
        if (scaleType3 == scaleType4) {
            Matrix matrix2;
            if (this.mMatrix.isIdentity()) {
                this.mDrawMatrix = null;
                return;
            }
            this.mDrawMatrix = matrix2 = this.mMatrix;
            return;
        }
        if (bl) {
            this.mDrawMatrix = null;
            return;
        }
        ScaleType scaleType5 = ScaleType.CENTER;
        ScaleType scaleType6 = this.mScaleType;
        if (scaleType5 == scaleType6) {
            Matrix matrix3;
            Matrix matrix4 = this.mDrawMatrix = (matrix3 = this.mMatrix);
            float f2 = (int)((float)(n7 - n) * 0.5f + 0.5f);
            float f3 = (int)((float)(n12 - n2) * 0.5f + 0.5f);
            matrix4.setTranslate(f2, f3);
            return;
        }
        ScaleType scaleType7 = ScaleType.CENTER_CROP;
        ScaleType scaleType8 = this.mScaleType;
        if (scaleType7 == scaleType8) {
            float f4;
            Matrix matrix5;
            this.mDrawMatrix = matrix5 = this.mMatrix;
            float f5 = 0.0f;
            float f6 = 0.0f;
            int n13 = n * n12;
            int n14 = n7 * n2;
            if (n13 > n14) {
                float f7 = n12;
                float f8 = n2;
                f4 = f7 / f8;
                float f9 = n7;
                float f10 = (float)n * f4;
                f5 = (f9 - f10) * 0.5f;
            } else {
                float f11 = n7;
                float f12 = n;
                f4 = f11 / f12;
                float f13 = n12;
                float f14 = (float)n2 * f4;
                f6 = (f13 - f14) * 0.5f;
            }
            this.mDrawMatrix.setScale(f4, f4);
            Matrix matrix6 = this.mDrawMatrix;
            float f15 = (int)(f5 + 0.5f);
            float f16 = (int)(f6 + 0.5f);
            boolean bl2 = matrix6.postTranslate(f15, f16);
            return;
        }
        ScaleType scaleType9 = ScaleType.CENTER_INSIDE;
        ScaleType scaleType10 = this.mScaleType;
        if (scaleType9 != scaleType10) {
            Matrix matrix7;
            RectF rectF = this.mTempSrc;
            float f17 = n;
            float f18 = n2;
            rectF.set(0.0f, 0.0f, f17, f18);
            RectF rectF2 = this.mTempDst;
            float f19 = n7;
            float f20 = n12;
            rectF2.set(0.0f, 0.0f, f19, f20);
            Matrix matrix8 = this.mDrawMatrix = (matrix7 = this.mMatrix);
            RectF rectF3 = this.mTempSrc;
            RectF rectF4 = this.mTempDst;
            Matrix.ScaleToFit scaleToFit = ImageView.scaleTypeToScaleToFit(this.mScaleType);
            boolean bl3 = matrix8.setRectToRect(rectF3, rectF4, scaleToFit);
            return;
        }
        this.mDrawMatrix = matrix = this.mMatrix;
        if (n <= n7 && n2 <= n12) {
            f = 1.0f;
        } else {
            float f21 = n7;
            float f22 = n;
            float f23 = f21 / f22;
            float f24 = n12;
            float f25 = n2;
            float f26 = f24 / f25;
            f = Math.min(f23, f26);
        }
        float f27 = n7;
        float f28 = (float)n * f;
        float f29 = (int)((f27 - f28) * 0.5f + 0.5f);
        float f30 = n12;
        float f31 = (float)n2 * f;
        float f32 = (int)((f30 - f31) * 0.5f + 0.5f);
        this.mDrawMatrix.setScale(f, f);
        boolean bl4 = this.mDrawMatrix.postTranslate(f29, f32);
    }

    private void initImageView() {
        ScaleType scaleType;
        Matrix matrix;
        this.mMatrix = matrix = new Matrix();
        this.mScaleType = scaleType = ScaleType.FIT_CENTER;
    }

    private void resizeFromDrawable() {
        int n;
        int n2;
        int n3;
        Drawable drawable2 = this.mDrawable;
        if (drawable2 == null) {
            return;
        }
        int n4 = drawable2.getIntrinsicWidth();
        if (n4 < 0) {
            n4 = this.mDrawableWidth;
        }
        if ((n3 = drawable2.getIntrinsicHeight()) < 0) {
            n3 = this.mDrawableHeight;
        }
        if (n4 != (n2 = this.mDrawableWidth) && n3 != (n = this.mDrawableHeight)) {
            return;
        }
        this.mDrawableWidth = n4;
        this.mDrawableHeight = n3;
        this.requestLayout();
    }

    /*
     * Enabled aggressive block sorting
     */
    private int resolveAdjustedSize(int n, int n2, int n3) {
        int n4 = n;
        int n5 = View.MeasureSpec.getMode(n3);
        int n6 = View.MeasureSpec.getSize(n3);
        switch (n5) {
            case 0: {
                return Math.min(n, n2);
            }
            case -2147483648: {
                return Math.min(Math.min(n, n6), n2);
            }
            case 0x40000000: {
                return n6;
            }
        }
        return n4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void resolveUri() {
        if (this.mDrawable != null) {
            return;
        }
        Resources resources = this.getResources();
        if (resources == null) {
            return;
        }
        Drawable drawable2 = null;
        if (this.mResource != 0) {
            try {
                Drawable drawable3;
                int n = this.mResource;
                drawable2 = drawable3 = resources.getDrawable(n);
            }
            catch (Exception exception) {
                StringBuilder stringBuilder = new StringBuilder().append("Unable to find resource: ");
                int n = this.mResource;
                String string2 = stringBuilder.append(n).toString();
                int n2 = Log.w("ImageView", string2, exception);
                this.mUri = null;
            }
        } else {
            if (this.mUri == null) {
                return;
            }
            String string3 = this.mUri.getScheme();
            if ("android.resource".equals(string3)) {
                try {
                    Drawable drawable4;
                    ContentResolver contentResolver = this.mContext.getContentResolver();
                    Uri uri = this.mUri;
                    ContentResolver.OpenResourceIdResult openResourceIdResult = contentResolver.getResourceId(uri);
                    Resources resources2 = openResourceIdResult.r;
                    int n = openResourceIdResult.id;
                    drawable2 = drawable4 = resources2.getDrawable(n);
                }
                catch (Exception exception) {
                    StringBuilder stringBuilder = new StringBuilder().append("Unable to open content: ");
                    Uri uri = this.mUri;
                    String string4 = stringBuilder.append(uri).toString();
                    int n = Log.w("ImageView", string4, exception);
                }
            } else if ("content".equals(string3) || "file".equals(string3)) {
                try {
                    Drawable drawable5;
                    ContentResolver contentResolver = this.mContext.getContentResolver();
                    Uri uri = this.mUri;
                    drawable2 = drawable5 = Drawable.createFromStream(contentResolver.openInputStream(uri), null);
                }
                catch (Exception exception) {
                    StringBuilder stringBuilder = new StringBuilder().append("Unable to open content: ");
                    Uri uri = this.mUri;
                    String string5 = stringBuilder.append(uri).toString();
                    int n = Log.w("ImageView", string5, exception);
                }
            } else {
                drawable2 = Drawable.createFromPath(this.mUri.toString());
            }
            if (drawable2 == null) {
                PrintStream printStream = System.out;
                StringBuilder stringBuilder = new StringBuilder().append("resolveUri failed on bad bitmap uri: ");
                Uri uri = this.mUri;
                String string6 = stringBuilder.append(uri).toString();
                printStream.println(string6);
                this.mUri = null;
            }
        }
        this.updateDrawable(drawable2);
    }

    private static Matrix.ScaleToFit scaleTypeToScaleToFit(ScaleType scaleType) {
        Matrix.ScaleToFit[] scaleToFitArray = sS2FArray;
        int n = scaleType.nativeInt - 1;
        return scaleToFitArray[n];
    }

    private void updateDrawable(Drawable drawable2) {
        int n;
        int n2;
        if (this.mDrawable != null) {
            this.mDrawable.setCallback(null);
            Drawable drawable3 = this.mDrawable;
            this.unscheduleDrawable(drawable3);
        }
        this.mDrawable = drawable2;
        if (drawable2 == null) {
            return;
        }
        drawable2.setCallback(this);
        if (drawable2.isStateful()) {
            int[] nArray = this.getDrawableState();
            boolean bl = drawable2.setState(nArray);
        }
        int n3 = this.mLevel;
        boolean bl = drawable2.setLevel(n3);
        this.mDrawableWidth = n2 = drawable2.getIntrinsicWidth();
        this.mDrawableHeight = n = drawable2.getIntrinsicHeight();
        this.applyColorMod();
        this.configureBounds();
    }

    public final void clearColorFilter() {
        this.setColorFilter(null);
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable drawable2 = this.mDrawable;
        if (drawable2 == null) {
            return;
        }
        if (!drawable2.isStateful()) {
            return;
        }
        int[] nArray = this.getDrawableState();
        boolean bl = drawable2.setState(nArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getBaseline() {
        if (!this.mBaselineAligned) return -1;
        return this.getMeasuredHeight();
    }

    public Drawable getDrawable() {
        return this.mDrawable;
    }

    public Matrix getImageMatrix() {
        return this.mMatrix;
    }

    public ScaleType getScaleType() {
        return this.mScaleType;
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        Drawable drawable3 = this.mDrawable;
        if (drawable2 == drawable3) {
            this.invalidate();
            return;
        }
        super.invalidateDrawable(drawable2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int[] onCreateDrawableState(int n) {
        if (this.mState == null) {
            return super.onCreateDrawableState(n);
        }
        if (!this.mMergeState) {
            return this.mState;
        }
        int n2 = this.mState.length + n;
        int[] nArray = super.onCreateDrawableState(n2);
        int[] nArray2 = this.mState;
        return ImageView.mergeDrawableStates(nArray, nArray2);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDrawable == null) {
            return;
        }
        if (this.mDrawableWidth == 0) {
            return;
        }
        if (this.mDrawableHeight == 0) {
            return;
        }
        if (this.mDrawMatrix == null && this.mPaddingTop == 0 && this.mPaddingLeft == 0) {
            this.mDrawable.draw(canvas);
            return;
        }
        int n = canvas.getSaveCount();
        int n2 = canvas.save();
        if (this.mCropToPadding) {
            int n3 = this.mScrollX;
            int n4 = this.mScrollY;
            int n5 = this.mPaddingLeft + n3;
            int n6 = this.mPaddingTop + n4;
            int n7 = this.mRight + n3;
            int n8 = this.mLeft;
            int n9 = n7 - n8;
            int n10 = this.mPaddingRight;
            int n11 = n9 - n10;
            int n12 = this.mBottom + n4;
            int n13 = this.mTop;
            int n14 = n12 - n13;
            int n15 = this.mPaddingBottom;
            int n16 = n14 - n15;
            boolean bl = canvas.clipRect(n5, n6, n11, n16);
        }
        float f = this.mPaddingLeft;
        float f2 = this.mPaddingTop;
        canvas.translate(f, f2);
        if (this.mDrawMatrix != null) {
            Matrix matrix = this.mDrawMatrix;
            canvas.concat(matrix);
        }
        this.mDrawable.draw(canvas);
        canvas.restoreToCount(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        int n3;
        int n4;
        block9: {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            block8: {
                float f;
                float f2;
                this.resolveUri();
                float f3 = 0.0f;
                boolean bl = false;
                boolean bl2 = false;
                if (this.mDrawable == null) {
                    int n11;
                    int n12;
                    this.mDrawableWidth = n12 = 65535;
                    this.mDrawableHeight = n11 = 65535;
                    n9 = n10 = 0;
                } else {
                    n9 = this.mDrawableWidth;
                    n10 = this.mDrawableHeight;
                    if (n9 <= 0) {
                        // empty if block
                    }
                    if (n10 <= 0) {
                        // empty if block
                    }
                    if (this.mAdjustViewBounds) {
                        int n13 = View.MeasureSpec.getMode(n);
                        int n14 = View.MeasureSpec.getMode(n2);
                        int n15 = n13;
                        int n16 = 0x40000000;
                        bl = n15 != n16;
                        int n17 = n14;
                        int n18 = 0x40000000;
                        bl2 = n17 != n18;
                        float f4 = n9;
                        float f5 = n10;
                        f3 = f4 / f5;
                    }
                }
                n8 = this.mPaddingLeft;
                n7 = this.mPaddingRight;
                n6 = this.mPaddingTop;
                n5 = this.mPaddingBottom;
                if (!bl && !bl2) break block8;
                int n19 = n9 + n8 + n7;
                int n20 = this.mMaxWidth;
                ImageView imageView = this;
                int n21 = n19;
                int n22 = n20;
                int n23 = n;
                n4 = imageView.resolveAdjustedSize(n21, n22, n23);
                int n24 = n10 + n6 + n5;
                int n25 = this.mMaxHeight;
                ImageView imageView2 = this;
                int n26 = n24;
                int n27 = n25;
                int n28 = n2;
                n3 = imageView2.resolveAdjustedSize(n26, n27, n28);
                if (f3 != 0.0f && (double)Math.abs((f2 = (float)(n4 - n8 - n7)) / (f = (float)(n3 - n6 - n5)) - f3) > 1.0E-7) {
                    int n29;
                    int n30;
                    int n31;
                    int n32;
                    boolean bl3 = false;
                    if (bl && (n32 = (n31 = (int)((float)(n3 - n6 - n5) * f3) + n8 + n7)) <= (n30 = n4)) {
                        n4 = n31;
                        bl3 = true;
                    }
                    if (!bl3 && bl2 && (n29 = (int)((float)(n4 - n8 - n7) / f3) + n6 + n5) <= n3) {
                        n3 = n29;
                    }
                }
                break block9;
            }
            int n33 = n8 + n7;
            int n34 = n9 + n33;
            int n35 = n6 + n5;
            int n36 = n10 + n35;
            int n37 = this.getSuggestedMinimumWidth();
            int n38 = n34;
            int n39 = n37;
            int n40 = Math.max(n38, n39);
            int n41 = this.getSuggestedMinimumHeight();
            int n42 = n36;
            int n43 = n41;
            int n44 = Math.max(n42, n43);
            int n45 = n40;
            int n46 = n;
            n4 = ImageView.resolveSize(n45, n46);
            int n47 = n44;
            int n48 = n2;
            n3 = ImageView.resolveSize(n47, n48);
        }
        ImageView imageView = this;
        int n49 = n4;
        int n50 = n3;
        imageView.setMeasuredDimension(n49, n50);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean onSetAlpha(int n) {
        if (this.getBackground() != null) return false;
        int n2 = n >> 7;
        int n3 = n + n2;
        if (this.mViewAlphaScale == n3) return true;
        this.mViewAlphaScale = n3;
        this.mColorMod = true;
        this.applyColorMod();
        return true;
    }

    @RemotableViewMethod
    public void setAdjustViewBounds(boolean bl) {
        this.mAdjustViewBounds = bl;
        if (!bl) {
            return;
        }
        ScaleType scaleType = ScaleType.FIT_CENTER;
        this.setScaleType(scaleType);
    }

    @RemotableViewMethod
    public void setAlpha(int n) {
        int n2 = n & 0xFF;
        if (this.mAlpha != n2) {
            return;
        }
        this.mAlpha = n2;
        this.mColorMod = true;
        this.applyColorMod();
        this.invalidate();
    }

    @RemotableViewMethod
    public final void setColorFilter(int n) {
        PorterDuff.Mode mode = PorterDuff.Mode.SRC_ATOP;
        this.setColorFilter(n, mode);
    }

    public final void setColorFilter(int n, PorterDuff.Mode mode) {
        PorterDuffColorFilter porterDuffColorFilter = new PorterDuffColorFilter(n, mode);
        this.setColorFilter(porterDuffColorFilter);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        if (this.mColorFilter == colorFilter) {
            return;
        }
        this.mColorFilter = colorFilter;
        this.mColorMod = true;
        this.applyColorMod();
        this.invalidate();
    }

    @Override
    protected boolean setFrame(int n, int n2, int n3, int n4) {
        boolean bl = super.setFrame(n, n2, n3, n4);
        this.mHaveFrame = true;
        this.configureBounds();
        return bl;
    }

    @RemotableViewMethod
    public void setImageBitmap(Bitmap bitmap) {
        Resources resources = this.mContext.getResources();
        BitmapDrawable bitmapDrawable = new BitmapDrawable(resources, bitmap);
        this.setImageDrawable(bitmapDrawable);
    }

    public void setImageDrawable(Drawable drawable2) {
        if (this.mDrawable == drawable2) {
            return;
        }
        this.mResource = 0;
        this.mUri = null;
        this.updateDrawable(drawable2);
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    public void setImageLevel(int n) {
        this.mLevel = n;
        if (this.mDrawable == null) {
            return;
        }
        boolean bl = this.mDrawable.setLevel(n);
        this.resizeFromDrawable();
    }

    public void setImageMatrix(Matrix matrix) {
        if (matrix != null && matrix.isIdentity()) {
            matrix = null;
        }
        if (matrix != null || this.mMatrix.isIdentity()) {
            if (matrix == null) {
                return;
            }
            if (this.mMatrix.equals(matrix)) {
                return;
            }
        }
        this.mMatrix.set(matrix);
        this.configureBounds();
        this.invalidate();
    }

    @RemotableViewMethod
    public void setImageResource(int n) {
        if (this.mUri == null && this.mResource != n) {
            return;
        }
        this.updateDrawable(null);
        this.mResource = n;
        this.mUri = null;
        this.resolveUri();
        this.requestLayout();
        this.invalidate();
    }

    public void setImageState(int[] nArray, boolean bl) {
        this.mState = nArray;
        this.mMergeState = bl;
        if (this.mDrawable == null) {
            return;
        }
        this.refreshDrawableState();
        this.resizeFromDrawable();
    }

    @RemotableViewMethod
    public void setImageURI(Uri uri) {
        if (this.mResource == 0) {
            Uri uri2;
            if (this.mUri == uri) {
                return;
            }
            if (uri != null && this.mUri != null && uri.equals(uri2 = this.mUri)) {
                return;
            }
        }
        this.updateDrawable(null);
        this.mResource = 0;
        this.mUri = uri;
        this.resolveUri();
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    public void setMaxHeight(int n) {
        this.mMaxHeight = n;
    }

    @RemotableViewMethod
    public void setMaxWidth(int n) {
        this.mMaxWidth = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setScaleType(ScaleType scaleType) {
        if (scaleType == null) {
            throw new NullPointerException();
        }
        if (this.mScaleType == scaleType) {
            return;
        }
        this.mScaleType = scaleType;
        ScaleType scaleType2 = this.mScaleType;
        ScaleType scaleType3 = ScaleType.CENTER;
        boolean bl = scaleType2 == scaleType3;
        this.setWillNotCacheDrawing(bl);
        this.requestLayout();
        this.invalidate();
    }

    @Override
    public void setSelected(boolean bl) {
        super.setSelected(bl);
        this.resizeFromDrawable();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean verifyDrawable(Drawable drawable2) {
        if (this.mDrawable == drawable2) return true;
        if (!super.verifyDrawable(drawable2)) return false;
        return true;
    }

    public static final class ScaleType
    extends Enum<ScaleType> {
        private static final /* synthetic */ ScaleType[] $VALUES;
        public static final /* enum */ ScaleType CENTER;
        public static final /* enum */ ScaleType CENTER_CROP;
        public static final /* enum */ ScaleType CENTER_INSIDE;
        public static final /* enum */ ScaleType FIT_CENTER;
        public static final /* enum */ ScaleType FIT_END;
        public static final /* enum */ ScaleType FIT_START;
        public static final /* enum */ ScaleType FIT_XY;
        public static final /* enum */ ScaleType MATRIX;
        final int nativeInt;

        static {
            MATRIX = new ScaleType(0);
            FIT_XY = new ScaleType(1);
            FIT_START = new ScaleType(2);
            FIT_CENTER = new ScaleType(3);
            FIT_END = new ScaleType(4);
            CENTER = new ScaleType(5);
            CENTER_CROP = new ScaleType(6);
            CENTER_INSIDE = new ScaleType(7);
            ScaleType scaleType = MATRIX;
            ScaleType scaleType2 = FIT_XY;
            ScaleType scaleType3 = FIT_START;
            ScaleType scaleType4 = FIT_CENTER;
            ScaleType scaleType5 = FIT_END;
            ScaleType scaleType6 = CENTER;
            ScaleType scaleType7 = CENTER_CROP;
            ScaleType scaleType8 = CENTER_INSIDE;
            ScaleType[] scaleTypeArray = new ScaleType[]{scaleType, scaleType2, scaleType3, scaleType4, scaleType5, scaleType6, scaleType7, scaleType8};
            $VALUES = scaleTypeArray;
        }

        private ScaleType(int n2) {
            this.nativeInt = n2;
        }

        public static ScaleType valueOf(String string2) {
            return Enum.valueOf(ScaleType.class, string2);
        }

        public static ScaleType[] values() {
            return (ScaleType[])$VALUES.clone();
        }
    }
}

