/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.widget.RemoteViews;
import com.android.internal.R;

@RemoteViews.RemoteView
public class LinearLayout
extends ViewGroup {
    public static final int HORIZONTAL = 0;
    private static final int INDEX_BOTTOM = 2;
    private static final int INDEX_CENTER_VERTICAL = 0;
    private static final int INDEX_FILL = 3;
    private static final int INDEX_TOP = 1;
    public static final int VERTICAL = 1;
    private static final int VERTICAL_GRAVITY_COUNT = 4;
    @ViewDebug.ExportedProperty(category="layout")
    private boolean mBaselineAligned = true;
    @ViewDebug.ExportedProperty(category="layout")
    private int mBaselineAlignedChildIndex = -1;
    @ViewDebug.ExportedProperty(category="measurement")
    private int mBaselineChildTop = 0;
    @ViewDebug.ExportedProperty(category="measurement", mapping={@ViewDebug.IntToString(from=255, to="NONE"), @ViewDebug.IntToString(from=0, to="NONE"), @ViewDebug.IntToString(from=48, to="TOP"), @ViewDebug.IntToString(from=80, to="BOTTOM"), @ViewDebug.IntToString(from=3, to="LEFT"), @ViewDebug.IntToString(from=5, to="RIGHT"), @ViewDebug.IntToString(from=16, to="CENTER_VERTICAL"), @ViewDebug.IntToString(from=112, to="FILL_VERTICAL"), @ViewDebug.IntToString(from=1, to="CENTER_HORIZONTAL"), @ViewDebug.IntToString(from=7, to="FILL_HORIZONTAL"), @ViewDebug.IntToString(from=17, to="CENTER"), @ViewDebug.IntToString(from=119, to="FILL")})
    private int mGravity = 51;
    private int[] mMaxAscent;
    private int[] mMaxDescent;
    @ViewDebug.ExportedProperty(category="measurement")
    private int mOrientation;
    @ViewDebug.ExportedProperty(category="measurement")
    private int mTotalLength;
    @ViewDebug.ExportedProperty(category="layout")
    private boolean mUseLargestChild;
    @ViewDebug.ExportedProperty(category="layout")
    private float mWeightSum;

    public LinearLayout(Context context) {
        super(context);
    }

    public LinearLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        boolean bl;
        int n;
        float f;
        boolean bl2;
        int n2;
        int[] nArray = R.styleable.LinearLayout;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray);
        int n3 = typedArray.getInt(1, -1);
        if (n3 >= 0) {
            this.setOrientation(n3);
        }
        if ((n2 = typedArray.getInt(0, -1)) >= 0) {
            this.setGravity(n2);
        }
        if (!(bl2 = typedArray.getBoolean(2, true))) {
            this.setBaselineAligned(bl2);
        }
        this.mWeightSum = f = typedArray.getFloat(4, -1.0f);
        this.mBaselineAlignedChildIndex = n = typedArray.getInt(3, -1);
        this.mUseLargestChild = bl = typedArray.getBoolean(5, false);
        typedArray.recycle();
    }

    private void forceUniformHeight(int n, int n2) {
        int n3 = View.MeasureSpec.makeMeasureSpec(this.getMeasuredHeight(), 0x40000000);
        int n4 = 0;
        while (n4 < n) {
            View view = this.getVirtualChildAt(n4);
            if (view.getVisibility() != 8) {
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                if (layoutParams.height == -1) {
                    int n5;
                    int n6 = layoutParams.width;
                    layoutParams.width = n5 = view.getMeasuredWidth();
                    LinearLayout linearLayout = this;
                    int n7 = n2;
                    int n8 = 0;
                    linearLayout.measureChildWithMargins(view, n7, 0, n3, n8);
                    layoutParams.width = n6;
                }
            }
            ++n4;
        }
        return;
    }

    private void forceUniformWidth(int n, int n2) {
        int n3 = View.MeasureSpec.makeMeasureSpec(this.getMeasuredWidth(), 0x40000000);
        int n4 = 0;
        while (n4 < n) {
            View view = this.getVirtualChildAt(n4);
            if (view.getVisibility() != 8) {
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                if (layoutParams.width == -1) {
                    int n5;
                    int n6 = layoutParams.height;
                    layoutParams.height = n5 = view.getMeasuredHeight();
                    LinearLayout linearLayout = this;
                    int n7 = n2;
                    int n8 = 0;
                    linearLayout.measureChildWithMargins(view, n3, 0, n7, n8);
                    layoutParams.height = n6;
                }
            }
            ++n4;
        }
        return;
    }

    private void setChildFrame(View view, int n, int n2, int n3, int n4) {
        int n5 = n + n3;
        int n6 = n2 + n4;
        view.layout(n, n2, n5, n6);
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected LayoutParams generateDefaultLayoutParams() {
        if (this.mOrientation == 0) {
            return new LayoutParams(-1, -1);
        }
        if (this.mOrientation != 1) return null;
        return new LayoutParams(-1, -1);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        Context context = this.getContext();
        return new LayoutParams(context, attributeSet);
    }

    @Override
    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new LayoutParams(layoutParams);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getBaseline() {
        int n;
        if (this.mBaselineAlignedChildIndex < 0) {
            return super.getBaseline();
        }
        int n2 = this.getChildCount();
        if (n2 <= (n = this.mBaselineAlignedChildIndex)) {
            throw new RuntimeException("mBaselineAlignedChildIndex of LinearLayout set to an index that is out of bounds.");
        }
        int n3 = this.mBaselineAlignedChildIndex;
        View view = this.getChildAt(n3);
        int n4 = view.getBaseline();
        if (n4 == -1) {
            if (this.mBaselineAlignedChildIndex != 0) throw new RuntimeException("mBaselineAlignedChildIndex of LinearLayout points to a View that doesn't know how to get its baseline.");
            return -1;
        }
        int n5 = this.mBaselineChildTop;
        if (this.mOrientation != 1) return ((LayoutParams)view.getLayoutParams()).topMargin + n5 + n4;
        int n6 = this.mGravity & 0x70;
        if (n6 == 48) return ((LayoutParams)view.getLayoutParams()).topMargin + n5 + n4;
        switch (n6) {
            case 80: {
                int n7 = this.mBottom;
                int n8 = this.mTop;
                int n9 = n7 - n8;
                int n10 = this.mPaddingBottom;
                int n11 = n9 - n10;
                int n12 = this.mTotalLength;
                n5 = n11 - n12;
            }
            default: {
                return ((LayoutParams)view.getLayoutParams()).topMargin + n5 + n4;
            }
            case 16: {
                int n13 = this.mBottom;
                int n14 = this.mTop;
                int n15 = n13 - n14;
                int n16 = this.mPaddingTop;
                int n17 = n15 - n16;
                int n18 = this.mPaddingBottom;
                int n19 = n17 - n18;
                int n20 = this.mTotalLength;
                int n21 = (n19 - n20) / 2;
                n5 += n21;
            }
        }
        return ((LayoutParams)view.getLayoutParams()).topMargin + n5 + n4;
    }

    public int getBaselineAlignedChildIndex() {
        return this.mBaselineAlignedChildIndex;
    }

    int getChildrenSkipCount(View view, int n) {
        return 0;
    }

    int getLocationOffset(View view) {
        return 0;
    }

    int getNextLocationOffset(View view) {
        return 0;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    View getVirtualChildAt(int n) {
        return this.getChildAt(n);
    }

    int getVirtualChildCount() {
        return this.getChildCount();
    }

    public float getWeightSum() {
        return this.mWeightSum;
    }

    public boolean isBaselineAligned() {
        return this.mBaselineAligned;
    }

    /*
     * Enabled aggressive block sorting
     */
    void layoutHorizontal() {
        int n = this.mPaddingTop;
        int n2 = this.mPaddingLeft;
        int n3 = this.mBottom;
        int n4 = this.mTop;
        int n5 = n3 - n4;
        int n6 = this.mPaddingBottom;
        int n7 = n5 - n6;
        int n8 = n5 - n;
        int n9 = this.mPaddingBottom;
        int n10 = n8 - n9;
        int n11 = this.getVirtualChildCount();
        int n12 = this.mGravity & 7;
        int n13 = this.mGravity & 0x70;
        boolean bl = this.mBaselineAligned;
        int[] nArray = this.mMaxAscent;
        int[] nArray2 = this.mMaxDescent;
        int n14 = n12;
        int n15 = 3;
        if (n14 != n15) {
            switch (n12) {
                case 5: {
                    int n16 = this.mRight;
                    int n17 = this.mLeft;
                    int n18 = n16 - n17;
                    int n19 = this.mPaddingLeft;
                    int n20 = n18 + n19;
                    int n21 = this.mTotalLength;
                    n2 = n20 - n21;
                    break;
                }
                case 1: {
                    int n22 = this.mRight;
                    int n23 = this.mLeft;
                    int n24 = n22 - n23;
                    int n25 = this.mTotalLength;
                    int n26 = (n24 - n25) / 2;
                    n2 += n26;
                }
            }
        }
        int n27 = 0;
        int n28;
        int n29;
        while ((n29 = ++n27) < (n28 = n11)) {
            int n30;
            int n31;
            LinearLayout linearLayout = this;
            int n32 = n27;
            View view = linearLayout.getVirtualChildAt(n32);
            if (view == null) {
                LinearLayout linearLayout2 = this;
                int n33 = n27;
                int n34 = linearLayout2.measureNullChild(n33);
                int n35 = n2 + n34;
                continue;
            }
            if (view.getVisibility() == 8) continue;
            int n36 = view.getMeasuredWidth();
            int n37 = view.getMeasuredHeight();
            int n38 = -1;
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (bl && layoutParams.height != -1) {
                n38 = view.getBaseline();
            }
            if ((n31 = layoutParams.gravity) < 0) {
                n31 = n13;
            }
            switch (n31 & 0x70) {
                default: {
                    n30 = n;
                    break;
                }
                case 48: {
                    int n39 = layoutParams.topMargin;
                    n30 = n + n39;
                    if (n38 == -1) break;
                    int n40 = nArray[1] - n38;
                    n30 += n40;
                    break;
                }
                case 16: {
                    int n41 = (n10 - n37) / 2 + n;
                    int n42 = layoutParams.topMargin;
                    int n43 = n41 + n42;
                    int n44 = layoutParams.bottomMargin;
                    n30 = n43 - n44;
                    break;
                }
                case 80: {
                    int n45 = n7 - n37;
                    int n46 = layoutParams.bottomMargin;
                    n30 = n45 - n46;
                    if (n38 == -1) break;
                    int n47 = view.getMeasuredHeight() - n38;
                    int n48 = nArray2[2] - n47;
                    n30 -= n48;
                }
            }
            int n49 = layoutParams.leftMargin;
            int n50 = n2 + n49;
            LinearLayout linearLayout3 = this;
            View view2 = view;
            int n51 = linearLayout3.getLocationOffset(view2);
            int n52 = n50 + n51;
            this.setChildFrame(view, n52, n30, n36, n37);
            int n53 = layoutParams.rightMargin + n36;
            LinearLayout linearLayout4 = this;
            View view3 = view;
            int n54 = linearLayout4.getNextLocationOffset(view3);
            int n55 = n53 + n54;
            int n56 = n50 + n55;
            LinearLayout linearLayout5 = this;
            View view4 = view;
            int n57 = n27;
            int n58 = linearLayout5.getChildrenSkipCount(view4, n57);
            n27 += n58;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    void layoutVertical() {
        int n = this.mPaddingLeft;
        int n2 = this.mPaddingTop;
        int n3 = this.mRight;
        int n4 = this.mLeft;
        int n5 = n3 - n4;
        int n6 = this.mPaddingRight;
        int n7 = n5 - n6;
        int n8 = n5 - n;
        int n9 = this.mPaddingRight;
        int n10 = n8 - n9;
        int n11 = this.getVirtualChildCount();
        int n12 = this.mGravity & 0x70;
        int n13 = this.mGravity & 7;
        int n14 = n12;
        int n15 = 48;
        if (n14 != n15) {
            switch (n12) {
                case 80: {
                    int n16 = this.mBottom;
                    int n17 = this.mTop;
                    int n18 = n16 - n17;
                    int n19 = this.mPaddingTop;
                    int n20 = n18 + n19;
                    int n21 = this.mTotalLength;
                    n2 = n20 - n21;
                    break;
                }
                case 16: {
                    int n22 = this.mBottom;
                    int n23 = this.mTop;
                    int n24 = n22 - n23;
                    int n25 = this.mTotalLength;
                    int n26 = (n24 - n25) / 2;
                    n2 += n26;
                }
            }
        }
        int n27 = 0;
        while (n27 < n11) {
            LinearLayout linearLayout = this;
            int n28 = n27;
            View view = linearLayout.getVirtualChildAt(n28);
            if (view == null) {
                LinearLayout linearLayout2 = this;
                int n29 = n27;
                int n30 = linearLayout2.measureNullChild(n29);
                int n31 = n2 + n30;
            } else if (view.getVisibility() != 8) {
                int n32;
                int n33 = view.getMeasuredWidth();
                int n34 = view.getMeasuredHeight();
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                int n35 = layoutParams.gravity;
                if (n35 < 0) {
                    n35 = n13;
                }
                switch (n35 & 7) {
                    default: {
                        n32 = n;
                        break;
                    }
                    case 3: {
                        int n36 = layoutParams.leftMargin;
                        n32 = n + n36;
                        break;
                    }
                    case 1: {
                        int n37 = (n10 - n33) / 2 + n;
                        int n38 = layoutParams.leftMargin;
                        int n39 = n37 + n38;
                        int n40 = layoutParams.rightMargin;
                        n32 = n39 - n40;
                        break;
                    }
                    case 5: {
                        int n41 = n7 - n33;
                        int n42 = layoutParams.rightMargin;
                        n32 = n41 - n42;
                    }
                }
                int n43 = layoutParams.topMargin;
                int n44 = n2 + n43;
                LinearLayout linearLayout3 = this;
                View view2 = view;
                int n45 = linearLayout3.getLocationOffset(view2);
                int n46 = n44 + n45;
                this.setChildFrame(view, n32, n46, n33, n34);
                int n47 = layoutParams.bottomMargin + n34;
                LinearLayout linearLayout4 = this;
                View view3 = view;
                int n48 = linearLayout4.getNextLocationOffset(view3);
                int n49 = n47 + n48;
                int n50 = n44 + n49;
                LinearLayout linearLayout5 = this;
                View view4 = view;
                int n51 = n27;
                int n52 = linearLayout5.getChildrenSkipCount(view4, n51);
                n27 += n52;
            }
            ++n27;
        }
        return;
    }

    void measureChildBeforeLayout(View view, int n, int n2, int n3, int n4, int n5) {
        LinearLayout linearLayout = this;
        View view2 = view;
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        int n9 = n5;
        linearLayout.measureChildWithMargins(view2, n6, n7, n8, n9);
    }

    /*
     * Enabled aggressive block sorting
     */
    void measureHorizontal(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20;
        int n21;
        int n22;
        int n23;
        this.mTotalLength = n23 = 0;
        int n24 = 0;
        int n25 = 0;
        int n26 = 0;
        boolean bl = true;
        float f = 0.0f;
        int n27 = this.getVirtualChildCount();
        int n28 = View.MeasureSpec.getMode(n);
        int n29 = View.MeasureSpec.getMode(n2);
        boolean bl2 = false;
        if (this.mMaxAscent == null || this.mMaxDescent == null) {
            int[] nArray = new int[4];
            this.mMaxAscent = nArray;
            int[] nArray2 = new int[4];
            this.mMaxDescent = nArray2;
        }
        int[] nArray = this.mMaxAscent;
        int[] nArray3 = this.mMaxDescent;
        nArray[3] = -1;
        nArray[2] = -1;
        nArray[1] = -1;
        nArray[0] = -1;
        nArray3[3] = -1;
        nArray3[2] = -1;
        nArray3[1] = -1;
        nArray3[0] = -1;
        boolean bl3 = this.mBaselineAligned;
        boolean bl4 = this.mUseLargestChild;
        int n30 = n28;
        int n31 = 0x40000000;
        boolean bl5 = n30 == n31;
        int n32 = Integer.MIN_VALUE;
        int n33 = 0;
        while ((n22 = ++n33) < (n21 = n27)) {
            int n34;
            int n35;
            LinearLayout linearLayout = this;
            int n36 = n33;
            View view = linearLayout.getVirtualChildAt(n36);
            if (view == null) {
                int n37;
                int n38 = this.mTotalLength;
                LinearLayout linearLayout2 = this;
                int n39 = n33;
                int n40 = linearLayout2.measureNullChild(n39);
                this.mTotalLength = n37 = n38 + n40;
                continue;
            }
            if (view.getVisibility() == 8) {
                LinearLayout linearLayout3 = this;
                View view2 = view;
                int n41 = n33;
                int n42 = linearLayout3.getChildrenSkipCount(view2, n41);
                n33 += n42;
                continue;
            }
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            float f2 = layoutParams.weight;
            f += f2;
            int n43 = n28;
            int n44 = 0x40000000;
            if (n43 == n44 && layoutParams.width == 0 && layoutParams.weight > 0.0f) {
                if (bl5) {
                    int n45;
                    int n46 = this.mTotalLength;
                    int n47 = layoutParams.leftMargin;
                    int n48 = layoutParams.rightMargin;
                    int n49 = n47 + n48;
                    this.mTotalLength = n45 = n46 + n49;
                } else {
                    int n50;
                    int n51 = this.mTotalLength;
                    int n52 = layoutParams.leftMargin + n51;
                    int n53 = layoutParams.rightMargin;
                    int n54 = n52 + n53;
                    int n55 = n51;
                    int n56 = n54;
                    this.mTotalLength = n50 = Math.max(n55, n56);
                }
                if (bl3) {
                    int n57 = View.MeasureSpec.makeMeasureSpec(0, 0);
                    View view3 = view;
                    int n58 = n57;
                    int n59 = n57;
                    view3.measure(n58, n59);
                }
            } else {
                int n60 = Integer.MIN_VALUE;
                if (layoutParams.width == 0 && layoutParams.weight > 0.0f) {
                    int n61;
                    n60 = 0;
                    layoutParams.width = n61 = -1;
                }
                int n62 = f == 0.0f ? this.mTotalLength : 0;
                LinearLayout linearLayout4 = this;
                int n63 = n;
                int n64 = n2;
                linearLayout4.measureChildBeforeLayout(view, n33, n63, n62, n64, 0);
                int n65 = n60;
                int n66 = Integer.MIN_VALUE;
                if (n65 != n66) {
                    int n67;
                    layoutParams.width = n67 = n60;
                }
                int n68 = view.getMeasuredWidth();
                if (bl5) {
                    int n69;
                    int n70 = this.mTotalLength;
                    int n71 = layoutParams.leftMargin + n68;
                    int n72 = layoutParams.rightMargin;
                    int n73 = n71 + n72;
                    LinearLayout linearLayout5 = this;
                    View view4 = view;
                    int n74 = linearLayout5.getNextLocationOffset(view4);
                    int n75 = n73 + n74;
                    this.mTotalLength = n69 = n70 + n75;
                } else {
                    int n76;
                    int n77 = this.mTotalLength;
                    int n78 = n77 + n68;
                    int n79 = layoutParams.leftMargin;
                    int n80 = n78 + n79;
                    int n81 = layoutParams.rightMargin;
                    int n82 = n80 + n81;
                    LinearLayout linearLayout6 = this;
                    View view5 = view;
                    int n83 = linearLayout6.getNextLocationOffset(view5);
                    int n84 = n82 + n83;
                    int n85 = n77;
                    int n86 = n84;
                    this.mTotalLength = n76 = Math.max(n85, n86);
                }
                if (bl4) {
                    int n87 = n68;
                    int n88 = n32;
                    n32 = Math.max(n87, n88);
                }
            }
            boolean bl6 = false;
            int n89 = n29;
            int n90 = 0x40000000;
            if (n89 != n90 && layoutParams.height == -1) {
                bl2 = true;
                bl6 = true;
            }
            int n91 = layoutParams.topMargin;
            int n92 = layoutParams.bottomMargin;
            int n93 = n91 + n92;
            int n94 = view.getMeasuredHeight() + n93;
            if (bl3 && (n35 = view.getBaseline()) != -1) {
                int n95;
                int n96;
                int n97 = layoutParams.gravity < 0 ? this.mGravity : layoutParams.gravity;
                int n98 = ((n97 & 0x70) >> 4 & 0xFFFFFFFE) >> 1;
                nArray[n98] = n96 = Math.max(nArray[n98], n35);
                int n99 = nArray3[n98];
                int n100 = n94 - n35;
                nArray3[n98] = n95 = Math.max(n99, n100);
            }
            int n101 = 0;
            int n102 = n94;
            int n103 = Math.max(n101, n102);
            bl = bl && layoutParams.height == -1;
            if (layoutParams.weight > 0.0f) {
                n34 = bl6 ? n93 : n94;
                int n104 = n26;
                int n105 = n34;
                n26 = Math.max(n104, n105);
            } else {
                n34 = bl6 ? n93 : n94;
                n25 = Math.max(n25, n34);
            }
            LinearLayout linearLayout7 = this;
            View view6 = view;
            int n106 = n33;
            int n107 = linearLayout7.getChildrenSkipCount(view6, n106);
            n33 += n107;
        }
        if (nArray[1] != -1 || nArray[0] != -1 || nArray[2] != -1 || nArray[3] != -1) {
            int n108 = nArray[3];
            int n109 = nArray[0];
            int n110 = nArray[1];
            int n111 = nArray[2];
            int n112 = Math.max(n110, n111);
            int n113 = Math.max(n109, n112);
            int n114 = Math.max(n108, n113);
            int n115 = nArray3[3];
            int n116 = nArray3[0];
            int n117 = nArray3[1];
            int n118 = nArray3[2];
            int n119 = Math.max(n117, n118);
            int n120 = Math.max(n116, n119);
            int n121 = Math.max(n115, n120);
            int n122 = n114 + n121;
            int n123 = 0;
            int n124 = n122;
            int n125 = Math.max(n123, n124);
        }
        if (bl4 && (n20 = n28) == (n19 = Integer.MIN_VALUE)) {
            int n126;
            int n127;
            int n128;
            this.mTotalLength = n128 = 0;
            n33 = 0;
            while ((n127 = ++n33) < (n126 = n27)) {
                int n129;
                LinearLayout linearLayout = this;
                int n130 = n33;
                View view = linearLayout.getVirtualChildAt(n130);
                if (view == null) {
                    int n131;
                    int n132 = this.mTotalLength;
                    LinearLayout linearLayout8 = this;
                    int n133 = n33;
                    int n134 = linearLayout8.measureNullChild(n133);
                    this.mTotalLength = n131 = n132 + n134;
                    continue;
                }
                if (view.getVisibility() == 8) {
                    LinearLayout linearLayout9 = this;
                    View view7 = view;
                    int n135 = n33;
                    int n136 = linearLayout9.getChildrenSkipCount(view7, n135);
                    n33 += n136;
                    continue;
                }
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                if (bl5) {
                    int n137;
                    int n138 = this.mTotalLength;
                    int n139 = layoutParams.leftMargin + n32;
                    int n140 = layoutParams.rightMargin;
                    int n141 = n139 + n140;
                    LinearLayout linearLayout10 = this;
                    View view8 = view;
                    int n142 = linearLayout10.getNextLocationOffset(view8) + n141;
                    this.mTotalLength = n137 = n138 + n142;
                    continue;
                }
                int n143 = this.mTotalLength;
                int n144 = n143 + n32;
                int n145 = layoutParams.leftMargin;
                int n146 = n144 + n145;
                int n147 = layoutParams.rightMargin;
                int n148 = n146 + n147;
                LinearLayout linearLayout11 = this;
                View view9 = view;
                int n149 = linearLayout11.getNextLocationOffset(view9);
                int n150 = n148 + n149;
                int n151 = n143;
                int n152 = n150;
                this.mTotalLength = n129 = Math.max(n151, n152);
            }
        }
        if ((n18 = (n17 = LinearLayout.resolveSize(n16 = Math.max(n15 = (n14 = (this.mTotalLength = (n13 = (n12 = this.mTotalLength) + (n11 = (n10 = this.mPaddingLeft) + (n9 = this.mPaddingRight))))), n8 = (n7 = this.getSuggestedMinimumWidth())), n6 = n)) - (n5 = this.mTotalLength)) == 0 || !(f > 0.0f)) {
            int n153 = n25;
            int n154 = n26;
            n25 = Math.max(n153, n154);
        } else {
            int n155;
            int n156;
            int n157;
            int n158;
            float f3 = this.mWeightSum > 0.0f ? this.mWeightSum : f;
            nArray[3] = -1;
            nArray[2] = -1;
            nArray[1] = -1;
            nArray[0] = -1;
            nArray3[3] = -1;
            nArray3[2] = -1;
            nArray3[1] = -1;
            nArray3[0] = -1;
            n24 = 65535;
            this.mTotalLength = n158 = 0;
            int n159 = 0;
            while ((n157 = ++n159) < (n156 = n27)) {
                int n160;
                int n161;
                int n162;
                int n163;
                int n164;
                LinearLayout linearLayout = this;
                int n165 = n159;
                View view = linearLayout.getVirtualChildAt(n165);
                if (view == null || view.getVisibility() == 8) continue;
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                float f4 = layoutParams.weight;
                if (f4 > 0.0f) {
                    int n166;
                    int n167;
                    int n168 = (int)((float)n18 * f4 / f3);
                    float f5 = f3 - f4;
                    int n169 = n18 - n168;
                    int n170 = this.mPaddingTop;
                    int n171 = this.mPaddingBottom;
                    int n172 = n170 + n171;
                    int n173 = layoutParams.topMargin;
                    int n174 = n172 + n173;
                    int n175 = layoutParams.bottomMargin;
                    int n176 = n174 + n175;
                    int n177 = layoutParams.height;
                    int n178 = n2;
                    int n179 = n176;
                    int n180 = n177;
                    int n181 = LinearLayout.getChildMeasureSpec(n178, n179, n180);
                    if (layoutParams.width != 0 || (n167 = n28) != (n166 = 0x40000000)) {
                        int n182 = view.getMeasuredWidth() + n168;
                        if (n182 < 0) {
                            n182 = 0;
                        }
                        int n183 = n182;
                        int n184 = 0x40000000;
                        int n185 = View.MeasureSpec.makeMeasureSpec(n183, n184);
                        View view10 = view;
                        int n186 = n185;
                        int n187 = n181;
                        view10.measure(n186, n187);
                    } else {
                        int n188 = n168 > 0 ? n168 : 0;
                        int n189 = View.MeasureSpec.makeMeasureSpec(n188, 0x40000000);
                        View view11 = view;
                        int n190 = n189;
                        int n191 = n181;
                        view11.measure(n190, n191);
                    }
                }
                if (bl5) {
                    int n192;
                    int n193 = this.mTotalLength;
                    int n194 = view.getMeasuredWidth();
                    int n195 = layoutParams.leftMargin;
                    int n196 = n194 + n195;
                    int n197 = layoutParams.rightMargin;
                    int n198 = n196 + n197;
                    LinearLayout linearLayout12 = this;
                    View view12 = view;
                    int n199 = linearLayout12.getNextLocationOffset(view12);
                    int n200 = n198 + n199;
                    this.mTotalLength = n192 = n193 + n200;
                } else {
                    int n201;
                    int n202 = this.mTotalLength;
                    int n203 = view.getMeasuredWidth() + n202;
                    int n204 = layoutParams.leftMargin;
                    int n205 = n203 + n204;
                    int n206 = layoutParams.rightMargin;
                    int n207 = n205 + n206;
                    LinearLayout linearLayout13 = this;
                    View view13 = view;
                    int n208 = linearLayout13.getNextLocationOffset(view13);
                    int n209 = n207 + n208;
                    int n210 = n202;
                    int n211 = n209;
                    this.mTotalLength = n201 = Math.max(n210, n211);
                }
                boolean bl7 = (n164 = n29) != (n163 = 0x40000000) && layoutParams.height == -1;
                int n212 = layoutParams.topMargin;
                int n213 = layoutParams.bottomMargin;
                int n214 = n212 + n213;
                int n215 = view.getMeasuredHeight() + n214;
                int n216 = n24;
                int n217 = n215;
                n24 = Math.max(n216, n217);
                int n218 = bl7 ? n214 : n215;
                n25 = Math.max(n25, n218);
                bl = bl && layoutParams.height == -1;
                if (!bl3 || (n162 = view.getBaseline()) == -1) continue;
                int n219 = layoutParams.gravity < 0 ? this.mGravity : layoutParams.gravity;
                int n220 = ((n219 & 0x70) >> 4 & 0xFFFFFFFE) >> 1;
                nArray[n220] = n161 = Math.max(nArray[n220], n162);
                int n221 = nArray3[n220];
                int n222 = n215 - n162;
                nArray3[n220] = n160 = Math.max(n221, n222);
            }
            int n223 = this.mTotalLength;
            int n224 = this.mPaddingLeft;
            int n225 = this.mPaddingRight;
            int n226 = n224 + n225;
            this.mTotalLength = n155 = n223 + n226;
            if (nArray[1] != -1 || nArray[0] != -1 || nArray[2] != -1 || nArray[3] != -1) {
                int n227 = nArray[3];
                int n228 = nArray[0];
                int n229 = nArray[1];
                int n230 = nArray[2];
                int n231 = Math.max(n229, n230);
                int n232 = Math.max(n228, n231);
                int n233 = Math.max(n227, n232);
                int n234 = nArray3[3];
                int n235 = nArray3[0];
                int n236 = nArray3[1];
                int n237 = nArray3[2];
                int n238 = Math.max(n236, n237);
                int n239 = Math.max(n235, n238);
                int n240 = Math.max(n234, n239);
                int n241 = n233 + n240;
                int n242 = n24;
                int n243 = n241;
                n24 = Math.max(n242, n243);
            }
        }
        if (!bl && (n4 = n29) != (n3 = 0x40000000)) {
            n24 = n25;
        }
        int n244 = this.mPaddingTop;
        int n245 = this.mPaddingBottom;
        int n246 = n244 + n245;
        int n247 = n24 + n246;
        int n248 = this.getSuggestedMinimumHeight();
        int n249 = n247;
        int n250 = n248;
        int n251 = Math.max(n249, n250);
        int n252 = n2;
        int n253 = LinearLayout.resolveSize(n251, n252);
        LinearLayout linearLayout = this;
        int n254 = n17;
        int n255 = n253;
        linearLayout.setMeasuredDimension(n254, n255);
        if (!bl2) {
            return;
        }
        LinearLayout linearLayout14 = this;
        int n256 = n27;
        int n257 = n;
        linearLayout14.forceUniformHeight(n256, n257);
    }

    int measureNullChild(int n) {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    void measureVertical(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20;
        int n21;
        int n22;
        int n23;
        this.mTotalLength = n23 = 0;
        int n24 = 0;
        int n25 = 0;
        int n26 = 0;
        boolean bl = true;
        float f = 0.0f;
        int n27 = this.getVirtualChildCount();
        int n28 = View.MeasureSpec.getMode(n);
        int n29 = View.MeasureSpec.getMode(n2);
        boolean bl2 = false;
        int n30 = this.mBaselineAlignedChildIndex;
        boolean bl3 = this.mUseLargestChild;
        int n31 = Integer.MIN_VALUE;
        int n32 = 0;
        while ((n22 = ++n32) < (n21 = n27)) {
            int n33;
            int n34;
            LinearLayout linearLayout = this;
            int n35 = n32;
            View view = linearLayout.getVirtualChildAt(n35);
            if (view == null) {
                int n36;
                int n37 = this.mTotalLength;
                LinearLayout linearLayout2 = this;
                int n38 = n32;
                int n39 = linearLayout2.measureNullChild(n38);
                this.mTotalLength = n36 = n37 + n39;
                continue;
            }
            if (view.getVisibility() == 8) {
                LinearLayout linearLayout3 = this;
                View view2 = view;
                int n40 = n32;
                int n41 = linearLayout3.getChildrenSkipCount(view2, n40);
                n32 += n41;
                continue;
            }
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            float f2 = layoutParams.weight;
            f += f2;
            int n42 = n29;
            int n43 = 0x40000000;
            if (n42 == n43 && layoutParams.height == 0 && layoutParams.weight > 0.0f) {
                int n44;
                int n45 = this.mTotalLength;
                int n46 = layoutParams.topMargin + n45;
                int n47 = layoutParams.bottomMargin;
                int n48 = n46 + n47;
                int n49 = n45;
                int n50 = n48;
                this.mTotalLength = n44 = Math.max(n49, n50);
            } else {
                int n51;
                int n52 = Integer.MIN_VALUE;
                if (layoutParams.height == 0 && layoutParams.weight > 0.0f) {
                    int n53;
                    n52 = 0;
                    layoutParams.height = n53 = -1;
                }
                int n54 = 0;
                int n55 = f == 0.0f ? this.mTotalLength : 0;
                LinearLayout linearLayout4 = this;
                int n56 = n;
                int n57 = n2;
                linearLayout4.measureChildBeforeLayout(view, n32, n56, n54, n57, n55);
                int n58 = n52;
                int n59 = Integer.MIN_VALUE;
                if (n58 != n59) {
                    int n60;
                    layoutParams.height = n60 = n52;
                }
                int n61 = view.getMeasuredHeight();
                int n62 = this.mTotalLength;
                int n63 = n62 + n61;
                int n64 = layoutParams.topMargin;
                int n65 = n63 + n64;
                int n66 = layoutParams.bottomMargin;
                int n67 = n65 + n66;
                LinearLayout linearLayout5 = this;
                View view3 = view;
                int n68 = linearLayout5.getNextLocationOffset(view3);
                int n69 = n67 + n68;
                int n70 = n62;
                int n71 = n69;
                this.mTotalLength = n51 = Math.max(n70, n71);
                if (bl3) {
                    int n72 = n61;
                    int n73 = n31;
                    n31 = Math.max(n72, n73);
                }
            }
            if (n30 >= 0 && n30 != (n34 = n32 + 1)) {
                int n74;
                this.mBaselineChildTop = n74 = this.mTotalLength;
            }
            if (n32 < n30 && layoutParams.weight > 0.0f) {
                throw new RuntimeException("A child of LinearLayout with index less than mBaselineAlignedChildIndex has weight > 0, which won't work.  Either remove the weight, or don't set mBaselineAlignedChildIndex.");
            }
            boolean bl4 = false;
            int n75 = n28;
            int n76 = 0x40000000;
            if (n75 != n76 && layoutParams.width == -1) {
                bl2 = true;
                bl4 = true;
            }
            int n77 = layoutParams.leftMargin;
            int n78 = layoutParams.rightMargin;
            int n79 = n77 + n78;
            int n80 = view.getMeasuredWidth() + n79;
            n24 = Math.max(n24, n80);
            bl = bl && layoutParams.width == -1;
            if (layoutParams.weight > 0.0f) {
                n33 = bl4 ? n79 : n80;
                int n81 = n26;
                int n82 = n33;
                n26 = Math.max(n81, n82);
            } else {
                n33 = bl4 ? n79 : n80;
                n25 = Math.max(n25, n33);
            }
            LinearLayout linearLayout6 = this;
            View view4 = view;
            int n83 = n32;
            int n84 = linearLayout6.getChildrenSkipCount(view4, n83);
            n32 += n84;
        }
        if (bl3 && (n20 = n29) == (n19 = Integer.MIN_VALUE)) {
            int n85;
            int n86;
            int n87;
            this.mTotalLength = n87 = 0;
            n32 = 0;
            while ((n86 = ++n32) < (n85 = n27)) {
                int n88;
                LinearLayout linearLayout = this;
                int n89 = n32;
                View view = linearLayout.getVirtualChildAt(n89);
                if (view == null) {
                    int n90;
                    int n91 = this.mTotalLength;
                    LinearLayout linearLayout7 = this;
                    int n92 = n32;
                    int n93 = linearLayout7.measureNullChild(n92);
                    this.mTotalLength = n90 = n91 + n93;
                    continue;
                }
                if (view.getVisibility() == 8) {
                    LinearLayout linearLayout8 = this;
                    View view5 = view;
                    int n94 = n32;
                    int n95 = linearLayout8.getChildrenSkipCount(view5, n94);
                    n32 += n95;
                    continue;
                }
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                int n96 = this.mTotalLength;
                int n97 = n96 + n31;
                int n98 = layoutParams.topMargin;
                int n99 = n97 + n98;
                int n100 = layoutParams.bottomMargin;
                int n101 = n99 + n100;
                LinearLayout linearLayout9 = this;
                View view6 = view;
                int n102 = linearLayout9.getNextLocationOffset(view6);
                int n103 = n101 + n102;
                int n104 = n96;
                int n105 = n103;
                this.mTotalLength = n88 = Math.max(n104, n105);
            }
        }
        if ((n18 = (n17 = LinearLayout.resolveSize(n16 = Math.max(n15 = (n14 = (this.mTotalLength = (n13 = (n12 = this.mTotalLength) + (n11 = (n10 = this.mPaddingTop) + (n9 = this.mPaddingBottom))))), n8 = (n7 = this.getSuggestedMinimumHeight())), n6 = n2)) - (n5 = this.mTotalLength)) == 0 || !(f > 0.0f)) {
            int n106 = n25;
            int n107 = n26;
            n25 = Math.max(n106, n107);
        } else {
            int n108;
            int n109;
            int n110;
            int n111;
            float f3 = this.mWeightSum > 0.0f ? this.mWeightSum : f;
            this.mTotalLength = n111 = 0;
            int n112 = 0;
            while ((n110 = ++n112) < (n109 = n27)) {
                int n113;
                LinearLayout linearLayout = this;
                int n114 = n112;
                View view = linearLayout.getVirtualChildAt(n114);
                if (view.getVisibility() == 8) continue;
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                float f4 = layoutParams.weight;
                if (f4 > 0.0f) {
                    int n115;
                    int n116;
                    int n117 = (int)((float)n18 * f4 / f3);
                    float f5 = f3 - f4;
                    int n118 = n18 - n117;
                    int n119 = this.mPaddingLeft;
                    int n120 = this.mPaddingRight;
                    int n121 = n119 + n120;
                    int n122 = layoutParams.leftMargin;
                    int n123 = n121 + n122;
                    int n124 = layoutParams.rightMargin;
                    int n125 = n123 + n124;
                    int n126 = layoutParams.width;
                    int n127 = n;
                    int n128 = n125;
                    int n129 = n126;
                    int n130 = LinearLayout.getChildMeasureSpec(n127, n128, n129);
                    if (layoutParams.height != 0 || (n116 = n29) != (n115 = 0x40000000)) {
                        int n131 = view.getMeasuredHeight() + n117;
                        if (n131 < 0) {
                            n131 = 0;
                        }
                        int n132 = View.MeasureSpec.makeMeasureSpec(n131, 0x40000000);
                        view.measure(n130, n132);
                    } else {
                        int n133 = n117 > 0 ? n117 : 0;
                        int n134 = View.MeasureSpec.makeMeasureSpec(n133, 0x40000000);
                        view.measure(n130, n134);
                    }
                }
                int n135 = layoutParams.leftMargin;
                int n136 = layoutParams.rightMargin;
                int n137 = n135 + n136;
                int n138 = view.getMeasuredWidth() + n137;
                n24 = Math.max(n24, n138);
                int n139 = n28;
                int n140 = 0x40000000;
                boolean bl5 = n139 != n140 && layoutParams.width == -1;
                int n141 = bl5 ? n137 : n138;
                n25 = Math.max(n25, n141);
                bl = bl && layoutParams.width == -1;
                int n142 = this.mTotalLength;
                int n143 = view.getMeasuredHeight() + n142;
                int n144 = layoutParams.topMargin;
                int n145 = n143 + n144;
                int n146 = layoutParams.bottomMargin;
                int n147 = n145 + n146;
                LinearLayout linearLayout10 = this;
                View view7 = view;
                int n148 = linearLayout10.getNextLocationOffset(view7);
                int n149 = n147 + n148;
                int n150 = n142;
                int n151 = n149;
                this.mTotalLength = n113 = Math.max(n150, n151);
            }
            int n152 = this.mTotalLength;
            int n153 = this.mPaddingTop;
            int n154 = this.mPaddingBottom;
            int n155 = n153 + n154;
            this.mTotalLength = n108 = n152 + n155;
        }
        if (!bl && (n4 = n28) != (n3 = 0x40000000)) {
            n24 = n25;
        }
        int n156 = this.mPaddingLeft;
        int n157 = this.mPaddingRight;
        int n158 = n156 + n157;
        int n159 = n24 + n158;
        int n160 = this.getSuggestedMinimumWidth();
        int n161 = n159;
        int n162 = n160;
        int n163 = Math.max(n161, n162);
        int n164 = n;
        int n165 = LinearLayout.resolveSize(n163, n164);
        LinearLayout linearLayout = this;
        int n166 = n165;
        int n167 = n17;
        linearLayout.setMeasuredDimension(n166, n167);
        if (!bl2) {
            return;
        }
        LinearLayout linearLayout11 = this;
        int n168 = n27;
        int n169 = n2;
        linearLayout11.forceUniformWidth(n168, n169);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        if (this.mOrientation == 1) {
            this.layoutVertical();
            return;
        }
        this.layoutHorizontal();
    }

    @Override
    protected void onMeasure(int n, int n2) {
        if (this.mOrientation == 1) {
            this.measureVertical(n, n2);
            return;
        }
        this.measureHorizontal(n, n2);
    }

    @RemotableViewMethod
    public void setBaselineAligned(boolean bl) {
        this.mBaselineAligned = bl;
    }

    @RemotableViewMethod
    public void setBaselineAlignedChildIndex(int n) {
        int n2;
        if (n < 0 || n >= (n2 = this.getChildCount())) {
            StringBuilder stringBuilder = new StringBuilder().append("base aligned child index out of range (0, ");
            int n3 = this.getChildCount();
            String string2 = stringBuilder.append(n3).append(")").toString();
            throw new IllegalArgumentException(string2);
        }
        this.mBaselineAlignedChildIndex = n;
    }

    @RemotableViewMethod
    public void setGravity(int n) {
        if (this.mGravity != n) {
            return;
        }
        if ((n & 7) == 0) {
            n |= 3;
        }
        if ((n & 0x70) == 0) {
            n |= 0x30;
        }
        this.mGravity = n;
        this.requestLayout();
    }

    @RemotableViewMethod
    public void setHorizontalGravity(int n) {
        int n2;
        int n3 = n & 7;
        if ((this.mGravity & 7) != n3) {
            return;
        }
        this.mGravity = n2 = this.mGravity & 0xFFFFFFF8 | n3;
        this.requestLayout();
    }

    public void setOrientation(int n) {
        if (this.mOrientation != n) {
            return;
        }
        this.mOrientation = n;
        this.requestLayout();
    }

    @RemotableViewMethod
    public void setVerticalGravity(int n) {
        int n2;
        int n3 = n & 0x70;
        if ((this.mGravity & 0x70) != n3) {
            return;
        }
        this.mGravity = n2 = this.mGravity & 0xFFFFFF8F | n3;
        this.requestLayout();
    }

    @RemotableViewMethod
    public void setWeightSum(float f) {
        float f2;
        this.mWeightSum = f2 = Math.max(0.0f, f);
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        @ViewDebug.ExportedProperty(category="layout", mapping={@ViewDebug.IntToString(from=255, to="NONE"), @ViewDebug.IntToString(from=0, to="NONE"), @ViewDebug.IntToString(from=48, to="TOP"), @ViewDebug.IntToString(from=80, to="BOTTOM"), @ViewDebug.IntToString(from=3, to="LEFT"), @ViewDebug.IntToString(from=5, to="RIGHT"), @ViewDebug.IntToString(from=16, to="CENTER_VERTICAL"), @ViewDebug.IntToString(from=112, to="FILL_VERTICAL"), @ViewDebug.IntToString(from=1, to="CENTER_HORIZONTAL"), @ViewDebug.IntToString(from=7, to="FILL_HORIZONTAL"), @ViewDebug.IntToString(from=17, to="CENTER"), @ViewDebug.IntToString(from=119, to="FILL")})
        public int gravity = -1;
        @ViewDebug.ExportedProperty(category="layout")
        public float weight;

        public LayoutParams(int n, int n2) {
            super(n, n2);
            this.weight = 0.0f;
        }

        public LayoutParams(int n, int n2, float f) {
            super(n, n2);
            this.weight = f;
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            int n;
            float f;
            int[] nArray = R.styleable.LinearLayout_Layout;
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray);
            this.weight = f = typedArray.getFloat(3, 0.0f);
            this.gravity = n = typedArray.getInt(0, -1);
            typedArray.recycle();
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }

        @Override
        public String debug(String string2) {
            StringBuilder stringBuilder = new StringBuilder().append(string2).append("LinearLayout.LayoutParams={width=");
            String string3 = LayoutParams.sizeToString(this.width);
            StringBuilder stringBuilder2 = stringBuilder.append(string3).append(", height=");
            String string4 = LayoutParams.sizeToString(this.height);
            StringBuilder stringBuilder3 = stringBuilder2.append(string4).append(" weight=");
            float f = this.weight;
            return stringBuilder3.append(f).append("}").toString();
        }
    }
}

