/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.LongSparseArray;
import android.util.SparseBooleanArray;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SoundEffectConstants;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.widget.AbsListView;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Checkable;
import android.widget.HeaderViewListAdapter;
import android.widget.ListAdapter;
import com.android.internal.R;
import com.google.android.collect.Lists;
import java.util.ArrayList;

public class ListView
extends AbsListView {
    public static final int CHOICE_MODE_MULTIPLE = 2;
    public static final int CHOICE_MODE_NONE = 0;
    public static final int CHOICE_MODE_SINGLE = 1;
    private static final float MAX_SCROLL_FACTOR = 0.33f;
    private static final int MIN_SCROLL_PREVIEW_PIXELS = 2;
    static final int NO_POSITION = 255;
    private boolean mAreAllItemsSelectable;
    private final ArrowScrollFocusResult mArrowScrollFocusResult;
    private SparseBooleanArray mCheckStates;
    private LongSparseArray<Boolean> mCheckedIdStates;
    private int mChoiceMode;
    private boolean mClipDivider;
    Drawable mDivider;
    int mDividerHeight;
    private boolean mDividerIsOpaque;
    private Paint mDividerPaint;
    private FocusSelector mFocusSelector;
    private boolean mFooterDividersEnabled;
    private ArrayList<FixedViewInfo> mFooterViewInfos;
    private boolean mHeaderDividersEnabled;
    private ArrayList<FixedViewInfo> mHeaderViewInfos;
    private boolean mIsCacheColorOpaque;
    private boolean mItemsCanFocus;
    Drawable mOverScrollFooter;
    Drawable mOverScrollHeader;
    private final Rect mTempRect;

    public ListView(Context context) {
        this(context, null);
    }

    public ListView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842868);
    }

    public ListView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        boolean bl;
        boolean bl2;
        int n2;
        Drawable drawable2;
        Drawable drawable3;
        Drawable drawable4;
        ArrowScrollFocusResult arrowScrollFocusResult;
        Rect rect;
        ArrayList arrayList = Lists.newArrayList();
        this.mHeaderViewInfos = arrayList;
        ArrayList arrayList2 = Lists.newArrayList();
        this.mFooterViewInfos = arrayList2;
        this.mAreAllItemsSelectable = true;
        this.mItemsCanFocus = false;
        this.mChoiceMode = 0;
        this.mTempRect = rect = new Rect();
        this.mArrowScrollFocusResult = arrowScrollFocusResult = new ArrowScrollFocusResult();
        int[] nArray = R.styleable.ListView;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, n, 0);
        CharSequence[] charSequenceArray = typedArray.getTextArray(0);
        if (charSequenceArray != null) {
            ArrayAdapter<CharSequence> arrayAdapter = new ArrayAdapter<CharSequence>(context, 17367043, charSequenceArray);
            this.setAdapter(arrayAdapter);
        }
        if ((drawable4 = typedArray.getDrawable(1)) != null) {
            this.setDivider(drawable4);
        }
        if ((drawable3 = typedArray.getDrawable(6)) != null) {
            this.setOverscrollHeader(drawable3);
        }
        if ((drawable2 = typedArray.getDrawable(7)) != null) {
            this.setOverscrollFooter(drawable2);
        }
        if ((n2 = typedArray.getDimensionPixelSize(2, 0)) != 0) {
            this.setDividerHeight(n2);
        }
        int n3 = typedArray.getInt(3, 0);
        this.setChoiceMode(n3);
        this.mHeaderDividersEnabled = bl2 = typedArray.getBoolean(4, true);
        this.mFooterDividersEnabled = bl = typedArray.getBoolean(5, true);
        typedArray.recycle();
    }

    private View addViewAbove(View view, int n) {
        int n2 = n - 1;
        boolean[] blArray = this.mIsScrap;
        View view2 = this.obtainView(n2, blArray);
        int n3 = view.getTop();
        int n4 = this.mDividerHeight;
        int n5 = n3 - n4;
        int n6 = this.mListPadding.left;
        boolean bl = this.mIsScrap[0];
        ListView listView = this;
        boolean bl2 = false;
        listView.setupChild(view2, n2, n5, false, n6, bl2, bl);
        return view2;
    }

    private View addViewBelow(View view, int n) {
        int n2 = n + 1;
        boolean[] blArray = this.mIsScrap;
        View view2 = this.obtainView(n2, blArray);
        int n3 = view.getBottom();
        int n4 = this.mDividerHeight;
        int n5 = n3 + n4;
        int n6 = this.mListPadding.left;
        boolean bl = this.mIsScrap[0];
        this.setupChild(view2, n2, n5, true, n6, false, bl);
        return view2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void adjustViewsUpOrDown() {
        int n;
        int n2 = this.getChildCount();
        if (n2 <= 0) {
            return;
        }
        if (!this.mStackFromBottom) {
            int n3 = this.getChildAt(0).getTop();
            int n4 = this.mListPadding.top;
            n = n3 - n4;
            if (this.mFirstPosition != 0) {
                int n5 = this.mDividerHeight;
                n -= n5;
            }
            if (n < 0) {
                return;
            }
        } else {
            int n6 = n2 - 1;
            int n7 = this.getChildAt(n6).getBottom();
            int n8 = this.getHeight();
            int n9 = this.mListPadding.bottom;
            int n10 = n8 - n9;
            n = n7 - n10;
            int n11 = this.mFirstPosition + n2;
            int n12 = this.mItemCount;
            if (n11 < n12) {
                int n13 = this.mDividerHeight;
                int n14 = n + n13;
            }
            if (n > 0) {
                return;
            }
        }
        if (n == 0) {
            return;
        }
        int n15 = -n;
        this.offsetChildrenTopAndBottom(n15);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int amountToScroll(int n, int n2) {
        int n3;
        int n4;
        int n5 = this.getHeight();
        int n6 = this.mListPadding.bottom;
        int n7 = n5 - n6;
        int n8 = this.mListPadding.top;
        int n9 = this.getChildCount();
        if (n == 130) {
            int n10;
            int n11;
            int n12;
            int n13 = n9 - 1;
            if (n2 != -1) {
                int n14 = this.mFirstPosition;
                n13 = n2 - n14;
            }
            int n15 = this.mFirstPosition + n13;
            View view = this.getChildAt(n13);
            int n16 = n7;
            int n17 = this.mItemCount - 1;
            if (n15 < n17) {
                int n18 = this.getArrowScrollPreviewLength();
                n16 -= n18;
            }
            if (view.getBottom() <= n16) {
                return 0;
            }
            if (n2 != -1 && (n12 = n16 - (n11 = view.getTop())) >= (n10 = this.getMaxScrollAmount())) {
                return 0;
            }
            int n19 = view.getBottom() - n16;
            int n20 = this.mFirstPosition + n9;
            int n21 = this.mItemCount;
            if (n20 != n21) {
                int n22 = n9 - 1;
                int n23 = this.getChildAt(n22).getBottom() - n7;
                n19 = Math.min(n19, n23);
            }
            int n24 = this.getMaxScrollAmount();
            return Math.min(n19, n24);
        }
        int n25 = 0;
        if (n2 != -1) {
            int n26 = this.mFirstPosition;
            int n27 = n2 - n26;
        }
        int n28 = this.mFirstPosition + n25;
        View view = this.getChildAt(n25);
        int n29 = n8;
        if (n28 > 0) {
            int n30 = this.getArrowScrollPreviewLength();
            n29 += n30;
        }
        if (view.getTop() >= n29) {
            return 0;
        }
        if (n2 != -1 && (n4 = view.getBottom() - n29) >= (n3 = this.getMaxScrollAmount())) {
            return 0;
        }
        int n31 = view.getTop();
        int n32 = n29 - n31;
        if (this.mFirstPosition == 0) {
            int n33 = this.getChildAt(0).getTop();
            int n34 = n8 - n33;
            int n35 = Math.min(n32, n34);
        }
        int n36 = this.getMaxScrollAmount();
        return Math.min(n32, n36);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int amountToScrollToNewFocus(int n, View view, int n2) {
        int n3;
        int n4 = 0;
        Rect rect = this.mTempRect;
        view.getDrawingRect(rect);
        Rect rect2 = this.mTempRect;
        this.offsetDescendantRectToMyCoords(view, rect2);
        if (n == 33) {
            int n5 = this.mTempRect.top;
            int n6 = this.mListPadding.top;
            if (n5 >= n6) return n4;
            int n7 = this.mListPadding.top;
            int n8 = this.mTempRect.top;
            n4 = n7 - n8;
            if (n2 <= 0) return n4;
            int n9 = this.getArrowScrollPreviewLength();
            n4 += n9;
            return n4;
        }
        int n10 = this.getHeight();
        int n11 = n10 - (n3 = this.mListPadding.bottom);
        if (this.mTempRect.bottom <= n11) return n4;
        n4 = this.mTempRect.bottom - n11;
        int n12 = this.mItemCount - 1;
        if (n2 >= n12) return n4;
        int n13 = this.getArrowScrollPreviewLength();
        return n4 += n13;
    }

    /*
     * Enabled aggressive block sorting
     */
    private ArrowScrollFocusResult arrowScrollFocused(int n) {
        int n2;
        int n3;
        int n4;
        View view;
        int n5;
        ListView listView;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        View view2;
        View view3 = this.getSelectedView();
        if (view3 != null && view3.hasFocus()) {
            View view4 = view3.findFocus();
            FocusFinder focusFinder = FocusFinder.getInstance();
            ListView listView2 = this;
            View view5 = view4;
            int n13 = n;
            view2 = focusFinder.findNextFocus(listView2, view5, n13);
        } else {
            int n14 = n;
            int n15 = 130;
            if (n14 == n15) {
                int n16;
                int n17;
                boolean bl = this.mFirstPosition > 0;
                int n18 = this.mListPadding.top;
                int n19 = bl ? this.getArrowScrollPreviewLength() : 0;
                int n20 = n18 + n19;
                int n21 = view3 != null && (n17 = view3.getTop()) > (n16 = n20) ? view3.getTop() : n20;
                Rect rect = this.mTempRect;
                int n22 = 0;
                int n23 = n21;
                int n24 = 0;
                int n25 = n21;
                rect.set(n22, n23, n24, n25);
            } else {
                int n26;
                int n27;
                int n28;
                int n29;
                int n30 = this.mFirstPosition;
                int n31 = this.getChildCount();
                int n32 = n30 + n31 - 1;
                int n33 = n32;
                boolean bl = n33 < (n29 = (n28 = this.mItemCount));
                int n34 = this.getHeight();
                int n35 = this.mListPadding.bottom;
                int n36 = n34 - n35;
                int n37 = bl ? this.getArrowScrollPreviewLength() : 0;
                int n38 = n36 - n37;
                int n39 = view3 != null && (n27 = view3.getBottom()) < (n26 = n38) ? view3.getBottom() : n38;
                Rect rect = this.mTempRect;
                int n40 = 0;
                int n41 = n39;
                int n42 = 0;
                int n43 = n39;
                rect.set(n40, n41, n42, n43);
            }
            FocusFinder focusFinder = FocusFinder.getInstance();
            Rect rect = this.mTempRect;
            FocusFinder focusFinder2 = focusFinder;
            ListView listView3 = this;
            Rect rect2 = rect;
            int n44 = n;
            view2 = focusFinder2.findNextFocusFromRect(listView3, rect2, n44);
        }
        if (view2 == null) return null;
        ListView listView4 = this;
        View view6 = view2;
        int n45 = listView4.positionOfNewFocus(view6);
        int n46 = this.mSelectedPosition;
        int n47 = 65535;
        if (n46 != n47 && (n12 = n45) != (n11 = (n10 = this.mSelectedPosition)) && (n9 = (n8 = this.lookForSelectablePositionOnScreen(n))) != (n7 = 65535)) {
            int n48;
            int n49;
            int n50 = n;
            int n51 = 130;
            if (n50 == n51) {
                if (n8 < n45) return null;
            }
            if ((n49 = n) == (n48 = 33) && n8 > n45) {
                return null;
            }
        }
        if ((n6 = (listView = this).amountToScrollToNewFocus(n5 = n, view = view2, n4 = n45)) < (n3 = this.getMaxScrollAmount())) {
            View view7 = view2;
            int n52 = n;
            boolean bl = view7.requestFocus(n52);
            ArrowScrollFocusResult arrowScrollFocusResult = this.mArrowScrollFocusResult;
            int n53 = n45;
            int n54 = n6;
            arrowScrollFocusResult.populate(n53, n54);
            return this.mArrowScrollFocusResult;
        }
        ListView listView5 = this;
        View view8 = view2;
        int n55 = listView5.distanceToView(view8);
        if (n55 >= (n2 = n3)) return null;
        View view9 = view2;
        int n56 = n;
        boolean bl = view9.requestFocus(n56);
        ArrowScrollFocusResult arrowScrollFocusResult = this.mArrowScrollFocusResult;
        int n57 = n45;
        int n58 = n3;
        arrowScrollFocusResult.populate(n57, n58);
        return this.mArrowScrollFocusResult;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean arrowScrollImpl(int n) {
        View view;
        if (this.getChildCount() <= 0) {
            return false;
        }
        View view2 = this.getSelectedView();
        int n2 = this.lookForSelectablePositionOnScreen(n);
        int n3 = this.amountToScroll(n, n2);
        ArrowScrollFocusResult arrowScrollFocusResult = this.mItemsCanFocus ? this.arrowScrollFocused(n) : null;
        if (arrowScrollFocusResult != null) {
            n2 = arrowScrollFocusResult.getSelectedPosition();
            n3 = arrowScrollFocusResult.getAmountToScroll();
        }
        boolean bl = arrowScrollFocusResult != null;
        if (n2 != -1) {
            boolean bl2 = arrowScrollFocusResult != null;
            this.handleNewSelectionChange(view2, n, n2, bl2);
            this.setSelectedPositionInt(n2);
            this.setNextSelectedPositionInt(n2);
            view2 = this.getSelectedView();
            if (this.mItemsCanFocus && arrowScrollFocusResult == null && (view = this.getFocusedChild()) != null) {
                view.clearFocus();
            }
            bl = true;
            this.checkSelectionChanged();
        }
        if (n3 > 0) {
            int n4 = n == 33 ? n3 : -n3;
            this.scrollListItemsBy(n4);
            bl = true;
        }
        if (this.mItemsCanFocus && arrowScrollFocusResult == null && view2 != null && view2.hasFocus() && this.distanceToView(view = view2.findFocus()) > 0) {
            view.clearFocus();
        }
        if (n2 == -1 && view2 != null && !this.isViewAncestorOf(view2, this)) {
            view2 = null;
            this.hideSelector();
            this.mResurrectToPosition = -1;
        }
        if (!bl) {
            return false;
        }
        if (view2 != null) {
            int n5;
            this.positionSelector(view2);
            this.mSelectedTop = n5 = view2.getTop();
        }
        if (!this.awakenScrollBars()) {
            this.invalidate();
        }
        this.invokeOnItemScrollListener();
        return true;
    }

    private void clearRecycledState(ArrayList<FixedViewInfo> arrayList) {
        if (arrayList == null) {
            return;
        }
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            AbsListView.LayoutParams layoutParams = (AbsListView.LayoutParams)arrayList.get((int)n2).view.getLayoutParams();
            if (layoutParams != null) {
                layoutParams.recycledHeaderFooter = false;
            }
            ++n2;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean commonKey(int n, int n2, KeyEvent keyEvent) {
        if (this.mAdapter == null) {
            return false;
        }
        if (this.mDataChanged) {
            this.layoutChildren();
        }
        boolean bl = false;
        int n3 = keyEvent.getAction();
        if (n3 != 1) {
            if (this.mSelectedPosition < 0) {
                switch (n) {
                    case 19: 
                    case 20: 
                    case 23: 
                    case 62: 
                    case 66: {
                        if (this.resurrectSelection()) {
                            return true;
                        } else {
                            break;
                        }
                    }
                }
            }
            switch (n) {
                case 19: {
                    if (!keyEvent.isAltPressed()) {
                        while (n2 > 0) {
                            bl = this.arrowScroll(33);
                            n2 += -1;
                        }
                        break;
                    } else {
                        bl = this.fullScroll(33);
                        break;
                    }
                }
                case 20: {
                    if (!keyEvent.isAltPressed()) {
                        while (n2 > 0) {
                            bl = this.arrowScroll(130);
                            n2 += -1;
                        }
                        break;
                    } else {
                        bl = this.fullScroll(130);
                        break;
                    }
                }
                case 21: {
                    bl = this.handleHorizontalFocusWithinListItem(17);
                    break;
                }
                case 22: {
                    bl = this.handleHorizontalFocusWithinListItem(66);
                    break;
                }
                case 23: 
                case 66: {
                    if (this.mItemCount > 0 && keyEvent.getRepeatCount() == 0) {
                        this.keyPressed();
                    }
                    bl = true;
                    break;
                }
                case 62: {
                    if (this.mPopup != null && this.mPopup.isShowing()) break;
                    if (!keyEvent.isShiftPressed()) {
                        boolean bl2 = this.pageScroll(130);
                    } else {
                        boolean bl3 = this.pageScroll(33);
                    }
                    bl = true;
                }
            }
        }
        if (!bl) {
            bl = this.sendToTextFilter(n, n2, keyEvent);
        }
        if (bl) {
            return true;
        }
        switch (n3) {
            default: {
                return false;
            }
            case 0: {
                return super.onKeyDown(n, keyEvent);
            }
            case 1: {
                return super.onKeyUp(n, keyEvent);
            }
            case 2: 
        }
        return super.onKeyMultiple(n, n2, keyEvent);
    }

    private void correctTooHigh(int n) {
        int n2;
        int n3 = this.mFirstPosition + n - 1;
        int n4 = this.mItemCount - 1;
        if (n3 != n4) {
            return;
        }
        if (n <= 0) {
            return;
        }
        int n5 = n - 1;
        int n6 = this.getChildAt(n5).getBottom();
        int n7 = this.mBottom;
        int n8 = this.mTop;
        int n9 = n7 - n8;
        int n10 = this.mListPadding.bottom;
        int n11 = n9 - n10 - n6;
        View view = this.getChildAt(0);
        int n12 = view.getTop();
        if (n11 <= 0) {
            return;
        }
        if (this.mFirstPosition <= 0 && n12 >= (n2 = this.mListPadding.top)) {
            return;
        }
        if (this.mFirstPosition == 0) {
            int n13 = this.mListPadding.top - n12;
            n11 = Math.min(n11, n13);
        }
        this.offsetChildrenTopAndBottom(n11);
        if (this.mFirstPosition <= 0) {
            return;
        }
        int n14 = this.mFirstPosition - 1;
        int n15 = view.getTop();
        int n16 = this.mDividerHeight;
        int n17 = n15 - n16;
        View view2 = this.fillUp(n14, n17);
        this.adjustViewsUpOrDown();
    }

    private void correctTooLow(int n) {
        if (this.mFirstPosition != 0) {
            return;
        }
        if (n <= 0) {
            return;
        }
        int n2 = this.getChildAt(0).getTop();
        int n3 = this.mListPadding.top;
        int n4 = this.mBottom;
        int n5 = this.mTop;
        int n6 = n4 - n5;
        int n7 = this.mListPadding.bottom;
        int n8 = n6 - n7;
        int n9 = n2 - n3;
        int n10 = n - 1;
        View view = this.getChildAt(n10);
        int n11 = view.getBottom();
        int n12 = this.mFirstPosition + n - 1;
        if (n9 <= 0) {
            return;
        }
        int n13 = this.mItemCount - 1;
        if (n12 < n13 || n11 > n8) {
            int n14 = this.mItemCount - 1;
            if (n12 != n14) {
                int n15 = n11 - n8;
                n9 = Math.min(n9, n15);
            }
            int n16 = -n9;
            this.offsetChildrenTopAndBottom(n16);
            int n17 = this.mItemCount - 1;
            if (n12 >= n17) {
                return;
            }
            int n18 = n12 + 1;
            int n19 = view.getBottom();
            int n20 = this.mDividerHeight;
            int n21 = n19 + n20;
            View view2 = this.fillDown(n18, n21);
            this.adjustViewsUpOrDown();
            return;
        }
        int n22 = this.mItemCount - 1;
        if (n12 != n22) {
            return;
        }
        this.adjustViewsUpOrDown();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int distanceToView(View view) {
        int n = 0;
        Rect rect = this.mTempRect;
        view.getDrawingRect(rect);
        Rect rect2 = this.mTempRect;
        this.offsetDescendantRectToMyCoords(view, rect2);
        int n2 = this.mBottom;
        int n3 = this.mTop;
        int n4 = n2 - n3;
        int n5 = this.mListPadding.bottom;
        int n6 = n4 - n5;
        int n7 = this.mTempRect.bottom;
        int n8 = this.mListPadding.top;
        if (n7 < n8) {
            int n9 = this.mListPadding.top;
            int n10 = this.mTempRect.bottom;
            return n9 - n10;
        }
        if (this.mTempRect.top <= n6) return n;
        return this.mTempRect.top - n6;
    }

    private void fillAboveAndBelow(View view, int n) {
        int n2 = this.mDividerHeight;
        if (!this.mStackFromBottom) {
            int n3 = n - 1;
            int n4 = view.getTop() - n2;
            View view2 = this.fillUp(n3, n4);
            this.adjustViewsUpOrDown();
            int n5 = n + 1;
            int n6 = view.getBottom() + n2;
            View view3 = this.fillDown(n5, n6);
            return;
        }
        int n7 = n + 1;
        int n8 = view.getBottom() + n2;
        View view4 = this.fillDown(n7, n8);
        this.adjustViewsUpOrDown();
        int n9 = n - 1;
        int n10 = view.getTop() - n2;
        View view5 = this.fillUp(n9, n10);
    }

    /*
     * Enabled aggressive block sorting
     */
    private View fillDown(int n, int n2) {
        int n3;
        View view = null;
        int n4 = this.mBottom;
        int n5 = this.mTop;
        int n6 = n4 - n5;
        int n7 = this.mListPadding.bottom;
        int n8 = n6 - n7;
        while (n2 < n8 && n < (n3 = this.mItemCount)) {
            int n9 = this.mSelectedPosition;
            boolean bl = n != n9;
            int n10 = this.mListPadding.left;
            ListView listView = this;
            int n11 = n;
            int n12 = n2;
            View view2 = listView.makeAndAddView(n11, n12, true, n10, bl);
            int n13 = view2.getBottom();
            int n14 = this.mDividerHeight;
            n2 = n13 + n14;
            if (bl) {
                view = view2;
            }
            ++n;
        }
        return view;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private View fillFromMiddle(int n, int n2) {
        int n3 = n2 - n;
        int n4 = this.reconcileSelectedPosition();
        int n5 = this.mListPadding.left;
        ListView listView = this;
        int n6 = n;
        boolean bl = true;
        View view = listView.makeAndAddView(n4, n6, true, n5, bl);
        this.mFirstPosition = n4;
        int n7 = view.getMeasuredHeight();
        if (n7 <= n3) {
            int n8 = (n3 - n7) / 2;
            view.offsetTopAndBottom(n8);
        }
        this.fillAboveAndBelow(view, n4);
        if (!this.mStackFromBottom) {
            int n9 = this.getChildCount();
            this.correctTooHigh(n9);
            return view;
        }
        int n10 = this.getChildCount();
        this.correctTooLow(n10);
        return view;
    }

    /*
     * Enabled aggressive block sorting
     */
    private View fillFromSelection(int n, int n2, int n3) {
        int n4 = this.getVerticalFadingEdgeLength();
        int n5 = this.mSelectedPosition;
        ListView listView = this;
        int n6 = n2;
        int n7 = n4;
        int n8 = n5;
        int n9 = listView.getTopSelectionPixel(n6, n7, n8);
        ListView listView2 = this;
        int n10 = n3;
        int n11 = n4;
        int n12 = n5;
        int n13 = listView2.getBottomSelectionPixel(n10, n11, n12);
        ListView listView3 = this;
        int n14 = n;
        int n15 = this.mListPadding.left;
        View view = listView3.makeAndAddView(n5, n14, true, n15, true);
        if (view.getBottom() > n13) {
            int n16 = view.getTop() - n9;
            int n17 = view.getBottom() - n13;
            int n18 = -Math.min(n16, n17);
            view.offsetTopAndBottom(n18);
        } else {
            int n19;
            int n20 = view.getTop();
            if (n20 < (n19 = n9)) {
                int n21 = view.getTop();
                int n22 = n9 - n21;
                int n23 = view.getBottom();
                int n24 = n13 - n23;
                int n25 = Math.min(n22, n24);
                view.offsetTopAndBottom(n25);
            }
        }
        ListView listView4 = this;
        View view2 = view;
        int n26 = n5;
        listView4.fillAboveAndBelow(view2, n26);
        if (!this.mStackFromBottom) {
            int n27 = this.getChildCount();
            ListView listView5 = this;
            int n28 = n27;
            listView5.correctTooHigh(n28);
            return view;
        }
        int n29 = this.getChildCount();
        ListView listView6 = this;
        int n30 = n29;
        listView6.correctTooLow(n30);
        return view;
    }

    private View fillFromTop(int n) {
        int n2;
        int n3;
        int n4 = this.mFirstPosition;
        int n5 = this.mSelectedPosition;
        int n6 = this.mFirstPosition = (n3 = Math.min(n4, n5));
        int n7 = this.mItemCount - 1;
        this.mFirstPosition = n2 = Math.min(n6, n7);
        if (this.mFirstPosition < 0) {
            this.mFirstPosition = 0;
        }
        int n8 = this.mFirstPosition;
        return this.fillDown(n8, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private View fillSpecific(int n, int n2) {
        View view;
        View view2;
        int n3 = this.mSelectedPosition;
        boolean bl = n != n3;
        int n4 = this.mListPadding.left;
        ListView listView = this;
        int n5 = n;
        int n6 = n2;
        View view3 = listView.makeAndAddView(n5, n6, true, n4, bl);
        this.mFirstPosition = n;
        int n7 = this.mDividerHeight;
        if (!this.mStackFromBottom) {
            int n8 = n - 1;
            int n9 = view3.getTop() - n7;
            view2 = this.fillUp(n8, n9);
            this.adjustViewsUpOrDown();
            int n10 = n + 1;
            int n11 = view3.getBottom() + n7;
            view = this.fillDown(n10, n11);
            int n12 = this.getChildCount();
            if (n12 > 0) {
                this.correctTooHigh(n12);
            }
        } else {
            int n13 = n + 1;
            int n14 = view3.getBottom() + n7;
            view = this.fillDown(n13, n14);
            this.adjustViewsUpOrDown();
            int n15 = n - 1;
            int n16 = view3.getTop() - n7;
            view2 = this.fillUp(n15, n16);
            int n17 = this.getChildCount();
            if (n17 > 0) {
                this.correctTooLow(n17);
            }
        }
        if (bl) {
            return view3;
        }
        if (view2 == null) return view;
        return view2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private View fillUp(int n, int n2) {
        int n3;
        View view = null;
        int n4 = this.mListPadding.top;
        while (n2 > n4 && n >= 0) {
            int n5 = this.mSelectedPosition;
            boolean bl = n != n5;
            int n6 = this.mListPadding.left;
            ListView listView = this;
            int n7 = n;
            int n8 = n2;
            View view2 = listView.makeAndAddView(n7, n8, false, n6, bl);
            int n9 = view2.getTop();
            int n10 = this.mDividerHeight;
            n2 = n9 - n10;
            if (bl) {
                view = view2;
            }
            n += -1;
        }
        this.mFirstPosition = n3 = n + 1;
        return view;
    }

    private int getArrowScrollPreviewLength() {
        int n = this.getVerticalFadingEdgeLength();
        return Math.max(2, n);
    }

    private int getBottomSelectionPixel(int n, int n2, int n3) {
        int n4 = n;
        int n5 = this.mItemCount - 1;
        if (n3 != n5) {
            n4 -= n2;
        }
        return n4;
    }

    private int getTopSelectionPixel(int n, int n2, int n3) {
        int n4 = n;
        if (n3 > 0) {
            n4 += n2;
        }
        return n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleHorizontalFocusWithinListItem(int n) {
        ViewGroup viewGroup;
        FocusFinder focusFinder;
        View view;
        ViewGroup viewGroup2;
        if (n != 17 && n != 66) {
            throw new IllegalArgumentException("direction must be one of {View.FOCUS_LEFT, View.FOCUS_RIGHT}");
        }
        int n2 = this.getChildCount();
        if (!this.mItemsCanFocus) return false;
        if (n2 <= 0) return false;
        if (this.mSelectedPosition == -1) return false;
        View view2 = this.getSelectedView();
        if (view2 == null) return false;
        if (!view2.hasFocus()) return false;
        if (!(view2 instanceof ViewGroup)) return false;
        View view3 = view2.findFocus();
        FocusFinder focusFinder2 = FocusFinder.getInstance();
        View view4 = focusFinder2.findNextFocus(viewGroup2 = (ViewGroup)view2, view3, n);
        if (view4 != null) {
            Rect rect = this.mTempRect;
            view3.getFocusedRect(rect);
            Rect rect2 = this.mTempRect;
            this.offsetDescendantRectToMyCoords(view3, rect2);
            Rect rect3 = this.mTempRect;
            this.offsetRectIntoDescendantCoords(view4, rect3);
            Rect rect4 = this.mTempRect;
            if (view4.requestFocus(n, rect4)) {
                return true;
            }
        }
        if ((view = (focusFinder = FocusFinder.getInstance()).findNextFocus(viewGroup = (ViewGroup)this.getRootView(), view3, n)) == null) return false;
        return this.isViewAncestorOf(view, this);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleNewSelectionChange(View view, int n, int n2, boolean bl) {
        boolean bl2;
        View view2;
        View view3;
        int n3;
        int n4;
        if (n2 == -1) {
            throw new IllegalArgumentException("newSelectedPosition needs to be valid");
        }
        boolean bl3 = false;
        int n5 = this.mSelectedPosition;
        int n6 = this.mFirstPosition;
        int n7 = n5 - n6;
        int n8 = this.mFirstPosition;
        int n9 = n2 - n8;
        if (n == 33) {
            n4 = n9;
            n3 = n7;
            view3 = this.getChildAt(n4);
            view2 = view;
            bl3 = true;
        } else {
            n4 = n7;
            n3 = n9;
            view3 = view;
            view2 = this.getChildAt(n3);
        }
        int n10 = this.getChildCount();
        if (view3 != null) {
            bl2 = !bl && bl3;
            view3.setSelected(bl2);
            this.measureAndAdjustDown(view3, n4, n10);
        }
        if (view2 == null) {
            return;
        }
        bl2 = !bl && !bl3;
        view2.setSelected(bl2);
        this.measureAndAdjustDown(view2, n3, n10);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isDirectChildHeaderOrFooter(View view) {
        int n;
        ArrayList<FixedViewInfo> arrayList = this.mHeaderViewInfos;
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            View view2 = arrayList.get((int)n).view;
            if (view != view2) continue;
            return true;
        }
        ArrayList<FixedViewInfo> arrayList2 = this.mFooterViewInfos;
        int n3 = arrayList2.size();
        n = 0;
        while (n < n3) {
            View view3 = arrayList2.get((int)n).view;
            if (view == view3) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isViewAncestorOf(View view, View view2) {
        if (view == view2) {
            return true;
        }
        ViewParent viewParent = view.getParent();
        if (!(viewParent instanceof ViewGroup)) return false;
        View view3 = (View)((Object)viewParent);
        if (!this.isViewAncestorOf(view3, view2)) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int lookForSelectablePositionOnScreen(int n) {
        int n2;
        int n3 = this.mFirstPosition;
        if (n != 130) {
            int n4 = this.getChildCount() + n3 - 1;
            n2 = this.mSelectedPosition != -1 ? this.mSelectedPosition - 1 : this.getChildCount() + n3 - 1;
            if (n2 < 0) {
                return -1;
            }
            if (n2 > n4) {
                n2 = n4;
            }
        } else {
            int n5;
            int n6 = this.mSelectedPosition != -1 ? this.mSelectedPosition + 1 : n3;
            if (n6 >= (n5 = this.mAdapter.getCount())) {
                return -1;
            }
            if (n6 < n3) {
                n6 = n3;
            }
            int n7 = this.getLastVisiblePosition();
            Adapter adapter = this.getAdapter();
            int n8 = n6;
            while (n8 <= n7) {
                int n9;
                if (adapter.isEnabled(n8) && this.getChildAt(n9 = n8 - n3).getVisibility() == 0) {
                    return n8;
                }
                ++n8;
            }
            return -1;
        }
        Adapter adapter = this.getAdapter();
        int n10 = n2;
        while (n10 >= n3) {
            int n11;
            if (adapter.isEnabled(n10) && this.getChildAt(n11 = n10 - n3).getVisibility() == 0) {
                return n10;
            }
            n10 += -1;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private View makeAndAddView(int n, int n2, boolean bl, int n3, boolean bl2) {
        View view;
        if (!this.mDataChanged && (view = this.mRecycler.getActiveView(n)) != null) {
            ListView listView = this;
            int n4 = n;
            int n5 = n2;
            boolean bl3 = bl;
            int n6 = n3;
            boolean bl4 = bl2;
            listView.setupChild(view, n4, n5, bl3, n6, bl4, true);
            return view;
        }
        boolean[] blArray = this.mIsScrap;
        View view2 = this.obtainView(n, blArray);
        boolean bl5 = this.mIsScrap[0];
        ListView listView = this;
        int n7 = n;
        int n8 = n2;
        boolean bl6 = bl;
        int n9 = n3;
        boolean bl7 = bl2;
        listView.setupChild(view2, n7, n8, bl6, n9, bl7, bl5);
        return view2;
    }

    private void measureAndAdjustDown(View view, int n, int n2) {
        int n3 = view.getHeight();
        this.measureItem(view);
        if (view.getMeasuredHeight() != n3) {
            return;
        }
        this.relayoutMeasuredItem(view);
        int n4 = view.getMeasuredHeight() - n3;
        int n5 = n + 1;
        while (n5 < n2) {
            this.getChildAt(n5).offsetTopAndBottom(n4);
            ++n5;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void measureItem(View view) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = new ViewGroup.LayoutParams(-1, -1);
        }
        int n = this.mWidthMeasureSpec;
        int n2 = this.mListPadding.left;
        int n3 = this.mListPadding.right;
        int n4 = n2 + n3;
        int n5 = layoutParams.width;
        int n6 = ViewGroup.getChildMeasureSpec(n, n4, n5);
        int n7 = layoutParams.height;
        int n8 = n7 > 0 ? View.MeasureSpec.makeMeasureSpec(n7, 0x40000000) : View.MeasureSpec.makeMeasureSpec(0, 0);
        view.measure(n6, n8);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void measureScrapChild(View view, int n, int n2) {
        int n3;
        AbsListView.LayoutParams layoutParams = (AbsListView.LayoutParams)view.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = new AbsListView.LayoutParams(-1, -1, 0);
            view.setLayoutParams(layoutParams);
        }
        layoutParams.viewType = n3 = this.mAdapter.getItemViewType(n);
        layoutParams.forceAdd = true;
        int n4 = this.mListPadding.left;
        int n5 = this.mListPadding.right;
        int n6 = n4 + n5;
        int n7 = layoutParams.width;
        int n8 = ViewGroup.getChildMeasureSpec(n2, n6, n7);
        int n9 = layoutParams.height;
        int n10 = n9 > 0 ? View.MeasureSpec.makeMeasureSpec(n9, 0x40000000) : View.MeasureSpec.makeMeasureSpec(0, 0);
        view.measure(n8, n10);
    }

    /*
     * Enabled aggressive block sorting
     */
    private View moveSelection(View view, View view2, int n, int n2, int n3) {
        int n4;
        int n5;
        View view3;
        int n6 = this.getVerticalFadingEdgeLength();
        int n7 = this.mSelectedPosition;
        ListView listView = this;
        int n8 = n2;
        int n9 = n6;
        int n10 = n7;
        int n11 = listView.getTopSelectionPixel(n8, n9, n10);
        ListView listView2 = this;
        int n12 = n2;
        int n13 = n6;
        int n14 = n7;
        int n15 = listView2.getBottomSelectionPixel(n12, n13, n14);
        if (n > 0) {
            int n16;
            int n17 = n7 - 1;
            int n18 = view.getTop();
            int n19 = this.mListPadding.left;
            view = this.makeAndAddView(n17, n18, true, n19, false);
            int n20 = this.mDividerHeight;
            ListView listView3 = this;
            int n21 = n7;
            int n22 = view.getBottom() + n20;
            view3 = listView3.makeAndAddView(n21, n22, true, n16 = this.mListPadding.left, true);
            if (view3.getBottom() > n15) {
                int n23 = view3.getTop() - n11;
                int n24 = view3.getBottom() - n15;
                int n25 = (n3 - n2) / 2;
                int n26 = Math.min(Math.min(n23, n24), n25);
                int n27 = -n26;
                View view4 = view;
                int n28 = n27;
                view4.offsetTopAndBottom(n28);
                int n29 = -n26;
                View view5 = view3;
                int n30 = n29;
                view5.offsetTopAndBottom(n30);
            }
            if (!this.mStackFromBottom) {
                int n31 = this.mSelectedPosition - 2;
                int n32 = view3.getTop() - n20;
                ListView listView4 = this;
                int n33 = n31;
                int n34 = n32;
                View view6 = listView4.fillUp(n33, n34);
                this.adjustViewsUpOrDown();
                int n35 = this.mSelectedPosition + 1;
                int n36 = view3.getBottom() + n20;
                ListView listView5 = this;
                int n37 = n35;
                int n38 = n36;
                View view7 = listView5.fillDown(n37, n38);
                return view3;
            }
            int n39 = this.mSelectedPosition + 1;
            int n40 = view3.getBottom() + n20;
            ListView listView6 = this;
            int n41 = n39;
            int n42 = n40;
            View view8 = listView6.fillDown(n41, n42);
            this.adjustViewsUpOrDown();
            int n43 = this.mSelectedPosition - 2;
            int n44 = view3.getTop() - n20;
            ListView listView7 = this;
            int n45 = n43;
            int n46 = n44;
            View view9 = listView7.fillUp(n45, n46);
            return view3;
        }
        if (n < 0) {
            int n47;
            int n48;
            if (view2 != null) {
                int n49 = view2.getTop();
                int n50 = this.mListPadding.left;
                ListView listView8 = this;
                int n51 = n7;
                view3 = listView8.makeAndAddView(n51, n49, true, n50, true);
            } else {
                int n52 = view.getTop();
                int n53 = this.mListPadding.left;
                ListView listView9 = this;
                int n54 = n7;
                view3 = listView9.makeAndAddView(n54, n52, false, n53, true);
            }
            if ((n48 = view3.getTop()) < (n47 = n11)) {
                int n55 = view3.getTop();
                int n56 = n11 - n55;
                int n57 = view3.getBottom();
                int n58 = n15 - n57;
                int n59 = (n3 - n2) / 2;
                int n60 = Math.min(Math.min(n56, n58), n59);
                View view10 = view3;
                int n61 = n60;
                view10.offsetTopAndBottom(n61);
            }
            ListView listView10 = this;
            View view11 = view3;
            int n62 = n7;
            listView10.fillAboveAndBelow(view11, n62);
            return view3;
        }
        int n63 = view.getTop();
        int n64 = this.mListPadding.left;
        ListView listView11 = this;
        int n65 = n7;
        view3 = listView11.makeAndAddView(n65, n63, true, n64, true);
        int n66 = n63;
        int n67 = n2;
        if (n66 < n67 && (n5 = view3.getBottom()) < (n4 = n2 + 20)) {
            int n68 = view3.getTop();
            int n69 = n2 - n68;
            View view12 = view3;
            int n70 = n69;
            view12.offsetTopAndBottom(n70);
        }
        ListView listView12 = this;
        View view13 = view3;
        int n71 = n7;
        listView12.fillAboveAndBelow(view13, n71);
        return view3;
    }

    private int positionOfNewFocus(View view) {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            View view2 = this.getChildAt(i);
            if (!this.isViewAncestorOf(view, view2)) continue;
            return this.mFirstPosition + i;
        }
        throw new IllegalArgumentException("newFocus is not a child of any of the children of the list!");
    }

    private void relayoutMeasuredItem(View view) {
        int n = view.getMeasuredWidth();
        int n2 = view.getMeasuredHeight();
        int n3 = this.mListPadding.left;
        int n4 = n3 + n;
        int n5 = view.getTop();
        int n6 = n5 + n2;
        view.layout(n3, n5, n4, n6);
    }

    private void removeFixedViewInfo(View view, ArrayList<FixedViewInfo> arrayList) {
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            if (arrayList.get((int)n2).view == view) {
                FixedViewInfo fixedViewInfo = arrayList.remove(n2);
                return;
            }
            ++n2;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void scrollListItemsBy(int n) {
        this.offsetChildrenTopAndBottom(n);
        int n2 = this.getHeight();
        int n3 = this.mListPadding.bottom;
        int n4 = n2 - n3;
        int n5 = this.mListPadding.top;
        AbsListView.RecycleBin recycleBin = this.mRecycler;
        if (n >= 0) {
            View view = this.getChildAt(0);
            while (view.getTop() > n5 && this.mFirstPosition > 0) {
                int n6;
                int n7 = this.mFirstPosition;
                View view2 = this.addViewAbove(view, n7);
                this.mFirstPosition = n6 = this.mFirstPosition - 1;
            }
            if (view.getTop() > n5) {
                int n8 = view.getTop();
                int n9 = n5 - n8;
                this.offsetChildrenTopAndBottom(n9);
            }
        } else {
            int n10;
            int n11;
            int n12 = this.getChildCount();
            int n13 = n12 - 1;
            View view = this.getChildAt(n13);
            while (view.getBottom() < n4 && (n11 = this.mFirstPosition + n12 - 1) < (n10 = this.mItemCount - 1)) {
                view = this.addViewBelow(view, n11);
                ++n12;
            }
            if (view.getBottom() < n4) {
                int n14 = view.getBottom();
                int n15 = n4 - n14;
                this.offsetChildrenTopAndBottom(n15);
            }
            View view3 = this.getChildAt(0);
            while (true) {
                int n16;
                if (view3.getBottom() >= n5) {
                    return;
                }
                int n17 = ((AbsListView.LayoutParams)view3.getLayoutParams()).viewType;
                if (recycleBin.shouldRecycleViewType(n17)) {
                    this.detachViewFromParent(view3);
                    recycleBin.addScrapView(view3);
                } else {
                    this.removeViewInLayout(view3);
                }
                view3 = this.getChildAt(0);
                this.mFirstPosition = n16 = this.mFirstPosition + 1;
            }
        }
        int n18 = this.getChildCount() - 1;
        View view = this.getChildAt(n18);
        while (view.getTop() > n4) {
            int n19 = ((AbsListView.LayoutParams)view.getLayoutParams()).viewType;
            if (recycleBin.shouldRecycleViewType(n19)) {
                this.detachViewFromParent(view);
                recycleBin.addScrapView(view);
            } else {
                this.removeViewInLayout(view);
            }
            view = this.getChildAt(n18 += -1);
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setupChild(View view, int n, int n2, boolean bl, int n3, boolean bl2, boolean bl3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        boolean bl4 = bl2 && this.shouldShowSelector();
        boolean bl5 = bl4;
        boolean bl6 = view.isSelected();
        boolean bl7 = bl6;
        boolean bl8 = bl5 != bl7;
        int n11 = this.mTouchMode;
        boolean bl9 = n11 > 0 && (n10 = n11) < (n9 = 3) && (n8 = this.mMotionPosition) != (n7 = n);
        boolean bl10 = bl9;
        boolean bl11 = view.isPressed();
        boolean bl12 = bl11;
        boolean bl13 = bl10 != bl12;
        boolean bl14 = !bl3 || bl8 || view.isLayoutRequested();
        AbsListView.LayoutParams layoutParams = (AbsListView.LayoutParams)view.getLayoutParams();
        if (layoutParams == null) {
            AbsListView.LayoutParams layoutParams2 = layoutParams;
            int n12 = 65535;
            int n13 = 65534;
            int n14 = 0;
            layoutParams2(n12, n13, n14);
        }
        ListAdapter listAdapter = this.mAdapter;
        int n15 = n;
        layoutParams.viewType = n6 = listAdapter.getItemViewType(n15);
        if (bl3 && !layoutParams.forceAdd || layoutParams.recycledHeaderFooter && (n5 = layoutParams.viewType) == (n4 = 65534)) {
            int n16 = bl ? 65535 : 0;
            ListView listView = this;
            View view2 = view;
            int n17 = n16;
            AbsListView.LayoutParams layoutParams3 = layoutParams;
            listView.attachViewToParent(view2, n17, layoutParams3);
        } else {
            boolean bl15;
            layoutParams.forceAdd = bl15 = false;
            int n18 = layoutParams.viewType;
            int n19 = 65534;
            if (n18 == n19) {
                boolean bl16;
                layoutParams.recycledHeaderFooter = bl16 = true;
            }
            int n20 = bl ? 65535 : 0;
            ListView listView = this;
            View view3 = view;
            int n21 = n20;
            AbsListView.LayoutParams layoutParams4 = layoutParams;
            boolean bl17 = true;
            boolean bl18 = listView.addViewInLayout(view3, n21, layoutParams4, bl17);
        }
        if (bl8) {
            View view4 = view;
            boolean bl19 = bl4;
            view4.setSelected(bl19);
        }
        if (bl13) {
            View view5 = view;
            boolean bl20 = bl9;
            view5.setPressed(bl20);
        }
        if (this.mChoiceMode != 0 && this.mCheckStates != null && view instanceof Checkable) {
            Checkable checkable = (Checkable)((Object)view);
            SparseBooleanArray sparseBooleanArray = this.mCheckStates;
            int n22 = n;
            boolean bl21 = sparseBooleanArray.get(n22);
            Checkable checkable2 = checkable;
            boolean bl22 = bl21;
            checkable2.setChecked(bl22);
        }
        if (bl14) {
            int n23;
            int n24 = this.mWidthMeasureSpec;
            int n25 = this.mListPadding.left;
            int n26 = this.mListPadding.right;
            int n27 = n25 + n26;
            int n28 = layoutParams.width;
            int n29 = ViewGroup.getChildMeasureSpec(n24, n27, n28);
            int n30 = layoutParams.height;
            if (n30 > 0) {
                int n31 = n30;
                int n32 = 0x40000000;
                n23 = View.MeasureSpec.makeMeasureSpec(n31, n32);
            } else {
                n23 = View.MeasureSpec.makeMeasureSpec(0, 0);
            }
            View view6 = view;
            int n33 = n29;
            int n34 = n23;
            view6.measure(n33, n34);
        } else {
            this.cleanupLayoutState(view);
        }
        int n35 = view.getMeasuredWidth();
        int n36 = view.getMeasuredHeight();
        int n37 = bl ? n2 : n2 - n36;
        if (bl14) {
            int n38 = n3 + n35;
            int n39 = n37 + n36;
            View view7 = view;
            int n40 = n3;
            int n41 = n37;
            int n42 = n38;
            int n43 = n39;
            view7.layout(n40, n41, n42, n43);
        } else {
            int n44 = view.getLeft();
            int n45 = n3 - n44;
            View view8 = view;
            int n46 = n45;
            view8.offsetLeftAndRight(n46);
            int n47 = view.getTop();
            int n48 = n37 - n47;
            View view9 = view;
            int n49 = n48;
            view9.offsetTopAndBottom(n49);
        }
        if (!this.mCachingStarted) {
            return;
        }
        if (view.isDrawingCacheEnabled()) {
            return;
        }
        View view10 = view;
        boolean bl23 = true;
        view10.setDrawingCacheEnabled(bl23);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean showingBottomFadingEdge() {
        int n = this.getChildCount();
        int n2 = n - 1;
        int n3 = this.getChildAt(n2).getBottom();
        int n4 = this.mFirstPosition + n - 1;
        int n5 = this.mScrollY;
        int n6 = this.getHeight();
        int n7 = n5 + n6;
        int n8 = this.mListPadding.bottom;
        int n9 = n7 - n8;
        int n10 = this.mItemCount - 1;
        if (n4 < n10) return true;
        if (n3 >= n9) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean showingTopFadingEdge() {
        int n = this.mScrollY;
        int n2 = this.mListPadding.top;
        int n3 = n + n2;
        if (this.mFirstPosition > 0) return true;
        if (this.getChildAt(0).getTop() <= n3) return false;
        return true;
    }

    public void addFooterView(View view) {
        this.addFooterView(view, null, true);
    }

    public void addFooterView(View view, Object object, boolean bl) {
        FixedViewInfo fixedViewInfo = new FixedViewInfo();
        fixedViewInfo.view = view;
        fixedViewInfo.data = object;
        fixedViewInfo.isSelectable = bl;
        boolean bl2 = this.mFooterViewInfos.add(fixedViewInfo);
        if (this.mDataSetObserver == null) {
            return;
        }
        this.mDataSetObserver.onChanged();
    }

    public void addHeaderView(View view) {
        this.addHeaderView(view, null, true);
    }

    public void addHeaderView(View view, Object object, boolean bl) {
        if (this.mAdapter != null) {
            throw new IllegalStateException("Cannot add header view to list -- setAdapter has already been called.");
        }
        FixedViewInfo fixedViewInfo = new FixedViewInfo();
        fixedViewInfo.view = view;
        fixedViewInfo.data = object;
        fixedViewInfo.isSelectable = bl;
        boolean bl2 = this.mHeaderViewInfos.add(fixedViewInfo);
    }

    boolean arrowScroll(int n) {
        try {
            this.mInLayout = true;
            boolean bl = this.arrowScrollImpl(n);
            if (bl) {
                int n2 = SoundEffectConstants.getContantForFocusDirection(n);
                this.playSoundEffect(n2);
            }
            return bl;
        }
        finally {
            this.mInLayout = false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean canAnimate() {
        if (!super.canAnimate()) return false;
        if (this.mItemCount <= 0) return false;
        return true;
    }

    public void clearChoices() {
        if (this.mCheckStates != null) {
            this.mCheckStates.clear();
        }
        if (this.mCheckedIdStates == null) {
            return;
        }
        this.mCheckedIdStates.clear();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void dispatchDraw(Canvas var1_1) {
        block33: {
            block30: {
                block29: {
                    block23: {
                        block27: {
                            block26: {
                                block25: {
                                    block24: {
                                        block22: {
                                            block28: {
                                                block32: {
                                                    block31: {
                                                        var2_2 = this.mDividerHeight;
                                                        var3_3 = this.mOverScrollHeader;
                                                        var4_4 = this.mOverScrollFooter;
                                                        if (var3_3 == null) break block31;
                                                        var5_5 = true;
lbl6:
                                                        // 2 sources

                                                        while (var4_4 != null) {
                                                            var6_6 = true;
lbl8:
                                                            // 2 sources

                                                            while (var2_2 > 0 && this.mDivider != null) {
                                                                var7_7 = true;
lbl10:
                                                                // 2 sources

                                                                while (var7_7 || var5_5 || var6_6) {
                                                                    var8_8 = this.mTempRect;
                                                                    var8_8.left = var9_9 = this.mPaddingLeft;
                                                                    var10_10 = this.mRight;
                                                                    var11_11 = this.mLeft;
                                                                    var12_12 = var10_10 - var11_11;
                                                                    var13_13 = this.mPaddingRight;
                                                                    var8_8.right = var14_14 = var12_12 - var13_13;
                                                                    var15_15 = this.getChildCount();
                                                                    var16_16 = this.mHeaderViewInfos.size();
                                                                    var17_17 = this.mItemCount;
                                                                    var18_18 = this.mFooterViewInfos.size();
                                                                    var19_19 = var17_17 - var18_18 - 1;
                                                                    var20_20 = this.mHeaderDividersEnabled;
                                                                    var21_21 = this.mFooterDividersEnabled;
                                                                    var22_22 = this.mFirstPosition;
                                                                    var23_23 = this.mAreAllItemsSelectable;
                                                                    var24_24 = this.mAdapter;
                                                                    if (!var7_7 || !this.isOpaque() || super.isOpaque()) break block22;
                                                                    var25_25 = true;
lbl30:
                                                                    // 2 sources

                                                                    while (true) {
                                                                        if (var25_25 && this.mDividerPaint == null && this.mIsCacheColorOpaque) {
                                                                            var27_27 = this.mDividerPaint = (var26_26 = new Paint());
                                                                            var28_28 = this.getCacheColorHint();
                                                                            var27_27.setColor(var28_28);
                                                                        }
                                                                        var29_29 = this.mDividerPaint;
                                                                        var30_30 = this.mBottom;
                                                                        var31_31 = this.mTop;
                                                                        var32_32 = var30_30 - var31_31;
                                                                        var33_33 = this.mListPadding.bottom;
                                                                        var34_34 = var32_32 - var33_33;
                                                                        var35_35 = this.mScrollY;
                                                                        var36_36 = var34_34 + var35_35;
                                                                        if (this.mStackFromBottom) break block23;
                                                                        var37_37 = 0;
                                                                        var38_38 = this.mScrollY;
                                                                        if (var15_15 > 0 && var38_38 < 0) {
                                                                            if (!var5_5) break block24;
                                                                            var8_8.bottom = var39_40 = 0;
                                                                            var8_8.top = var40_41 = var38_38;
                                                                            var41_42 = this;
                                                                            var42_43 = var1_1;
                                                                            var43_44 = var3_3;
                                                                            var44_45 = var8_8;
                                                                            var41_42.drawOverscrollHeader(var42_43, var43_44, var44_45);
                                                                        }
lbl55:
                                                                        // 5 sources

                                                                        while (true) {
                                                                            var45_52 = 0;
                                                                            block5: while ((var46_54 = ++var45_52) < (var47_55 = var15_15)) {
                                                                                if ((var20_20 || (var48_56 = var22_22 + var45_52) >= (var49_57 = var16_16)) && (var21_21 || (var50_58 = var22_22 + var45_52) < (var51_59 = var19_19))) {
                                                                                    var52_60 = this;
                                                                                    var53_61 = var45_52;
                                                                                    var37_37 = var52_60.getChildAt(var53_61).getBottom();
                                                                                    if (var7_7 && (var54_62 = var37_37) < (var55_63 = var36_36) && (!var6_6 || (var57_65 = var45_52) != (var58_66 = (var56_64 = var15_15 - 1)))) {
                                                                                        if (!var23_23 && (!(var60_68 = var24_24).isEnabled(var61_69 = (var59_67 = var22_22 + var45_52)) || (var63_71 = var45_52) != (var64_72 = (var62_70 = var15_15 - 1)) && !(var66_74 = var24_24).isEnabled(var67_75 = (var65_73 = var22_22 + var45_52 + 1)))) break block25;
                                                                                        var8_8.top = var37_37;
                                                                                        var8_8.bottom = var68_76 = var37_37 + var2_2;
                                                                                        var69_77 = this;
                                                                                        var70_78 = var1_1;
                                                                                        var71_79 = var8_8;
                                                                                        var72_80 = var45_52;
                                                                                        var69_77.drawDivider(var70_78, var71_79, var72_80);
                                                                                    }
                                                                                }
lbl71:
                                                                                // 7 sources

                                                                            }
                                                                            break block26;
                                                                            break;
                                                                        }
                                                                        break;
                                                                    }
                                                                }
                                                                break block27;
                                                            }
                                                            break block28;
                                                        }
                                                        break block32;
                                                    }
                                                    var5_5 = false;
                                                    ** GOTO lbl6
                                                }
                                                var6_6 = false;
                                                ** GOTO lbl8
                                            }
                                            var7_7 = false;
                                            ** GOTO lbl10
                                        }
                                        var25_25 = false;
                                        ** while (true)
                                    }
                                    if (!var7_7) ** GOTO lbl55
                                    var8_8.bottom = var73_46 = 0;
                                    var8_8.top = var74_47 = -var2_2;
                                    var75_48 = this;
                                    var76_49 = var1_1;
                                    var77_50 = var8_8;
                                    var78_51 = 65535;
                                    var75_48.drawDivider(var76_49, var77_50, var78_51);
                                    ** while (true)
                                }
                                if (!var25_25) ** GOTO lbl71
                                var8_8.top = var37_37;
                                var8_8.bottom = var79_81 = var37_37 + var2_2;
                                var80_82 = var1_1;
                                var81_83 = var8_8;
                                var82_84 = var29_29;
                                var80_82.drawRect(var81_83, var82_84);
                                ** while (true)
                            }
                            var83_85 = this.mBottom;
                            var84_86 = this.mScrollY;
                            var85_87 = var83_85 + var84_86;
                            if (var6_6 && (var86_88 = var22_22 + var15_15) != (var87_89 = var17_17) && (var88_90 = var85_87) > (var89_91 = var37_37)) {
                                var8_8.top = var37_37;
                                var8_8.bottom = var90_92 = var85_87;
                                var91_93 = this;
                                var92_94 = var1_1;
                                var93_95 = var4_4;
                                var94_96 = var8_8;
                                var91_93.drawOverscrollFooter(var92_94, var93_95, var94_96);
                            }
                        }
lbl121:
                        // 5 sources

                        while (true) {
                            super.dispatchDraw(var1_1);
                            return;
                        }
                    }
                    var95_97 = this.mListPadding.top;
                    var38_39 = this.mScrollY;
                    if (var15_15 > 0 && var5_5) {
                        var8_8.top = var96_98 = var38_39;
                        var97_99 = this;
                        var98_100 = 0;
                        var8_8.bottom = var99_101 = var97_99.getChildAt(var98_100).getTop();
                        var100_102 = this;
                        var101_103 = var1_1;
                        var102_104 = var3_3;
                        var103_105 = var8_8;
                        var100_102.drawOverscrollHeader(var101_103, var102_104, var103_105);
                    }
                    if (var5_5) {
                        var104_106 = 1;
lbl139:
                        // 2 sources

                        while (true) {
                            var45_53 = var104_106;
                            block9: while ((var105_117 = var45_53) < (var106_118 = var15_15)) {
                                if ((var20_20 || (var107_119 = var22_22 + var45_53) >= (var108_120 = var16_16)) && (var21_21 || (var109_121 = var22_22 + var45_53) < (var110_122 = var19_19))) {
                                    var111_123 = this;
                                    var112_124 = var45_53;
                                    var113_125 = var111_123.getChildAt(var112_124).getTop();
                                    if (var7_7 && (var114_126 = var113_125) > (var115_127 = var95_97)) {
                                        if (!var23_23 && (!(var117_129 = var24_24).isEnabled(var118_130 = (var116_128 = var22_22 + var45_53)) || (var120_132 = var45_53) != (var121_133 = (var119_131 = var15_15 - 1)) && !(var123_135 = var24_24).isEnabled(var124_136 = (var122_134 = var22_22 + var45_53 + 1)))) break block29;
                                        var8_8.top = var125_137 = var113_125 - var2_2;
                                        var8_8.bottom = var126_138 = var113_125;
                                        var127_139 = var45_53 - 1;
                                        var128_107 = this;
                                        var129_108 = var1_1;
                                        var130_109 = var8_8;
                                        var131_110 = var127_139;
                                        var128_107.drawDivider(var129_108, var130_109, var131_110);
                                    }
                                }
lbl156:
                                // 7 sources

                                while (true) {
                                    var132_111 = var45_53 + 1;
                                    continue block9;
                                    break;
                                }
                            }
                            break block30;
                            break;
                        }
                    }
                    var104_106 = 0;
                    ** while (true)
                }
                if (!var25_25) ** GOTO lbl156
                var8_8.top = var133_112 = var113_125 - var2_2;
                var8_8.bottom = var134_113 = var113_125;
                var135_114 = var1_1;
                var136_115 = var8_8;
                var137_116 = var29_29;
                var135_114.drawRect(var136_115, var137_116);
                ** while (true)
            }
            if (var15_15 <= 0 || var38_39 <= 0) ** GOTO lbl121
            if (!var6_6) break block33;
            var8_8.top = var138_140 = this.mBottom;
            var8_8.bottom = var139_141 = var138_140 + var38_39;
            var140_142 = this;
            var141_143 = var1_1;
            var142_144 = var4_4;
            var143_145 = var8_8;
            var140_142.drawOverscrollFooter(var141_143, var142_144, var143_145);
            ** GOTO lbl121
        }
        if (!var7_7) ** GOTO lbl121
        var8_8.top = var144_146 = var36_36;
        var8_8.bottom = var145_147 = var36_36 + var2_2;
        var146_148 = this;
        var147_149 = var1_1;
        var148_150 = var8_8;
        var149_151 = 65535;
        var146_148.drawDivider(var147_149, var148_150, var149_151);
        ** while (true)
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        boolean bl = super.dispatchKeyEvent(keyEvent);
        if (!bl && this.getFocusedChild() != null && keyEvent.getAction() == 0) {
            int n = keyEvent.getKeyCode();
            bl = this.onKeyDown(n, keyEvent);
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        boolean bl = super.dispatchPopulateAccessibilityEvent(accessibilityEvent);
        if (!bl) {
            int n = 0;
            int n2 = this.getSelectedItemPosition();
            Adapter adapter = this.getAdapter();
            if (adapter != null) {
                int n3 = adapter.getCount();
                if (n3 >= 15) {
                    n = n3;
                } else {
                    for (int i = 0; i < n3; ++i) {
                        if (adapter.isEnabled(i)) {
                            ++n;
                            continue;
                        }
                        if (i > n2) continue;
                        n2 += -1;
                    }
                }
            }
            accessibilityEvent.setItemCount(n);
            accessibilityEvent.setCurrentItemIndex(n2);
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    void drawDivider(Canvas canvas, Rect rect, int n) {
        Drawable drawable2 = this.mDivider;
        boolean bl = this.mClipDivider;
        if (!bl) {
            drawable2.setBounds(rect);
        } else {
            int n2 = canvas.save();
            boolean bl2 = canvas.clipRect(rect);
        }
        drawable2.draw(canvas);
        if (!bl) {
            return;
        }
        canvas.restore();
    }

    void drawOverscrollFooter(Canvas canvas, Drawable drawable2, Rect rect) {
        int n = drawable2.getMinimumHeight();
        int n2 = canvas.save();
        boolean bl = canvas.clipRect(rect);
        int n3 = rect.bottom;
        int n4 = rect.top;
        if (n3 - n4 < n) {
            int n5;
            rect.bottom = n5 = rect.top + n;
        }
        drawable2.setBounds(rect);
        drawable2.draw(canvas);
        canvas.restore();
    }

    void drawOverscrollHeader(Canvas canvas, Drawable drawable2, Rect rect) {
        int n = drawable2.getMinimumHeight();
        int n2 = canvas.save();
        boolean bl = canvas.clipRect(rect);
        int n3 = rect.bottom;
        int n4 = rect.top;
        if (n3 - n4 < n) {
            int n5;
            rect.top = n5 = rect.bottom - n;
        }
        drawable2.setBounds(rect);
        drawable2.draw(canvas);
        canvas.restore();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    void fillGap(boolean bl) {
        int n;
        int n2 = this.getChildCount();
        if (bl) {
            int n3;
            if (n2 > 0) {
                int n4 = n2 - 1;
                int n5 = this.getChildAt(n4).getBottom();
                int n6 = this.mDividerHeight;
                n3 = n5 + n6;
            } else {
                n3 = this.getListPaddingTop();
            }
            int n7 = this.mFirstPosition + n2;
            View view = this.fillDown(n7, n3);
            int n8 = this.getChildCount();
            this.correctTooHigh(n8);
            return;
        }
        if (n2 > 0) {
            int n9 = this.getChildAt(0).getTop();
            int n10 = this.mDividerHeight;
            n = n9 - n10;
        } else {
            int n11 = this.getHeight();
            int n12 = this.getListPaddingBottom();
            n = n11 - n12;
        }
        int n13 = this.mFirstPosition - 1;
        View view = this.fillUp(n13, n);
        int n14 = this.getChildCount();
        this.correctTooLow(n14);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    int findMotionRow(int n) {
        int n2 = this.getChildCount();
        if (n2 <= 0) return -1;
        if (!this.mStackFromBottom) {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.getChildAt(n3).getBottom();
                if (n <= n4) {
                    return this.mFirstPosition + n3;
                }
                ++n3;
            }
            return -1;
        }
        int n5 = n2 - 1;
        while (n5 >= 0) {
            int n6 = this.getChildAt(n5).getTop();
            if (n >= n6) {
                return this.mFirstPosition + n5;
            }
            n5 += -1;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    View findViewInHeadersOrFooters(ArrayList<FixedViewInfo> arrayList, int n) {
        if (arrayList == null) return null;
        int n2 = arrayList.size();
        int n3 = 0;
        while (n3 < n2) {
            View view = arrayList.get((int)n3).view;
            if (!view.isRootNamespace() && (view = view.findViewById(n)) != null) {
                return view;
            }
            ++n3;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    View findViewTagInHeadersOrFooters(ArrayList<FixedViewInfo> arrayList, Object object) {
        if (arrayList == null) return null;
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            View view = arrayList.get((int)n2).view;
            if (!view.isRootNamespace() && (view = view.findViewWithTag(object)) != null) {
                return view;
            }
            ++n2;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected View findViewTraversal(int n) {
        View view = super.findViewTraversal(n);
        if (view != null) return view;
        ArrayList<FixedViewInfo> arrayList = this.mHeaderViewInfos;
        view = this.findViewInHeadersOrFooters(arrayList, n);
        if (view != null) {
            return view;
        }
        ArrayList<FixedViewInfo> arrayList2 = this.mFooterViewInfos;
        view = this.findViewInHeadersOrFooters(arrayList2, n);
        if (view == null) return view;
        return view;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected View findViewWithTagTraversal(Object object) {
        View view = super.findViewWithTagTraversal(object);
        if (view != null) return view;
        ArrayList<FixedViewInfo> arrayList = this.mHeaderViewInfos;
        view = this.findViewTagInHeadersOrFooters(arrayList, object);
        if (view != null) {
            return view;
        }
        ArrayList<FixedViewInfo> arrayList2 = this.mFooterViewInfos;
        view = this.findViewTagInHeadersOrFooters(arrayList2, object);
        if (view == null) return view;
        return view;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean fullScroll(int n) {
        int n2;
        int n3;
        boolean bl = false;
        if (n == 33) {
            if (this.mSelectedPosition != 0) {
                int n4 = this.lookForSelectablePosition(0, true);
                if (n4 >= 0) {
                    this.mLayoutMode = 1;
                    this.setSelectionInt(n4);
                    this.invokeOnItemScrollListener();
                }
                bl = true;
            }
        } else if (n == 130 && (n3 = this.mSelectedPosition) < (n2 = this.mItemCount - 1)) {
            int n5 = this.mItemCount - 1;
            int n6 = this.lookForSelectablePosition(n5, true);
            if (n6 >= 0) {
                this.mLayoutMode = 3;
                this.setSelectionInt(n6);
                this.invokeOnItemScrollListener();
            }
            bl = true;
        }
        if (bl && !this.awakenScrollBars()) {
            boolean bl2 = this.awakenScrollBars();
            this.invalidate();
        }
        return bl;
    }

    @Override
    public ListAdapter getAdapter() {
        return this.mAdapter;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Deprecated
    public long[] getCheckItemIds() {
        int n;
        ListAdapter listAdapter;
        int n2;
        int n3;
        SparseBooleanArray sparseBooleanArray;
        void var1_2;
        if (this.mAdapter != null && this.mAdapter.hasStableIds()) {
            long[] lArray = this.getCheckedItemIds();
            return var1_2;
        }
        if (this.mChoiceMode != 0 && this.mCheckStates != null && this.mAdapter != null) {
            sparseBooleanArray = this.mCheckStates;
            n2 = n3 = sparseBooleanArray.size();
            listAdapter = this.mAdapter;
            n = 0;
        } else {
            boolean bl = false;
            return var1_2;
        }
        for (int i = 0; i < n3; ++i) {
            int n4;
            if (sparseBooleanArray.valueAt(i)) {
                long l;
                n4 = n + 1;
                int n5 = sparseBooleanArray.keyAt(i);
                n2[n] = l = listAdapter.getItemId(n5);
            } else {
                n4 = n;
            }
            n = n4;
        }
        if (n != n3) {
            int n6 = n2;
            return var1_2;
        }
        int n7 = n;
        System.arraycopy(n2, 0, n7, 0, n);
        int n8 = n7;
        return var1_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long[] getCheckedItemIds() {
        int n;
        if (this.mChoiceMode == 0) return 0;
        if (this.mCheckedIdStates == null) return 0;
        if (this.mAdapter == null) {
            return 0;
        }
        LongSparseArray<Boolean> longSparseArray = this.mCheckedIdStates;
        int n2 = n = longSparseArray.size();
        int n3 = 0;
        while (n3 < n) {
            long l;
            n2[n3] = l = longSparseArray.keyAt(n3);
            ++n3;
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getCheckedItemPosition() {
        if (this.mChoiceMode != 1) return -1;
        if (this.mCheckStates == null) return -1;
        if (this.mCheckStates.size() != 1) return -1;
        return this.mCheckStates.keyAt(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SparseBooleanArray getCheckedItemPositions() {
        if (this.mChoiceMode == 0) return null;
        return this.mCheckStates;
    }

    public int getChoiceMode() {
        return this.mChoiceMode;
    }

    public Drawable getDivider() {
        return this.mDivider;
    }

    public int getDividerHeight() {
        return this.mDividerHeight;
    }

    @Override
    public int getFooterViewsCount() {
        return this.mFooterViewInfos.size();
    }

    @Override
    public int getHeaderViewsCount() {
        return this.mHeaderViewInfos.size();
    }

    public boolean getItemsCanFocus() {
        return this.mItemsCanFocus;
    }

    public int getMaxScrollAmount() {
        int n = this.mBottom;
        int n2 = this.mTop;
        float f = n - n2;
        return (int)(0.33f * f);
    }

    public Drawable getOverscrollFooter() {
        return this.mOverScrollFooter;
    }

    public Drawable getOverscrollHeader() {
        return this.mOverScrollHeader;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isItemChecked(int n) {
        if (this.mChoiceMode == 0) return false;
        if (this.mCheckStates == null) return false;
        return this.mCheckStates.get(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isOpaque() {
        if (this.mCachingStarted && this.mIsCacheColorOpaque && this.mDividerIsOpaque) {
            if (this.hasOpaqueScrollbars()) return true;
        }
        if (!super.isOpaque()) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void layoutChildren() {
        block61: {
            boolean bl;
            block55: {
                boolean bl2;
                boolean bl3;
                int n;
                View view;
                View view2;
                AbsListView.RecycleBin recycleBin;
                View view3;
                boolean bl4;
                block58: {
                    int n2;
                    int n3;
                    View view4;
                    int n4;
                    int n5;
                    block60: {
                        View view5;
                        boolean bl5;
                        View view6;
                        int n6;
                        int n7;
                        int n8;
                        block57: {
                            int n9;
                            block56: {
                                boolean bl6;
                                bl4 = this.mBlockLayoutRequests;
                                if (bl4) {
                                    return;
                                }
                                this.mBlockLayoutRequests = bl6 = true;
                                try {
                                    int n10;
                                    int n11;
                                    super.layoutChildren();
                                    this.invalidate();
                                    if (this.mAdapter == null) {
                                        this.resetList();
                                        this.invokeOnItemScrollListener();
                                        if (bl4) {
                                            return;
                                        }
                                        break block55;
                                    }
                                    n5 = this.mListPadding.top;
                                    int n12 = this.mBottom;
                                    int n13 = this.mTop;
                                    int n14 = n12 - n13;
                                    int n15 = this.mListPadding.bottom;
                                    n8 = n14 - n15;
                                    n7 = this.getChildCount();
                                    n6 = 0;
                                    n4 = 0;
                                    view4 = null;
                                    view6 = null;
                                    view3 = null;
                                    switch (this.mLayoutMode) {
                                        default: {
                                            int n16;
                                            int n17;
                                            int n18 = this.mSelectedPosition;
                                            int n19 = this.mFirstPosition;
                                            int n20 = n18 - n19;
                                            if (n20 >= 0 && (n17 = n20) < (n16 = n7)) {
                                                ListView listView = this;
                                                int n21 = n20;
                                                View view7 = listView.getChildAt(n21);
                                            }
                                            ListView listView = this;
                                            int n22 = 0;
                                            view4 = listView.getChildAt(n22);
                                            if (this.mNextSelectedPosition >= 0) {
                                                int n23 = this.mNextSelectedPosition;
                                                int n24 = this.mSelectedPosition;
                                                n6 = n23 - n24;
                                            }
                                            int n25 = n20 + n6;
                                            ListView listView2 = this;
                                            int n26 = n25;
                                            view6 = listView2.getChildAt(n26);
                                            break;
                                        }
                                        case 2: {
                                            int n27;
                                            int n28;
                                            int n29 = this.mNextSelectedPosition;
                                            int n30 = this.mFirstPosition;
                                            int n20 = n29 - n30;
                                            if (n20 >= 0 && (n28 = n20) < (n27 = n7)) {
                                                ListView listView = this;
                                                int n31 = n20;
                                                view6 = listView.getChildAt(n31);
                                            }
                                        }
                                        case 1: 
                                        case 3: 
                                        case 4: 
                                        case 5: 
                                    }
                                    bl5 = this.mDataChanged;
                                    if (bl5) {
                                        this.handleDataChanged();
                                    }
                                    if (this.mItemCount == 0) {
                                        this.resetList();
                                        this.invokeOnItemScrollListener();
                                        if (bl4) {
                                            return;
                                        }
                                        break block55;
                                    }
                                    int n32 = this.mItemCount;
                                    int n33 = this.mAdapter.getCount();
                                    if (n32 != n33) {
                                        StringBuilder stringBuilder = new StringBuilder().append("The content of the adapter has changed but ListView did not receive a notification. Make sure the content of your adapter is not modified from a background thread, but only from the UI thread. [in ListView(");
                                        int n34 = this.getId();
                                        StringBuilder stringBuilder2 = stringBuilder.append(n34).append(", ");
                                        Class<? extends Object> clazz = this.getClass();
                                        StringBuilder stringBuilder3 = stringBuilder2.append(clazz).append(") with Adapter(");
                                        Class<? extends Object> clazz2 = this.mAdapter.getClass();
                                        String string2 = stringBuilder3.append(clazz2).append(")]").toString();
                                        throw new IllegalStateException(string2);
                                    }
                                    int n35 = this.mNextSelectedPosition;
                                    ListView listView = this;
                                    int n36 = n35;
                                    listView.setSelectedPositionInt(n36);
                                    n9 = this.mFirstPosition;
                                    recycleBin = this.mRecycler;
                                    view2 = null;
                                    if (!bl5) break block56;
                                    int n37 = 0;
                                    while ((n11 = n37) < (n10 = n7)) {
                                        ListView listView3 = this;
                                        int n38 = n37++;
                                        View view8 = listView3.getChildAt(n38);
                                        AbsListView.RecycleBin recycleBin2 = recycleBin;
                                        View view9 = view8;
                                        recycleBin2.addScrapView(view9);
                                    }
                                    break block57;
                                }
                                catch (Throwable throwable) {
                                    if (!bl4) {
                                        boolean bl7;
                                        this.mBlockLayoutRequests = bl7 = false;
                                    }
                                    throw throwable;
                                }
                            }
                            AbsListView.RecycleBin recycleBin3 = recycleBin;
                            int n39 = n7;
                            int n40 = n9;
                            recycleBin3.fillActiveViews(n39, n40);
                        }
                        if ((view5 = this.getFocusedChild()) != null) {
                            View view10;
                            ListView listView;
                            if (!bl5 || (listView = this).isDirectChildHeaderOrFooter(view10 = view5)) {
                                view2 = view5;
                                view3 = this.findFocus();
                                if (view3 != null) {
                                    view3.onStartTemporaryDetach();
                                }
                            }
                            boolean bl8 = this.requestFocus();
                        }
                        this.detachAllViewsFromParent();
                        switch (this.mLayoutMode) {
                            default: {
                                if (n7 != 0) break block60;
                                if (this.mStackFromBottom) break;
                                ListView listView = this;
                                int n41 = 0;
                                boolean bl9 = true;
                                int n42 = listView.lookForSelectablePosition(n41, bl9);
                                ListView listView4 = this;
                                int n43 = n42;
                                listView4.setSelectedPositionInt(n43);
                                ListView listView5 = this;
                                int n44 = n5;
                                view = listView5.fillFromTop(n44);
                                break block58;
                            }
                            case 2: {
                                if (view6 != null) {
                                    int n45 = view6.getTop();
                                    ListView listView = this;
                                    int n46 = n45;
                                    int n47 = n5;
                                    int n48 = n8;
                                    view = listView.fillFromSelection(n46, n47, n48);
                                    break block58;
                                } else {
                                    ListView listView = this;
                                    int n49 = n5;
                                    int n50 = n8;
                                    view = listView.fillFromMiddle(n49, n50);
                                }
                                break block58;
                            }
                            case 5: {
                                int n51 = this.mSyncPosition;
                                int n52 = this.mSpecificTop;
                                ListView listView = this;
                                int n53 = n51;
                                int n54 = n52;
                                view = listView.fillSpecific(n53, n54);
                                break block58;
                            }
                            case 3: {
                                int n55 = this.mItemCount - 1;
                                ListView listView = this;
                                int n56 = n55;
                                int n57 = n8;
                                view = listView.fillUp(n56, n57);
                                this.adjustViewsUpOrDown();
                                break block58;
                            }
                            case 1: {
                                int n58;
                                this.mFirstPosition = n58 = 0;
                                ListView listView = this;
                                int n59 = n5;
                                view = listView.fillFromTop(n59);
                                this.adjustViewsUpOrDown();
                                break block58;
                            }
                            case 4: {
                                int n60 = this.reconcileSelectedPosition();
                                int n61 = this.mSpecificTop;
                                ListView listView = this;
                                int n62 = n60;
                                int n63 = n61;
                                view = listView.fillSpecific(n62, n63);
                                break block58;
                            }
                            case 6: {
                                view = this.moveSelection((View)n4, view6, n6, n5, n8);
                                break block58;
                            }
                        }
                        int n64 = this.mItemCount - 1;
                        ListView listView = this;
                        int n65 = n64;
                        boolean bl10 = false;
                        int n66 = listView.lookForSelectablePosition(n65, bl10);
                        ListView listView6 = this;
                        int n67 = n66;
                        listView6.setSelectedPositionInt(n67);
                        int n68 = this.mItemCount - 1;
                        ListView listView7 = this;
                        int n69 = n68;
                        int n70 = n8;
                        view = listView7.fillUp(n69, n70);
                        break block58;
                    }
                    if (this.mSelectedPosition >= 0 && (n3 = this.mSelectedPosition) < (n2 = this.mItemCount)) {
                        int n71 = this.mSelectedPosition;
                        n4 = n4 == 0 ? n5 : n4.getTop();
                        ListView listView = this;
                        int n72 = n71;
                        int n73 = n4;
                        view = listView.fillSpecific(n72, n73);
                    } else {
                        int n74 = this.mFirstPosition;
                        int n75 = this.mItemCount;
                        if (n74 < n75) {
                            int n76 = this.mFirstPosition;
                            n4 = view4 == null ? n5 : view4.getTop();
                            ListView listView = this;
                            int n77 = n76;
                            int n78 = n4;
                            view = listView.fillSpecific(n77, n78);
                        } else {
                            ListView listView = this;
                            int n79 = 0;
                            int n80 = n5;
                            view = listView.fillSpecific(n79, n80);
                        }
                    }
                }
                recycleBin.scrapActiveViews();
                if (view != null) {
                    int n81;
                    if (this.mItemsCanFocus && this.hasFocus() && !view.hasFocus()) {
                        View view11 = view;
                        View view12 = view2;
                        boolean bl11 = view11 == view12 && view3.requestFocus() || view.requestFocus();
                        if (!bl11) {
                            View view13 = this.getFocusedChild();
                            if (view13 != null) {
                                view13.clearFocus();
                            }
                            ListView listView = this;
                            View view14 = view;
                            listView.positionSelector(view14);
                        } else {
                            View view15 = view;
                            boolean bl12 = false;
                            view15.setSelected(bl12);
                            this.mSelectorRect.setEmpty();
                        }
                    } else {
                        ListView listView = this;
                        View view16 = view;
                        listView.positionSelector(view16);
                    }
                    this.mSelectedTop = n81 = view.getTop();
                } else {
                    if (this.mTouchMode > 0 && this.mTouchMode < 3) {
                        ListView listView = this;
                        int n82 = this.mMotionPosition;
                        int n83 = this.mFirstPosition;
                        int n84 = n82 - n83;
                        int n85 = n84;
                        View view17 = listView.getChildAt(n85);
                        if (view17 != null) {
                            ListView listView8 = this;
                            View view18 = view17;
                            listView8.positionSelector(view18);
                        }
                    } else {
                        int n86;
                        this.mSelectedTop = n86 = 0;
                        this.mSelectorRect.setEmpty();
                    }
                    if (this.hasFocus() && view3 != null) {
                        boolean bl13 = view3.requestFocus();
                    }
                }
                if (view3 != null && view3.getWindowToken() != null) {
                    view3.onFinishTemporaryDetach();
                }
                this.mLayoutMode = n = 0;
                this.mDataChanged = bl3 = false;
                this.mNeedSync = bl2 = false;
                int n87 = this.mSelectedPosition;
                ListView listView = this;
                int n88 = n87;
                listView.setNextSelectedPositionInt(n88);
                this.updateScrollIndicators();
                if (this.mItemCount > 0) {
                    this.checkSelectionChanged();
                }
                this.invokeOnItemScrollListener();
                if (bl4) break block61;
            }
            this.mBlockLayoutRequests = bl = false;
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    int lookForSelectablePosition(int n, boolean bl) {
        ListAdapter listAdapter = this.mAdapter;
        if (listAdapter == null) return -1;
        if (this.isInTouchMode()) {
            return -1;
        }
        int n2 = listAdapter.getCount();
        if (!this.mAreAllItemsSelectable) {
            if (bl) {
                n = Math.max(0, n);
                while (n < n2 && !listAdapter.isEnabled(n)) {
                    int n3 = n + 1;
                }
            } else {
                int n4 = n2 - 1;
                for (n = Math.min(n, n4); n >= 0 && !listAdapter.isEnabled(n); n += -1) {
                }
            }
            if (n < 0) return -1;
            if (n < n2) return n;
            return -1;
        }
        if (n < 0) return -1;
        if (n < n2) return n;
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    final int measureHeightOfChildren(int n, int n2, int n3, int n4, int n5) {
        ListAdapter listAdapter = this.mAdapter;
        if (listAdapter == null) {
            int n6 = this.mListPadding.top;
            int n7 = this.mListPadding.bottom;
            return n6 + n7;
        }
        int n8 = this.mListPadding.top;
        int n9 = this.mListPadding.bottom;
        int n10 = n8 + n9;
        int n11 = this.mDividerHeight > 0 && this.mDivider != null ? this.mDividerHeight : 0;
        int n12 = 0;
        int n13 = n3;
        int n14 = -1;
        if (n13 == n14) {
            n3 = listAdapter.getCount() - 1;
        }
        AbsListView.RecycleBin recycleBin = this.mRecycler;
        boolean bl = this.recycleOnMeasure();
        boolean[] blArray = this.mIsScrap;
        int n15 = n2;
        int n16;
        int n17;
        while ((n17 = ++n15) <= (n16 = n3)) {
            int n18;
            int n19;
            int n20;
            int n21;
            int n22;
            int n23;
            View view = this.obtainView(n15, blArray);
            this.measureScrapChild(view, n15, n);
            if (n15 > 0) {
                n10 += n11;
            }
            if (bl && recycleBin.shouldRecycleViewType(n23 = ((AbsListView.LayoutParams)view.getLayoutParams()).viewType)) {
                recycleBin.addScrapView(view);
            }
            if ((n22 = (n10 += (n21 = view.getMeasuredHeight()))) >= (n20 = n4)) {
                if (n5 < 0) return n4;
                int n24 = n15;
                int n25 = n5;
                if (n24 <= n25) return n4;
                if (n12 <= 0) return n4;
                int n26 = n10;
                int n27 = n4;
                if (n26 == n27) return n4;
                return n12;
            }
            if (n5 < 0 || (n19 = n15) < (n18 = n5)) continue;
            int n28 = n10;
        }
        return n10;
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        int n = this.getChildCount();
        if (n <= 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            View view = this.getChildAt(i);
            this.addHeaderView(view);
        }
        this.removeAllViews();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onFocusChanged(boolean bl, int n, Rect rect) {
        super.onFocusChanged(bl, n, rect);
        int n2 = -1;
        if (bl && rect != null) {
            int n3 = this.mScrollX;
            int n4 = this.mScrollY;
            rect.offset(n3, n4);
            ListAdapter listAdapter = this.mAdapter;
            int n5 = listAdapter.getCount();
            int n6 = this.getChildCount();
            int n7 = this.mFirstPosition;
            int n8 = n6 + n7;
            if (n5 < n8) {
                this.mLayoutMode = 0;
                this.layoutChildren();
            }
            Rect rect2 = this.mTempRect;
            int n9 = Integer.MAX_VALUE;
            int n10 = this.getChildCount();
            int n11 = this.mFirstPosition;
            for (int i = 0; i < n10; ++i) {
                int n12 = n11 + i;
                if (!listAdapter.isEnabled(n12)) continue;
                View view = this.getChildAt(i);
                view.getDrawingRect(rect2);
                this.offsetDescendantRectToMyCoords(view, rect2);
                int n13 = ListView.getDistance(rect, rect2, n);
                if (n13 >= n9) continue;
                n9 = n13;
                n2 = i;
            }
        }
        if (n2 >= 0) {
            int n14 = this.mFirstPosition + n2;
            this.setSelection(n14);
            return;
        }
        this.requestLayout();
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return this.commonKey(n, 1, keyEvent);
    }

    @Override
    public boolean onKeyMultiple(int n, int n2, KeyEvent keyEvent) {
        return this.commonKey(n, n2, keyEvent);
    }

    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        return this.commonKey(n, 1, keyEvent);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        int n3 = View.MeasureSpec.getMode(n);
        int n4 = View.MeasureSpec.getMode(n2);
        int n5 = View.MeasureSpec.getSize(n);
        int n6 = View.MeasureSpec.getSize(n2);
        int n7 = 0;
        int n8 = 0;
        int n9 = this.mAdapter == null ? 0 : this.mAdapter.getCount();
        this.mItemCount = n9;
        if (this.mItemCount > 0 && (n3 == 0 || n4 == 0)) {
            int n10;
            AbsListView.RecycleBin recycleBin;
            boolean[] blArray = this.mIsScrap;
            View view = this.obtainView(0, blArray);
            this.measureScrapChild(view, 0, n);
            n7 = view.getMeasuredWidth();
            n8 = view.getMeasuredHeight();
            if (this.recycleOnMeasure() && (recycleBin = this.mRecycler).shouldRecycleViewType(n10 = ((AbsListView.LayoutParams)view.getLayoutParams()).viewType)) {
                this.mRecycler.addScrapView(view);
            }
        }
        if (n3 == 0) {
            int n11 = this.mListPadding.left;
            int n12 = this.mListPadding.right;
            int n13 = n11 + n12 + n7;
            int n14 = this.getVerticalScrollbarWidth();
            n5 = n13 + n14;
        }
        if (n4 == 0) {
            int n15 = this.mListPadding.top;
            int n16 = this.mListPadding.bottom;
            int n17 = n15 + n16 + n8;
            int n18 = this.getVerticalFadingEdgeLength() * 2;
            n6 = n17 + n18;
        }
        if (n4 == Integer.MIN_VALUE) {
            ListView listView = this;
            int n19 = n;
            int n20 = -1;
            n6 = listView.measureHeightOfChildren(n19, 0, -1, n6, n20);
        }
        this.setMeasuredDimension(n5, n6);
        this.mWidthMeasureSpec = n;
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        SavedState savedState = (SavedState)parcelable;
        Parcelable parcelable2 = savedState.getSuperState();
        super.onRestoreInstanceState(parcelable2);
        if (savedState.checkState != null) {
            SparseBooleanArray sparseBooleanArray;
            this.mCheckStates = sparseBooleanArray = savedState.checkState;
        }
        if (savedState.checkIdState == null) {
            return;
        }
        LongSparseArray<Boolean> longSparseArray = savedState.checkIdState;
        this.mCheckedIdStates = longSparseArray;
    }

    @Override
    public Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        SparseBooleanArray sparseBooleanArray = this.mCheckStates;
        LongSparseArray<Boolean> longSparseArray = this.mCheckedIdStates;
        return new SavedState(parcelable, sparseBooleanArray, longSparseArray);
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        View view;
        if (this.getChildCount() > 0 && (view = this.getFocusedChild()) != null) {
            int n5 = this.mFirstPosition;
            int n6 = this.indexOfChild(view);
            int n7 = n5 + n6;
            int n8 = view.getBottom();
            int n9 = this.mPaddingTop;
            int n10 = n2 - n9;
            int n11 = n8 - n10;
            int n12 = Math.max(0, n11);
            int n13 = view.getTop() - n12;
            if (this.mFocusSelector == null) {
                FocusSelector focusSelector;
                this.mFocusSelector = focusSelector = new FocusSelector();
            }
            FocusSelector focusSelector = this.mFocusSelector.setup(n7, n13);
            boolean bl = this.post(focusSelector);
        }
        super.onSizeChanged(n, n2, n3, n4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (!this.mItemsCanFocus) return super.onTouchEvent(motionEvent);
        if (motionEvent.getAction() != 0) return super.onTouchEvent(motionEvent);
        if (motionEvent.getEdgeFlags() == 0) return super.onTouchEvent(motionEvent);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean pageScroll(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = -1;
        boolean bl = false;
        if (n == 33) {
            int n8 = this.mSelectedPosition;
            int n9 = this.getChildCount();
            int n10 = n8 - n9 - 1;
            n7 = Math.max(0, n10);
        } else if (n == 130) {
            int n11 = this.mItemCount - 1;
            int n12 = this.mSelectedPosition;
            int n13 = this.getChildCount();
            int n14 = n12 + n13 - 1;
            n7 = Math.min(n11, n14);
            bl = true;
        }
        if (n7 < 0) return false;
        int n15 = this.lookForSelectablePosition(n7, bl);
        if (n15 < 0) return false;
        this.mLayoutMode = 4;
        int n16 = this.mPaddingTop;
        int n17 = this.getVerticalFadingEdgeLength();
        this.mSpecificTop = n6 = n16 + n17;
        if (bl && n15 > (n5 = (n4 = this.mItemCount) - (n3 = this.getChildCount()))) {
            this.mLayoutMode = 3;
        }
        if (!bl && n15 < (n2 = this.getChildCount())) {
            this.mLayoutMode = 1;
        }
        this.setSelectionInt(n15);
        this.invokeOnItemScrollListener();
        if (this.awakenScrollBars()) return true;
        this.invalidate();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean performItemClick(View view, int n, long l) {
        boolean bl = false;
        if (this.mChoiceMode != 0) {
            bl = true;
            if (this.mChoiceMode == 2) {
                boolean bl2 = !this.mCheckStates.get(n, false);
                this.mCheckStates.put(n, bl2);
                if (this.mCheckedIdStates != null && this.mAdapter.hasStableIds()) {
                    if (bl2) {
                        LongSparseArray<Boolean> longSparseArray = this.mCheckedIdStates;
                        long l2 = this.mAdapter.getItemId(n);
                        Boolean bl3 = Boolean.TRUE;
                        longSparseArray.put(l2, bl3);
                    } else {
                        LongSparseArray<Boolean> longSparseArray = this.mCheckedIdStates;
                        long l3 = this.mAdapter.getItemId(n);
                        longSparseArray.delete(l3);
                    }
                }
            } else {
                boolean bl4 = !this.mCheckStates.get(n, false);
                if (bl4) {
                    this.mCheckStates.clear();
                    this.mCheckStates.put(n, true);
                    if (this.mCheckedIdStates != null && this.mAdapter.hasStableIds()) {
                        this.mCheckedIdStates.clear();
                        LongSparseArray<Boolean> longSparseArray = this.mCheckedIdStates;
                        long l4 = this.mAdapter.getItemId(n);
                        Boolean bl5 = Boolean.TRUE;
                        longSparseArray.put(l4, bl5);
                    }
                }
            }
            this.mDataChanged = true;
            this.rememberSyncState();
            this.requestLayout();
        }
        boolean bl6 = super.performItemClick(view, n, l);
        return bl | bl6;
    }

    @ViewDebug.ExportedProperty(category="list")
    protected boolean recycleOnMeasure() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean removeFooterView(View view) {
        if (this.mFooterViewInfos.size() <= 0) return false;
        boolean bl = false;
        if (((HeaderViewListAdapter)this.mAdapter).removeFooter(view)) {
            this.mDataSetObserver.onChanged();
            bl = true;
        }
        ArrayList<FixedViewInfo> arrayList = this.mFooterViewInfos;
        this.removeFixedViewInfo(view, arrayList);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean removeHeaderView(View view) {
        if (this.mHeaderViewInfos.size() <= 0) return false;
        boolean bl = false;
        if (((HeaderViewListAdapter)this.mAdapter).removeHeader(view)) {
            this.mDataSetObserver.onChanged();
            bl = true;
        }
        ArrayList<FixedViewInfo> arrayList = this.mHeaderViewInfos;
        this.removeFixedViewInfo(view, arrayList);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean requestChildRectangleOnScreen(View view, Rect rect, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = rect.top;
        int n11 = view.getLeft();
        int n12 = view.getTop();
        Rect rect2 = rect;
        int n13 = n11;
        int n14 = n12;
        rect2.offset(n13, n14);
        int n15 = -view.getScrollX();
        int n16 = -view.getScrollY();
        Rect rect3 = rect;
        int n17 = n15;
        int n18 = n16;
        rect3.offset(n17, n18);
        int n19 = this.getHeight();
        int n20 = this.getScrollY();
        int n21 = n20 + n19;
        int n22 = this.getVerticalFadingEdgeLength();
        if (this.showingTopFadingEdge() && (this.mSelectedPosition > 0 || n10 > n22)) {
            n20 += n22;
        }
        int n23 = this.getChildCount() - 1;
        ListView listView = this;
        int n24 = n23;
        int n25 = listView.getChildAt(n24).getBottom();
        if (this.showingBottomFadingEdge() && ((n9 = (n8 = this.mSelectedPosition)) < (n7 = (n6 = this.mItemCount - 1)) || (n5 = (n4 = rect.bottom)) < (n3 = (n2 = n25 - n22)))) {
            n21 -= n22;
        }
        int n26 = 0;
        if (rect.bottom > n21 && rect.top > n20) {
            int n27;
            if (rect.height() > n19) {
                int n28 = rect.top - n20;
                n27 = n26 + n28;
            } else {
                int n29 = rect.bottom - n21;
                n27 = n26 + n29;
            }
            int n30 = n25 - n21;
            n26 = Math.min(n27, n30);
        } else if (rect.top < n20 && rect.bottom < n21) {
            int n31;
            if (rect.height() > n19) {
                int n32 = rect.bottom;
                int n33 = n21 - n32;
                n31 = n26 - n33;
            } else {
                int n34 = rect.top;
                int n35 = n20 - n34;
                n31 = n26 - n35;
            }
            ListView listView2 = this;
            int n36 = 0;
            int n37 = listView2.getChildAt(n36).getTop() - n20;
            n26 = Math.max(n31, n37);
        }
        if (n26 == 0) return false;
        boolean bl2 = true;
        if (!bl2) return bl2;
        int n38 = -n26;
        ListView listView3 = this;
        int n39 = n38;
        listView3.scrollListItemsBy(n39);
        this.positionSelector(view);
        this.mSelectedTop = n = view.getTop();
        this.invalidate();
        return bl2;
    }

    @Override
    void resetList() {
        ArrayList<FixedViewInfo> arrayList = this.mHeaderViewInfos;
        this.clearRecycledState(arrayList);
        ArrayList<FixedViewInfo> arrayList2 = this.mFooterViewInfos;
        this.clearRecycledState(arrayList2);
        super.resetList();
        this.mLayoutMode = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setAdapter(ListAdapter listAdapter) {
        if (this.mAdapter != null) {
            ListAdapter listAdapter2 = this.mAdapter;
            AdapterView.AdapterDataSetObserver adapterDataSetObserver = this.mDataSetObserver;
            listAdapter2.unregisterDataSetObserver(adapterDataSetObserver);
        }
        this.resetList();
        this.mRecycler.clear();
        if (this.mHeaderViewInfos.size() > 0 || this.mFooterViewInfos.size() > 0) {
            ArrayList<FixedViewInfo> arrayList = this.mHeaderViewInfos;
            ArrayList<FixedViewInfo> arrayList2 = this.mFooterViewInfos;
            HeaderViewListAdapter headerViewListAdapter = new HeaderViewListAdapter(arrayList, arrayList2, listAdapter);
            this.mAdapter = headerViewListAdapter;
        } else {
            this.mAdapter = listAdapter;
        }
        this.mOldSelectedPosition = -1;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        if (this.mAdapter != null) {
            int n;
            AdapterView.AdapterDataSetObserver adapterDataSetObserver;
            int n2;
            int n3;
            boolean bl;
            this.mAreAllItemsSelectable = bl = this.mAdapter.areAllItemsEnabled();
            this.mOldItemCount = n3 = this.mItemCount;
            this.mItemCount = n2 = this.mAdapter.getCount();
            this.checkFocus();
            this.mDataSetObserver = adapterDataSetObserver = new AdapterView.AdapterDataSetObserver();
            ListAdapter listAdapter3 = this.mAdapter;
            AdapterView.AdapterDataSetObserver adapterDataSetObserver2 = this.mDataSetObserver;
            listAdapter3.registerDataSetObserver(adapterDataSetObserver2);
            AbsListView.RecycleBin recycleBin = this.mRecycler;
            int n4 = this.mAdapter.getViewTypeCount();
            recycleBin.setViewTypeCount(n4);
            if (this.mStackFromBottom) {
                int n5 = this.mItemCount - 1;
                n = this.lookForSelectablePosition(n5, false);
            } else {
                n = this.lookForSelectablePosition(0, true);
            }
            this.setSelectedPositionInt(n);
            this.setNextSelectedPositionInt(n);
            if (this.mItemCount == 0) {
                this.checkSelectionChanged();
            }
            if (this.mChoiceMode != 0 && this.mAdapter.hasStableIds() && this.mCheckedIdStates == null) {
                LongSparseArray longSparseArray = new LongSparseArray();
                this.mCheckedIdStates = longSparseArray;
            }
        } else {
            this.mAreAllItemsSelectable = true;
            this.checkFocus();
            this.checkSelectionChanged();
        }
        if (this.mCheckStates != null) {
            this.mCheckStates.clear();
        }
        if (this.mCheckedIdStates != null) {
            this.mCheckedIdStates.clear();
        }
        this.requestLayout();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setCacheColorHint(int n) {
        boolean bl = n >>> 24 == 255;
        this.mIsCacheColorOpaque = bl;
        if (bl) {
            if (this.mDividerPaint == null) {
                Paint paint;
                this.mDividerPaint = paint = new Paint();
            }
            this.mDividerPaint.setColor(n);
        }
        super.setCacheColorHint(n);
    }

    public void setChoiceMode(int n) {
        this.mChoiceMode = n;
        if (this.mChoiceMode == 0) {
            return;
        }
        if (this.mCheckStates == null) {
            SparseBooleanArray sparseBooleanArray;
            this.mCheckStates = sparseBooleanArray = new SparseBooleanArray();
        }
        if (this.mCheckedIdStates != null) {
            return;
        }
        if (this.mAdapter == null) {
            return;
        }
        if (!this.mAdapter.hasStableIds()) {
            return;
        }
        LongSparseArray longSparseArray = new LongSparseArray();
        this.mCheckedIdStates = longSparseArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDivider(Drawable drawable2) {
        if (drawable2 != null) {
            boolean bl;
            int n;
            this.mDividerHeight = n = drawable2.getIntrinsicHeight();
            this.mClipDivider = bl = drawable2 instanceof ColorDrawable;
        } else {
            this.mDividerHeight = 0;
            this.mClipDivider = false;
        }
        this.mDivider = drawable2;
        boolean bl = drawable2 == null || drawable2.getOpacity() == -1;
        this.mDividerIsOpaque = bl;
        this.requestLayoutIfNecessary();
    }

    public void setDividerHeight(int n) {
        this.mDividerHeight = n;
        this.requestLayoutIfNecessary();
    }

    public void setFooterDividersEnabled(boolean bl) {
        this.mFooterDividersEnabled = bl;
        this.invalidate();
    }

    public void setHeaderDividersEnabled(boolean bl) {
        this.mHeaderDividersEnabled = bl;
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setItemChecked(int n, boolean bl) {
        if (this.mChoiceMode == 0) {
            return;
        }
        if (this.mChoiceMode == 2) {
            this.mCheckStates.put(n, bl);
            if (this.mCheckedIdStates != null && this.mAdapter.hasStableIds()) {
                if (bl) {
                    LongSparseArray<Boolean> longSparseArray = this.mCheckedIdStates;
                    long l = this.mAdapter.getItemId(n);
                    Boolean bl2 = Boolean.TRUE;
                    longSparseArray.put(l, bl2);
                } else {
                    LongSparseArray<Boolean> longSparseArray = this.mCheckedIdStates;
                    long l = this.mAdapter.getItemId(n);
                    longSparseArray.delete(l);
                }
            }
        } else {
            boolean bl3 = this.mCheckedIdStates != null && this.mAdapter.hasStableIds();
            if (bl || this.isItemChecked(n)) {
                this.mCheckStates.clear();
                if (bl3) {
                    this.mCheckedIdStates.clear();
                }
            }
            if (bl) {
                this.mCheckStates.put(n, true);
                if (bl3) {
                    LongSparseArray<Boolean> longSparseArray = this.mCheckedIdStates;
                    long l = this.mAdapter.getItemId(n);
                    Boolean bl4 = Boolean.TRUE;
                    longSparseArray.put(l, bl4);
                }
            }
        }
        if (this.mInLayout) {
            return;
        }
        if (this.mBlockLayoutRequests) {
            return;
        }
        this.mDataChanged = true;
        this.rememberSyncState();
        this.requestLayout();
    }

    public void setItemsCanFocus(boolean bl) {
        this.mItemsCanFocus = bl;
        if (bl) {
            return;
        }
        this.setDescendantFocusability(393216);
    }

    public void setOverscrollFooter(Drawable drawable2) {
        this.mOverScrollFooter = drawable2;
        this.invalidate();
    }

    public void setOverscrollHeader(Drawable drawable2) {
        this.mOverScrollHeader = drawable2;
        if (this.mScrollY >= 0) {
            return;
        }
        this.invalidate();
    }

    @Override
    public void setSelection(int n) {
        this.setSelectionFromTop(n, 0);
    }

    public void setSelectionAfterHeaderView() {
        int n = this.mHeaderViewInfos.size();
        if (n > 0) {
            this.mNextSelectedPosition = 0;
            return;
        }
        if (this.mAdapter != null) {
            this.setSelection(n);
            return;
        }
        this.mNextSelectedPosition = n;
        this.mLayoutMode = 2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setSelectionFromTop(int n, int n2) {
        int n3;
        if (this.mAdapter == null) {
            return;
        }
        if (!this.isInTouchMode()) {
            if ((n = this.lookForSelectablePosition(n, true)) >= 0) {
                this.setNextSelectedPositionInt(n);
            }
        } else {
            this.mResurrectToPosition = n;
        }
        if (n < 0) {
            return;
        }
        this.mLayoutMode = 4;
        this.mSpecificTop = n3 = this.mListPadding.top + n2;
        if (this.mNeedSync) {
            long l;
            this.mSyncPosition = n;
            this.mSyncRowId = l = this.mAdapter.getItemId(n);
        }
        this.requestLayout();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    void setSelectionInt(int n) {
        this.setNextSelectedPositionInt(n);
        boolean bl = false;
        int n2 = this.mSelectedPosition;
        if (n2 >= 0) {
            int n3 = n2 - 1;
            if (n != n3) {
                bl = true;
            } else {
                int n4 = n2 + 1;
                if (n != n4) {
                    bl = true;
                }
            }
        }
        this.layoutChildren();
        if (!bl) {
            return;
        }
        boolean bl2 = this.awakenScrollBars();
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        LongSparseArray<Boolean> checkIdState;
        SparseBooleanArray checkState;

        private SavedState(Parcel parcel) {
            super(parcel);
            SparseBooleanArray sparseBooleanArray;
            this.checkState = sparseBooleanArray = parcel.readSparseBooleanArray();
            long[] lArray = parcel.createLongArray();
            if (lArray.length <= 0) {
                return;
            }
            LongSparseArray longSparseArray = new LongSparseArray();
            LongSparseArray<Boolean> longSparseArray2 = this.checkIdState = longSparseArray;
            Boolean bl = Boolean.TRUE;
            longSparseArray2.setValues(lArray, bl);
        }

        SavedState(Parcelable parcelable, SparseBooleanArray sparseBooleanArray, LongSparseArray<Boolean> longSparseArray) {
            super(parcelable);
            this.checkState = sparseBooleanArray;
            this.checkIdState = longSparseArray;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("ListView.SavedState{");
            String string2 = Integer.toHexString(System.identityHashCode(this));
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" checkState=");
            SparseBooleanArray sparseBooleanArray = this.checkState;
            return stringBuilder2.append(sparseBooleanArray).append("}").toString();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            SparseBooleanArray sparseBooleanArray = this.checkState;
            parcel.writeSparseBooleanArray(sparseBooleanArray);
            long[] lArray = this.checkIdState != null ? this.checkIdState.getKeys() : null;
            parcel.writeLongArray(lArray);
        }
    }

    private static class ArrowScrollFocusResult {
        private int mAmountToScroll;
        private int mSelectedPosition;

        private ArrowScrollFocusResult() {
        }

        public int getAmountToScroll() {
            return this.mAmountToScroll;
        }

        public int getSelectedPosition() {
            return this.mSelectedPosition;
        }

        void populate(int n, int n2) {
            this.mSelectedPosition = n;
            this.mAmountToScroll = n2;
        }
    }

    private class FocusSelector
    implements Runnable {
        private int mPosition;
        private int mPositionTop;

        private FocusSelector() {
        }

        @Override
        public void run() {
            ListView listView = ListView.this;
            int n = this.mPosition;
            int n2 = this.mPositionTop;
            listView.setSelectionFromTop(n, n2);
        }

        public FocusSelector setup(int n, int n2) {
            this.mPosition = n;
            this.mPositionTop = n2;
            return this;
        }
    }

    public class FixedViewInfo {
        public Object data;
        public boolean isSelectable;
        public View view;
    }
}

