/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import com.android.internal.policy.PolicyManager;
import java.util.Formatter;
import java.util.Locale;

public class MediaController
extends FrameLayout {
    private static final int FADE_OUT = 1;
    private static final int SHOW_PROGRESS = 2;
    private static final int sDefaultTimeout = 3000;
    private View mAnchor;
    private Context mContext;
    private TextView mCurrentTime;
    private View mDecor;
    private boolean mDragging;
    private TextView mEndTime;
    private ImageButton mFfwdButton;
    private View.OnClickListener mFfwdListener;
    StringBuilder mFormatBuilder;
    Formatter mFormatter;
    private boolean mFromXml;
    private Handler mHandler;
    private boolean mListenersSet;
    private ImageButton mNextButton;
    private View.OnClickListener mNextListener;
    private ImageButton mPauseButton;
    private View.OnClickListener mPauseListener;
    private MediaPlayerControl mPlayer;
    private ImageButton mPrevButton;
    private View.OnClickListener mPrevListener;
    private ProgressBar mProgress;
    private ImageButton mRewButton;
    private View.OnClickListener mRewListener;
    private View mRoot;
    private SeekBar.OnSeekBarChangeListener mSeekListener;
    private boolean mShowing;
    private View.OnTouchListener mTouchListener;
    private boolean mUseFastForward;
    private Window mWindow;
    private WindowManager mWindowManager;

    public MediaController(Context context) {
        super(context);
        View.OnClickListener onClickListener;
        View.OnClickListener onClickListener2;
        SeekBar.OnSeekBarChangeListener onSeekBarChangeListener;
        View.OnClickListener onClickListener3;
        Handler handler;
        View.OnTouchListener onTouchListener;
        this.mTouchListener = onTouchListener = new View.OnTouchListener(){

            @Override
            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (motionEvent.getAction() == 0 && MediaController.this.mShowing) {
                    MediaController.this.hide();
                }
                return false;
            }
        };
        this.mHandler = handler = new Handler(){

            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 1: {
                        MediaController.this.hide();
                        return;
                    }
                    case 2: 
                }
                int n = MediaController.this.setProgress();
                if (MediaController.this.mDragging) {
                    return;
                }
                if (!MediaController.this.mShowing) {
                    return;
                }
                if (!MediaController.this.mPlayer.isPlaying()) {
                    return;
                }
                Message message2 = this.obtainMessage(2);
                int n2 = n % 1000;
                long l = 1000 - n2;
                boolean bl = this.sendMessageDelayed(message2, l);
            }
        };
        this.mPauseListener = onClickListener3 = new View.OnClickListener(){

            @Override
            public void onClick(View view) {
                MediaController.this.doPauseResume();
                MediaController.this.show(3000);
            }
        };
        this.mSeekListener = onSeekBarChangeListener = new SeekBar.OnSeekBarChangeListener(){

            @Override
            public void onProgressChanged(SeekBar seekBar, int n, boolean bl) {
                if (!bl) {
                    return;
                }
                long l = MediaController.this.mPlayer.getDuration();
                long l2 = (long)n * l / 1000L;
                MediaPlayerControl mediaPlayerControl = MediaController.this.mPlayer;
                int n2 = (int)l2;
                mediaPlayerControl.seekTo(n2);
                if (MediaController.this.mCurrentTime == null) {
                    return;
                }
                TextView textView = MediaController.this.mCurrentTime;
                MediaController mediaController = MediaController.this;
                int n3 = (int)l2;
                String string2 = mediaController.stringForTime(n3);
                textView.setText(string2);
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {
                MediaController.this.show(3600000);
                boolean bl = MediaController.access$202(MediaController.this, true);
                MediaController.this.mHandler.removeMessages(2);
            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
                boolean bl = MediaController.access$202(MediaController.this, false);
                int n = MediaController.this.setProgress();
                MediaController.this.updatePausePlay();
                MediaController.this.show(3000);
                boolean bl2 = MediaController.this.mHandler.sendEmptyMessage(2);
            }
        };
        this.mRewListener = onClickListener2 = new View.OnClickListener(){

            @Override
            public void onClick(View view) {
                int n = MediaController.this.mPlayer.getCurrentPosition() + -5000;
                MediaController.this.mPlayer.seekTo(n);
                int n2 = MediaController.this.setProgress();
                MediaController.this.show(3000);
            }
        };
        this.mFfwdListener = onClickListener = new View.OnClickListener(){

            @Override
            public void onClick(View view) {
                int n = MediaController.this.mPlayer.getCurrentPosition() + 15000;
                MediaController.this.mPlayer.seekTo(n);
                int n2 = MediaController.this.setProgress();
                MediaController.this.show(3000);
            }
        };
        this.mContext = context;
        this.mUseFastForward = true;
        this.initFloatingWindow();
    }

    public MediaController(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        View.OnClickListener onClickListener;
        View.OnClickListener onClickListener2;
        SeekBar.OnSeekBarChangeListener onSeekBarChangeListener;
        View.OnClickListener onClickListener3;
        Handler handler;
        View.OnTouchListener onTouchListener;
        this.mTouchListener = onTouchListener = new /* invalid duplicate definition of identical inner class */;
        this.mHandler = handler = new /* invalid duplicate definition of identical inner class */;
        this.mPauseListener = onClickListener3 = new /* invalid duplicate definition of identical inner class */;
        this.mSeekListener = onSeekBarChangeListener = new /* invalid duplicate definition of identical inner class */;
        this.mRewListener = onClickListener2 = new /* invalid duplicate definition of identical inner class */;
        this.mFfwdListener = onClickListener = new /* invalid duplicate definition of identical inner class */;
        this.mRoot = this;
        this.mContext = context;
        this.mUseFastForward = true;
        this.mFromXml = true;
    }

    public MediaController(Context context, boolean bl) {
        super(context);
        View.OnClickListener onClickListener;
        View.OnClickListener onClickListener2;
        SeekBar.OnSeekBarChangeListener onSeekBarChangeListener;
        View.OnClickListener onClickListener3;
        Handler handler;
        View.OnTouchListener onTouchListener;
        this.mTouchListener = onTouchListener = new /* invalid duplicate definition of identical inner class */;
        this.mHandler = handler = new /* invalid duplicate definition of identical inner class */;
        this.mPauseListener = onClickListener3 = new /* invalid duplicate definition of identical inner class */;
        this.mSeekListener = onSeekBarChangeListener = new /* invalid duplicate definition of identical inner class */;
        this.mRewListener = onClickListener2 = new /* invalid duplicate definition of identical inner class */;
        this.mFfwdListener = onClickListener = new /* invalid duplicate definition of identical inner class */;
        this.mContext = context;
        this.mUseFastForward = bl;
        this.initFloatingWindow();
    }

    static /* synthetic */ boolean access$202(MediaController mediaController, boolean bl) {
        mediaController.mDragging = bl;
        return bl;
    }

    private void disableUnsupportedButtons() {
        try {
            if (this.mPauseButton != null && !this.mPlayer.canPause()) {
                this.mPauseButton.setEnabled(false);
            }
            if (this.mRewButton != null && !this.mPlayer.canSeekBackward()) {
                this.mRewButton.setEnabled(false);
            }
            if (this.mFfwdButton == null) {
                return;
            }
            if (this.mPlayer.canSeekForward()) {
                return;
            }
            this.mFfwdButton.setEnabled(false);
            return;
        }
        catch (IncompatibleClassChangeError incompatibleClassChangeError) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doPauseResume() {
        if (this.mPlayer.isPlaying()) {
            this.mPlayer.pause();
        } else {
            this.mPlayer.start();
        }
        this.updatePausePlay();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initControllerView(View view) {
        Formatter formatter;
        StringBuilder stringBuilder;
        TextView textView;
        TextView textView2;
        ProgressBar progressBar;
        ImageButton imageButton;
        ImageButton imageButton2;
        ImageButton imageButton3;
        int n;
        ImageButton imageButton4;
        ImageButton imageButton5;
        this.mPauseButton = imageButton5 = (ImageButton)view.findViewById(16908787);
        if (this.mPauseButton != null) {
            boolean bl = this.mPauseButton.requestFocus();
            ImageButton imageButton6 = this.mPauseButton;
            View.OnClickListener onClickListener = this.mPauseListener;
            imageButton6.setOnClickListener(onClickListener);
        }
        this.mFfwdButton = imageButton4 = (ImageButton)view.findViewById(16908788);
        if (this.mFfwdButton != null) {
            ImageButton imageButton7 = this.mFfwdButton;
            View.OnClickListener onClickListener = this.mFfwdListener;
            imageButton7.setOnClickListener(onClickListener);
            if (!this.mFromXml) {
                ImageButton imageButton8 = this.mFfwdButton;
                n = this.mUseFastForward ? 0 : 8;
                imageButton8.setVisibility(n);
            }
        }
        this.mRewButton = imageButton3 = (ImageButton)view.findViewById(16908786);
        if (this.mRewButton != null) {
            ImageButton imageButton9 = this.mRewButton;
            View.OnClickListener onClickListener = this.mRewListener;
            imageButton9.setOnClickListener(onClickListener);
            if (!this.mFromXml) {
                ImageButton imageButton10 = this.mRewButton;
                n = this.mUseFastForward ? 0 : 8;
                imageButton10.setVisibility(n);
            }
        }
        this.mNextButton = imageButton2 = (ImageButton)view.findViewById(16908789);
        if (this.mNextButton != null && !this.mFromXml && !this.mListenersSet) {
            this.mNextButton.setVisibility(8);
        }
        this.mPrevButton = imageButton = (ImageButton)view.findViewById(16908785);
        if (this.mPrevButton != null && !this.mFromXml && !this.mListenersSet) {
            this.mPrevButton.setVisibility(8);
        }
        this.mProgress = progressBar = (ProgressBar)view.findViewById(16908791);
        if (this.mProgress != null) {
            if (this.mProgress instanceof SeekBar) {
                SeekBar seekBar = (SeekBar)this.mProgress;
                SeekBar.OnSeekBarChangeListener onSeekBarChangeListener = this.mSeekListener;
                seekBar.setOnSeekBarChangeListener(onSeekBarChangeListener);
            }
            this.mProgress.setMax(1000);
        }
        this.mEndTime = textView2 = (TextView)view.findViewById(16908379);
        this.mCurrentTime = textView = (TextView)view.findViewById(16908790);
        StringBuilder stringBuilder2 = this.mFormatBuilder = (stringBuilder = new StringBuilder());
        Locale locale = Locale.getDefault();
        this.mFormatter = formatter = new Formatter(stringBuilder2, locale);
        this.installPrevNextListeners();
    }

    private void initFloatingWindow() {
        View view;
        Window window;
        WindowManager windowManager;
        this.mWindowManager = windowManager = (WindowManager)this.mContext.getSystemService("window");
        Window window2 = this.mWindow = (window = PolicyManager.makeNewWindow(this.mContext));
        WindowManager windowManager2 = this.mWindowManager;
        window2.setWindowManager(windowManager2, null, null);
        boolean bl = this.mWindow.requestFeature(1);
        View view2 = this.mDecor = (view = this.mWindow.getDecorView());
        View.OnTouchListener onTouchListener = this.mTouchListener;
        view2.setOnTouchListener(onTouchListener);
        this.mWindow.setContentView(this);
        this.mWindow.setBackgroundDrawableResource(17170445);
        this.mWindow.setVolumeControlStream(3);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.setDescendantFocusability(262144);
        boolean bl2 = this.requestFocus();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void installPrevNextListeners() {
        boolean bl;
        if (this.mNextButton != null) {
            ImageButton imageButton = this.mNextButton;
            View.OnClickListener onClickListener = this.mNextListener;
            imageButton.setOnClickListener(onClickListener);
            ImageButton imageButton2 = this.mNextButton;
            bl = this.mNextListener != null;
            imageButton2.setEnabled(bl);
        }
        if (this.mPrevButton == null) {
            return;
        }
        ImageButton imageButton = this.mPrevButton;
        View.OnClickListener onClickListener = this.mPrevListener;
        imageButton.setOnClickListener(onClickListener);
        ImageButton imageButton3 = this.mPrevButton;
        bl = this.mPrevListener != null;
        imageButton3.setEnabled(bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int setProgress() {
        if (this.mPlayer == null) return 0;
        if (this.mDragging) {
            return 0;
        }
        int n = this.mPlayer.getCurrentPosition();
        int n2 = this.mPlayer.getDuration();
        if (this.mProgress != null) {
            if (n2 > 0) {
                long l = n;
                long l2 = 1000L * l;
                long l3 = n2;
                long l4 = l2 / l3;
                ProgressBar progressBar = this.mProgress;
                int n3 = (int)l4;
                progressBar.setProgress(n3);
            }
            int n4 = this.mPlayer.getBufferPercentage();
            ProgressBar progressBar = this.mProgress;
            int n5 = n4 * 10;
            progressBar.setSecondaryProgress(n5);
        }
        if (this.mEndTime != null) {
            TextView textView = this.mEndTime;
            String string2 = this.stringForTime(n2);
            textView.setText(string2);
        }
        if (this.mCurrentTime == null) return n;
        TextView textView = this.mCurrentTime;
        String string3 = this.stringForTime(n);
        textView.setText(string3);
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String stringForTime(int n) {
        int n2 = n / 1000;
        int n3 = n2 % 60;
        int n4 = n2 / 60 % 60;
        int n5 = n2 / 3600;
        this.mFormatBuilder.setLength(0);
        if (n5 > 0) {
            Formatter formatter = this.mFormatter;
            Object[] objectArray = new Object[3];
            Integer n6 = n5;
            objectArray[0] = n6;
            Integer n7 = n4;
            objectArray[1] = n7;
            Integer n8 = n3;
            objectArray[2] = n8;
            return formatter.format("%d:%02d:%02d", objectArray).toString();
        }
        Formatter formatter = this.mFormatter;
        Object[] objectArray = new Object[2];
        Integer n9 = n4;
        objectArray[0] = n9;
        Integer n10 = n3;
        objectArray[1] = n10;
        return formatter.format("%02d:%02d", objectArray).toString();
    }

    private void updatePausePlay() {
        if (this.mRoot == null) {
            return;
        }
        if (this.mPauseButton == null) {
            return;
        }
        if (this.mPlayer.isPlaying()) {
            this.mPauseButton.setImageResource(17301539);
            return;
        }
        this.mPauseButton.setImageResource(17301540);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (keyEvent.getRepeatCount() == 0 && keyEvent.isDown() && (n == 79 || n == 85 || n == 62)) {
            this.doPauseResume();
            this.show(3000);
            if (this.mPauseButton == null) return true;
            boolean bl = this.mPauseButton.requestFocus();
            return true;
        }
        if (n == 86) {
            if (!this.mPlayer.isPlaying()) return true;
            this.mPlayer.pause();
            this.updatePausePlay();
            return true;
        }
        if (n == 25) return super.dispatchKeyEvent(keyEvent);
        if (n == 24) {
            return super.dispatchKeyEvent(keyEvent);
        }
        if (n == 4 || n == 82) {
            this.hide();
            return true;
        }
        this.show(3000);
        return super.dispatchKeyEvent(keyEvent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void hide() {
        if (this.mAnchor == null) {
            return;
        }
        if (!this.mShowing) {
            return;
        }
        try {
            this.mHandler.removeMessages(2);
            WindowManager windowManager = this.mWindowManager;
            View view = this.mDecor;
            windowManager.removeView(view);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            int n = Log.w("MediaController", "already removed");
        }
        this.mShowing = false;
    }

    public boolean isShowing() {
        return this.mShowing;
    }

    protected View makeControllerView() {
        View view;
        View view2 = this.mRoot = (view = ((LayoutInflater)this.mContext.getSystemService("layout_inflater")).inflate(17367105, null));
        this.initControllerView(view2);
        return this.mRoot;
    }

    @Override
    public void onFinishInflate() {
        if (this.mRoot == null) {
            return;
        }
        View view = this.mRoot;
        this.initControllerView(view);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        this.show(3000);
        return true;
    }

    @Override
    public boolean onTrackballEvent(MotionEvent motionEvent) {
        this.show(3000);
        return false;
    }

    public void setAnchorView(View view) {
        this.mAnchor = view;
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        this.removeAllViews();
        View view2 = this.makeControllerView();
        this.addView(view2, layoutParams);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setEnabled(boolean bl) {
        boolean bl2;
        if (this.mPauseButton != null) {
            this.mPauseButton.setEnabled(bl);
        }
        if (this.mFfwdButton != null) {
            this.mFfwdButton.setEnabled(bl);
        }
        if (this.mRewButton != null) {
            this.mRewButton.setEnabled(bl);
        }
        if (this.mNextButton != null) {
            ImageButton imageButton = this.mNextButton;
            bl2 = bl && this.mNextListener != null;
            imageButton.setEnabled(bl2);
        }
        if (this.mPrevButton != null) {
            ImageButton imageButton = this.mPrevButton;
            bl2 = bl && this.mPrevListener != null;
            imageButton.setEnabled(bl2);
        }
        if (this.mProgress != null) {
            this.mProgress.setEnabled(bl);
        }
        this.disableUnsupportedButtons();
        super.setEnabled(bl);
    }

    public void setMediaPlayer(MediaPlayerControl mediaPlayerControl) {
        this.mPlayer = mediaPlayerControl;
        this.updatePausePlay();
    }

    public void setPrevNextListeners(View.OnClickListener onClickListener, View.OnClickListener onClickListener2) {
        this.mNextListener = onClickListener;
        this.mPrevListener = onClickListener2;
        this.mListenersSet = true;
        if (this.mRoot == null) {
            return;
        }
        this.installPrevNextListeners();
        if (this.mNextButton != null && !this.mFromXml) {
            this.mNextButton.setVisibility(0);
        }
        if (this.mPrevButton == null) {
            return;
        }
        if (this.mFromXml) {
            return;
        }
        this.mPrevButton.setVisibility(0);
    }

    public void show() {
        this.show(3000);
    }

    public void show(int n) {
        if (!this.mShowing && this.mAnchor != null) {
            int n2;
            int n3;
            int n4;
            int n5 = this.setProgress();
            if (this.mPauseButton != null) {
                boolean bl = this.mPauseButton.requestFocus();
            }
            this.disableUnsupportedButtons();
            int[] nArray = new int[2];
            this.mAnchor.getLocationOnScreen(nArray);
            WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams();
            layoutParams.gravity = 48;
            layoutParams.width = n4 = this.mAnchor.getWidth();
            layoutParams.height = -1;
            layoutParams.x = 0;
            int n6 = nArray[1];
            int n7 = this.mAnchor.getHeight();
            int n8 = n6 + n7;
            int n9 = layoutParams.height;
            layoutParams.y = n3 = n8 - n9;
            layoutParams.format = -1;
            layoutParams.type = 1000;
            layoutParams.flags = n2 = layoutParams.flags | 0x20000;
            layoutParams.token = null;
            layoutParams.windowAnimations = 0;
            WindowManager windowManager = this.mWindowManager;
            View view = this.mDecor;
            windowManager.addView(view, layoutParams);
            this.mShowing = true;
        }
        this.updatePausePlay();
        boolean bl = this.mHandler.sendEmptyMessage(2);
        Message message = this.mHandler.obtainMessage(1);
        if (n == 0) {
            return;
        }
        this.mHandler.removeMessages(1);
        Handler handler = this.mHandler;
        long l = n;
        boolean bl2 = handler.sendMessageDelayed(message, l);
    }

    public static interface MediaPlayerControl {
        public boolean canPause();

        public boolean canSeekBackward();

        public boolean canSeekForward();

        public int getBufferPercentage();

        public int getCurrentPosition();

        public int getDuration();

        public boolean isPlaying();

        public void pause();

        public void seekTo(int var1);

        public void start();
    }
}

