/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.text.Editable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.method.QwertyKeyListener;
import android.util.AttributeSet;
import android.widget.AutoCompleteTextView;
import android.widget.Filter;

public class MultiAutoCompleteTextView
extends AutoCompleteTextView {
    private Tokenizer mTokenizer;

    public MultiAutoCompleteTextView(Context context) {
        this(context, null);
    }

    public MultiAutoCompleteTextView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842859);
    }

    public MultiAutoCompleteTextView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean enoughToFilter() {
        int n;
        Editable editable = this.getText();
        int n2 = this.getSelectionEnd();
        if (n2 < 0) return false;
        if (this.mTokenizer == null) {
            return false;
        }
        int n3 = this.mTokenizer.findTokenStart(editable, n2);
        int n4 = n2 - n3;
        if (n4 < (n = this.getThreshold())) return false;
        return true;
    }

    void finishInit() {
    }

    @Override
    protected void performFiltering(CharSequence charSequence, int n) {
        if (this.enoughToFilter()) {
            int n2 = this.getSelectionEnd();
            int n3 = this.mTokenizer.findTokenStart(charSequence, n2);
            this.performFiltering(charSequence, n3, n2, n);
            return;
        }
        this.dismissDropDown();
        Filter filter = this.getFilter();
        if (filter == null) {
            return;
        }
        filter.filter(null);
    }

    protected void performFiltering(CharSequence charSequence, int n, int n2, int n3) {
        Filter filter = this.getFilter();
        CharSequence charSequence2 = charSequence.subSequence(n, n2);
        filter.filter(charSequence2, this);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void performValidation() {
        AutoCompleteTextView.Validator validator = this.getValidator();
        if (validator == null) {
            return;
        }
        if (this.mTokenizer == null) {
            return;
        }
        Editable editable = this.getText();
        int n = this.getText().length();
        while (n > 0) {
            int n2;
            int n3 = this.mTokenizer.findTokenStart(editable, n);
            CharSequence charSequence = editable.subSequence(n3, n2 = this.mTokenizer.findTokenEnd(editable, n3));
            if (TextUtils.isEmpty(charSequence)) {
                Editable editable2 = editable.replace(n3, n, "");
            } else if (!validator.isValid(charSequence)) {
                Tokenizer tokenizer = this.mTokenizer;
                CharSequence charSequence2 = validator.fixText(charSequence);
                CharSequence charSequence3 = tokenizer.terminateToken(charSequence2);
                Editable editable3 = editable.replace(n3, n, charSequence3);
            }
            n = n3;
        }
        return;
    }

    @Override
    protected void replaceText(CharSequence charSequence) {
        this.clearComposingText();
        int n = this.getSelectionEnd();
        Tokenizer tokenizer = this.mTokenizer;
        Editable editable = this.getText();
        int n2 = tokenizer.findTokenStart(editable, n);
        Editable editable2 = this.getText();
        String string2 = TextUtils.substring(editable2, n2, n);
        QwertyKeyListener.markAsReplaced(editable2, n2, n, string2);
        CharSequence charSequence2 = this.mTokenizer.terminateToken(charSequence);
        Editable editable3 = editable2.replace(n2, n, charSequence2);
    }

    public void setTokenizer(Tokenizer tokenizer) {
        this.mTokenizer = tokenizer;
    }

    public static class CommaTokenizer
    implements Tokenizer {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int findTokenEnd(CharSequence charSequence, int n) {
            int n2 = n;
            int n3 = charSequence.length();
            while (n2 < n3) {
                if (charSequence.charAt(n2) == ',') {
                    return n2;
                }
                ++n2;
            }
            return n3;
        }

        @Override
        public int findTokenStart(CharSequence charSequence, int n) {
            int n2;
            int n3;
            for (n3 = n; n3 > 0 && charSequence.charAt(n2 = n3 - 1) != ','; n3 += -1) {
            }
            while (n3 < n && charSequence.charAt(n3) == ' ') {
                ++n3;
            }
            return n3;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public CharSequence terminateToken(CharSequence charSequence) {
            int n;
            int n2;
            int n3;
            for (n3 = charSequence.length(); n3 > 0 && charSequence.charAt(n2 = n3 - 1) == ' '; n3 += -1) {
            }
            if (n3 > 0 && charSequence.charAt(n = n3 - 1) == ',') {
                return charSequence;
            }
            if (!(charSequence instanceof Spanned)) return charSequence + ", ";
            String string2 = charSequence + ", ";
            SpannableString spannableString = new SpannableString(string2);
            Spanned spanned = (Spanned)charSequence;
            int n4 = charSequence.length();
            int n5 = 0;
            TextUtils.copySpansFrom(spanned, 0, n4, Object.class, spannableString, n5);
            return spannableString;
        }
    }

    public static interface Tokenizer {
        public int findTokenEnd(CharSequence var1, int var2);

        public int findTokenStart(CharSequence var1, int var2);

        public CharSequence terminateToken(CharSequence var1);
    }
}

