/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.os.Handler;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.method.NumberKeyListener;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.NumberPickerButton;
import android.widget.TextView;

public class NumberPicker
extends LinearLayout {
    private static final char[] DIGIT_CHARACTERS;
    public static final Formatter TWO_DIGIT_FORMATTER;
    private int mCurrent;
    private boolean mDecrement;
    private NumberPickerButton mDecrementButton;
    private String[] mDisplayedValues;
    private int mEnd;
    private Formatter mFormatter;
    private final Handler mHandler;
    private boolean mIncrement;
    private NumberPickerButton mIncrementButton;
    private OnChangedListener mListener;
    private final InputFilter mNumberInputFilter;
    private int mPrevious;
    private final Runnable mRunnable;
    private long mSpeed;
    private int mStart;
    private final EditText mText;

    static {
        TWO_DIGIT_FORMATTER = new Formatter(){
            final Object[] mArgs;
            final StringBuilder mBuilder;
            final java.util.Formatter mFmt;
            {
                java.util.Formatter formatter;
                StringBuilder stringBuilder;
                StringBuilder stringBuilder2 = this.mBuilder = (stringBuilder = new StringBuilder());
                this.mFmt = formatter = new java.util.Formatter(stringBuilder2);
                Object[] objectArray = new Object[1];
                this.mArgs = objectArray;
            }

            @Override
            public String toString(int n) {
                Object[] objectArray = this.mArgs;
                Integer n2 = n;
                objectArray[0] = n2;
                StringBuilder stringBuilder = this.mBuilder;
                int n3 = this.mBuilder.length();
                StringBuilder stringBuilder2 = stringBuilder.delete(0, n3);
                java.util.Formatter formatter = this.mFmt;
                Object[] objectArray2 = this.mArgs;
                java.util.Formatter formatter2 = formatter.format("%02d", objectArray2);
                return this.mFmt.toString();
            }
        };
        DIGIT_CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    }

    public NumberPicker(Context context) {
        this(context, null);
    }

    public NumberPicker(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        EditText editText;
        NumberPickerButton numberPickerButton;
        NumberPickerButton numberPickerButton2;
        Handler handler;
        Runnable runnable;
        this.mRunnable = runnable = new Runnable(){

            @Override
            public void run() {
                if (NumberPicker.this.mIncrement) {
                    NumberPicker numberPicker = NumberPicker.this;
                    int n = NumberPicker.this.mCurrent + 1;
                    numberPicker.changeCurrent(n);
                    Handler handler = NumberPicker.this.mHandler;
                    long l = NumberPicker.this.mSpeed;
                    boolean bl = handler.postDelayed(this, l);
                    return;
                }
                if (!NumberPicker.this.mDecrement) {
                    return;
                }
                NumberPicker numberPicker = NumberPicker.this;
                int n = NumberPicker.this.mCurrent - 1;
                numberPicker.changeCurrent(n);
                Handler handler = NumberPicker.this.mHandler;
                long l = NumberPicker.this.mSpeed;
                boolean bl = handler.postDelayed(this, l);
            }
        };
        this.mSpeed = 300L;
        this.setOrientation(1);
        View view = ((LayoutInflater)this.mContext.getSystemService("layout_inflater")).inflate(17367107, (ViewGroup)this, true);
        this.mHandler = handler = new Handler();
        View.OnClickListener onClickListener = new View.OnClickListener(){

            @Override
            public void onClick(View view) {
                int n;
                NumberPicker numberPicker = NumberPicker.this;
                EditText editText = NumberPicker.this.mText;
                numberPicker.validateInput(editText);
                if (!NumberPicker.this.mText.hasFocus()) {
                    boolean bl = NumberPicker.this.mText.requestFocus();
                }
                if (16908794 != (n = view.getId())) {
                    NumberPicker numberPicker2 = NumberPicker.this;
                    int n2 = NumberPicker.this.mCurrent + 1;
                    numberPicker2.changeCurrent(n2);
                    return;
                }
                int n3 = view.getId();
                if (16908796 != n3) {
                    return;
                }
                NumberPicker numberPicker3 = NumberPicker.this;
                int n4 = NumberPicker.this.mCurrent - 1;
                numberPicker3.changeCurrent(n4);
            }
        };
        View.OnFocusChangeListener onFocusChangeListener = new View.OnFocusChangeListener(){

            @Override
            public void onFocusChange(View view, boolean bl) {
                if (bl) {
                    return;
                }
                NumberPicker.this.validateInput(view);
            }
        };
        View.OnLongClickListener onLongClickListener = new View.OnLongClickListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public boolean onLongClick(View view) {
                NumberPicker.this.mText.clearFocus();
                int n = view.getId();
                if (16908794 != n) {
                    boolean bl = NumberPicker.access$002(NumberPicker.this, true);
                    Handler handler = NumberPicker.this.mHandler;
                    Runnable runnable = NumberPicker.this.mRunnable;
                    boolean bl2 = handler.post(runnable);
                    return true;
                }
                int n2 = view.getId();
                if (16908796 == n2) return true;
                boolean bl = NumberPicker.access$402(NumberPicker.this, true);
                Handler handler = NumberPicker.this.mHandler;
                Runnable runnable = NumberPicker.this.mRunnable;
                boolean bl3 = handler.post(runnable);
                return true;
            }
        };
        NumberPickerInputFilter numberPickerInputFilter = new NumberPickerInputFilter();
        NumberRangeKeyListener numberRangeKeyListener = new NumberRangeKeyListener();
        this.mNumberInputFilter = numberRangeKeyListener;
        this.mIncrementButton = numberPickerButton2 = (NumberPickerButton)this.findViewById(16908794);
        this.mIncrementButton.setOnClickListener(onClickListener);
        this.mIncrementButton.setOnLongClickListener(onLongClickListener);
        this.mIncrementButton.setNumberPicker(this);
        this.mDecrementButton = numberPickerButton = (NumberPickerButton)this.findViewById(16908796);
        this.mDecrementButton.setOnClickListener(onClickListener);
        this.mDecrementButton.setOnLongClickListener(onLongClickListener);
        this.mDecrementButton.setNumberPicker(this);
        this.mText = editText = (EditText)this.findViewById(16908795);
        this.mText.setOnFocusChangeListener(onFocusChangeListener);
        EditText editText2 = this.mText;
        InputFilter[] inputFilterArray = new InputFilter[]{numberPickerInputFilter};
        editText2.setFilters(inputFilterArray);
        this.mText.setRawInputType(2);
        if (this.isEnabled()) {
            return;
        }
        this.setEnabled(false);
    }

    static /* synthetic */ boolean access$002(NumberPicker numberPicker, boolean bl) {
        numberPicker.mIncrement = bl;
        return bl;
    }

    static /* synthetic */ boolean access$402(NumberPicker numberPicker, boolean bl) {
        numberPicker.mDecrement = bl;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String formatNumber(int n) {
        if (this.mFormatter == null) return String.valueOf(n);
        return this.mFormatter.toString(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getSelectedPos(String string2) {
        int n;
        if (this.mDisplayedValues == null) {
            try {
                int n2 = Integer.parseInt(string2);
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                return this.mStart;
            }
        }
        for (int i = 0; i < (n = this.mDisplayedValues.length); string2 = string2.toLowerCase(), ++i) {
            if (!this.mDisplayedValues[i].toLowerCase().startsWith(string2)) continue;
            return this.mStart + i;
        }
        try {
            int n3 = Integer.parseInt(string2);
            return n3;
        }
        catch (NumberFormatException numberFormatException) {
            return this.mStart;
        }
    }

    private void notifyChange() {
        if (this.mListener == null) {
            return;
        }
        OnChangedListener onChangedListener = this.mListener;
        int n = this.mPrevious;
        int n2 = this.mCurrent;
        onChangedListener.onChanged(this, n, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateView() {
        if (this.mDisplayedValues == null) {
            EditText editText = this.mText;
            int n = this.mCurrent;
            String string2 = this.formatNumber(n);
            editText.setText(string2);
        } else {
            EditText editText = this.mText;
            String[] stringArray = this.mDisplayedValues;
            int n = this.mCurrent;
            int n2 = this.mStart;
            int n3 = n - n2;
            String string3 = stringArray[n3];
            editText.setText(string3);
        }
        EditText editText = this.mText;
        int n = this.mText.getText().length();
        editText.setSelection(n);
    }

    private void validateCurrentView(CharSequence charSequence) {
        int n;
        int n2;
        String string2 = ((Object)charSequence).toString();
        int n3 = this.getSelectedPos(string2);
        if (n3 >= (n2 = this.mStart) && n3 <= (n = this.mEnd) && this.mCurrent != n3) {
            int n4;
            this.mPrevious = n4 = this.mCurrent;
            this.mCurrent = n3;
            this.notifyChange();
        }
        this.updateView();
    }

    private void validateInput(View view) {
        String string2 = String.valueOf(((TextView)view).getText());
        if ("".equals(string2)) {
            this.updateView();
            return;
        }
        this.validateCurrentView(string2);
    }

    public void cancelDecrement() {
        this.mDecrement = false;
    }

    public void cancelIncrement() {
        this.mIncrement = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void changeCurrent(int n) {
        int n2;
        int n3 = this.mEnd;
        if (n > n3) {
            n = this.mStart;
        } else {
            int n4 = this.mStart;
            if (n < n4) {
                n = this.mEnd;
            }
        }
        this.mPrevious = n2 = this.mCurrent;
        this.mCurrent = n;
        this.notifyChange();
        this.updateView();
    }

    protected int getBeginRange() {
        return this.mStart;
    }

    public int getCurrent() {
        return this.mCurrent;
    }

    protected int getEndRange() {
        return this.mEnd;
    }

    public void setCurrent(int n) {
        int n2;
        int n3 = this.mStart;
        if (n < n3 || n > (n2 = this.mEnd)) {
            throw new IllegalArgumentException("current should be >= start and <= end");
        }
        this.mCurrent = n;
        this.updateView();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.mIncrementButton.setEnabled(bl);
        this.mDecrementButton.setEnabled(bl);
        this.mText.setEnabled(bl);
    }

    public void setFormatter(Formatter formatter) {
        this.mFormatter = formatter;
    }

    public void setOnChangeListener(OnChangedListener onChangedListener) {
        this.mListener = onChangedListener;
    }

    public void setRange(int n, int n2) {
        this.setRange(n, n2, null);
    }

    public void setRange(int n, int n2, String[] stringArray) {
        this.mDisplayedValues = stringArray;
        this.mStart = n;
        this.mEnd = n2;
        this.mCurrent = n;
        this.updateView();
        if (stringArray == null) {
            return;
        }
        this.mText.setRawInputType(524289);
    }

    public void setSpeed(long l) {
        this.mSpeed = l;
    }

    private class NumberRangeKeyListener
    extends NumberKeyListener {
        private NumberRangeKeyListener() {
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public CharSequence filter(CharSequence charSequence, int n, int n2, Spanned spanned, int n3, int n4) {
            int n5;
            void var14_15;
            int n6;
            CharSequence charSequence2;
            String string2;
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2;
            String string3;
            CharSequence charSequence3 = super.filter(charSequence, n, n2, spanned, n3, n4);
            if (charSequence3 == null) {
                charSequence3 = charSequence.subSequence(n, n2);
            }
            if ("".equals(string3 = (stringBuilder2 = (stringBuilder = new StringBuilder()).append(string2 = String.valueOf(spanned.subSequence(0, n3))).append((Object)charSequence3)).append((Object)(charSequence2 = spanned.subSequence(n4, n6 = spanned.length()))).toString())) {
                String string4 = string3;
                return var14_15;
            }
            int n7 = NumberPicker.this.getSelectedPos(string3);
            if (n7 > (n5 = NumberPicker.this.mEnd)) {
                return var14_15;
            }
            CharSequence charSequence4 = charSequence3;
            return var14_15;
        }

        @Override
        protected char[] getAcceptedChars() {
            return DIGIT_CHARACTERS;
        }

        @Override
        public int getInputType() {
            return 2;
        }
    }

    private class NumberPickerInputFilter
    implements InputFilter {
        private NumberPickerInputFilter() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public CharSequence filter(CharSequence charSequence, int n, int n2, Spanned spanned, int n3, int n4) {
            if (NumberPicker.this.mDisplayedValues == null) {
                InputFilter inputFilter = NumberPicker.this.mNumberInputFilter;
                CharSequence charSequence2 = charSequence;
                int n5 = n;
                int n6 = n2;
                Spanned spanned2 = spanned;
                int n7 = n3;
                int n8 = n4;
                return inputFilter.filter(charSequence2, n5, n6, spanned2, n7, n8);
            }
            String string2 = String.valueOf(charSequence.subSequence(n, n2));
            StringBuilder stringBuilder = new StringBuilder();
            Spanned spanned3 = spanned;
            int n9 = 0;
            int n10 = n3;
            String string3 = String.valueOf(spanned3.subSequence(n9, n10));
            StringBuilder stringBuilder2 = stringBuilder.append(string3).append((Object)string2);
            int n11 = spanned.length();
            Spanned spanned4 = spanned;
            int n12 = n4;
            int n13 = n11;
            CharSequence charSequence3 = spanned4.subSequence(n12, n13);
            String string4 = String.valueOf(stringBuilder2.append((Object)charSequence3).toString()).toLowerCase();
            String[] stringArray = NumberPicker.this.mDisplayedValues;
            int n14 = stringArray.length;
            int n15 = 0;
            while (n15 < n14) {
                String string5;
                String string6 = stringArray[n15].toLowerCase();
                if (string6.startsWith(string5 = string4)) {
                    return string2;
                }
                ++n15;
            }
            return "";
        }
    }

    public static interface Formatter {
        public String toString(int var1);
    }

    public static interface OnChangedListener {
        public void onChanged(NumberPicker var1, int var2, int var3);
    }
}

