/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.util.FloatMath;
import android.view.ViewConfiguration;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.widget.Scroller;

public class OverScroller {
    private static final int DEFAULT_DURATION = 250;
    private static final int FLING_MODE = 1;
    private static final int SCROLL_MODE;
    private final Interpolator mInterpolator;
    private int mMode;
    private MagneticOverScroller mScrollerX;
    private MagneticOverScroller mScrollerY;

    public OverScroller(Context context) {
        this(context, null);
    }

    public OverScroller(Context context, Interpolator interpolator) {
        this(context, interpolator, 0.16f, 0.16f);
    }

    public OverScroller(Context context, Interpolator interpolator, float f, float f2) {
        MagneticOverScroller magneticOverScroller;
        MagneticOverScroller magneticOverScroller2;
        this.mInterpolator = interpolator;
        this.mScrollerX = magneticOverScroller2 = new MagneticOverScroller();
        this.mScrollerY = magneticOverScroller = new MagneticOverScroller();
        MagneticOverScroller.initializeFromContext(context);
        this.mScrollerX.setBounceCoefficient(f);
        this.mScrollerY.setBounceCoefficient(f2);
    }

    public void abortAnimation() {
        this.mScrollerX.finish();
        this.mScrollerY.finish();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean computeScrollOffset() {
        if (this.isFinished()) {
            return false;
        }
        switch (this.mMode) {
            case 0: {
                long l = AnimationUtils.currentAnimationTimeMillis();
                long l2 = this.mScrollerX.mStartTime;
                long l3 = l - l2;
                int n = this.mScrollerX.mDuration;
                long l4 = n;
                if (l3 < l4) {
                    float f = l3;
                    float f2 = n;
                    float f3 = f / f2;
                    float f4 = this.mInterpolator == null ? Scroller.viscousFluid(f3) : this.mInterpolator.getInterpolation(f3);
                    this.mScrollerX.updateScroll(f4);
                    this.mScrollerY.updateScroll(f4);
                    return true;
                }
                this.abortAnimation();
            }
            default: {
                return true;
            }
            case 1: {
                if (!(this.mScrollerX.mFinished || this.mScrollerX.update() || this.mScrollerX.continueWhenFinished())) {
                    this.mScrollerX.finish();
                }
                if (this.mScrollerY.mFinished) return true;
                if (this.mScrollerY.update()) return true;
                if (this.mScrollerY.continueWhenFinished()) return true;
                this.mScrollerY.finish();
            }
        }
        return true;
    }

    public void extendDuration(int n) {
        this.mScrollerX.extendDuration(n);
        this.mScrollerY.extendDuration(n);
    }

    public void fling(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        OverScroller overScroller = this;
        int n9 = n;
        int n10 = n2;
        int n11 = n3;
        int n12 = n4;
        int n13 = n5;
        int n14 = n6;
        int n15 = n7;
        int n16 = n8;
        overScroller.fling(n9, n10, n11, n12, n13, n14, n15, n16, 0, 0);
    }

    public void fling(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        this.mMode = 1;
        MagneticOverScroller magneticOverScroller = this.mScrollerX;
        int n11 = n;
        int n12 = n3;
        int n13 = n5;
        int n14 = n6;
        int n15 = n9;
        magneticOverScroller.fling(n11, n12, n13, n14, n15);
        MagneticOverScroller magneticOverScroller2 = this.mScrollerY;
        int n16 = n2;
        int n17 = n4;
        int n18 = n7;
        int n19 = n8;
        int n20 = n10;
        magneticOverScroller2.fling(n16, n17, n18, n19, n20);
    }

    public final void forceFinished(boolean bl) {
        MagneticOverScroller magneticOverScroller = this.mScrollerX;
        this.mScrollerY.mFinished = bl;
        magneticOverScroller.mFinished = bl;
    }

    public float getCurrVelocity() {
        float f = this.mScrollerX.mCurrVelocity;
        float f2 = this.mScrollerX.mCurrVelocity;
        float f3 = f * f2;
        float f4 = this.mScrollerY.mCurrVelocity;
        float f5 = this.mScrollerY.mCurrVelocity;
        float f6 = f4 * f5;
        return FloatMath.sqrt(f3 + f6);
    }

    public final int getCurrX() {
        return this.mScrollerX.mCurrentPosition;
    }

    public final int getCurrY() {
        return this.mScrollerY.mCurrentPosition;
    }

    public final int getDuration() {
        int n = this.mScrollerX.mDuration;
        int n2 = this.mScrollerY.mDuration;
        return Math.max(n, n2);
    }

    public final int getFinalX() {
        return this.mScrollerX.mFinal;
    }

    public final int getFinalY() {
        return this.mScrollerY.mFinal;
    }

    public final int getStartX() {
        return this.mScrollerX.mStart;
    }

    public final int getStartY() {
        return this.mScrollerY.mStart;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isFinished() {
        if (!this.mScrollerX.mFinished) return false;
        if (!this.mScrollerY.mFinished) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOverScrolled() {
        if (!this.mScrollerX.mFinished) {
            if (this.mScrollerX.mState != 0) return true;
        }
        if (this.mScrollerY.mFinished) return false;
        if (this.mScrollerY.mState == 0) return false;
        return true;
    }

    public void notifyHorizontalEdgeReached(int n, int n2, int n3) {
        this.mScrollerX.notifyEdgeReached(n, n2, n3);
    }

    public void notifyVerticalEdgeReached(int n, int n2, int n3) {
        this.mScrollerY.notifyEdgeReached(n, n2, n3);
    }

    public void setFinalX(int n) {
        this.mScrollerX.setFinalPosition(n);
    }

    public void setFinalY(int n) {
        this.mScrollerY.setFinalPosition(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean springBack(int n, int n2, int n3, int n4, int n5, int n6) {
        this.mMode = 1;
        boolean bl = this.mScrollerX.springback(n, n3, n4);
        boolean bl2 = this.mScrollerY.springback(n2, n5, n6);
        if (bl) return true;
        if (!bl2) return false;
        return true;
    }

    public void startScroll(int n, int n2, int n3, int n4) {
        OverScroller overScroller = this;
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        overScroller.startScroll(n5, n6, n7, n8, 250);
    }

    public void startScroll(int n, int n2, int n3, int n4, int n5) {
        this.mMode = 0;
        this.mScrollerX.startScroll(n, n3, n5);
        this.mScrollerY.startScroll(n2, n4, n5);
    }

    public int timePassed() {
        long l = AnimationUtils.currentAnimationTimeMillis();
        long l2 = this.mScrollerX.mStartTime;
        long l3 = this.mScrollerY.mStartTime;
        long l4 = Math.min(l2, l3);
        return (int)(l - l4);
    }

    static class MagneticOverScroller {
        private static final float DEFAULT_BOUNCE_COEFFICIENT = 0.16f;
        static float GRAVITY = 0.0f;
        private static final float MINIMUM_VELOCITY_FOR_BOUNCE = Float.MAX_VALUE;
        private static final int OVERSCROLL_SPRINGBACK_DURATION = 200;
        private static final float TIME_COEF = (float)Math.PI * 5;
        private static final int TO_BOUNCE = 2;
        private static final int TO_BOUNDARY = 1;
        private static final int TO_EDGE;
        private float mBounceCoefficient = 0.16f;
        float mCurrVelocity;
        int mCurrentPosition;
        float mDeceleration;
        int mDuration;
        int mFinal;
        boolean mFinished = true;
        private int mOver;
        int mStart;
        long mStartTime;
        private int mState = 0;
        int mVelocity;

        MagneticOverScroller() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static int computeDuration(int n, int n2, float f, float f2) {
            float f3 = f * f;
            float f4 = 2.0f * f2;
            int n3 = n - n2;
            float f5 = n3;
            float f6 = f4 * f5;
            float f7 = f3 - f6;
            if (!(f7 >= 0.0f)) return 0;
            float f8 = (float)Math.sqrt(f7);
            if (f2 < 0.0f) {
                f8 = -f8;
            }
            float f9 = -f - f8;
            return (int)(1000.0f * f9 / f2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static float getDeceleration(int n) {
            if (n <= 0) return GRAVITY;
            return -GRAVITY;
        }

        static void initializeFromContext(Context context) {
            float f = context.getResources().getDisplayMetrics().density * 160.0f;
            float f2 = 386.0878f * f;
            float f3 = ViewConfiguration.getScrollFriction();
            GRAVITY = f2 * f3;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void onEdgeReached() {
            int n;
            int n2;
            float f;
            float f2 = (float)this.mVelocity / ((float)Math.PI * 5);
            float f3 = Math.abs(f2);
            if (f3 < (f = (float)this.mOver)) {
                int n3;
                this.mState = 2;
                this.mFinal = n3 = this.mStart;
                this.mDuration = 200;
                return;
            }
            this.mState = 1;
            int n4 = this.mVelocity > 0 ? this.mOver : -this.mOver;
            this.mFinal = n2 = this.mStart + n4;
            double d = Math.asin((float)n4 / f2);
            this.mDuration = n = (int)(1000.0 * d / 15.707963943481445);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void startSpringback(int n, int n2, boolean bl) {
            int n3;
            long l;
            this.mFinished = false;
            this.mState = 2;
            this.mFinal = n2;
            this.mStart = n2;
            this.mDuration = 200;
            this.mStartTime = l = this.mStartTime - 100L;
            double d = (float)Math.abs(n2 - n) * ((float)Math.PI * 5);
            double d2 = bl ? 1.0 : -1.0;
            this.mVelocity = n3 = (int)(d * d2);
        }

        /*
         * Unable to fully structure code
         */
        boolean continueWhenFinished() {
            switch (this.mState) lbl-1000:
            // 3 sources

            {
                default: lbl-1000:
                // 2 sources

                {
                    while (true) {
                        var1_1 = this.update();
                        var2_2 = true;
lbl6:
                        // 3 sources

                        return var2_2;
                    }
                }
                case 0: {
                    var3_3 = this.mVelocity;
                    var4_4 = -1000.0f * var3_3;
                    var5_5 = this.mDeceleration;
                    var6_6 = (int)(var4_4 / var5_5);
                    if (this.mDuration >= var6_6) ** GOTO lbl25
                    this.mStart = var7_7 = this.mFinal;
                    var8_8 = this.mVelocity;
                    var9_9 = this.mDeceleration;
                    var10_10 = this.mDuration;
                    var11_11 = var9_9 * var10_10 / 1000.0f;
                    this.mVelocity = var12_12 = (int)(var8_8 + var11_11);
                    var13_13 = this.mStartTime;
                    var15_14 = this.mDuration;
                    this.mStartTime = var17_15 = var13_13 + var15_14;
                    this.onEdgeReached();
                    ** GOTO lbl-1000
lbl25:
                    // 1 sources

                    var2_2 = false;
                    ** GOTO lbl6
                }
                case 1: {
                    var19_16 = this.mStartTime;
                    var21_17 = this.mDuration;
                    this.mStartTime = var23_18 = var19_16 + var21_17;
                    var25_19 = this.mFinal;
                    var26_20 = this.mFinal;
                    if (this.mVelocity <= 0) ** GOTO lbl42
                    var27_21 = this.mOver;
lbl35:
                    // 2 sources

                    while (true) {
                        var28_22 = var26_20 - var27_21;
                        if (this.mVelocity <= 0) ** GOTO lbl44
                        var29_23 = true;
lbl39:
                        // 2 sources

                        while (true) {
                            this.startSpringback(var25_19, var28_22, var29_23);
                            ** GOTO lbl-1000
                            break;
                        }
                        break;
                    }
lbl42:
                    // 1 sources

                    var27_21 = -this.mOver;
                    ** continue;
lbl44:
                    // 1 sources

                    var29_23 = false;
                    ** continue;
                }
                case 2: 
            }
            var30_24 = this.mVelocity;
            var31_25 = this.mBounceCoefficient;
            this.mVelocity = var32_26 = (int)(var30_24 * var31_25);
            if ((float)Math.abs(this.mVelocity) < 3.4028235E38f) {
                var2_2 = false;
                ** continue;
            }
            var33_27 = this.mStartTime;
            var35_28 = this.mDuration;
            this.mStartTime = var37_29 = var33_27 + var35_28;
            ** while (true)
        }

        void extendDuration(int n) {
            int n2;
            long l = AnimationUtils.currentAnimationTimeMillis();
            long l2 = this.mStartTime;
            this.mDuration = n2 = (int)(l - l2) + n;
            this.mFinished = false;
        }

        void finish() {
            int n;
            this.mCurrentPosition = n = this.mFinal;
            this.mFinished = true;
        }

        void fling(int n, int n2, int n3, int n4) {
            int n5;
            int n6;
            int n7;
            float f;
            long l;
            this.mFinished = false;
            this.mStart = n;
            this.mStartTime = l = AnimationUtils.currentAnimationTimeMillis();
            this.mVelocity = n2;
            this.mDeceleration = f = MagneticOverScroller.getDeceleration(n2);
            if (this.mStart < n3) {
                this.mDuration = 0;
                this.mFinal = n3;
                return;
            }
            if (this.mStart > n4) {
                this.mDuration = 0;
                this.mFinal = n4;
                return;
            }
            float f2 = n2;
            float f3 = -1000.0f * f2;
            float f4 = this.mDeceleration;
            this.mDuration = n7 = (int)(f3 / f4);
            float f5 = n2 * n2;
            float f6 = this.mDeceleration;
            float f7 = 2.0f * f6;
            int n8 = Math.round(f5 / f7);
            this.mFinal = n6 = n - n8;
            if (this.mFinal < n3) {
                int n9;
                this.mFinal = n3;
                int n10 = this.mStart;
                float f8 = this.mVelocity;
                float f9 = this.mDeceleration;
                this.mDuration = n9 = MagneticOverScroller.computeDuration(n10, n3, f8, f9);
            }
            if (this.mFinal <= n4) {
                return;
            }
            this.mFinal = n4;
            int n11 = this.mStart;
            float f10 = this.mVelocity;
            float f11 = this.mDeceleration;
            this.mDuration = n5 = MagneticOverScroller.computeDuration(n11, n4, f10, f11);
        }

        void fling(int n, int n2, int n3, int n4, int n5) {
            int n6;
            long l;
            int n7;
            int n8;
            float f;
            long l2;
            this.mState = 0;
            this.mOver = n5;
            this.mFinished = false;
            this.mStart = n;
            this.mStartTime = l2 = AnimationUtils.currentAnimationTimeMillis();
            this.mVelocity = n2;
            this.mDeceleration = f = MagneticOverScroller.getDeceleration(n2);
            float f2 = n2;
            float f3 = -1000.0f * f2;
            float f4 = this.mDeceleration;
            this.mDuration = n8 = (int)(f3 / f4);
            float f5 = n2 * n2;
            float f6 = this.mDeceleration;
            float f7 = 2.0f * f6;
            int n9 = Math.round(f5 / f7);
            this.mFinal = n7 = n - n9;
            if (this.mFinal < n3) {
                int n10;
                this.mFinal = n3;
                int n11 = this.mStart;
                float f8 = this.mVelocity;
                float f9 = this.mDeceleration;
                this.mDuration = n10 = MagneticOverScroller.computeDuration(n11, n3, f8, f9);
            }
            if (this.mFinal > n4) {
                int n12;
                this.mFinal = n4;
                int n13 = this.mStart;
                float f10 = this.mVelocity;
                float f11 = this.mDeceleration;
                this.mDuration = n12 = MagneticOverScroller.computeDuration(n13, n4, f10, f11);
            }
            if (n > n4) {
                int n14;
                long l3;
                int n15 = n4 + n5;
                if (n >= n15) {
                    int n16 = n4 + n5;
                    boolean bl = this.springback(n16, n3, n4);
                    return;
                }
                if (n2 <= 0) {
                    boolean bl = this.springback(n, n3, n4);
                    return;
                }
                long l4 = AnimationUtils.currentAnimationTimeMillis();
                float f12 = (float)(n - n4) * ((float)Math.PI * 5);
                float f13 = n2;
                double d = Math.atan(f12 / f13) / 15.707963943481445;
                double d2 = l4;
                double d3 = 1000.0 * d;
                this.mStartTime = l3 = (long)((int)(d2 - d3));
                this.mStart = n4;
                double d4 = n2;
                double d5 = Math.cos(15.707963943481445 * d);
                this.mVelocity = n14 = (int)(d4 / d5);
                this.onEdgeReached();
                return;
            }
            if (n >= n3) {
                return;
            }
            int n17 = n3 - n5;
            if (n <= n17) {
                int n18 = n3 - n5;
                boolean bl = this.springback(n18, n3, n4);
                return;
            }
            if (n2 >= 0) {
                boolean bl = this.springback(n, n3, n4);
                return;
            }
            long l5 = AnimationUtils.currentAnimationTimeMillis();
            float f14 = (float)(n - n3) * ((float)Math.PI * 5);
            float f15 = n2;
            double d = Math.atan(f14 / f15) / 15.707963943481445;
            double d6 = l5;
            double d7 = 1000.0 * d;
            this.mStartTime = l = (long)((int)(d6 - d7));
            this.mStart = n3;
            double d8 = n2;
            double d9 = Math.cos(15.707963943481445 * d);
            this.mVelocity = n6 = (int)(d8 / d9);
            this.onEdgeReached();
        }

        void notifyEdgeReached(int n, int n2, int n3) {
            long l;
            int n4;
            float f;
            this.mDeceleration = f = MagneticOverScroller.getDeceleration(this.mVelocity);
            float f2 = this.mCurrVelocity;
            float f3 = this.mDeceleration;
            float f4 = f2 / f3;
            float f5 = n2 - n;
            float f6 = 2.0f * f5;
            float f7 = this.mDeceleration;
            float f8 = f6 / f7;
            float f9 = f4 * f4;
            float f10 = -((float)Math.sqrt(f8 + f9));
            this.mVelocity = n4 = (int)(this.mDeceleration * f10);
            this.mStart = n2;
            this.mOver = n3;
            float f11 = AnimationUtils.currentAnimationTimeMillis();
            float f12 = f4 - f10;
            float f13 = 1000.0f * f12;
            this.mStartTime = l = (long)((int)(f11 - f13));
            this.onEdgeReached();
        }

        void setBounceCoefficient(float f) {
            this.mBounceCoefficient = f;
        }

        void setFinalPosition(int n) {
            this.mFinal = n;
            this.mFinished = false;
        }

        /*
         * Enabled aggressive block sorting
         */
        boolean springback(int n, int n2, int n3) {
            long l;
            this.mFinished = true;
            this.mStart = n;
            this.mVelocity = 0;
            this.mStartTime = l = AnimationUtils.currentAnimationTimeMillis();
            this.mDuration = 0;
            if (n < n2) {
                this.startSpringback(n, n2, false);
            } else if (n > n3) {
                this.startSpringback(n, n3, true);
            }
            if (this.mFinished) return false;
            return true;
        }

        void startScroll(int n, int n2, int n3) {
            long l;
            int n4;
            this.mFinished = false;
            this.mStart = n;
            this.mFinal = n4 = n + n2;
            this.mStartTime = l = AnimationUtils.currentAnimationTimeMillis();
            this.mDuration = n3;
            this.mDeceleration = 0.0f;
            this.mVelocity = 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        boolean update() {
            int n;
            double d;
            long l;
            long l2;
            long l3 = AnimationUtils.currentAnimationTimeMillis();
            long l4 = l3 - (l2 = this.mStartTime);
            if (l4 > (l = (long)this.mDuration)) {
                return false;
            }
            float f = (float)l4 / 1000.0f;
            if (this.mState == 0) {
                float f2;
                float f3 = this.mVelocity;
                float f4 = this.mDeceleration * f;
                this.mCurrVelocity = f2 = f3 + f4;
                float f5 = (float)this.mVelocity * f;
                float f6 = this.mDeceleration * f * f / 2.0f;
                d = f5 + f6;
            } else {
                float f7;
                float f8 = f * ((float)Math.PI * 5);
                float f9 = this.mVelocity;
                float f10 = (float)Math.cos(f8);
                this.mCurrVelocity = f7 = f9 * f10;
                double d2 = (float)this.mVelocity / ((float)Math.PI * 5);
                double d3 = Math.sin(f8);
                d = d2 * d3;
            }
            int n2 = this.mStart;
            int n3 = (int)d;
            this.mCurrentPosition = n = n2 + n3;
            return true;
        }

        void updateScroll(float f) {
            int n;
            int n2 = this.mStart;
            int n3 = this.mFinal;
            int n4 = this.mStart;
            int n5 = Math.round((float)(n3 - n4) * f);
            this.mCurrentPosition = n = n2 + n5;
        }
    }
}

