/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.IBinder;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.android.internal.R;
import java.lang.ref.WeakReference;

public class PopupWindow {
    private static final int[] ABOVE_ANCHOR_STATE_SET;
    public static final int INPUT_METHOD_FROM_FOCUSABLE = 0;
    public static final int INPUT_METHOD_NEEDED = 1;
    public static final int INPUT_METHOD_NOT_NEEDED = 2;
    private boolean mAboveAnchor;
    private Drawable mAboveAnchorBackgroundDrawable;
    private WeakReference<View> mAnchor;
    private int mAnchorXoff;
    private int mAnchorYoff;
    private int mAnimationStyle;
    private Drawable mBackground;
    private Drawable mBelowAnchorBackgroundDrawable;
    private boolean mClippingEnabled;
    private View mContentView;
    private Context mContext;
    private int[] mDrawingLocation;
    private boolean mFocusable;
    private int mHeight;
    private int mHeightMode;
    private boolean mIgnoreCheekPress;
    private int mInputMethodMode;
    private boolean mIsDropdown;
    private boolean mIsShowing;
    private int mLastHeight;
    private int mLastWidth;
    private boolean mLayoutInScreen;
    private OnDismissListener mOnDismissListener;
    private ViewTreeObserver.OnScrollChangedListener mOnScrollChangedListener;
    private boolean mOutsideTouchable;
    private int mPopupHeight;
    private View mPopupView;
    private int mPopupWidth;
    private int[] mScreenLocation;
    private int mSoftInputMode;
    private boolean mSplitTouchEnabled;
    private Rect mTempRect;
    private View.OnTouchListener mTouchInterceptor;
    private boolean mTouchable;
    private int mWidth;
    private int mWidthMode;
    private int mWindowLayoutType;
    private WindowManager mWindowManager;

    static {
        int[] nArray = new int[]{0x10100AA};
        ABOVE_ANCHOR_STATE_SET = nArray;
    }

    public PopupWindow() {
        this(null, 0, 0);
    }

    public PopupWindow(int n, int n2) {
        this(null, n, n2);
    }

    public PopupWindow(Context context) {
        this(context, null);
    }

    public PopupWindow(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842870);
    }

    /*
     * Enabled aggressive block sorting
     */
    public PopupWindow(Context context, AttributeSet attributeSet, int n) {
        TypedArray typedArray;
        block5: {
            Drawable drawable2;
            WindowManager windowManager;
            ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
            Rect rect;
            this.mInputMethodMode = 0;
            this.mTouchable = true;
            this.mOutsideTouchable = false;
            this.mClippingEnabled = true;
            int[] nArray = new int[2];
            this.mDrawingLocation = nArray;
            int[] nArray2 = new int[2];
            this.mScreenLocation = nArray2;
            this.mTempRect = rect = new Rect();
            this.mWindowLayoutType = 1000;
            this.mIgnoreCheekPress = false;
            this.mAnimationStyle = -1;
            this.mOnScrollChangedListener = onScrollChangedListener = new ViewTreeObserver.OnScrollChangedListener(){

                @Override
                public void onScrollChanged() {
                    View view = (View)PopupWindow.this.mAnchor.get();
                    if (view == null) {
                        return;
                    }
                    if (PopupWindow.this.mPopupView == null) {
                        return;
                    }
                    WindowManager.LayoutParams layoutParams = (WindowManager.LayoutParams)PopupWindow.this.mPopupView.getLayoutParams();
                    PopupWindow popupWindow = PopupWindow.this;
                    PopupWindow popupWindow2 = PopupWindow.this;
                    int n = PopupWindow.this.mAnchorXoff;
                    int n2 = PopupWindow.this.mAnchorYoff;
                    boolean bl = popupWindow2.findDropDownPosition(view, layoutParams, n, n2);
                    popupWindow.updateAboveAnchor(bl);
                    PopupWindow popupWindow3 = PopupWindow.this;
                    int n3 = layoutParams.x;
                    int n4 = layoutParams.y;
                    int n5 = -1;
                    popupWindow3.update(n3, n4, -1, n5, true);
                }
            };
            this.mContext = context;
            this.mWindowManager = windowManager = (WindowManager)context.getSystemService("window");
            int[] nArray3 = R.styleable.PopupWindow;
            typedArray = context.obtainStyledAttributes(attributeSet, nArray3, n, 0);
            this.mBackground = drawable2 = typedArray.getDrawable(0);
            int n2 = typedArray.getResourceId(1, -1);
            int n3 = n2 == 16973947 ? -1 : n2;
            this.mAnimationStyle = n3;
            if (!(this.mBackground instanceof StateListDrawable)) break block5;
            StateListDrawable stateListDrawable = (StateListDrawable)this.mBackground;
            int[] nArray4 = ABOVE_ANCHOR_STATE_SET;
            int n4 = stateListDrawable.getStateDrawableIndex(nArray4);
            int n5 = stateListDrawable.getStateCount();
            int n6 = -1;
            int n7 = 0;
            while (true) {
                block7: {
                    block6: {
                        if (n7 >= n5) break block6;
                        if (n7 == n4) break block7;
                        n6 = n7;
                    }
                    if (n4 != -1 && n6 != -1) {
                        Drawable drawable3;
                        Drawable drawable4;
                        this.mAboveAnchorBackgroundDrawable = drawable4 = stateListDrawable.getStateDrawable(n4);
                        this.mBelowAnchorBackgroundDrawable = drawable3 = stateListDrawable.getStateDrawable(n6);
                        break;
                    }
                    this.mBelowAnchorBackgroundDrawable = null;
                    this.mAboveAnchorBackgroundDrawable = null;
                    break;
                }
                ++n7;
            }
        }
        typedArray.recycle();
    }

    public PopupWindow(View view) {
        this(view, 0, 0);
    }

    public PopupWindow(View view, int n, int n2) {
        this(view, n, n2, false);
    }

    public PopupWindow(View view, int n, int n2, boolean bl) {
        ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
        Rect rect;
        this.mInputMethodMode = 0;
        this.mTouchable = true;
        this.mOutsideTouchable = false;
        this.mClippingEnabled = true;
        int[] nArray = new int[2];
        this.mDrawingLocation = nArray;
        int[] nArray2 = new int[2];
        this.mScreenLocation = nArray2;
        this.mTempRect = rect = new Rect();
        this.mWindowLayoutType = 1000;
        this.mIgnoreCheekPress = false;
        this.mAnimationStyle = -1;
        this.mOnScrollChangedListener = onScrollChangedListener = new /* invalid duplicate definition of identical inner class */;
        if (view != null) {
            WindowManager windowManager;
            Context context;
            this.mContext = context = view.getContext();
            this.mWindowManager = windowManager = (WindowManager)this.mContext.getSystemService("window");
        }
        this.setContentView(view);
        this.setWidth(n);
        this.setHeight(n2);
        this.setFocusable(bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int computeAnimationResource() {
        if (this.mAnimationStyle != -1) return this.mAnimationStyle;
        if (!this.mIsDropdown) return 0;
        if (!this.mAboveAnchor) return 16973939;
        return 16973940;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int computeFlags(int n) {
        int n2 = n & 0xFF797DE7;
        if (this.mIgnoreCheekPress) {
            int n3 = n2 | 0x8000;
        }
        if (!this.mFocusable) {
            n2 |= 8;
            if (this.mInputMethodMode == 1) {
                n2 |= 0x20000;
            }
        } else if (this.mInputMethodMode == 2) {
            n2 |= 0x20000;
        }
        if (!this.mTouchable) {
            n2 |= 0x10;
        }
        if (this.mOutsideTouchable) {
            n2 |= 0x40000;
        }
        if (!this.mClippingEnabled) {
            n2 |= 0x200;
        }
        if (this.mSplitTouchEnabled) {
            n2 |= 0x800000;
        }
        if (this.mLayoutInScreen) {
            n2 |= 0x100;
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private WindowManager.LayoutParams createPopupLayout(IBinder iBinder) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams();
        layoutParams.gravity = 51;
        this.mLastWidth = n6 = this.mWidth;
        layoutParams.width = n6;
        this.mLastHeight = n5 = this.mHeight;
        layoutParams.height = n5;
        layoutParams.format = this.mBackground != null ? (n4 = this.mBackground.getOpacity()) : -1;
        int n7 = layoutParams.flags;
        layoutParams.flags = n3 = this.computeFlags(n7);
        layoutParams.type = n2 = this.mWindowLayoutType;
        layoutParams.token = iBinder;
        layoutParams.softInputMode = n = this.mSoftInputMode;
        StringBuilder stringBuilder = new StringBuilder().append("PopupWindow:");
        String string2 = Integer.toHexString(this.hashCode());
        String string3 = stringBuilder.append(string2).toString();
        layoutParams.setTitle(string3);
        return layoutParams;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean findDropDownPosition(View view, WindowManager.LayoutParams layoutParams, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int[] nArray = this.mDrawingLocation;
        view.getLocationInWindow(nArray);
        layoutParams.x = n9 = this.mDrawingLocation[0] + n;
        int n10 = this.mDrawingLocation[1];
        int n11 = view.getHeight();
        layoutParams.y = n8 = n10 + n11 + n2;
        boolean bl = false;
        layoutParams.gravity = 51;
        int[] nArray2 = this.mScreenLocation;
        view.getLocationOnScreen(nArray2);
        Rect rect = new Rect();
        view.getWindowVisibleDisplayFrame(rect);
        View view2 = view.getRootView();
        int n12 = layoutParams.y;
        int n13 = this.mPopupHeight;
        int n14 = n12 + n13;
        int n15 = rect.bottom;
        if (n14 > n15 || (n7 = (n6 = layoutParams.x) + (n5 = this.mPopupWidth)) - (n4 = view2.getWidth()) > 0) {
            int n16;
            int n17;
            int n18 = view.getScrollX();
            int n19 = view.getScrollY();
            int n20 = this.mPopupWidth + n18 + n;
            int n21 = this.mPopupHeight + n19;
            int n22 = view.getHeight();
            int n23 = n21 + n22 + n2;
            Rect rect2 = new Rect(n18, n19, n20, n23);
            boolean bl2 = view.requestRectangleOnScreen(rect2, true);
            int[] nArray3 = this.mDrawingLocation;
            view.getLocationInWindow(nArray3);
            layoutParams.x = n17 = this.mDrawingLocation[0] + n;
            int n24 = this.mDrawingLocation[1];
            int n25 = view.getHeight();
            layoutParams.y = n16 = n24 + n25 + n2;
            int[] nArray4 = this.mScreenLocation;
            view.getLocationOnScreen(nArray4);
            int n26 = rect.bottom;
            int n27 = this.mScreenLocation[1];
            int n28 = n26 - n27;
            int n29 = view.getHeight();
            int n30 = n28 - n29 - n2;
            int n31 = this.mScreenLocation[1] - n2;
            int n32 = rect.top;
            int n33 = n31 - n32;
            bl = n30 < n33;
            if (bl) {
                int n34;
                layoutParams.gravity = 83;
                int n35 = view2.getHeight();
                int n36 = this.mDrawingLocation[1];
                layoutParams.y = n34 = n35 - n36 + n2;
            } else {
                int n37;
                int n38 = this.mDrawingLocation[1];
                int n39 = view.getHeight();
                layoutParams.y = n37 = n38 + n39 + n2;
            }
        }
        layoutParams.gravity = n3 = layoutParams.gravity | 0x10000000;
        return bl;
    }

    private void invokePopup(WindowManager.LayoutParams layoutParams) {
        String string2;
        layoutParams.packageName = string2 = this.mContext.getPackageName();
        WindowManager windowManager = this.mWindowManager;
        View view = this.mPopupView;
        windowManager.addView(view, layoutParams);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void preparePopup(WindowManager.LayoutParams layoutParams) {
        int n;
        int n2;
        if (this.mContentView == null || this.mContext == null || this.mWindowManager == null) {
            throw new IllegalStateException("You must specify a valid content view by calling setContentView() before attempting to show the popup.");
        }
        if (this.mBackground != null) {
            ViewGroup.LayoutParams layoutParams2 = this.mContentView.getLayoutParams();
            int n3 = -1;
            if (layoutParams2 != null && layoutParams2.height == -1) {
                n3 = -1;
            }
            Context context = this.mContext;
            PopupViewContainer popupViewContainer = new PopupViewContainer(context);
            FrameLayout.LayoutParams layoutParams3 = new FrameLayout.LayoutParams(-1, n3);
            Drawable drawable2 = this.mBackground;
            popupViewContainer.setBackgroundDrawable(drawable2);
            View view = this.mContentView;
            popupViewContainer.addView(view, layoutParams3);
            this.mPopupView = popupViewContainer;
        } else {
            View view;
            this.mPopupView = view = this.mContentView;
        }
        this.mPopupWidth = n2 = layoutParams.width;
        this.mPopupHeight = n = layoutParams.height;
    }

    private void registerForScrollChanged(View view, int n, int n2) {
        this.unregisterForScrollChanged();
        WeakReference<View> weakReference = new WeakReference<View>(view);
        this.mAnchor = weakReference;
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        if (viewTreeObserver != null) {
            ViewTreeObserver.OnScrollChangedListener onScrollChangedListener = this.mOnScrollChangedListener;
            viewTreeObserver.addOnScrollChangedListener(onScrollChangedListener);
        }
        this.mAnchorXoff = n;
        this.mAnchorYoff = n2;
    }

    private void unregisterForScrollChanged() {
        WeakReference<View> weakReference = this.mAnchor;
        View view = null;
        if (weakReference != null) {
            view = (View)weakReference.get();
        }
        if (view != null) {
            ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
            ViewTreeObserver.OnScrollChangedListener onScrollChangedListener = this.mOnScrollChangedListener;
            viewTreeObserver.removeOnScrollChangedListener(onScrollChangedListener);
        }
        this.mAnchor = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void update(View view, boolean bl, int n, int n2, boolean bl2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        View view2;
        Object t;
        if (!this.isShowing()) {
            return;
        }
        if (this.mContentView == null) {
            return;
        }
        WeakReference<View> weakReference = this.mAnchor;
        if (weakReference == null || (t = weakReference.get()) != (view2 = view) || bl && ((n9 = this.mAnchorXoff) == (n8 = n) || (n7 = this.mAnchorYoff) != (n6 = n2))) {
            PopupWindow popupWindow = this;
            View view3 = view;
            int n10 = n;
            int n11 = n2;
            popupWindow.registerForScrollChanged(view3, n10, n11);
        }
        WindowManager.LayoutParams layoutParams = (WindowManager.LayoutParams)this.mPopupView.getLayoutParams();
        if (bl2) {
            int n12;
            int n13;
            int n14 = n3;
            int n15 = -1;
            if (n14 == n15) {
                n3 = this.mPopupWidth;
            } else {
                int n16;
                this.mPopupWidth = n16 = n3;
            }
            if ((n13 = n4) == (n12 = -1)) {
                n4 = this.mPopupHeight;
            } else {
                int n17;
                this.mPopupHeight = n17 = n4;
            }
        }
        int n18 = layoutParams.x;
        int n19 = layoutParams.y;
        if (bl) {
            PopupWindow popupWindow = this;
            View view4 = view;
            WindowManager.LayoutParams layoutParams2 = layoutParams;
            int n20 = n;
            int n21 = n2;
            boolean bl3 = popupWindow.findDropDownPosition(view4, layoutParams2, n20, n21);
            this.updateAboveAnchor(bl3);
        } else {
            int n22 = this.mAnchorXoff;
            int n23 = this.mAnchorYoff;
            PopupWindow popupWindow = this;
            View view5 = view;
            WindowManager.LayoutParams layoutParams3 = layoutParams;
            int n24 = n22;
            int n25 = n23;
            boolean bl4 = popupWindow.findDropDownPosition(view5, layoutParams3, n24, n25);
            this.updateAboveAnchor(bl4);
        }
        int n26 = layoutParams.x;
        int n27 = layoutParams.y;
        int n28 = layoutParams.x;
        boolean bl5 = n18 == n28 || n19 != (n5 = layoutParams.y);
        PopupWindow popupWindow = this;
        int n29 = n3;
        int n30 = n4;
        popupWindow.update(n26, n27, n29, n30, bl5);
    }

    private void updateAboveAnchor(boolean bl) {
        boolean bl2 = this.mAboveAnchor;
        if (bl != bl2) {
            return;
        }
        this.mAboveAnchor = bl;
        if (this.mBackground == null) {
            return;
        }
        if (this.mAboveAnchorBackgroundDrawable != null) {
            if (this.mAboveAnchor) {
                View view = this.mPopupView;
                Drawable drawable2 = this.mAboveAnchorBackgroundDrawable;
                view.setBackgroundDrawable(drawable2);
                return;
            }
            View view = this.mPopupView;
            Drawable drawable3 = this.mBelowAnchorBackgroundDrawable;
            view.setBackgroundDrawable(drawable3);
            return;
        }
        this.mPopupView.refreshDrawableState();
    }

    public void dismiss() {
        View view;
        View view2;
        if (!this.isShowing()) {
            return;
        }
        if (this.mPopupView == null) {
            return;
        }
        this.unregisterForScrollChanged();
        try {
            WindowManager windowManager = this.mWindowManager;
            View view3 = this.mPopupView;
            windowManager.removeView(view3);
            view2 = this.mPopupView;
            view = this.mContentView;
        }
        catch (Throwable throwable) {
            View view4 = this.mPopupView;
            View view5 = this.mContentView;
            if (view4 != view5 && this.mPopupView instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)this.mPopupView;
                View view6 = this.mContentView;
                viewGroup.removeView(view6);
            }
            this.mPopupView = null;
            this.mIsShowing = false;
            if (this.mOnDismissListener != null) {
                this.mOnDismissListener.onDismiss();
            }
            throw throwable;
        }
        if (view2 != view && this.mPopupView instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)this.mPopupView;
            View view7 = this.mContentView;
            viewGroup.removeView(view7);
        }
        this.mPopupView = null;
        this.mIsShowing = false;
        if (this.mOnDismissListener == null) {
            return;
        }
        this.mOnDismissListener.onDismiss();
    }

    public int getAnimationStyle() {
        return this.mAnimationStyle;
    }

    public Drawable getBackground() {
        return this.mBackground;
    }

    public View getContentView() {
        return this.mContentView;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getInputMethodMode() {
        return this.mInputMethodMode;
    }

    public int getMaxAvailableHeight(View view) {
        return this.getMaxAvailableHeight(view, 0);
    }

    public int getMaxAvailableHeight(View view, int n) {
        return this.getMaxAvailableHeight(view, n, false);
    }

    public int getMaxAvailableHeight(View view, int n, boolean bl) {
        Rect rect = new Rect();
        view.getWindowVisibleDisplayFrame(rect);
        int[] nArray = this.mDrawingLocation;
        view.getLocationOnScreen(nArray);
        int n2 = rect.bottom;
        if (bl) {
            n2 = view.getContext().getResources().getDisplayMetrics().heightPixels;
        }
        int n3 = nArray[1];
        int n4 = view.getHeight();
        int n5 = n3 + n4;
        int n6 = n2 - n5 - n;
        int n7 = nArray[1];
        int n8 = rect.top;
        int n9 = n7 - n8 + n;
        int n10 = Math.max(n6, n9);
        if (this.mBackground != null) {
            Drawable drawable2 = this.mBackground;
            Rect rect2 = this.mTempRect;
            boolean bl2 = drawable2.getPadding(rect2);
            int n11 = this.mTempRect.top;
            int n12 = this.mTempRect.bottom;
            int n13 = n11 + n12;
            n10 -= n13;
        }
        return n10;
    }

    public int getSoftInputMode() {
        return this.mSoftInputMode;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getWindowLayoutType() {
        return this.mWindowLayoutType;
    }

    public boolean isAboveAnchor() {
        return this.mAboveAnchor;
    }

    public boolean isClippingEnabled() {
        return this.mClippingEnabled;
    }

    public boolean isFocusable() {
        return this.mFocusable;
    }

    public boolean isLayoutInScreenEnabled() {
        return this.mLayoutInScreen;
    }

    public boolean isOutsideTouchable() {
        return this.mOutsideTouchable;
    }

    public boolean isShowing() {
        return this.mIsShowing;
    }

    public boolean isSplitTouchEnabled() {
        return this.mSplitTouchEnabled;
    }

    public boolean isTouchable() {
        return this.mTouchable;
    }

    public void setAnimationStyle(int n) {
        this.mAnimationStyle = n;
    }

    public void setBackgroundDrawable(Drawable drawable2) {
        this.mBackground = drawable2;
    }

    public void setClippingEnabled(boolean bl) {
        this.mClippingEnabled = bl;
    }

    public void setContentView(View view) {
        WindowManager windowManager;
        if (this.isShowing()) {
            return;
        }
        this.mContentView = view;
        if (this.mContext == null) {
            Context context;
            this.mContext = context = this.mContentView.getContext();
        }
        if (this.mWindowManager != null) {
            return;
        }
        this.mWindowManager = windowManager = (WindowManager)this.mContext.getSystemService("window");
    }

    public void setFocusable(boolean bl) {
        this.mFocusable = bl;
    }

    public void setHeight(int n) {
        this.mHeight = n;
    }

    public void setIgnoreCheekPress() {
        this.mIgnoreCheekPress = true;
    }

    public void setInputMethodMode(int n) {
        this.mInputMethodMode = n;
    }

    public void setLayoutInScreenEnabled(boolean bl) {
        this.mLayoutInScreen = bl;
    }

    public void setOnDismissListener(OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
    }

    public void setOutsideTouchable(boolean bl) {
        this.mOutsideTouchable = bl;
    }

    public void setSoftInputMode(int n) {
        this.mSoftInputMode = n;
    }

    public void setSplitTouchEnabled(boolean bl) {
        this.mSplitTouchEnabled = bl;
    }

    public void setTouchInterceptor(View.OnTouchListener onTouchListener) {
        this.mTouchInterceptor = onTouchListener;
    }

    public void setTouchable(boolean bl) {
        this.mTouchable = bl;
    }

    public void setWidth(int n) {
        this.mWidth = n;
    }

    public void setWindowLayoutMode(int n, int n2) {
        this.mWidthMode = n;
        this.mHeightMode = n2;
    }

    public void setWindowLayoutType(int n) {
        this.mWindowLayoutType = n;
    }

    public void showAsDropDown(View view) {
        this.showAsDropDown(view, 0, 0);
    }

    public void showAsDropDown(View view, int n, int n2) {
        int n3;
        if (this.isShowing()) {
            return;
        }
        if (this.mContentView == null) {
            return;
        }
        this.registerForScrollChanged(view, n, n2);
        this.mIsShowing = true;
        this.mIsDropdown = true;
        IBinder iBinder = view.getWindowToken();
        WindowManager.LayoutParams layoutParams = this.createPopupLayout(iBinder);
        this.preparePopup(layoutParams);
        boolean bl = this.findDropDownPosition(view, layoutParams, n, n2);
        this.updateAboveAnchor(bl);
        if (this.mHeightMode < 0) {
            int n4;
            this.mLastHeight = n4 = this.mHeightMode;
            layoutParams.height = n4;
        }
        if (this.mWidthMode < 0) {
            int n5;
            this.mLastWidth = n5 = this.mWidthMode;
            layoutParams.width = n5;
        }
        layoutParams.windowAnimations = n3 = this.computeAnimationResource();
        this.invokePopup(layoutParams);
    }

    public void showAtLocation(View view, int n, int n2, int n3) {
        int n4;
        if (this.isShowing()) {
            return;
        }
        if (this.mContentView == null) {
            return;
        }
        this.unregisterForScrollChanged();
        this.mIsShowing = true;
        this.mIsDropdown = false;
        IBinder iBinder = view.getWindowToken();
        WindowManager.LayoutParams layoutParams = this.createPopupLayout(iBinder);
        layoutParams.windowAnimations = n4 = this.computeAnimationResource();
        this.preparePopup(layoutParams);
        if (n == 0) {
            n = 51;
        }
        layoutParams.gravity = n;
        layoutParams.x = n2;
        layoutParams.y = n3;
        this.invokePopup(layoutParams);
    }

    public void update() {
        int n;
        int n2;
        int n3;
        int n4;
        if (!this.isShowing()) {
            return;
        }
        if (this.mContentView == null) {
            return;
        }
        WindowManager.LayoutParams layoutParams = (WindowManager.LayoutParams)this.mPopupView.getLayoutParams();
        boolean bl = false;
        int n5 = this.computeAnimationResource();
        if (n5 != (n4 = layoutParams.windowAnimations)) {
            layoutParams.windowAnimations = n5;
            bl = true;
        }
        if ((n3 = this.computeFlags(n2 = layoutParams.flags)) != (n = layoutParams.flags)) {
            layoutParams.flags = n3;
            bl = true;
        }
        if (!bl) {
            return;
        }
        WindowManager windowManager = this.mWindowManager;
        View view = this.mPopupView;
        windowManager.updateViewLayout(view, layoutParams);
    }

    public void update(int n, int n2) {
        WindowManager.LayoutParams layoutParams = (WindowManager.LayoutParams)this.mPopupView.getLayoutParams();
        int n3 = layoutParams.x;
        int n4 = layoutParams.y;
        PopupWindow popupWindow = this;
        int n5 = n;
        int n6 = n2;
        popupWindow.update(n3, n4, n5, n6, false);
    }

    public void update(int n, int n2, int n3, int n4) {
        PopupWindow popupWindow = this;
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        popupWindow.update(n5, n6, n7, n8, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void update(int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        if (n3 != -1) {
            this.mLastWidth = n3;
            this.setWidth(n3);
        }
        if (n4 != -1) {
            this.mLastHeight = n4;
            this.setHeight(n4);
        }
        if (!this.isShowing()) {
            return;
        }
        if (this.mContentView == null) {
            return;
        }
        WindowManager.LayoutParams layoutParams = (WindowManager.LayoutParams)this.mPopupView.getLayoutParams();
        boolean bl2 = bl;
        int n10 = this.mWidthMode < 0 ? this.mWidthMode : this.mLastWidth;
        if (n3 != -1 && layoutParams.width != n10) {
            this.mLastWidth = n10;
            layoutParams.width = n10;
            bl2 = true;
        }
        int n11 = this.mHeightMode < 0 ? this.mHeightMode : this.mLastHeight;
        if (n4 != -1 && layoutParams.height != n11) {
            this.mLastHeight = n11;
            layoutParams.height = n11;
            bl2 = true;
        }
        if (layoutParams.x != n) {
            layoutParams.x = n;
            bl2 = true;
        }
        if (layoutParams.y != n2) {
            layoutParams.y = n2;
            bl2 = true;
        }
        if ((n9 = this.computeAnimationResource()) != (n8 = layoutParams.windowAnimations)) {
            layoutParams.windowAnimations = n9;
            bl2 = true;
        }
        if ((n7 = this.computeFlags(n6 = layoutParams.flags)) != (n5 = layoutParams.flags)) {
            layoutParams.flags = n7;
            bl2 = true;
        }
        if (!bl2) {
            return;
        }
        WindowManager windowManager = this.mWindowManager;
        View view = this.mPopupView;
        windowManager.updateViewLayout(view, layoutParams);
    }

    public void update(View view, int n, int n2) {
        PopupWindow popupWindow = this;
        View view2 = view;
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        int n6 = n2;
        popupWindow.update(view2, false, n3, n4, true, n5, n6);
    }

    public void update(View view, int n, int n2, int n3, int n4) {
        PopupWindow popupWindow = this;
        View view2 = view;
        int n5 = n;
        int n6 = n2;
        boolean bl = true;
        int n7 = n3;
        int n8 = n4;
        popupWindow.update(view2, true, n5, n6, bl, n7, n8);
    }

    private class PopupViewContainer
    extends FrameLayout {
        public PopupViewContainer(Context context) {
            super(context);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() != 4) return super.dispatchKeyEvent(keyEvent);
            if (keyEvent.getAction() == 0 && keyEvent.getRepeatCount() == 0) {
                this.getKeyDispatcherState().startTracking(keyEvent, this);
                return true;
            }
            if (keyEvent.getAction() != 1) return super.dispatchKeyEvent(keyEvent);
            if (!this.getKeyDispatcherState().isTracking(keyEvent)) return super.dispatchKeyEvent(keyEvent);
            if (keyEvent.isCanceled()) return super.dispatchKeyEvent(keyEvent);
            PopupWindow.this.dismiss();
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean dispatchTouchEvent(MotionEvent motionEvent) {
            if (PopupWindow.this.mTouchInterceptor == null) return super.dispatchTouchEvent(motionEvent);
            if (!PopupWindow.this.mTouchInterceptor.onTouch(this, motionEvent)) return super.dispatchTouchEvent(motionEvent);
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected int[] onCreateDrawableState(int n) {
            if (!PopupWindow.this.mAboveAnchor) return super.onCreateDrawableState(n);
            int n2 = n + 1;
            int[] nArray = super.onCreateDrawableState(n2);
            int[] nArray2 = ABOVE_ANCHOR_STATE_SET;
            int[] nArray3 = View.mergeDrawableStates(nArray, nArray2);
            return nArray;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean onTouchEvent(MotionEvent motionEvent) {
            int n;
            int n2;
            int n3 = (int)motionEvent.getX();
            int n4 = (int)motionEvent.getY();
            if (motionEvent.getAction() == 0 && (n3 < 0 || n3 >= (n2 = this.getWidth()) || n4 < 0 || n4 >= (n = this.getHeight()))) {
                PopupWindow.this.dismiss();
                return true;
            }
            if (motionEvent.getAction() != 4) return super.onTouchEvent(motionEvent);
            PopupWindow.this.dismiss();
            return true;
        }

        @Override
        public void sendAccessibilityEvent(int n) {
            if (PopupWindow.this.mContentView != null) {
                PopupWindow.this.mContentView.sendAccessibilityEvent(n);
                return;
            }
            super.sendAccessibilityEvent(n);
        }
    }

    public static interface OnDismissListener {
        public void onDismiss();
    }
}

