/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewDebug;
import android.view.animation.AlphaAnimation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.Transformation;
import android.widget.RemoteViews;
import com.android.internal.R;

@RemoteViews.RemoteView
public class ProgressBar
extends View {
    private static final int ANIMATION_RESOLUTION = 200;
    private static final int MAX_LEVEL = 10000;
    private AlphaAnimation mAnimation;
    private int mBehavior;
    private Drawable mCurrentDrawable;
    private int mDuration;
    private boolean mInDrawing;
    private boolean mIndeterminate;
    private Drawable mIndeterminateDrawable;
    private Interpolator mInterpolator;
    private long mLastDrawTime;
    private int mMax;
    int mMaxHeight;
    int mMaxWidth;
    int mMinHeight;
    int mMinWidth;
    private boolean mNoInvalidate;
    private boolean mOnlyIndeterminate;
    private int mProgress;
    private Drawable mProgressDrawable;
    private RefreshProgressRunnable mRefreshProgressRunnable;
    Bitmap mSampleTile;
    private int mSecondaryProgress;
    private boolean mShouldStartAnimationDrawable;
    private Transformation mTransformation;
    private long mUiThreadId;

    public ProgressBar(Context context) {
        this(context, null);
    }

    public ProgressBar(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0x1010077);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ProgressBar(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        boolean bl;
        boolean bl2;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        long l;
        this.mUiThreadId = l = Thread.currentThread().getId();
        this.initProgressBar();
        int[] nArray = R.styleable.ProgressBar;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, n, 0);
        this.mNoInvalidate = true;
        Drawable drawable2 = typedArray.getDrawable(8);
        if (drawable2 != null) {
            Drawable drawable3 = this.tileify(drawable2, false);
            this.setProgressDrawable(drawable3);
        }
        int n8 = this.mDuration;
        this.mDuration = n7 = typedArray.getInt(9, n8);
        int n9 = this.mMinWidth;
        this.mMinWidth = n6 = typedArray.getDimensionPixelSize(11, n9);
        int n10 = this.mMaxWidth;
        this.mMaxWidth = n5 = typedArray.getDimensionPixelSize(0, n10);
        int n11 = this.mMinHeight;
        this.mMinHeight = n4 = typedArray.getDimensionPixelSize(12, n11);
        int n12 = this.mMaxHeight;
        this.mMaxHeight = n3 = typedArray.getDimensionPixelSize(1, n12);
        int n13 = this.mBehavior;
        this.mBehavior = n2 = typedArray.getInt(10, n13);
        int n14 = typedArray.getResourceId(13, 17432587);
        if (n14 > 0) {
            this.setInterpolator(context, n14);
        }
        int n15 = this.mMax;
        int n16 = typedArray.getInt(2, n15);
        this.setMax(n16);
        int n17 = this.mProgress;
        int n18 = typedArray.getInt(3, n17);
        this.setProgress(n18);
        int n19 = this.mSecondaryProgress;
        int n20 = typedArray.getInt(4, n19);
        this.setSecondaryProgress(n20);
        Drawable drawable4 = typedArray.getDrawable(7);
        if (drawable4 != null) {
            Drawable drawable5 = this.tileifyIndeterminate(drawable4);
            this.setIndeterminateDrawable(drawable5);
        }
        boolean bl3 = this.mOnlyIndeterminate;
        this.mOnlyIndeterminate = bl2 = typedArray.getBoolean(6, bl3);
        this.mNoInvalidate = false;
        boolean bl4 = this.mOnlyIndeterminate || typedArray.getBoolean(5, bl = this.mIndeterminate);
        this.setIndeterminate(bl4);
        typedArray.recycle();
    }

    static /* synthetic */ RefreshProgressRunnable access$102(ProgressBar progressBar, RefreshProgressRunnable refreshProgressRunnable) {
        progressBar.mRefreshProgressRunnable = refreshProgressRunnable;
        return refreshProgressRunnable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doRefreshProgress(int n, int n2, boolean bl) {
        synchronized (this) {
            Drawable drawable2;
            float f;
            if (this.mMax > 0) {
                float f2 = n2;
                float f3 = this.mMax;
                f = f2 / f3;
            } else {
                f = 0.0f;
            }
            if ((drawable2 = this.mCurrentDrawable) != null) {
                Drawable drawable3 = null;
                if (drawable2 instanceof LayerDrawable) {
                    drawable3 = ((LayerDrawable)drawable2).findDrawableByLayerId(n);
                }
                int n3 = (int)(10000.0f * f);
                Drawable drawable4 = drawable3 != null ? drawable3 : drawable2;
                boolean bl2 = drawable4.setLevel(n3);
            } else {
                this.invalidate();
            }
            if (n == 16908301) {
                this.onProgressRefresh(f, bl);
            }
            return;
        }
    }

    private void initProgressBar() {
        this.mMax = 100;
        this.mProgress = 0;
        this.mSecondaryProgress = 0;
        this.mIndeterminate = false;
        this.mOnlyIndeterminate = false;
        this.mDuration = 4000;
        this.mBehavior = 1;
        this.mMinWidth = 24;
        this.mMaxWidth = 48;
        this.mMinHeight = 24;
        this.mMaxHeight = 48;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void refreshProgress(int n, int n2, boolean bl) {
        synchronized (this) {
            long l = this.mUiThreadId;
            long l2 = Thread.currentThread().getId();
            if (l == l2) {
                this.doRefreshProgress(n, n2, bl);
            } else {
                RefreshProgressRunnable refreshProgressRunnable;
                if (this.mRefreshProgressRunnable != null) {
                    refreshProgressRunnable = this.mRefreshProgressRunnable;
                    this.mRefreshProgressRunnable = null;
                    refreshProgressRunnable.setup(n, n2, bl);
                } else {
                    refreshProgressRunnable = new RefreshProgressRunnable(n, n2, bl);
                }
                boolean bl2 = this.post(refreshProgressRunnable);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Drawable tileify(Drawable drawable2, boolean bl) {
        Drawable[] drawableArray;
        int n;
        LayerDrawable layerDrawable;
        if (drawable2 instanceof LayerDrawable) {
            layerDrawable = (LayerDrawable)drawable2;
            n = layerDrawable.getNumberOfLayers();
            drawableArray = new Drawable[n];
        } else {
            Drawable drawable3;
            BitmapShader bitmapShader;
            ShapeDrawable shapeDrawable;
            if (drawable2 instanceof StateListDrawable) {
                StateListDrawable stateListDrawable = (StateListDrawable)drawable2;
                StateListDrawable stateListDrawable2 = new StateListDrawable();
                int n2 = stateListDrawable.getStateCount();
                int n3 = 0;
                while (true) {
                    if (n3 >= n2) {
                        return stateListDrawable2;
                    }
                    int[] nArray = stateListDrawable.getStateSet(n3);
                    Drawable drawable4 = stateListDrawable.getStateDrawable(n3);
                    ProgressBar progressBar = this;
                    Drawable drawable5 = drawable4;
                    boolean bl2 = bl;
                    Drawable drawable6 = progressBar.tileify(drawable5, bl2);
                    StateListDrawable stateListDrawable3 = stateListDrawable2;
                    int[] nArray2 = nArray;
                    Drawable drawable7 = drawable6;
                    stateListDrawable3.addState(nArray2, drawable7);
                    int n4 = n3 + 1;
                }
            }
            if (!(drawable2 instanceof BitmapDrawable)) {
                return drawable2;
            }
            Bitmap bitmap = ((BitmapDrawable)drawable2).getBitmap();
            if (this.mSampleTile == null) {
                Bitmap bitmap2;
                this.mSampleTile = bitmap2 = bitmap;
            }
            Shape shape = this.getDrawableShape();
            ShapeDrawable shapeDrawable2 = shapeDrawable;
            Shape shape2 = shape;
            shapeDrawable2(shape2);
            Shader.TileMode tileMode = Shader.TileMode.REPEAT;
            Shader.TileMode tileMode2 = Shader.TileMode.CLAMP;
            BitmapShader bitmapShader2 = bitmapShader;
            Bitmap bitmap3 = bitmap;
            Shader.TileMode tileMode3 = tileMode;
            Shader.TileMode tileMode4 = tileMode2;
            bitmapShader2(bitmap3, tileMode3, tileMode4);
            Paint paint = shapeDrawable.getPaint();
            BitmapShader bitmapShader3 = bitmapShader;
            Shader shader = paint.setShader(bitmapShader3);
            if (!bl) return shapeDrawable;
            Drawable drawable8 = drawable3;
            ShapeDrawable shapeDrawable3 = shapeDrawable;
            int n5 = 3;
            int n6 = 1;
            ((ClipDrawable)drawable8)(shapeDrawable3, n5, n6);
            return drawable3;
        }
        for (int i = 0; i < n; ++i) {
            Drawable drawable9;
            int n7;
            int n8;
            int n9 = layerDrawable.getId(i);
            Drawable drawable10 = layerDrawable.getDrawable(i);
            int n10 = n9;
            int n11 = 16908301;
            boolean bl3 = n10 == n11 || (n8 = n9) == (n7 = 16908303);
            ProgressBar progressBar = this;
            Drawable drawable11 = drawable10;
            boolean bl4 = bl3;
            drawableArray[i] = drawable9 = progressBar.tileify(drawable11, bl4);
        }
        LayerDrawable layerDrawable2 = new LayerDrawable(drawableArray);
        int n12 = 0;
        while (n12 < n) {
            int n13 = layerDrawable.getId(n12);
            LayerDrawable layerDrawable3 = layerDrawable2;
            int n14 = n12++;
            int n15 = n13;
            layerDrawable3.setId(n14, n15);
        }
        return layerDrawable2;
    }

    private Drawable tileifyIndeterminate(Drawable drawable2) {
        if (drawable2 instanceof AnimationDrawable) {
            AnimationDrawable animationDrawable = (AnimationDrawable)drawable2;
            int n = animationDrawable.getNumberOfFrames();
            AnimationDrawable animationDrawable2 = new AnimationDrawable();
            boolean bl = animationDrawable.isOneShot();
            animationDrawable2.setOneShot(bl);
            for (int i = 0; i < n; ++i) {
                Drawable drawable3 = animationDrawable.getFrame(i);
                Drawable drawable4 = this.tileify(drawable3, true);
                boolean bl2 = drawable4.setLevel(10000);
                int n2 = animationDrawable.getDuration(i);
                animationDrawable2.addFrame(drawable4, n2);
            }
            boolean bl3 = animationDrawable2.setLevel(10000);
            drawable2 = animationDrawable2;
        }
        return drawable2;
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        int[] nArray = this.getDrawableState();
        if (this.mProgressDrawable != null && this.mProgressDrawable.isStateful()) {
            boolean bl = this.mProgressDrawable.setState(nArray);
        }
        if (this.mIndeterminateDrawable == null) {
            return;
        }
        if (!this.mIndeterminateDrawable.isStateful()) {
            return;
        }
        boolean bl = this.mIndeterminateDrawable.setState(nArray);
    }

    Drawable getCurrentDrawable() {
        return this.mCurrentDrawable;
    }

    Shape getDrawableShape() {
        float[] fArray = new float[]{0x40A00000, 0x40A00000, 0x40A00000, 0x40A00000, 0x40A00000, 0x40A00000, 0x40A00000, 0x40A00000};
        return new RoundRectShape(fArray, null, null);
    }

    public Drawable getIndeterminateDrawable() {
        return this.mIndeterminateDrawable;
    }

    public Interpolator getInterpolator() {
        return this.mInterpolator;
    }

    @ViewDebug.ExportedProperty(category="progress")
    public int getMax() {
        synchronized (this) {
            int n = this.mMax;
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ViewDebug.ExportedProperty(category="progress")
    public int getProgress() {
        synchronized (this) {
            block6: {
                boolean bl = this.mIndeterminate;
                if (!bl) break block6;
                return 0;
            }
            int n = this.mProgress;
            return n;
        }
    }

    public Drawable getProgressDrawable() {
        return this.mProgressDrawable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ViewDebug.ExportedProperty(category="progress")
    public int getSecondaryProgress() {
        synchronized (this) {
            block6: {
                boolean bl = this.mIndeterminate;
                if (!bl) break block6;
                return 0;
            }
            int n = this.mSecondaryProgress;
            return n;
        }
    }

    public final void incrementProgressBy(int n) {
        synchronized (this) {
            int n2 = this.mProgress + n;
            this.setProgress(n2);
            return;
        }
    }

    public final void incrementSecondaryProgressBy(int n) {
        synchronized (this) {
            int n2 = this.mSecondaryProgress + n;
            this.setSecondaryProgress(n2);
            return;
        }
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        if (this.mInDrawing) {
            return;
        }
        if (this.verifyDrawable(drawable2)) {
            Rect rect = drawable2.getBounds();
            int n = this.mScrollX;
            int n2 = this.mPaddingLeft;
            int n3 = n + n2;
            int n4 = this.mScrollY;
            int n5 = this.mPaddingTop;
            int n6 = n4 + n5;
            int n7 = rect.left + n3;
            int n8 = rect.top + n6;
            int n9 = rect.right + n3;
            int n10 = rect.bottom + n6;
            this.invalidate(n7, n8, n9, n10);
            return;
        }
        super.invalidateDrawable(drawable2);
    }

    @ViewDebug.ExportedProperty(category="progress")
    public boolean isIndeterminate() {
        synchronized (this) {
            boolean bl = this.mIndeterminate;
            return bl;
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.mIndeterminate) {
            return;
        }
        this.startAnimation();
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.mIndeterminate) {
            return;
        }
        this.stopAnimation();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void onDraw(Canvas canvas) {
        synchronized (this) {
            super.onDraw(canvas);
            Drawable drawable2 = this.mCurrentDrawable;
            if (drawable2 != null) {
                int n = canvas.save();
                float f = this.mPaddingLeft;
                float f2 = this.mPaddingTop;
                canvas.translate(f, f2);
                long l = this.getDrawingTime();
                if (this.mAnimation != null) {
                    float f3;
                    AlphaAnimation alphaAnimation = this.mAnimation;
                    Transformation transformation = this.mTransformation;
                    boolean bl = alphaAnimation.getTransformation(l, transformation);
                    float f4 = f3 = this.mTransformation.getAlpha();
                    boolean bl2 = true;
                    try {
                        this.mInDrawing = bl2;
                        int n2 = (int)(10000.0f * f4);
                        boolean bl3 = drawable2.setLevel(n2);
                        Object var16_15 = null;
                        this.mInDrawing = var16_15;
                    }
                    catch (Throwable throwable) {
                        boolean bl4;
                        this.mInDrawing = bl4 = false;
                        throw throwable;
                    }
                    long l2 = SystemClock.uptimeMillis();
                    long l3 = this.mLastDrawTime;
                    if (l2 - l3 >= 200L) {
                        long l4;
                        this.mLastDrawTime = l4 = SystemClock.uptimeMillis();
                        this.postInvalidateDelayed(200L);
                    }
                }
                drawable2.draw(canvas);
                canvas.restore();
                if (this.mShouldStartAnimationDrawable && drawable2 instanceof Animatable) {
                    ((Animatable)((Object)drawable2)).start();
                    this.mShouldStartAnimationDrawable = false;
                }
            }
            return;
        }
    }

    @Override
    protected void onMeasure(int n, int n2) {
        synchronized (this) {
            Drawable drawable2 = this.mCurrentDrawable;
            int n3 = 0;
            int n4 = 0;
            if (drawable2 != null) {
                int n5 = this.mMinWidth;
                int n6 = this.mMaxWidth;
                int n7 = drawable2.getIntrinsicWidth();
                int n8 = Math.min(n6, n7);
                n3 = Math.max(n5, n8);
                int n9 = this.mMinHeight;
                int n10 = this.mMaxHeight;
                int n11 = drawable2.getIntrinsicHeight();
                int n12 = Math.min(n10, n11);
                n4 = Math.max(n9, n12);
            }
            int n13 = this.mPaddingLeft;
            int n14 = this.mPaddingRight;
            int n15 = n13 + n14;
            int n16 = n3 + n15;
            int n17 = this.mPaddingTop;
            int n18 = this.mPaddingBottom;
            int n19 = n17 + n18;
            int n20 = n4 + n19;
            int n21 = ProgressBar.resolveSize(n16, n);
            int n22 = ProgressBar.resolveSize(n20, n2);
            this.setMeasuredDimension(n21, n22);
            return;
        }
    }

    void onProgressRefresh(float f, boolean bl) {
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        SavedState savedState = (SavedState)parcelable;
        Parcelable parcelable2 = savedState.getSuperState();
        super.onRestoreInstanceState(parcelable2);
        int n = savedState.progress;
        this.setProgress(n);
        int n2 = savedState.secondaryProgress;
        this.setSecondaryProgress(n2);
    }

    @Override
    public Parcelable onSaveInstanceState() {
        int n;
        int n2;
        Parcelable parcelable = super.onSaveInstanceState();
        SavedState savedState = new SavedState(parcelable);
        savedState.progress = n2 = this.mProgress;
        savedState.secondaryProgress = n = this.mSecondaryProgress;
        return savedState;
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        int n5 = this.mPaddingRight;
        int n6 = n - n5;
        int n7 = this.mPaddingLeft;
        int n8 = n6 - n7;
        int n9 = this.mPaddingBottom;
        int n10 = n2 - n9;
        int n11 = this.mPaddingTop;
        int n12 = n10 - n11;
        if (this.mIndeterminateDrawable != null) {
            this.mIndeterminateDrawable.setBounds(0, 0, n8, n12);
        }
        if (this.mProgressDrawable == null) {
            return;
        }
        this.mProgressDrawable.setBounds(0, 0, n8, n12);
    }

    @Override
    protected void onVisibilityChanged(View view, int n) {
        super.onVisibilityChanged(view, n);
        if (!this.mIndeterminate) {
            return;
        }
        if (n == 8 || n == 4) {
            this.stopAnimation();
            return;
        }
        this.startAnimation();
    }

    @Override
    public void postInvalidate() {
        if (this.mNoInvalidate) {
            return;
        }
        super.postInvalidate();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RemotableViewMethod
    public void setIndeterminate(boolean bl) {
        synchronized (this) {
            boolean bl2;
            if (!(this.mOnlyIndeterminate && this.mIndeterminate || bl == (bl2 = this.mIndeterminate))) {
                this.mIndeterminate = bl;
                if (bl) {
                    Drawable drawable2;
                    this.mCurrentDrawable = drawable2 = this.mIndeterminateDrawable;
                    this.startAnimation();
                } else {
                    Drawable drawable3;
                    this.mCurrentDrawable = drawable3 = this.mProgressDrawable;
                    this.stopAnimation();
                }
            }
            return;
        }
    }

    public void setIndeterminateDrawable(Drawable drawable2) {
        if (drawable2 != null) {
            drawable2.setCallback(this);
        }
        this.mIndeterminateDrawable = drawable2;
        if (!this.mIndeterminate) {
            return;
        }
        this.mCurrentDrawable = drawable2;
        this.postInvalidate();
    }

    public void setInterpolator(Context context, int n) {
        Interpolator interpolator = AnimationUtils.loadInterpolator(context, n);
        this.setInterpolator(interpolator);
    }

    public void setInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    @RemotableViewMethod
    public void setMax(int n) {
        synchronized (this) {
            if (n < 0) {
                n = 0;
            }
            int n2 = this.mMax;
            if (n != n2) {
                this.mMax = n;
                this.postInvalidate();
                if (this.mProgress > n) {
                    int n3 = this.mProgress = n;
                    this.refreshProgress(16908301, n3, false);
                }
            }
            return;
        }
    }

    @RemotableViewMethod
    public void setProgress(int n) {
        synchronized (this) {
            this.setProgress(n, false);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RemotableViewMethod
    void setProgress(int n, boolean bl) {
        synchronized (this) {
            boolean bl2 = this.mIndeterminate;
            if (!bl2) {
                int n2;
                int n3;
                if (n < 0) {
                    n = 0;
                }
                if (n > (n3 = this.mMax)) {
                    n = this.mMax;
                }
                if (n != (n2 = this.mProgress)) {
                    int n4 = this.mProgress = n;
                    this.refreshProgress(16908301, n4, bl);
                }
            }
            return;
        }
    }

    public void setProgressDrawable(Drawable drawable2) {
        if (drawable2 != null) {
            drawable2.setCallback(this);
            int n = drawable2.getMinimumHeight();
            if (this.mMaxHeight < n) {
                this.mMaxHeight = n;
                this.requestLayout();
            }
        }
        this.mProgressDrawable = drawable2;
        if (this.mIndeterminate) {
            return;
        }
        this.mCurrentDrawable = drawable2;
        this.postInvalidate();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RemotableViewMethod
    public void setSecondaryProgress(int n) {
        synchronized (this) {
            boolean bl = this.mIndeterminate;
            if (!bl) {
                int n2;
                int n3;
                if (n < 0) {
                    n = 0;
                }
                if (n > (n3 = this.mMax)) {
                    n = this.mMax;
                }
                if (n != (n2 = this.mSecondaryProgress)) {
                    int n4 = this.mSecondaryProgress = n;
                    this.refreshProgress(16908303, n4, false);
                }
            }
            return;
        }
    }

    @Override
    @RemotableViewMethod
    public void setVisibility(int n) {
        if (this.getVisibility() != n) {
            return;
        }
        super.setVisibility(n);
        if (!this.mIndeterminate) {
            return;
        }
        if (n == 8 || n == 4) {
            this.stopAnimation();
            return;
        }
        this.startAnimation();
    }

    void startAnimation() {
        AlphaAnimation alphaAnimation;
        Transformation transformation;
        if (this.getVisibility() != 0) {
            return;
        }
        if (this.mIndeterminateDrawable instanceof Animatable) {
            this.mShouldStartAnimationDrawable = true;
            this.mAnimation = null;
            return;
        }
        if (this.mInterpolator == null) {
            LinearInterpolator linearInterpolator = new LinearInterpolator();
            this.mInterpolator = linearInterpolator;
        }
        this.mTransformation = transformation = new Transformation();
        AlphaAnimation alphaAnimation2 = this.mAnimation = (alphaAnimation = new AlphaAnimation(0.0f, 1.0f));
        int n = this.mBehavior;
        alphaAnimation2.setRepeatMode(n);
        this.mAnimation.setRepeatCount(-1);
        AlphaAnimation alphaAnimation3 = this.mAnimation;
        long l = this.mDuration;
        alphaAnimation3.setDuration(l);
        AlphaAnimation alphaAnimation4 = this.mAnimation;
        Interpolator interpolator = this.mInterpolator;
        alphaAnimation4.setInterpolator(interpolator);
        this.mAnimation.setStartTime(65535L);
        this.postInvalidate();
    }

    void stopAnimation() {
        this.mAnimation = null;
        this.mTransformation = null;
        if (!(this.mIndeterminateDrawable instanceof Animatable)) {
            return;
        }
        ((Animatable)((Object)this.mIndeterminateDrawable)).stop();
        this.mShouldStartAnimationDrawable = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean verifyDrawable(Drawable drawable2) {
        Drawable drawable3 = this.mProgressDrawable;
        if (drawable2 == drawable3) return true;
        Drawable drawable4 = this.mIndeterminateDrawable;
        if (drawable2 == drawable4) return true;
        if (!super.verifyDrawable(drawable2)) return false;
        return true;
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        int progress;
        int secondaryProgress;

        private SavedState(Parcel parcel) {
            super(parcel);
            int n;
            int n2;
            this.progress = n2 = parcel.readInt();
            this.secondaryProgress = n = parcel.readInt();
        }

        SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            int n2 = this.progress;
            parcel.writeInt(n2);
            int n3 = this.secondaryProgress;
            parcel.writeInt(n3);
        }
    }

    private class RefreshProgressRunnable
    implements Runnable {
        private boolean mFromUser;
        private int mId;
        private int mProgress;

        RefreshProgressRunnable(int n, int n2, boolean bl) {
            this.mId = n;
            this.mProgress = n2;
            this.mFromUser = bl;
        }

        @Override
        public void run() {
            ProgressBar progressBar = ProgressBar.this;
            int n = this.mId;
            int n2 = this.mProgress;
            boolean bl = this.mFromUser;
            progressBar.doRefreshProgress(n, n2, bl);
            RefreshProgressRunnable refreshProgressRunnable = ProgressBar.access$102(ProgressBar.this, this);
        }

        public void setup(int n, int n2, boolean bl) {
            this.mId = n;
            this.mProgress = n2;
            this.mFromUser = bl;
        }
    }
}

