/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import com.android.internal.R;

public class RadioGroup
extends LinearLayout {
    private int mCheckedId = -1;
    private CompoundButton.OnCheckedChangeListener mChildOnCheckedChangeListener;
    private OnCheckedChangeListener mOnCheckedChangeListener;
    private PassThroughHierarchyChangeListener mPassThroughListener;
    private boolean mProtectFromCheckedChange = false;

    public RadioGroup(Context context) {
        super(context);
        this.setOrientation(1);
        this.init();
    }

    public RadioGroup(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        int[] nArray = R.styleable.RadioGroup;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, 16842878, 0);
        int n = typedArray.getResourceId(1, -1);
        if (n != -1) {
            this.mCheckedId = n;
        }
        int n2 = typedArray.getInt(0, 1);
        this.setOrientation(n2);
        typedArray.recycle();
        this.init();
    }

    static /* synthetic */ boolean access$302(RadioGroup radioGroup, boolean bl) {
        radioGroup.mProtectFromCheckedChange = bl;
        return bl;
    }

    private void init() {
        PassThroughHierarchyChangeListener passThroughHierarchyChangeListener;
        CheckedStateTracker checkedStateTracker = new CheckedStateTracker();
        this.mChildOnCheckedChangeListener = checkedStateTracker;
        PassThroughHierarchyChangeListener passThroughHierarchyChangeListener2 = this.mPassThroughListener = (passThroughHierarchyChangeListener = new PassThroughHierarchyChangeListener());
        super.setOnHierarchyChangeListener(passThroughHierarchyChangeListener2);
    }

    private void setCheckedId(int n) {
        this.mCheckedId = n;
        if (this.mOnCheckedChangeListener == null) {
            return;
        }
        OnCheckedChangeListener onCheckedChangeListener = this.mOnCheckedChangeListener;
        int n2 = this.mCheckedId;
        onCheckedChangeListener.onCheckedChanged(this, n2);
    }

    private void setCheckedStateForView(int n, boolean bl) {
        View view = this.findViewById(n);
        if (view == null) {
            return;
        }
        if (!(view instanceof RadioButton)) {
            return;
        }
        ((RadioButton)view).setChecked(bl);
    }

    @Override
    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        RadioButton radioButton;
        if (view instanceof RadioButton && (radioButton = (RadioButton)view).isChecked()) {
            this.mProtectFromCheckedChange = true;
            if (this.mCheckedId != -1) {
                int n2 = this.mCheckedId;
                this.setCheckedStateForView(n2, false);
            }
            this.mProtectFromCheckedChange = false;
            int n3 = radioButton.getId();
            this.setCheckedId(n3);
        }
        super.addView(view, n, layoutParams);
    }

    public void check(int n) {
        int n2;
        if (n != -1 && n != (n2 = this.mCheckedId)) {
            return;
        }
        if (this.mCheckedId != -1) {
            int n3 = this.mCheckedId;
            this.setCheckedStateForView(n3, false);
        }
        if (n != -1) {
            this.setCheckedStateForView(n, true);
        }
        this.setCheckedId(n);
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    public void clearCheck() {
        this.check(-1);
    }

    @Override
    protected LinearLayout.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        Context context = this.getContext();
        return new LayoutParams(context, attributeSet);
    }

    public int getCheckedRadioButtonId() {
        return this.mCheckedId;
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.mCheckedId == -1) {
            return;
        }
        this.mProtectFromCheckedChange = true;
        int n = this.mCheckedId;
        this.setCheckedStateForView(n, true);
        this.mProtectFromCheckedChange = false;
        int n2 = this.mCheckedId;
        this.setCheckedId(n2);
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener onCheckedChangeListener) {
        this.mOnCheckedChangeListener = onCheckedChangeListener;
    }

    @Override
    public void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener) {
        ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener2 = PassThroughHierarchyChangeListener.access$202(this.mPassThroughListener, onHierarchyChangeListener);
    }

    private class PassThroughHierarchyChangeListener
    implements ViewGroup.OnHierarchyChangeListener {
        private ViewGroup.OnHierarchyChangeListener mOnHierarchyChangeListener;

        private PassThroughHierarchyChangeListener() {
        }

        static /* synthetic */ ViewGroup.OnHierarchyChangeListener access$202(PassThroughHierarchyChangeListener passThroughHierarchyChangeListener, ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener) {
            passThroughHierarchyChangeListener.mOnHierarchyChangeListener = onHierarchyChangeListener;
            return onHierarchyChangeListener;
        }

        @Override
        public void onChildViewAdded(View view, View view2) {
            RadioGroup radioGroup = RadioGroup.this;
            if (view == radioGroup && view2 instanceof RadioButton) {
                if (view2.getId() == -1) {
                    int n = view2.hashCode();
                    view2.setId(n);
                }
                RadioButton radioButton = (RadioButton)view2;
                CompoundButton.OnCheckedChangeListener onCheckedChangeListener = RadioGroup.this.mChildOnCheckedChangeListener;
                radioButton.setOnCheckedChangeWidgetListener(onCheckedChangeListener);
            }
            if (this.mOnHierarchyChangeListener == null) {
                return;
            }
            this.mOnHierarchyChangeListener.onChildViewAdded(view, view2);
        }

        @Override
        public void onChildViewRemoved(View view, View view2) {
            RadioGroup radioGroup = RadioGroup.this;
            if (view == radioGroup && view2 instanceof RadioButton) {
                ((RadioButton)view2).setOnCheckedChangeWidgetListener(null);
            }
            if (this.mOnHierarchyChangeListener == null) {
                return;
            }
            this.mOnHierarchyChangeListener.onChildViewRemoved(view, view2);
        }
    }

    private class CheckedStateTracker
    implements CompoundButton.OnCheckedChangeListener {
        private CheckedStateTracker() {
        }

        @Override
        public void onCheckedChanged(CompoundButton compoundButton, boolean bl) {
            if (RadioGroup.this.mProtectFromCheckedChange) {
                return;
            }
            boolean bl2 = RadioGroup.access$302(RadioGroup.this, true);
            if (RadioGroup.this.mCheckedId != -1) {
                RadioGroup radioGroup = RadioGroup.this;
                int n = RadioGroup.this.mCheckedId;
                radioGroup.setCheckedStateForView(n, false);
            }
            boolean bl3 = RadioGroup.access$302(RadioGroup.this, false);
            int n = compoundButton.getId();
            RadioGroup.this.setCheckedId(n);
        }
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(RadioGroup var1, int var2);
    }

    public static class LayoutParams
    extends LinearLayout.LayoutParams {
        public LayoutParams(int n, int n2) {
            super(n, n2);
        }

        public LayoutParams(int n, int n2, float f) {
            super(n, n2, f);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected void setBaseAttributes(TypedArray typedArray, int n, int n2) {
            int n3;
            this.width = typedArray.hasValue(n) ? (n3 = typedArray.getLayoutDimension(n, "layout_width")) : -1;
            if (typedArray.hasValue(n2)) {
                int n4;
                this.height = n4 = typedArray.getLayoutDimension(n2, "layout_height");
                return;
            }
            this.height = -1;
        }
    }
}

