/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import android.widget.AbsSeekBar;
import com.android.internal.R;

public class RatingBar
extends AbsSeekBar {
    private int mNumStars = 5;
    private OnRatingBarChangeListener mOnRatingBarChangeListener;
    private int mProgressOnStartTracking;

    public RatingBar(Context context) {
        this(context, null);
    }

    public RatingBar(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842876);
    }

    /*
     * Enabled aggressive block sorting
     */
    public RatingBar(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        int n2;
        int[] nArray = R.styleable.RatingBar;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, n, 0);
        int n3 = this.mNumStars;
        int n4 = typedArray.getInt(0, n3);
        boolean bl = !this.mIsUserSeekable;
        boolean bl2 = typedArray.getBoolean(3, bl);
        this.setIsIndicator(bl2);
        float f = typedArray.getFloat(1, -1.0f);
        float f2 = typedArray.getFloat(2, -1.0f);
        typedArray.recycle();
        if (n4 > 0 && n4 != (n2 = this.mNumStars)) {
            this.setNumStars(n4);
        }
        if (f2 >= 0.0f) {
            this.setStepSize(f2);
        } else {
            this.setStepSize(0.5f);
        }
        if (f >= 0.0f) {
            this.setRating(f);
        }
        this.mTouchProgressOffset = 1.1f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private float getProgressPerStar() {
        if (this.mNumStars <= 0) return 1.0f;
        float f = (float)this.getMax() * 1.0f;
        float f2 = this.mNumStars;
        return f / f2;
    }

    private void updateSecondaryProgress(int n) {
        float f = this.getProgressPerStar();
        if (!(f > 0.0f)) {
            return;
        }
        double d = Math.ceil((float)n / f);
        double d2 = f;
        int n2 = (int)(d * d2);
        this.setSecondaryProgress(n2);
    }

    void dispatchRatingChange(boolean bl) {
        if (this.mOnRatingBarChangeListener == null) {
            return;
        }
        OnRatingBarChangeListener onRatingBarChangeListener = this.mOnRatingBarChangeListener;
        float f = this.getRating();
        onRatingBarChangeListener.onRatingChanged(this, f, bl);
    }

    @Override
    Shape getDrawableShape() {
        return new RectShape();
    }

    public int getNumStars() {
        return this.mNumStars;
    }

    public OnRatingBarChangeListener getOnRatingBarChangeListener() {
        return this.mOnRatingBarChangeListener;
    }

    public float getRating() {
        float f = this.getProgress();
        float f2 = this.getProgressPerStar();
        return f / f2;
    }

    public float getStepSize() {
        float f = this.getNumStars();
        float f2 = this.getMax();
        return f / f2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isIndicator() {
        if (this.mIsUserSeekable) return false;
        return true;
    }

    @Override
    void onKeyChange() {
        super.onKeyChange();
        this.dispatchRatingChange(true);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        synchronized (this) {
            super.onMeasure(n, n2);
            if (this.mSampleTile != null) {
                int n3 = this.mSampleTile.getWidth();
                int n4 = this.mNumStars;
                int n5 = RatingBar.resolveSize(n3 * n4, n);
                int n6 = this.mMeasuredHeight;
                this.setMeasuredDimension(n5, n6);
            }
            return;
        }
    }

    @Override
    void onProgressRefresh(float f, boolean bl) {
        super.onProgressRefresh(f, bl);
        int n = this.getProgress();
        this.updateSecondaryProgress(n);
        if (bl) {
            return;
        }
        this.dispatchRatingChange(false);
    }

    @Override
    void onStartTrackingTouch() {
        int n;
        this.mProgressOnStartTracking = n = this.getProgress();
        super.onStartTrackingTouch();
    }

    @Override
    void onStopTrackingTouch() {
        super.onStopTrackingTouch();
        int n = this.getProgress();
        int n2 = this.mProgressOnStartTracking;
        if (n != n2) {
            return;
        }
        this.dispatchRatingChange(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setIsIndicator(boolean bl) {
        boolean bl2 = !bl;
        this.mIsUserSeekable = bl2;
        boolean bl3 = !bl;
        this.setFocusable(bl3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setMax(int n) {
        synchronized (this) {
            if (n <= 0) {
                return;
            }
            super.setMax(n);
            return;
        }
    }

    public void setNumStars(int n) {
        if (n <= 0) {
            return;
        }
        this.mNumStars = n;
        this.requestLayout();
    }

    public void setOnRatingBarChangeListener(OnRatingBarChangeListener onRatingBarChangeListener) {
        this.mOnRatingBarChangeListener = onRatingBarChangeListener;
    }

    public void setRating(float f) {
        int n = Math.round(this.getProgressPerStar() * f);
        this.setProgress(n);
    }

    public void setStepSize(float f) {
        if (f <= 0.0f) {
            return;
        }
        float f2 = (float)this.mNumStars / f;
        float f3 = this.getMax();
        float f4 = f2 / f3;
        float f5 = this.getProgress();
        int n = (int)(f4 * f5);
        int n2 = (int)f2;
        this.setMax(n2);
        this.setProgress(n);
    }

    public static interface OnRatingBarChangeListener {
        public void onRatingChanged(RatingBar var1, float var2, boolean var3);
    }
}

