/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Pool;
import android.util.Poolable;
import android.util.PoolableManager;
import android.util.Pools;
import android.util.SparseArray;
import android.view.Gravity;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.RemoteViews;
import com.android.internal.R;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;

@RemoteViews.RemoteView
public class RelativeLayout
extends ViewGroup {
    public static final int ABOVE = 2;
    public static final int ALIGN_BASELINE = 4;
    public static final int ALIGN_BOTTOM = 8;
    public static final int ALIGN_LEFT = 5;
    public static final int ALIGN_PARENT_BOTTOM = 12;
    public static final int ALIGN_PARENT_LEFT = 9;
    public static final int ALIGN_PARENT_RIGHT = 11;
    public static final int ALIGN_PARENT_TOP = 10;
    public static final int ALIGN_RIGHT = 7;
    public static final int ALIGN_TOP = 6;
    public static final int BELOW = 3;
    public static final int CENTER_HORIZONTAL = 14;
    public static final int CENTER_IN_PARENT = 13;
    public static final int CENTER_VERTICAL = 15;
    private static final boolean DEBUG_GRAPH = false;
    public static final int LEFT_OF = 0;
    private static final String LOG_TAG = "RelativeLayout";
    public static final int RIGHT_OF = 1;
    public static final int TRUE = 255;
    private static final int VERB_COUNT = 16;
    private View mBaselineView = null;
    private final Rect mContentBounds;
    private boolean mDirtyHierarchy;
    private final DependencyGraph mGraph;
    private int mGravity = 51;
    private boolean mHasBaselineAlignedChild;
    private int mIgnoreGravity;
    private final Rect mSelfBounds;
    private View[] mSortedHorizontalChildren;
    private View[] mSortedVerticalChildren;
    private SortedSet<View> mTopToBottomLeftToRightSet;

    public RelativeLayout(Context context) {
        super(context);
        DependencyGraph dependencyGraph;
        Rect rect;
        Rect rect2;
        this.mContentBounds = rect2 = new Rect();
        this.mSelfBounds = rect = new Rect();
        this.mTopToBottomLeftToRightSet = null;
        View[] viewArray = new View[]{};
        this.mSortedHorizontalChildren = viewArray;
        View[] viewArray2 = new View[]{};
        this.mSortedVerticalChildren = viewArray2;
        this.mGraph = dependencyGraph = new DependencyGraph();
    }

    public RelativeLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        DependencyGraph dependencyGraph;
        Rect rect;
        Rect rect2;
        this.mContentBounds = rect2 = new Rect();
        this.mSelfBounds = rect = new Rect();
        this.mTopToBottomLeftToRightSet = null;
        View[] viewArray = new View[]{};
        this.mSortedHorizontalChildren = viewArray;
        View[] viewArray2 = new View[]{};
        this.mSortedVerticalChildren = viewArray2;
        this.mGraph = dependencyGraph = new DependencyGraph();
        this.initFromAttributes(context, attributeSet);
    }

    public RelativeLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        DependencyGraph dependencyGraph;
        Rect rect;
        Rect rect2;
        this.mContentBounds = rect2 = new Rect();
        this.mSelfBounds = rect = new Rect();
        this.mTopToBottomLeftToRightSet = null;
        View[] viewArray = new View[]{};
        this.mSortedHorizontalChildren = viewArray;
        View[] viewArray2 = new View[]{};
        this.mSortedVerticalChildren = viewArray2;
        this.mGraph = dependencyGraph = new DependencyGraph();
        this.initFromAttributes(context, attributeSet);
    }

    private void alignBaseline(View view, LayoutParams layoutParams) {
        int n;
        LayoutParams layoutParams2;
        int[] nArray = layoutParams.getRules();
        int n2 = this.getRelatedViewBaseline(nArray, 4);
        if (n2 != -1 && (layoutParams2 = this.getRelatedViewParams(nArray, 4)) != null) {
            int n3 = layoutParams2.mTop + n2;
            int n4 = view.getBaseline();
            if (n4 != -1) {
                n3 -= n4;
            }
            int n5 = layoutParams.mBottom;
            int n6 = layoutParams.mTop;
            int n7 = n5 - n6;
            int n8 = LayoutParams.access$402(layoutParams, n3);
            int n9 = layoutParams.mTop + n7;
            int n10 = LayoutParams.access$202(layoutParams, n9);
        }
        if (this.mBaselineView == null) {
            this.mBaselineView = view;
            return;
        }
        LayoutParams layoutParams3 = (LayoutParams)this.mBaselineView.getLayoutParams();
        int n11 = layoutParams.mTop;
        if (n11 >= (n = layoutParams3.mTop)) {
            int n12;
            int n13;
            int n14 = layoutParams.mTop;
            if (n14 != (n13 = layoutParams3.mTop)) {
                return;
            }
            int n15 = layoutParams.mLeft;
            if (n15 >= (n12 = layoutParams3.mLeft)) {
                return;
            }
        }
        this.mBaselineView = view;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void applyHorizontalSizeRules(LayoutParams layoutParams, int n) {
        LayoutParams layoutParams2;
        LayoutParams layoutParams3;
        LayoutParams layoutParams4;
        int[] nArray = layoutParams.getRules();
        int n2 = LayoutParams.access$302(layoutParams, -1);
        int n3 = LayoutParams.access$102(layoutParams, -1);
        LayoutParams layoutParams5 = this.getRelatedViewParams(nArray, 0);
        if (layoutParams5 != null) {
            int n4 = layoutParams5.mLeft;
            int n5 = layoutParams5.leftMargin;
            int n6 = layoutParams.rightMargin;
            int n7 = n5 + n6;
            int n8 = n4 - n7;
            int n9 = LayoutParams.access$102(layoutParams, n8);
        } else if (layoutParams.alignWithParent && nArray[0] != 0 && n >= 0) {
            int n10 = this.mPaddingRight;
            int n11 = n - n10;
            int n12 = layoutParams.rightMargin;
            int n13 = n11 - n12;
            int n14 = LayoutParams.access$102(layoutParams, n13);
        }
        if ((layoutParams4 = this.getRelatedViewParams(nArray, 1)) != null) {
            int n15 = layoutParams4.mRight;
            int n16 = layoutParams4.rightMargin;
            int n17 = layoutParams.leftMargin;
            int n18 = n16 + n17;
            int n19 = n15 + n18;
            int n20 = LayoutParams.access$302(layoutParams, n19);
        } else if (layoutParams.alignWithParent && nArray[1] != 0) {
            int n21 = this.mPaddingLeft;
            int n22 = layoutParams.leftMargin;
            int n23 = n21 + n22;
            int n24 = LayoutParams.access$302(layoutParams, n23);
        }
        if ((layoutParams3 = this.getRelatedViewParams(nArray, 5)) != null) {
            int n25 = layoutParams3.mLeft;
            int n26 = layoutParams.leftMargin;
            int n27 = n25 + n26;
            int n28 = LayoutParams.access$302(layoutParams, n27);
        } else if (layoutParams.alignWithParent && nArray[5] != 0) {
            int n29 = this.mPaddingLeft;
            int n30 = layoutParams.leftMargin;
            int n31 = n29 + n30;
            int n32 = LayoutParams.access$302(layoutParams, n31);
        }
        if ((layoutParams2 = this.getRelatedViewParams(nArray, 7)) != null) {
            int n33 = layoutParams2.mRight;
            int n34 = layoutParams.rightMargin;
            int n35 = n33 - n34;
            int n36 = LayoutParams.access$102(layoutParams, n35);
        } else if (layoutParams.alignWithParent && nArray[7] != 0 && n >= 0) {
            int n37 = this.mPaddingRight;
            int n38 = n - n37;
            int n39 = layoutParams.rightMargin;
            int n40 = n38 - n39;
            int n41 = LayoutParams.access$102(layoutParams, n40);
        }
        if (nArray[9] != 0) {
            int n42 = this.mPaddingLeft;
            int n43 = layoutParams.leftMargin;
            int n44 = n42 + n43;
            int n45 = LayoutParams.access$302(layoutParams, n44);
        }
        if (nArray[11] == 0) {
            return;
        }
        if (n < 0) {
            return;
        }
        int n46 = this.mPaddingRight;
        int n47 = n - n46;
        int n48 = layoutParams.rightMargin;
        int n49 = n47 - n48;
        int n50 = LayoutParams.access$102(layoutParams, n49);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void applyVerticalSizeRules(LayoutParams layoutParams, int n) {
        LayoutParams layoutParams2;
        LayoutParams layoutParams3;
        LayoutParams layoutParams4;
        int[] nArray = layoutParams.getRules();
        int n2 = LayoutParams.access$402(layoutParams, -1);
        int n3 = LayoutParams.access$202(layoutParams, -1);
        LayoutParams layoutParams5 = this.getRelatedViewParams(nArray, 2);
        if (layoutParams5 != null) {
            int n4 = layoutParams5.mTop;
            int n5 = layoutParams5.topMargin;
            int n6 = layoutParams.bottomMargin;
            int n7 = n5 + n6;
            int n8 = n4 - n7;
            int n9 = LayoutParams.access$202(layoutParams, n8);
        } else if (layoutParams.alignWithParent && nArray[2] != 0 && n >= 0) {
            int n10 = this.mPaddingBottom;
            int n11 = n - n10;
            int n12 = layoutParams.bottomMargin;
            int n13 = n11 - n12;
            int n14 = LayoutParams.access$202(layoutParams, n13);
        }
        if ((layoutParams4 = this.getRelatedViewParams(nArray, 3)) != null) {
            int n15 = layoutParams4.mBottom;
            int n16 = layoutParams4.bottomMargin;
            int n17 = layoutParams.topMargin;
            int n18 = n16 + n17;
            int n19 = n15 + n18;
            int n20 = LayoutParams.access$402(layoutParams, n19);
        } else if (layoutParams.alignWithParent && nArray[3] != 0) {
            int n21 = this.mPaddingTop;
            int n22 = layoutParams.topMargin;
            int n23 = n21 + n22;
            int n24 = LayoutParams.access$402(layoutParams, n23);
        }
        if ((layoutParams3 = this.getRelatedViewParams(nArray, 6)) != null) {
            int n25 = layoutParams3.mTop;
            int n26 = layoutParams.topMargin;
            int n27 = n25 + n26;
            int n28 = LayoutParams.access$402(layoutParams, n27);
        } else if (layoutParams.alignWithParent && nArray[6] != 0) {
            int n29 = this.mPaddingTop;
            int n30 = layoutParams.topMargin;
            int n31 = n29 + n30;
            int n32 = LayoutParams.access$402(layoutParams, n31);
        }
        if ((layoutParams2 = this.getRelatedViewParams(nArray, 8)) != null) {
            int n33 = layoutParams2.mBottom;
            int n34 = layoutParams.bottomMargin;
            int n35 = n33 - n34;
            int n36 = LayoutParams.access$202(layoutParams, n35);
        } else if (layoutParams.alignWithParent && nArray[8] != 0 && n >= 0) {
            int n37 = this.mPaddingBottom;
            int n38 = n - n37;
            int n39 = layoutParams.bottomMargin;
            int n40 = n38 - n39;
            int n41 = LayoutParams.access$202(layoutParams, n40);
        }
        if (nArray[10] != 0) {
            int n42 = this.mPaddingTop;
            int n43 = layoutParams.topMargin;
            int n44 = n42 + n43;
            int n45 = LayoutParams.access$402(layoutParams, n44);
        }
        if (nArray[12] != 0 && n >= 0) {
            int n46 = this.mPaddingBottom;
            int n47 = n - n46;
            int n48 = layoutParams.bottomMargin;
            int n49 = n47 - n48;
            int n50 = LayoutParams.access$202(layoutParams, n49);
        }
        if (nArray[4] == 0) {
            return;
        }
        this.mHasBaselineAlignedChild = true;
    }

    private void centerHorizontal(View view, LayoutParams layoutParams, int n) {
        int n2 = view.getMeasuredWidth();
        int n3 = (n - n2) / 2;
        int n4 = LayoutParams.access$302(layoutParams, n3);
        int n5 = n3 + n2;
        int n6 = LayoutParams.access$102(layoutParams, n5);
    }

    private void centerVertical(View view, LayoutParams layoutParams, int n) {
        int n2 = view.getMeasuredHeight();
        int n3 = (n - n2) / 2;
        int n4 = LayoutParams.access$402(layoutParams, n3);
        int n5 = n3 + n2;
        int n6 = LayoutParams.access$202(layoutParams, n5);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getChildMeasureSpec(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = 0;
        int n10 = 0;
        int n11 = n;
        int n12 = n2;
        if (n11 < 0) {
            n11 = n6 + n4;
        }
        if (n12 < 0) {
            n12 = n8 - n7 - n5;
        }
        int n13 = n12 - n11;
        if (n >= 0 && n2 >= 0) {
            n9 = 0x40000000;
            n10 = n13;
            return View.MeasureSpec.makeMeasureSpec(n10, n9);
        }
        if (n3 >= 0) {
            n9 = 0x40000000;
            if (n13 >= 0) {
                n10 = Math.min(n13, n3);
                return View.MeasureSpec.makeMeasureSpec(n10, n9);
            }
            n10 = n3;
            return View.MeasureSpec.makeMeasureSpec(n10, n9);
        }
        if (n3 == -1) {
            n9 = 0x40000000;
            n10 = n13;
            return View.MeasureSpec.makeMeasureSpec(n10, n9);
        }
        if (n3 != -1) return View.MeasureSpec.makeMeasureSpec(n10, n9);
        if (n13 >= 0) {
            n9 = Integer.MIN_VALUE;
            n10 = n13;
            return View.MeasureSpec.makeMeasureSpec(n10, n9);
        }
        n9 = 0;
        n10 = 0;
        return View.MeasureSpec.makeMeasureSpec(n10, n9);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private View getRelatedView(int[] nArray, int n) {
        int n2 = nArray[n];
        if (n2 == 0) return null;
        DependencyGraph.Node node = (DependencyGraph.Node)this.mGraph.mKeyNodes.get(n2);
        if (node == null) {
            return null;
        }
        View view = node.view;
        while (view.getVisibility() == 8) {
            int n3;
            int[] nArray2 = ((LayoutParams)view.getLayoutParams()).getRules();
            SparseArray sparseArray = this.mGraph.mKeyNodes;
            node = (DependencyGraph.Node)sparseArray.get(n3 = nArray2[n]);
            if (node == null) {
                return null;
            }
            view = node.view;
        }
        return view;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getRelatedViewBaseline(int[] nArray, int n) {
        View view = this.getRelatedView(nArray, n);
        if (view == null) return -1;
        return view.getBaseline();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LayoutParams getRelatedViewParams(int[] nArray, int n) {
        View view = this.getRelatedView(nArray, n);
        if (view == null) return null;
        if (!(view.getLayoutParams() instanceof LayoutParams)) return null;
        return (LayoutParams)view.getLayoutParams();
    }

    private void initFromAttributes(Context context, AttributeSet attributeSet) {
        int n;
        int n2;
        int[] nArray = R.styleable.RelativeLayout;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray);
        this.mIgnoreGravity = n2 = typedArray.getResourceId(1, -1);
        int n3 = this.mGravity;
        this.mGravity = n = typedArray.getInt(0, n3);
        typedArray.recycle();
    }

    private void measureChild(View view, LayoutParams layoutParams, int n, int n2) {
        int n3 = layoutParams.mLeft;
        int n4 = layoutParams.mRight;
        int n5 = layoutParams.width;
        int n6 = layoutParams.leftMargin;
        int n7 = layoutParams.rightMargin;
        int n8 = this.mPaddingLeft;
        int n9 = this.mPaddingRight;
        RelativeLayout relativeLayout = this;
        int n10 = n;
        int n11 = relativeLayout.getChildMeasureSpec(n3, n4, n5, n6, n7, n8, n9, n10);
        int n12 = layoutParams.mTop;
        int n13 = layoutParams.mBottom;
        int n14 = layoutParams.height;
        int n15 = layoutParams.topMargin;
        int n16 = layoutParams.bottomMargin;
        int n17 = this.mPaddingTop;
        int n18 = this.mPaddingBottom;
        RelativeLayout relativeLayout2 = this;
        int n19 = n2;
        int n20 = relativeLayout2.getChildMeasureSpec(n12, n13, n14, n15, n16, n17, n18, n19);
        view.measure(n11, n20);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void measureChildHorizontal(View view, LayoutParams layoutParams, int n, int n2) {
        int n3 = layoutParams.mLeft;
        int n4 = layoutParams.mRight;
        int n5 = layoutParams.width;
        int n6 = layoutParams.leftMargin;
        int n7 = layoutParams.rightMargin;
        int n8 = this.mPaddingLeft;
        int n9 = this.mPaddingRight;
        RelativeLayout relativeLayout = this;
        int n10 = n;
        int n11 = relativeLayout.getChildMeasureSpec(n3, n4, n5, n6, n7, n8, n9, n10);
        int n12 = layoutParams.width == -1 ? View.MeasureSpec.makeMeasureSpec(n2, 0x40000000) : View.MeasureSpec.makeMeasureSpec(n2, Integer.MIN_VALUE);
        view.measure(n11, n12);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean positionChildHorizontal(View view, LayoutParams layoutParams, int n, boolean bl) {
        int[] nArray = layoutParams.getRules();
        if (layoutParams.mLeft < 0 && layoutParams.mRight >= 0) {
            int n2 = layoutParams.mRight;
            int n3 = view.getMeasuredWidth();
            int n4 = n2 - n3;
            int n5 = LayoutParams.access$302(layoutParams, n4);
        } else if (layoutParams.mLeft >= 0 && layoutParams.mRight < 0) {
            int n6 = layoutParams.mLeft;
            int n7 = view.getMeasuredWidth();
            int n8 = n6 + n7;
            int n9 = LayoutParams.access$102(layoutParams, n8);
        } else if (layoutParams.mLeft < 0 && layoutParams.mRight < 0) {
            if (nArray[13] != 0 || nArray[14] != 0) {
                if (!bl) {
                    this.centerHorizontal(view, layoutParams, n);
                    return true;
                } else {
                    int n10 = this.mPaddingLeft;
                    int n11 = layoutParams.leftMargin;
                    int n12 = n10 + n11;
                    int n13 = LayoutParams.access$302(layoutParams, n12);
                    int n14 = layoutParams.mLeft;
                    int n15 = view.getMeasuredWidth();
                    int n16 = n14 + n15;
                    int n17 = LayoutParams.access$102(layoutParams, n16);
                }
                return true;
            }
            int n18 = this.mPaddingLeft;
            int n19 = layoutParams.leftMargin;
            int n20 = n18 + n19;
            int n21 = LayoutParams.access$302(layoutParams, n20);
            int n22 = layoutParams.mLeft;
            int n23 = view.getMeasuredWidth();
            int n24 = n22 + n23;
            int n25 = LayoutParams.access$102(layoutParams, n24);
        }
        if (nArray[11] == 0) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean positionChildVertical(View view, LayoutParams layoutParams, int n, boolean bl) {
        int[] nArray = layoutParams.getRules();
        if (layoutParams.mTop < 0 && layoutParams.mBottom >= 0) {
            int n2 = layoutParams.mBottom;
            int n3 = view.getMeasuredHeight();
            int n4 = n2 - n3;
            int n5 = LayoutParams.access$402(layoutParams, n4);
        } else if (layoutParams.mTop >= 0 && layoutParams.mBottom < 0) {
            int n6 = layoutParams.mTop;
            int n7 = view.getMeasuredHeight();
            int n8 = n6 + n7;
            int n9 = LayoutParams.access$202(layoutParams, n8);
        } else if (layoutParams.mTop < 0 && layoutParams.mBottom < 0) {
            if (nArray[13] != 0 || nArray[15] != 0) {
                if (!bl) {
                    this.centerVertical(view, layoutParams, n);
                    return true;
                } else {
                    int n10 = this.mPaddingTop;
                    int n11 = layoutParams.topMargin;
                    int n12 = n10 + n11;
                    int n13 = LayoutParams.access$402(layoutParams, n12);
                    int n14 = layoutParams.mTop;
                    int n15 = view.getMeasuredHeight();
                    int n16 = n14 + n15;
                    int n17 = LayoutParams.access$202(layoutParams, n16);
                }
                return true;
            }
            int n18 = this.mPaddingTop;
            int n19 = layoutParams.topMargin;
            int n20 = n18 + n19;
            int n21 = LayoutParams.access$402(layoutParams, n20);
            int n22 = layoutParams.mTop;
            int n23 = view.getMeasuredHeight();
            int n24 = n22 + n23;
            int n25 = LayoutParams.access$202(layoutParams, n24);
        }
        if (nArray[12] == 0) return false;
        return true;
    }

    private void sortChildren() {
        int n = this.getChildCount();
        if (this.mSortedVerticalChildren.length != n) {
            View[] viewArray = new View[n];
            this.mSortedVerticalChildren = viewArray;
        }
        if (this.mSortedHorizontalChildren.length != n) {
            View[] viewArray = new View[n];
            this.mSortedHorizontalChildren = viewArray;
        }
        DependencyGraph dependencyGraph = this.mGraph;
        dependencyGraph.clear();
        for (int i = 0; i < n; ++i) {
            View view = this.getChildAt(i);
            dependencyGraph.add(view);
        }
        View[] viewArray = this.mSortedVerticalChildren;
        int[] nArray = new int[]{2, 3, 4, 6, 8};
        dependencyGraph.getSortedViews(viewArray, nArray);
        View[] viewArray2 = this.mSortedHorizontalChildren;
        int[] nArray2 = new int[]{0, 1, 5, 7};
        dependencyGraph.getSortedViews(viewArray2, nArray2);
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        if (this.mTopToBottomLeftToRightSet == null) {
            TopToBottomLeftToRightComparator topToBottomLeftToRightComparator = new TopToBottomLeftToRightComparator();
            TreeSet<View> treeSet = new TreeSet<View>(topToBottomLeftToRightComparator);
            this.mTopToBottomLeftToRightSet = treeSet;
        }
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            SortedSet<View> sortedSet = this.mTopToBottomLeftToRightSet;
            View view = this.getChildAt(i);
            boolean bl = sortedSet.add(view);
        }
        Iterator iterator = this.mTopToBottomLeftToRightSet.iterator();
        while (iterator.hasNext()) {
            if (!((View)iterator.next()).dispatchPopulateAccessibilityEvent(accessibilityEvent)) continue;
            this.mTopToBottomLeftToRightSet.clear();
            return true;
        }
        this.mTopToBottomLeftToRightSet.clear();
        return false;
    }

    @Override
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    @Override
    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new LayoutParams(layoutParams);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        Context context = this.getContext();
        return new LayoutParams(context, attributeSet);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getBaseline() {
        if (this.mBaselineView == null) return super.getBaseline();
        return this.mBaselineView.getBaseline();
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        int n5 = this.getChildCount();
        int n6 = 0;
        while (n6 < n5) {
            View view = this.getChildAt(n6);
            if (view.getVisibility() != 8) {
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                int n7 = layoutParams.mLeft;
                int n8 = layoutParams.mTop;
                int n9 = layoutParams.mRight;
                int n10 = layoutParams.mBottom;
                view.layout(n7, n8, n9, n10);
            }
            ++n6;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        boolean bl;
        int n11;
        int n12;
        int n13;
        int n14;
        if (this.mDirtyHierarchy) {
            boolean bl2;
            this.mDirtyHierarchy = bl2 = false;
            this.sortChildren();
        }
        int n15 = 65535;
        int n16 = 65535;
        int n17 = 0;
        int n18 = 0;
        int n19 = View.MeasureSpec.getMode(n);
        int n20 = View.MeasureSpec.getMode(n2);
        int n21 = View.MeasureSpec.getSize(n);
        int n22 = View.MeasureSpec.getSize(n2);
        if (n19 != 0) {
            n15 = n21;
        }
        if (n20 != 0) {
            n16 = n22;
        }
        if ((n14 = n19) == (n13 = 0x40000000)) {
            n17 = n15;
        }
        if ((n12 = n20) == (n11 = 0x40000000)) {
            n18 = n16;
        }
        this.mHasBaselineAlignedChild = bl = false;
        View view = null;
        int n23 = this.mGravity & 7;
        int n24 = n23;
        int n25 = 3;
        boolean bl3 = n24 != n25 && n23 != 0;
        int n26 = this.mGravity & 0x70;
        int n27 = n26;
        int n28 = 48;
        boolean bl4 = n27 != n28 && n26 != 0;
        int n29 = Integer.MAX_VALUE;
        int n30 = Integer.MAX_VALUE;
        int n31 = Integer.MIN_VALUE;
        int n32 = Integer.MIN_VALUE;
        boolean bl5 = false;
        boolean bl6 = false;
        if ((bl3 || bl4) && (n10 = this.mIgnoreGravity) != (n9 = 65535)) {
            int n33 = this.mIgnoreGravity;
            RelativeLayout relativeLayout = this;
            int n34 = n33;
            view = relativeLayout.findViewById(n34);
        }
        boolean bl7 = (n8 = n19) != (n7 = 0x40000000);
        int n35 = n20;
        int n36 = 0x40000000;
        boolean bl8 = n35 != n36;
        View[] viewArray = this.mSortedHorizontalChildren;
        int n37 = viewArray.length;
        int n38 = 0;
        while ((n6 = ++n38) < (n5 = n37)) {
            int n39;
            View view2 = viewArray[n38];
            int n40 = view2.getVisibility();
            if (n40 == (n39 = 8)) continue;
            LayoutParams layoutParams = (LayoutParams)view2.getLayoutParams();
            RelativeLayout relativeLayout = this;
            LayoutParams layoutParams2 = layoutParams;
            int n41 = n15;
            relativeLayout.applyHorizontalSizeRules(layoutParams2, n41);
            RelativeLayout relativeLayout2 = this;
            View view3 = view2;
            LayoutParams layoutParams3 = layoutParams;
            int n42 = n15;
            int n43 = n16;
            relativeLayout2.measureChildHorizontal(view3, layoutParams3, n42, n43);
            RelativeLayout relativeLayout3 = this;
            View view4 = view2;
            LayoutParams layoutParams4 = layoutParams;
            int n44 = n15;
            boolean bl9 = bl7;
            if (!relativeLayout3.positionChildHorizontal(view4, layoutParams4, n44, bl9)) continue;
            bl5 = true;
        }
        View[] viewArray2 = this.mSortedVerticalChildren;
        int n45 = viewArray2.length;
        int n46 = 0;
        while ((n4 = ++n46) < (n3 = n45)) {
            View view5;
            View view6;
            View view7;
            View view8;
            int n47;
            View view9 = viewArray2[n46];
            int n48 = view9.getVisibility();
            if (n48 == (n47 = 8)) continue;
            LayoutParams layoutParams = (LayoutParams)view9.getLayoutParams();
            RelativeLayout relativeLayout = this;
            LayoutParams layoutParams5 = layoutParams;
            int n49 = n16;
            relativeLayout.applyVerticalSizeRules(layoutParams5, n49);
            RelativeLayout relativeLayout4 = this;
            View view10 = view9;
            LayoutParams layoutParams6 = layoutParams;
            int n50 = n15;
            int n51 = n16;
            relativeLayout4.measureChild(view10, layoutParams6, n50, n51);
            RelativeLayout relativeLayout5 = this;
            View view11 = view9;
            LayoutParams layoutParams7 = layoutParams;
            int n52 = n16;
            boolean bl10 = bl8;
            if (relativeLayout5.positionChildVertical(view11, layoutParams7, n52, bl10)) {
                bl6 = true;
            }
            if (bl7) {
                int n53 = layoutParams.mRight;
                int n54 = n17;
                int n55 = n53;
                n17 = Math.max(n54, n55);
            }
            if (bl8) {
                int n56 = layoutParams.mBottom;
                int n57 = n18;
                int n58 = n56;
                n18 = Math.max(n57, n58);
            }
            if ((view8 = view9) != (view7 = view) || bl4) {
                int n59 = layoutParams.mLeft;
                int n60 = layoutParams.leftMargin;
                int n61 = n59 - n60;
                int n62 = n29;
                int n63 = n61;
                n29 = Math.min(n62, n63);
                int n64 = layoutParams.mTop;
                int n65 = layoutParams.topMargin;
                int n66 = n64 - n65;
                int n67 = n30;
                int n68 = n66;
                n30 = Math.min(n67, n68);
            }
            if ((view6 = view9) == (view5 = view) && !bl3) continue;
            int n69 = layoutParams.mRight;
            int n70 = layoutParams.rightMargin;
            int n71 = n69 + n70;
            int n72 = n31;
            int n73 = n71;
            n31 = Math.max(n72, n73);
            int n74 = layoutParams.mBottom;
            int n75 = layoutParams.bottomMargin;
            int n76 = n74 + n75;
            int n77 = n32;
            int n78 = n76;
            n32 = Math.max(n77, n78);
        }
        if (this.mHasBaselineAlignedChild) {
            int n79;
            int n80;
            n46 = 0;
            while ((n80 = ++n46) < (n79 = n45)) {
                View view12;
                View view13;
                int n81;
                RelativeLayout relativeLayout = this;
                int n82 = n46;
                View view14 = relativeLayout.getChildAt(n82);
                int n83 = view14.getVisibility();
                if (n83 == (n81 = 8)) continue;
                LayoutParams layoutParams = (LayoutParams)view14.getLayoutParams();
                RelativeLayout relativeLayout6 = this;
                View view15 = view14;
                LayoutParams layoutParams8 = layoutParams;
                relativeLayout6.alignBaseline(view15, layoutParams8);
                View view16 = view14;
                View view17 = view;
                if (view16 != view17 || bl4) {
                    int n84 = layoutParams.mLeft;
                    int n85 = layoutParams.leftMargin;
                    int n86 = n84 - n85;
                    int n87 = n29;
                    int n88 = n86;
                    n29 = Math.min(n87, n88);
                    int n89 = layoutParams.mTop;
                    int n90 = layoutParams.topMargin;
                    int n91 = n89 - n90;
                    int n92 = n30;
                    int n93 = n91;
                    n30 = Math.min(n92, n93);
                }
                if ((view13 = view14) == (view12 = view) && !bl3) continue;
                int n94 = layoutParams.mRight;
                int n95 = layoutParams.rightMargin;
                int n96 = n94 + n95;
                int n97 = n31;
                int n98 = n96;
                n31 = Math.max(n97, n98);
                int n99 = layoutParams.mBottom;
                int n100 = layoutParams.bottomMargin;
                int n101 = n99 + n100;
                int n102 = n32;
                int n103 = n101;
                n32 = Math.max(n102, n103);
            }
        }
        if (bl7) {
            int n104 = this.mPaddingRight;
            int n105 = n17 + n104;
            if (this.mLayoutParams.width >= 0) {
                int n106 = this.mLayoutParams.width;
                int n107 = n105;
                int n108 = n106;
                n105 = Math.max(n107, n108);
            }
            int n109 = this.getSuggestedMinimumWidth();
            int n110 = n105;
            int n111 = n109;
            int n112 = Math.max(n110, n111);
            int n113 = n;
            n17 = RelativeLayout.resolveSize(n112, n113);
            if (bl5) {
                int n114;
                int n115;
                n46 = 0;
                while ((n115 = ++n46) < (n114 = n45)) {
                    int n116;
                    RelativeLayout relativeLayout = this;
                    int n117 = n46;
                    View view18 = relativeLayout.getChildAt(n117);
                    int n118 = view18.getVisibility();
                    if (n118 == (n116 = 8)) continue;
                    LayoutParams layoutParams = (LayoutParams)view18.getLayoutParams();
                    int[] nArray = layoutParams.getRules();
                    if (nArray[13] != 0 || nArray[14] != 0) {
                        RelativeLayout relativeLayout7 = this;
                        View view19 = view18;
                        LayoutParams layoutParams9 = layoutParams;
                        int n119 = n17;
                        relativeLayout7.centerHorizontal(view19, layoutParams9, n119);
                        continue;
                    }
                    if (nArray[11] == 0) continue;
                    int n120 = view18.getMeasuredWidth();
                    int n121 = this.mPaddingRight;
                    int n122 = n17 - n121 - n120;
                    LayoutParams layoutParams10 = layoutParams;
                    int n123 = n122;
                    int n124 = LayoutParams.access$302(layoutParams10, n123);
                    int n125 = layoutParams.mLeft + n120;
                    LayoutParams layoutParams11 = layoutParams;
                    int n126 = n125;
                    int n127 = LayoutParams.access$102(layoutParams11, n126);
                }
            }
        }
        if (bl8) {
            int n128 = this.mPaddingBottom;
            int n129 = n18 + n128;
            if (this.mLayoutParams.height >= 0) {
                int n130 = this.mLayoutParams.height;
                int n131 = n129;
                int n132 = n130;
                n129 = Math.max(n131, n132);
            }
            int n133 = this.getSuggestedMinimumHeight();
            int n134 = n129;
            int n135 = n133;
            int n136 = Math.max(n134, n135);
            int n137 = n2;
            n18 = RelativeLayout.resolveSize(n136, n137);
            if (bl6) {
                int n138;
                int n139;
                n46 = 0;
                while ((n139 = ++n46) < (n138 = n45)) {
                    int n140;
                    RelativeLayout relativeLayout = this;
                    int n141 = n46;
                    View view20 = relativeLayout.getChildAt(n141);
                    int n142 = view20.getVisibility();
                    if (n142 == (n140 = 8)) continue;
                    LayoutParams layoutParams = (LayoutParams)view20.getLayoutParams();
                    int[] nArray = layoutParams.getRules();
                    if (nArray[13] != 0 || nArray[15] != 0) {
                        RelativeLayout relativeLayout8 = this;
                        View view21 = view20;
                        LayoutParams layoutParams12 = layoutParams;
                        int n143 = n18;
                        relativeLayout8.centerVertical(view21, layoutParams12, n143);
                        continue;
                    }
                    if (nArray[12] == 0) continue;
                    int n144 = view20.getMeasuredHeight();
                    int n145 = this.mPaddingBottom;
                    int n146 = n18 - n145 - n144;
                    LayoutParams layoutParams13 = layoutParams;
                    int n147 = n146;
                    int n148 = LayoutParams.access$402(layoutParams13, n147);
                    int n149 = layoutParams.mTop + n144;
                    LayoutParams layoutParams14 = layoutParams;
                    int n150 = n149;
                    int n151 = LayoutParams.access$202(layoutParams14, n150);
                }
            }
        }
        if (bl3 || bl4) {
            Rect rect = this.mSelfBounds;
            int n152 = this.mPaddingLeft;
            int n153 = this.mPaddingTop;
            int n154 = this.mPaddingRight;
            int n155 = n17 - n154;
            int n156 = this.mPaddingBottom;
            int n157 = n18 - n156;
            Rect rect2 = rect;
            int n158 = n152;
            int n159 = n153;
            int n160 = n155;
            int n161 = n157;
            rect2.set(n158, n159, n160, n161);
            Rect rect3 = this.mContentBounds;
            int n162 = this.mGravity;
            int n163 = n31 - n29;
            int n164 = n32 - n30;
            int n165 = n162;
            int n166 = n163;
            int n167 = n164;
            Rect rect4 = rect;
            Rect rect5 = rect3;
            Gravity.apply(n165, n166, n167, rect4, rect5);
            int n168 = rect3.left - n29;
            int n169 = rect3.top - n30;
            if (n168 != 0 || n169 != 0) {
                int n170;
                int n171;
                n46 = 0;
                while ((n171 = ++n46) < (n170 = n45)) {
                    View view22;
                    View view23;
                    int n172;
                    RelativeLayout relativeLayout = this;
                    int n173 = n46;
                    View view24 = relativeLayout.getChildAt(n173);
                    int n174 = view24.getVisibility();
                    if (n174 == (n172 = 8) || (view23 = view24) == (view22 = view)) continue;
                    LayoutParams layoutParams = (LayoutParams)view24.getLayoutParams();
                    if (bl3) {
                        LayoutParams layoutParams15 = layoutParams;
                        int n175 = n168;
                        int n176 = LayoutParams.access$312(layoutParams15, n175);
                        LayoutParams layoutParams16 = layoutParams;
                        int n177 = n168;
                        int n178 = LayoutParams.access$112(layoutParams16, n177);
                    }
                    if (!bl4) continue;
                    LayoutParams layoutParams17 = layoutParams;
                    int n179 = n169;
                    int n180 = LayoutParams.access$412(layoutParams17, n179);
                    LayoutParams layoutParams18 = layoutParams;
                    int n181 = n169;
                    int n182 = LayoutParams.access$212(layoutParams18, n181);
                }
            }
        }
        RelativeLayout relativeLayout = this;
        int n183 = n17;
        int n184 = n18;
        relativeLayout.setMeasuredDimension(n183, n184);
    }

    @Override
    public void requestLayout() {
        super.requestLayout();
        this.mDirtyHierarchy = true;
    }

    @RemotableViewMethod
    public void setGravity(int n) {
        if (this.mGravity != n) {
            return;
        }
        if ((n & 7) == 0) {
            n |= 3;
        }
        if ((n & 0x70) == 0) {
            n |= 0x30;
        }
        this.mGravity = n;
        this.requestLayout();
    }

    @RemotableViewMethod
    public void setHorizontalGravity(int n) {
        int n2;
        int n3 = n & 7;
        if ((this.mGravity & 7) != n3) {
            return;
        }
        this.mGravity = n2 = this.mGravity & 0xFFFFFFF8 | n3;
        this.requestLayout();
    }

    @RemotableViewMethod
    public void setIgnoreGravity(int n) {
        this.mIgnoreGravity = n;
    }

    @RemotableViewMethod
    public void setVerticalGravity(int n) {
        int n2;
        int n3 = n & 0x70;
        if ((this.mGravity & 0x70) != n3) {
            return;
        }
        this.mGravity = n2 = this.mGravity & 0xFFFFFF8F | n3;
        this.requestLayout();
    }

    private static class DependencyGraph {
        private SparseArray<Node> mKeyNodes;
        private ArrayList<Node> mNodes;
        private LinkedList<Node> mRoots;

        private DependencyGraph() {
            ArrayList arrayList = new ArrayList();
            this.mNodes = arrayList;
            SparseArray sparseArray = new SparseArray();
            this.mKeyNodes = sparseArray;
            LinkedList linkedList = new LinkedList();
            this.mRoots = linkedList;
        }

        private static void appendViewId(Resources resources, Node node, StringBuilder stringBuilder) {
            if (node.view.getId() != -1) {
                int n = node.view.getId();
                String string2 = resources.getResourceEntryName(n);
                StringBuilder stringBuilder2 = stringBuilder.append(string2);
                return;
            }
            StringBuilder stringBuilder3 = stringBuilder.append("NO_ID");
        }

        /*
         * Enabled aggressive block sorting
         */
        private LinkedList<Node> findRoots(int[] nArray) {
            SparseArray<Node> sparseArray = this.mKeyNodes;
            ArrayList<Node> arrayList = this.mNodes;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Node node = arrayList.get(i);
                node.dependents.clear();
                node.dependencies.clear();
            }
            int n2 = 0;
            while (true) {
                int n3;
                int[] nArray2;
                Node node;
                if (n2 < n) {
                    node = arrayList.get(n2);
                    nArray2 = ((LayoutParams)node.view.getLayoutParams()).mRules;
                    n3 = nArray.length;
                } else {
                    LinkedList<Node> linkedList = this.mRoots;
                    linkedList.clear();
                    int n4 = 0;
                    while (true) {
                        if (n4 >= n) {
                            return linkedList;
                        }
                        Node node2 = arrayList.get(n4);
                        if (node2.dependencies.size() == 0) {
                            boolean bl = linkedList.add(node2);
                        }
                        ++n4;
                    }
                }
                for (int i = 0; i < n3; ++i) {
                    Node node3;
                    int n5 = nArray[i];
                    int n6 = nArray2[n5];
                    if (n6 <= 0 || (node3 = sparseArray.get(n6)) == null || node3 == node) continue;
                    boolean bl = node3.dependents.add(node);
                    node.dependencies.put(n6, node3);
                }
                ++n2;
            }
        }

        private static void printNode(Resources resources, Node node) {
            if (node.dependents.size() == 0) {
                View view = node.view;
                DependencyGraph.printViewId(resources, view);
                return;
            }
            Iterator<Node> iterator = node.dependents.iterator();
            while (iterator.hasNext()) {
                Node node2 = iterator.next();
                StringBuilder stringBuilder = new StringBuilder();
                DependencyGraph.appendViewId(resources, node, stringBuilder);
                DependencyGraph.printdependents(resources, node2, stringBuilder);
            }
            return;
        }

        static void printViewId(Resources resources, View view) {
            if (view.getId() != -1) {
                int n = view.getId();
                String string2 = resources.getResourceEntryName(n);
                int n2 = Log.d(RelativeLayout.LOG_TAG, string2);
                return;
            }
            int n = Log.d(RelativeLayout.LOG_TAG, "NO_ID");
        }

        private static void printdependents(Resources resources, Node node, StringBuilder stringBuilder) {
            StringBuilder stringBuilder2 = stringBuilder.append(" -> ");
            DependencyGraph.appendViewId(resources, node, stringBuilder);
            if (node.dependents.size() == 0) {
                String string2 = stringBuilder.toString();
                int n = Log.d(RelativeLayout.LOG_TAG, string2);
                return;
            }
            Iterator<Node> iterator = node.dependents.iterator();
            while (iterator.hasNext()) {
                Node node2 = iterator.next();
                StringBuilder stringBuilder3 = new StringBuilder(stringBuilder);
                DependencyGraph.printdependents(resources, node2, stringBuilder3);
            }
            return;
        }

        void add(View view) {
            int n = view.getId();
            Node node = Node.acquire(view);
            if (n != -1) {
                this.mKeyNodes.put(n, node);
            }
            boolean bl = this.mNodes.add(node);
        }

        void clear() {
            ArrayList<Node> arrayList = this.mNodes;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                arrayList.get(i).release();
            }
            arrayList.clear();
            this.mKeyNodes.clear();
            this.mRoots.clear();
        }

        void getSortedViews(View[] viewArray, int ... nArray) {
            LinkedList<Node> linkedList = this.findRoots(nArray);
            int n = 0;
            while (linkedList.size() > 0) {
                Node node = linkedList.removeFirst();
                View view = node.view;
                int n2 = view.getId();
                int n3 = n + 1;
                viewArray[n] = view;
                for (Node node2 : node.dependents) {
                    SparseArray<Node> sparseArray = node2.dependencies;
                    sparseArray.remove(n2);
                    if (sparseArray.size() != 0) continue;
                    boolean bl = linkedList.add(node2);
                }
                n = n3;
            }
            int n4 = viewArray.length;
            if (n >= n4) {
                return;
            }
            throw new IllegalStateException("Circular dependencies cannot exist in RelativeLayout");
        }

        void log(Resources resources, int ... nArray) {
            Iterator iterator = this.findRoots(nArray).iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                DependencyGraph.printNode(resources, node);
            }
            return;
        }

        static class Node
        implements Poolable<Node> {
            private static final int POOL_LIMIT = 100;
            private static final Pool<Node> sPool = Pools.synchronizedPool(Pools.finitePool(new PoolableManager<Node>(){

                @Override
                public Node newInstance() {
                    return new Node();
                }

                @Override
                public void onAcquired(Node node) {
                }

                @Override
                public void onReleased(Node node) {
                }
            }, 100));
            final SparseArray<Node> dependencies;
            final HashSet<Node> dependents;
            private Node mNext;
            View view;

            Node() {
                HashSet hashSet = new HashSet();
                this.dependents = hashSet;
                SparseArray sparseArray = new SparseArray();
                this.dependencies = sparseArray;
            }

            static Node acquire(View view) {
                Node node = sPool.acquire();
                node.view = view;
                return node;
            }

            @Override
            public Node getNextPoolable() {
                return this.mNext;
            }

            void release() {
                this.view = null;
                this.dependents.clear();
                this.dependencies.clear();
                sPool.release(this);
            }

            @Override
            public void setNextPoolable(Node node) {
                this.mNext = node;
            }
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        @ViewDebug.ExportedProperty(category="layout")
        public boolean alignWithParent;
        private int mBottom;
        private int mLeft;
        private int mRight;
        @ViewDebug.ExportedProperty(category="layout", indexMapping={@ViewDebug.IntToString(from=2, to="above"), @ViewDebug.IntToString(from=4, to="alignBaseline"), @ViewDebug.IntToString(from=8, to="alignBottom"), @ViewDebug.IntToString(from=5, to="alignLeft"), @ViewDebug.IntToString(from=12, to="alignParentBottom"), @ViewDebug.IntToString(from=9, to="alignParentLeft"), @ViewDebug.IntToString(from=11, to="alignParentRight"), @ViewDebug.IntToString(from=10, to="alignParentTop"), @ViewDebug.IntToString(from=7, to="alignRight"), @ViewDebug.IntToString(from=6, to="alignTop"), @ViewDebug.IntToString(from=3, to="below"), @ViewDebug.IntToString(from=14, to="centerHorizontal"), @ViewDebug.IntToString(from=13, to="center"), @ViewDebug.IntToString(from=15, to="centerVertical"), @ViewDebug.IntToString(from=0, to="leftOf"), @ViewDebug.IntToString(from=1, to="rightOf")}, mapping={@ViewDebug.IntToString(from=255, to="true"), @ViewDebug.IntToString(from=0, to="false/NO_ID")}, resolveId=true)
        private int[] mRules;
        private int mTop;

        public LayoutParams(int n, int n2) {
            super(n, n2);
            int[] nArray = new int[16];
            this.mRules = nArray;
        }

        /*
         * Enabled aggressive block sorting
         */
        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            int[] nArray = new int[16];
            this.mRules = nArray;
            int[] nArray2 = R.styleable.RelativeLayout_Layout;
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray2);
            int[] nArray3 = this.mRules;
            int n = typedArray.getIndexCount();
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    typedArray.recycle();
                    return;
                }
                int n3 = typedArray.getIndex(n2);
                switch (n3) {
                    case 16: {
                        boolean bl;
                        this.alignWithParent = bl = typedArray.getBoolean(n3, false);
                        break;
                    }
                    case 0: {
                        int n4;
                        nArray3[0] = n4 = typedArray.getResourceId(n3, 0);
                        break;
                    }
                    case 1: {
                        int n5;
                        nArray3[1] = n5 = typedArray.getResourceId(n3, 0);
                        break;
                    }
                    case 2: {
                        int n6;
                        nArray3[2] = n6 = typedArray.getResourceId(n3, 0);
                        break;
                    }
                    case 3: {
                        int n7;
                        nArray3[3] = n7 = typedArray.getResourceId(n3, 0);
                        break;
                    }
                    case 4: {
                        int n8;
                        nArray3[4] = n8 = typedArray.getResourceId(n3, 0);
                        break;
                    }
                    case 5: {
                        int n9;
                        nArray3[5] = n9 = typedArray.getResourceId(n3, 0);
                        break;
                    }
                    case 6: {
                        int n10;
                        nArray3[6] = n10 = typedArray.getResourceId(n3, 0);
                        break;
                    }
                    case 7: {
                        int n11;
                        nArray3[7] = n11 = typedArray.getResourceId(n3, 0);
                        break;
                    }
                    case 8: {
                        int n12;
                        nArray3[8] = n12 = typedArray.getResourceId(n3, 0);
                        break;
                    }
                    case 9: {
                        int n13 = 9;
                        int n14 = typedArray.getBoolean(n3, false) ? -1 : 0;
                        nArray3[n13] = n14;
                        break;
                    }
                    case 10: {
                        int n13 = 10;
                        int n14 = typedArray.getBoolean(n3, false) ? -1 : 0;
                        nArray3[n13] = n14;
                        break;
                    }
                    case 11: {
                        int n13 = 11;
                        int n14 = typedArray.getBoolean(n3, false) ? -1 : 0;
                        nArray3[n13] = n14;
                        break;
                    }
                    case 12: {
                        int n13 = 12;
                        int n14 = typedArray.getBoolean(n3, false) ? -1 : 0;
                        nArray3[n13] = n14;
                        break;
                    }
                    case 13: {
                        int n13 = 13;
                        int n14 = typedArray.getBoolean(n3, false) ? -1 : 0;
                        nArray3[n13] = n14;
                        break;
                    }
                    case 14: {
                        int n13 = 14;
                        int n14 = typedArray.getBoolean(n3, false) ? -1 : 0;
                        nArray3[n13] = n14;
                        break;
                    }
                    case 15: {
                        int n13 = 15;
                        int n14 = typedArray.getBoolean(n3, false) ? -1 : 0;
                        nArray3[n13] = n14;
                        break;
                    }
                }
                ++n2;
            }
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
            int[] nArray = new int[16];
            this.mRules = nArray;
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
            int[] nArray = new int[16];
            this.mRules = nArray;
        }

        static /* synthetic */ int access$102(LayoutParams layoutParams, int n) {
            layoutParams.mRight = n;
            return n;
        }

        static /* synthetic */ int access$112(LayoutParams layoutParams, int n) {
            int n2;
            layoutParams.mRight = n2 = layoutParams.mRight + n;
            return n2;
        }

        static /* synthetic */ int access$202(LayoutParams layoutParams, int n) {
            layoutParams.mBottom = n;
            return n;
        }

        static /* synthetic */ int access$212(LayoutParams layoutParams, int n) {
            int n2;
            layoutParams.mBottom = n2 = layoutParams.mBottom + n;
            return n2;
        }

        static /* synthetic */ int access$302(LayoutParams layoutParams, int n) {
            layoutParams.mLeft = n;
            return n;
        }

        static /* synthetic */ int access$312(LayoutParams layoutParams, int n) {
            int n2;
            layoutParams.mLeft = n2 = layoutParams.mLeft + n;
            return n2;
        }

        static /* synthetic */ int access$402(LayoutParams layoutParams, int n) {
            layoutParams.mTop = n;
            return n;
        }

        static /* synthetic */ int access$412(LayoutParams layoutParams, int n) {
            int n2;
            layoutParams.mTop = n2 = layoutParams.mTop + n;
            return n2;
        }

        public void addRule(int n) {
            this.mRules[n] = -1;
        }

        public void addRule(int n, int n2) {
            this.mRules[n] = n2;
        }

        @Override
        public String debug(String string2) {
            StringBuilder stringBuilder = new StringBuilder().append(string2).append("ViewGroup.LayoutParams={ width=");
            String string3 = LayoutParams.sizeToString(this.width);
            StringBuilder stringBuilder2 = stringBuilder.append(string3).append(", height=");
            String string4 = LayoutParams.sizeToString(this.height);
            return stringBuilder2.append(string4).append(" }").toString();
        }

        public int[] getRules() {
            return this.mRules;
        }
    }

    private class TopToBottomLeftToRightComparator
    implements Comparator<View> {
        private TopToBottomLeftToRightComparator() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compare(View view, View view2) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5 = view.getTop();
            int n6 = n5 - (n4 = view2.getTop());
            if (n6 != 0) {
                return n6;
            }
            int n7 = view.getLeft();
            int n8 = n7 - (n3 = view2.getLeft());
            if (n8 != 0) {
                return n8;
            }
            int n9 = view.getHeight();
            int n10 = n9 - (n2 = view2.getHeight());
            if (n10 != 0) {
                return n10;
            }
            int n11 = view.getWidth();
            int n12 = n11 - (n = view2.getWidth());
            if (n12 == 0) return 0;
            return n12;
        }
    }
}

