/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class RemoteViews
implements Parcelable,
LayoutInflater.Filter {
    public static final Parcelable.Creator<RemoteViews> CREATOR = new Parcelable.Creator<RemoteViews>(){

        @Override
        public RemoteViews createFromParcel(Parcel parcel) {
            return new RemoteViews(parcel);
        }

        public RemoteViews[] newArray(int n) {
            return new RemoteViews[n];
        }
    };
    private static final String LOG_TAG = "RemoteViews";
    private ArrayList<Action> mActions;
    private int mLayoutId;
    private String mPackage;

    /*
     * Enabled aggressive block sorting
     */
    public RemoteViews(Parcel parcel) {
        int n;
        String string2;
        this.mPackage = string2 = parcel.readString();
        this.mLayoutId = n = parcel.readInt();
        int n2 = parcel.readInt();
        if (n2 <= 0) {
            return;
        }
        ArrayList arrayList = new ArrayList(n2);
        this.mActions = arrayList;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = parcel.readInt();
            switch (n4) {
                default: {
                    String string3 = "Tag " + n4 + " not found";
                    throw new ActionException(string3);
                }
                case 1: {
                    ArrayList<Action> arrayList2 = this.mActions;
                    SetOnClickPendingIntent setOnClickPendingIntent = new SetOnClickPendingIntent(parcel);
                    boolean bl = arrayList2.add(setOnClickPendingIntent);
                    break;
                }
                case 3: {
                    ArrayList<Action> arrayList3 = this.mActions;
                    SetDrawableParameters setDrawableParameters = new SetDrawableParameters(parcel);
                    boolean bl = arrayList3.add(setDrawableParameters);
                    break;
                }
                case 2: {
                    ArrayList<Action> arrayList4 = this.mActions;
                    ReflectionAction reflectionAction = new ReflectionAction(parcel);
                    boolean bl = arrayList4.add(reflectionAction);
                    break;
                }
                case 4: {
                    ArrayList<Action> arrayList5 = this.mActions;
                    ViewGroupAction viewGroupAction = new ViewGroupAction(parcel);
                    boolean bl = arrayList5.add(viewGroupAction);
                }
            }
            ++n3;
        }
        return;
    }

    public RemoteViews(String string2, int n) {
        this.mPackage = string2;
        this.mLayoutId = n;
    }

    private void addAction(Action action) {
        if (this.mActions == null) {
            ArrayList arrayList = new ArrayList();
            this.mActions = arrayList;
        }
        boolean bl = this.mActions.add(action);
    }

    private void performApply(View view) {
        if (this.mActions == null) {
            return;
        }
        int n = this.mActions.size();
        int n2 = 0;
        while (n2 < n) {
            this.mActions.get(n2).apply(view);
            ++n2;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Context prepareContext(Context context) {
        String string2 = this.mPackage;
        if (string2 == null) return context;
        int n = 4;
        try {
            Context context2 = context.createPackageContext(string2, n);
            return context2;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string3 = "Package name " + string2 + " not found";
            int n2 = Log.e(LOG_TAG, string3);
            return context;
        }
    }

    public void addView(int n, RemoteViews remoteViews) {
        ViewGroupAction viewGroupAction = new ViewGroupAction(n, remoteViews);
        this.addAction(viewGroupAction);
    }

    public View apply(Context context, ViewGroup viewGroup) {
        Context context2 = this.prepareContext(context);
        LayoutInflater layoutInflater = ((LayoutInflater)context2.getSystemService("layout_inflater")).cloneInContext(context2);
        layoutInflater.setFilter(this);
        int n = this.mLayoutId;
        View view = layoutInflater.inflate(n, viewGroup, false);
        this.performApply(view);
        return view;
    }

    public RemoteViews clone() {
        String string2 = this.mPackage;
        int n = this.mLayoutId;
        RemoteViews remoteViews = new RemoteViews(string2, n);
        if (this.mActions != null) {
            ArrayList arrayList;
            remoteViews.mActions = arrayList = (ArrayList)this.mActions.clone();
        }
        return remoteViews;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getLayoutId() {
        return this.mLayoutId;
    }

    public String getPackage() {
        return this.mPackage;
    }

    @Override
    public boolean onLoadClass(Class clazz) {
        return clazz.isAnnotationPresent(RemoteView.class);
    }

    public void reapply(Context context, View view) {
        Context context2 = this.prepareContext(context);
        this.performApply(view);
    }

    public void removeAllViews(int n) {
        ViewGroupAction viewGroupAction = new ViewGroupAction(n, null);
        this.addAction(viewGroupAction);
    }

    public void setBitmap(int n, String string2, Bitmap bitmap) {
        RemoteViews remoteViews = this;
        int n2 = n;
        String string3 = string2;
        Bitmap bitmap2 = bitmap;
        ReflectionAction reflectionAction = remoteViews.new ReflectionAction(n2, string3, 12, bitmap2);
        this.addAction(reflectionAction);
    }

    public void setBoolean(int n, String string2, boolean bl) {
        Boolean bl2 = bl;
        RemoteViews remoteViews = this;
        int n2 = n;
        String string3 = string2;
        ReflectionAction reflectionAction = remoteViews.new ReflectionAction(n2, string3, 1, bl2);
        this.addAction(reflectionAction);
    }

    public void setBundle(int n, String string2, Bundle bundle) {
        RemoteViews remoteViews = this;
        int n2 = n;
        String string3 = string2;
        Bundle bundle2 = bundle;
        ReflectionAction reflectionAction = remoteViews.new ReflectionAction(n2, string3, 13, bundle2);
        this.addAction(reflectionAction);
    }

    public void setByte(int n, String string2, byte by) {
        Byte by2 = by;
        RemoteViews remoteViews = this;
        int n2 = n;
        String string3 = string2;
        ReflectionAction reflectionAction = remoteViews.new ReflectionAction(n2, string3, 2, by2);
        this.addAction(reflectionAction);
    }

    public void setChar(int n, String string2, char c) {
        Character c2 = Character.valueOf(c);
        RemoteViews remoteViews = this;
        int n2 = n;
        String string3 = string2;
        ReflectionAction reflectionAction = remoteViews.new ReflectionAction(n2, string3, 8, c2);
        this.addAction(reflectionAction);
    }

    public void setCharSequence(int n, String string2, CharSequence charSequence) {
        RemoteViews remoteViews = this;
        int n2 = n;
        String string3 = string2;
        CharSequence charSequence2 = charSequence;
        ReflectionAction reflectionAction = remoteViews.new ReflectionAction(n2, string3, 10, charSequence2);
        this.addAction(reflectionAction);
    }

    public void setChronometer(int n, long l, String string2, boolean bl) {
        this.setLong(n, "setBase", l);
        this.setString(n, "setFormat", string2);
        this.setBoolean(n, "setStarted", bl);
    }

    public void setDouble(int n, String string2, double d) {
        Double d2 = d;
        RemoteViews remoteViews = this;
        int n2 = n;
        String string3 = string2;
        ReflectionAction reflectionAction = remoteViews.new ReflectionAction(n2, string3, 7, d2);
        this.addAction(reflectionAction);
    }

    public void setDrawableParameters(int n, boolean bl, int n2, int n3, PorterDuff.Mode mode, int n4) {
        RemoteViews remoteViews = this;
        int n5 = n;
        boolean bl2 = bl;
        int n6 = n2;
        int n7 = n3;
        PorterDuff.Mode mode2 = mode;
        int n8 = n4;
        SetDrawableParameters setDrawableParameters = remoteViews.new SetDrawableParameters(n5, bl2, n6, n7, mode2, n8);
        this.addAction(setDrawableParameters);
    }

    public void setFloat(int n, String string2, float f) {
        Float f2 = Float.valueOf(f);
        RemoteViews remoteViews = this;
        int n2 = n;
        String string3 = string2;
        ReflectionAction reflectionAction = remoteViews.new ReflectionAction(n2, string3, 6, f2);
        this.addAction(reflectionAction);
    }

    public void setImageViewBitmap(int n, Bitmap bitmap) {
        this.setBitmap(n, "setImageBitmap", bitmap);
    }

    public void setImageViewResource(int n, int n2) {
        this.setInt(n, "setImageResource", n2);
    }

    public void setImageViewUri(int n, Uri uri) {
        this.setUri(n, "setImageURI", uri);
    }

    public void setInt(int n, String string2, int n2) {
        Integer n3 = n2;
        RemoteViews remoteViews = this;
        int n4 = n;
        String string3 = string2;
        ReflectionAction reflectionAction = remoteViews.new ReflectionAction(n4, string3, 4, n3);
        this.addAction(reflectionAction);
    }

    public void setLong(int n, String string2, long l) {
        Long l2 = l;
        RemoteViews remoteViews = this;
        int n2 = n;
        String string3 = string2;
        ReflectionAction reflectionAction = remoteViews.new ReflectionAction(n2, string3, 5, l2);
        this.addAction(reflectionAction);
    }

    public void setOnClickPendingIntent(int n, PendingIntent pendingIntent) {
        SetOnClickPendingIntent setOnClickPendingIntent = new SetOnClickPendingIntent(n, pendingIntent);
        this.addAction(setOnClickPendingIntent);
    }

    public void setProgressBar(int n, int n2, int n3, boolean bl) {
        this.setBoolean(n, "setIndeterminate", bl);
        if (bl) {
            return;
        }
        this.setInt(n, "setMax", n2);
        this.setInt(n, "setProgress", n3);
    }

    public void setShort(int n, String string2, short s) {
        Short s2 = s;
        RemoteViews remoteViews = this;
        int n2 = n;
        String string3 = string2;
        ReflectionAction reflectionAction = remoteViews.new ReflectionAction(n2, string3, 3, s2);
        this.addAction(reflectionAction);
    }

    public void setString(int n, String string2, String string3) {
        RemoteViews remoteViews = this;
        int n2 = n;
        String string4 = string2;
        String string5 = string3;
        ReflectionAction reflectionAction = remoteViews.new ReflectionAction(n2, string4, 9, string5);
        this.addAction(reflectionAction);
    }

    public void setTextColor(int n, int n2) {
        this.setInt(n, "setTextColor", n2);
    }

    public void setTextViewText(int n, CharSequence charSequence) {
        this.setCharSequence(n, "setText", charSequence);
    }

    public void setUri(int n, String string2, Uri uri) {
        RemoteViews remoteViews = this;
        int n2 = n;
        String string3 = string2;
        Uri uri2 = uri;
        ReflectionAction reflectionAction = remoteViews.new ReflectionAction(n2, string3, 11, uri2);
        this.addAction(reflectionAction);
    }

    public void setViewVisibility(int n, int n2) {
        this.setInt(n, "setVisibility", n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        String string2 = this.mPackage;
        parcel.writeString(string2);
        int n2 = this.mLayoutId;
        parcel.writeInt(n2);
        int n3 = this.mActions != null ? this.mActions.size() : 0;
        parcel.writeInt(n3);
        int n4 = 0;
        while (n4 < n3) {
            this.mActions.get(n4).writeToParcel(parcel, 0);
            ++n4;
        }
        return;
    }

    private class ViewGroupAction
    extends Action {
        public static final int TAG = 4;
        RemoteViews nestedViews;
        int viewId;

        public ViewGroupAction(int n, RemoteViews remoteViews2) {
            this.viewId = n;
            this.nestedViews = remoteViews2;
        }

        public ViewGroupAction(Parcel parcel) {
            RemoteViews remoteViews2;
            int n;
            this.viewId = n = parcel.readInt();
            this.nestedViews = remoteViews2 = (RemoteViews)parcel.readParcelable(null);
        }

        @Override
        public void apply(View view) {
            Context context = view.getContext();
            int n = this.viewId;
            ViewGroup viewGroup = (ViewGroup)view.findViewById(n);
            if (this.nestedViews != null) {
                View view2 = this.nestedViews.apply(context, viewGroup);
                viewGroup.addView(view2);
                return;
            }
            if (viewGroup == null) {
                return;
            }
            viewGroup.removeAllViews();
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(4);
            int n2 = this.viewId;
            parcel.writeInt(n2);
            RemoteViews remoteViews = this.nestedViews;
            parcel.writeParcelable(remoteViews, 0);
        }
    }

    private class ReflectionAction
    extends Action {
        static final int BITMAP = 12;
        static final int BOOLEAN = 1;
        static final int BUNDLE = 13;
        static final int BYTE = 2;
        static final int CHAR = 8;
        static final int CHAR_SEQUENCE = 10;
        static final int DOUBLE = 7;
        static final int FLOAT = 6;
        static final int INT = 4;
        static final int LONG = 5;
        static final int SHORT = 3;
        static final int STRING = 9;
        static final int TAG = 2;
        static final int URI = 11;
        String methodName;
        int type;
        Object value;
        int viewId;

        ReflectionAction(int n, String string2, int n2, Object object) {
            this.viewId = n;
            this.methodName = string2;
            this.type = n2;
            this.value = object;
        }

        /*
         * Enabled aggressive block sorting
         */
        ReflectionAction(Parcel parcel) {
            int n;
            String string2;
            int n2;
            this.viewId = n2 = parcel.readInt();
            this.methodName = string2 = parcel.readString();
            this.type = n = parcel.readInt();
            switch (this.type) {
                default: {
                    return;
                }
                case 1: {
                    boolean bl = parcel.readInt() != 0;
                    Boolean bl2 = bl;
                    this.value = bl2;
                    return;
                }
                case 2: {
                    Byte by = parcel.readByte();
                    this.value = by;
                    return;
                }
                case 3: {
                    Short s = (short)parcel.readInt();
                    this.value = s;
                    return;
                }
                case 4: {
                    Integer n3 = parcel.readInt();
                    this.value = n3;
                    return;
                }
                case 5: {
                    Long l = parcel.readLong();
                    this.value = l;
                    return;
                }
                case 6: {
                    Float f = Float.valueOf(parcel.readFloat());
                    this.value = f;
                    return;
                }
                case 7: {
                    Double d = parcel.readDouble();
                    this.value = d;
                    return;
                }
                case 8: {
                    Character c = Character.valueOf((char)parcel.readInt());
                    this.value = c;
                    return;
                }
                case 9: {
                    String string3 = parcel.readString();
                    this.value = string3;
                    return;
                }
                case 10: {
                    CharSequence charSequence = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
                    this.value = charSequence;
                    return;
                }
                case 11: {
                    Uri uri = Uri.CREATOR.createFromParcel(parcel);
                    this.value = uri;
                    return;
                }
                case 12: {
                    Bitmap bitmap = Bitmap.CREATOR.createFromParcel(parcel);
                    this.value = bitmap;
                    return;
                }
                case 13: 
            }
            Bundle bundle = parcel.readBundle();
            this.value = bundle;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Class getParameterType() {
            void var1_2;
            switch (this.type) {
                default: {
                    return var1_2;
                }
                case 1: {
                    Class<Boolean> clazz = Boolean.TYPE;
                    return var1_2;
                }
                case 2: {
                    Class<Byte> clazz = Byte.TYPE;
                    return var1_2;
                }
                case 3: {
                    Class<Short> clazz = Short.TYPE;
                    return var1_2;
                }
                case 4: {
                    Class<Integer> clazz = Integer.TYPE;
                    return var1_2;
                }
                case 5: {
                    Class<Long> clazz = Long.TYPE;
                    return var1_2;
                }
                case 6: {
                    Class<Float> clazz = Float.TYPE;
                    return var1_2;
                }
                case 7: {
                    Class<Double> clazz = Double.TYPE;
                    return var1_2;
                }
                case 8: {
                    Class<Character> clazz = Character.TYPE;
                    return var1_2;
                }
                case 9: {
                    return var1_2;
                }
                case 10: {
                    return var1_2;
                }
                case 11: {
                    return var1_2;
                }
                case 12: {
                    return var1_2;
                }
                case 13: 
            }
            return var1_2;
        }

        @Override
        public void apply(View view) {
            Method method;
            int n = this.viewId;
            View view2 = view.findViewById(n);
            if (view2 == null) {
                StringBuilder stringBuilder = new StringBuilder().append("can't find view: 0x");
                String string2 = Integer.toHexString(this.viewId);
                String string3 = stringBuilder.append(string2).toString();
                throw new ActionException(string3);
            }
            Class clazz = this.getParameterType();
            if (clazz == null) {
                StringBuilder stringBuilder = new StringBuilder().append("bad type: ");
                int n2 = this.type;
                String string4 = stringBuilder.append(n2).toString();
                throw new ActionException(string4);
            }
            Class<? extends Object> clazz2 = view2.getClass();
            try {
                Method method2;
                String string5 = this.methodName;
                Class clazz3 = this.getParameterType();
                Class[] classArray = new Class[]{clazz3};
                method = method2 = clazz2.getMethod(string5, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                StringBuilder stringBuilder = new StringBuilder().append("view: ");
                String string6 = clazz2.getName();
                StringBuilder stringBuilder2 = stringBuilder.append(string6).append(" doesn't have method: ");
                String string7 = this.methodName;
                StringBuilder stringBuilder3 = stringBuilder2.append(string7).append("(");
                String string8 = clazz.getName();
                String string9 = stringBuilder3.append(string8).append(")").toString();
                throw new ActionException(string9);
            }
            if (!method.isAnnotationPresent(RemotableViewMethod.class)) {
                StringBuilder stringBuilder = new StringBuilder().append("view: ");
                String string10 = clazz2.getName();
                StringBuilder stringBuilder4 = stringBuilder.append(string10).append(" can't use method with RemoteViews: ");
                String string11 = this.methodName;
                StringBuilder stringBuilder5 = stringBuilder4.append(string11).append("(");
                String string12 = clazz.getName();
                String string13 = stringBuilder5.append(string12).append(")").toString();
                throw new ActionException(string13);
            }
            int n3 = 1;
            try {
                Object object;
                Object[] objectArray = new Object[n3];
                objectArray[0] = object = this.value;
                Object object2 = method.invoke(view2, objectArray);
                return;
            }
            catch (Exception exception) {
                throw new ActionException(exception);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(2);
            int n2 = this.viewId;
            parcel.writeInt(n2);
            String string2 = this.methodName;
            parcel.writeString(string2);
            int n3 = this.type;
            parcel.writeInt(n3);
            switch (this.type) {
                default: {
                    return;
                }
                case 1: {
                    int n4 = (Boolean)this.value != false ? 1 : 0;
                    parcel.writeInt(n4);
                    return;
                }
                case 2: {
                    byte by = (Byte)this.value;
                    parcel.writeByte(by);
                    return;
                }
                case 3: {
                    short s = (Short)this.value;
                    parcel.writeInt(s);
                    return;
                }
                case 4: {
                    int n5 = (Integer)this.value;
                    parcel.writeInt(n5);
                    return;
                }
                case 5: {
                    long l = (Long)this.value;
                    parcel.writeLong(l);
                    return;
                }
                case 6: {
                    float f = ((Float)this.value).floatValue();
                    parcel.writeFloat(f);
                    return;
                }
                case 7: {
                    double d = (Double)this.value;
                    parcel.writeDouble(d);
                    return;
                }
                case 8: {
                    char c = ((Character)this.value).charValue();
                    parcel.writeInt(c);
                    return;
                }
                case 9: {
                    String string3 = (String)this.value;
                    parcel.writeString(string3);
                    return;
                }
                case 10: {
                    TextUtils.writeToParcel((CharSequence)this.value, parcel, n);
                    return;
                }
                case 11: {
                    ((Uri)this.value).writeToParcel(parcel, n);
                    return;
                }
                case 12: {
                    ((Bitmap)this.value).writeToParcel(parcel, n);
                    return;
                }
                case 13: 
            }
            Bundle bundle = (Bundle)this.value;
            parcel.writeBundle(bundle);
        }
    }

    private class SetDrawableParameters
    extends Action {
        public static final int TAG = 3;
        int alpha;
        int colorFilter;
        PorterDuff.Mode filterMode;
        int level;
        boolean targetBackground;
        int viewId;

        public SetDrawableParameters(int n, boolean bl, int n2, int n3, PorterDuff.Mode mode, int n4) {
            this.viewId = n;
            this.targetBackground = bl;
            this.alpha = n2;
            this.colorFilter = n3;
            this.filterMode = mode;
            this.level = n4;
        }

        /*
         * Enabled aggressive block sorting
         */
        public SetDrawableParameters(Parcel parcel) {
            int n;
            PorterDuff.Mode mode;
            int n2;
            int n3;
            int n4;
            this.viewId = n4 = parcel.readInt();
            boolean bl = parcel.readInt() != 0;
            this.targetBackground = bl;
            this.alpha = n3 = parcel.readInt();
            this.colorFilter = n2 = parcel.readInt();
            boolean bl2 = parcel.readInt() != 0;
            this.filterMode = bl2 ? (mode = PorterDuff.Mode.valueOf(parcel.readString())) : null;
            this.level = n = parcel.readInt();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void apply(View view) {
            int n = this.viewId;
            View view2 = view.findViewById(n);
            if (view2 == null) {
                return;
            }
            Drawable drawable2 = null;
            if (this.targetBackground) {
                drawable2 = view2.getBackground();
            } else if (view2 instanceof ImageView) {
                drawable2 = ((ImageView)view2).getDrawable();
            }
            if (drawable2 == null) {
                return;
            }
            if (this.alpha != -1) {
                int n2 = this.alpha;
                drawable2.setAlpha(n2);
            }
            if (this.colorFilter != -1 && this.filterMode != null) {
                int n3 = this.colorFilter;
                PorterDuff.Mode mode = this.filterMode;
                drawable2.setColorFilter(n3, mode);
            }
            if (this.level == -1) {
                return;
            }
            int n4 = this.level;
            boolean bl = drawable2.setLevel(n4);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(3);
            int n2 = this.viewId;
            parcel.writeInt(n2);
            int n3 = this.targetBackground ? 1 : 0;
            parcel.writeInt(n3);
            int n4 = this.alpha;
            parcel.writeInt(n4);
            int n5 = this.colorFilter;
            parcel.writeInt(n5);
            if (this.filterMode != null) {
                parcel.writeInt(1);
                String string2 = this.filterMode.toString();
                parcel.writeString(string2);
            } else {
                parcel.writeInt(0);
            }
            int n6 = this.level;
            parcel.writeInt(n6);
        }
    }

    private class SetOnClickPendingIntent
    extends Action {
        public static final int TAG = 1;
        PendingIntent pendingIntent;
        int viewId;

        public SetOnClickPendingIntent(int n, PendingIntent pendingIntent) {
            this.viewId = n;
            this.pendingIntent = pendingIntent;
        }

        public SetOnClickPendingIntent(Parcel parcel) {
            PendingIntent pendingIntent;
            int n;
            this.viewId = n = parcel.readInt();
            this.pendingIntent = pendingIntent = PendingIntent.readPendingIntentOrNullFromParcel(parcel);
        }

        @Override
        public void apply(View view) {
            int n = this.viewId;
            View view2 = view.findViewById(n);
            if (view2 == null) {
                return;
            }
            if (this.pendingIntent == null) {
                return;
            }
            View.OnClickListener onClickListener = new View.OnClickListener(){

                @Override
                public void onClick(View view) {
                    int n;
                    int n2;
                    int n3;
                    int n4;
                    float f = view.getContext().getResources().getCompatibilityInfo().applicationScale;
                    int[] nArray = new int[2];
                    view.getLocationOnScreen(nArray);
                    Rect rect = new Rect();
                    rect.left = n4 = (int)((float)nArray[0] * f + 0.5f);
                    rect.top = n3 = (int)((float)nArray[1] * f + 0.5f);
                    int n5 = nArray[0];
                    int n6 = view.getWidth();
                    rect.right = n2 = (int)((float)(n5 + n6) * f + 0.5f);
                    int n7 = nArray[1];
                    int n8 = view.getHeight();
                    rect.bottom = n = (int)((float)(n7 + n8) * f + 0.5f);
                    Intent intent = new Intent();
                    intent.setSourceBounds(rect);
                    try {
                        Context context = view.getContext();
                        IntentSender intentSender = SetOnClickPendingIntent.this.pendingIntent.getIntentSender();
                        context.startIntentSender(intentSender, intent, 0x10000000, 0x10000000, 0);
                        return;
                    }
                    catch (IntentSender.SendIntentException sendIntentException) {
                        int n9 = Log.e(RemoteViews.LOG_TAG, "Cannot send pending intent: ", sendIntentException);
                        return;
                    }
                }
            };
            view2.setOnClickListener(onClickListener);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(1);
            int n2 = this.viewId;
            parcel.writeInt(n2);
            this.pendingIntent.writeToParcel(parcel, 0);
        }
    }

    private static abstract class Action
    implements Parcelable {
        private Action() {
        }

        public abstract void apply(View var1) throws ActionException;

        @Override
        public int describeContents() {
            return 0;
        }
    }

    public static class ActionException
    extends RuntimeException {
        public ActionException(Exception exception) {
            super(exception);
        }

        public ActionException(String string2) {
            super(string2);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface RemoteView {
    }
}

