/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.database.Cursor;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CursorAdapter;

public abstract class ResourceCursorAdapter
extends CursorAdapter {
    private int mDropDownLayout;
    private LayoutInflater mInflater;
    private int mLayout;

    public ResourceCursorAdapter(Context context, int n, Cursor cursor) {
        super(context, cursor);
        LayoutInflater layoutInflater;
        this.mDropDownLayout = n;
        this.mLayout = n;
        this.mInflater = layoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
    }

    public ResourceCursorAdapter(Context context, int n, Cursor cursor, boolean bl) {
        super(context, cursor, bl);
        LayoutInflater layoutInflater;
        this.mDropDownLayout = n;
        this.mLayout = n;
        this.mInflater = layoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
    }

    @Override
    public View newDropDownView(Context context, Cursor cursor, ViewGroup viewGroup) {
        LayoutInflater layoutInflater = this.mInflater;
        int n = this.mDropDownLayout;
        return layoutInflater.inflate(n, viewGroup, false);
    }

    @Override
    public View newView(Context context, Cursor cursor, ViewGroup viewGroup) {
        LayoutInflater layoutInflater = this.mInflater;
        int n = this.mLayout;
        return layoutInflater.inflate(n, viewGroup, false);
    }

    public void setDropDownViewResource(int n) {
        this.mDropDownLayout = n;
    }

    public void setViewResource(int n) {
        this.mLayout = n;
    }
}

