/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;

public class ScrollBarDrawable
extends Drawable {
    private boolean mAlwaysDrawHorizontalTrack;
    private boolean mAlwaysDrawVerticalTrack;
    private boolean mChanged;
    private int mExtent;
    private Drawable mHorizontalThumb;
    private Drawable mHorizontalTrack;
    private int mOffset;
    private int mRange;
    private boolean mRangeChanged;
    private final Rect mTempBounds;
    private boolean mVertical;
    private Drawable mVerticalThumb;
    private Drawable mVerticalTrack;

    public ScrollBarDrawable() {
        Rect rect;
        this.mTempBounds = rect = new Rect();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void draw(Canvas canvas) {
        int n;
        int n2;
        boolean bl = this.mVertical;
        int n3 = this.mExtent;
        int n4 = this.mRange;
        boolean bl2 = true;
        boolean bl3 = true;
        if (n3 <= 0 || n4 <= n3) {
            bl2 = bl ? this.mAlwaysDrawVerticalTrack : this.mAlwaysDrawHorizontalTrack;
            bl3 = false;
        }
        Rect rect = this.getBounds();
        float f = rect.left;
        float f2 = rect.top;
        float f3 = rect.right;
        float f4 = rect.bottom;
        Canvas.EdgeType edgeType = Canvas.EdgeType.AA;
        if (canvas.quickReject(f, f2, f3, f4, edgeType)) {
            return;
        }
        if (bl2) {
            ScrollBarDrawable scrollBarDrawable = this;
            Canvas canvas2 = canvas;
            Rect rect2 = rect;
            boolean bl4 = bl;
            scrollBarDrawable.drawTrack(canvas2, rect2, bl4);
        }
        if (!bl3) {
            return;
        }
        int n5 = bl ? rect.height() : rect.width();
        int n6 = bl ? rect.width() : rect.height();
        float f5 = n5;
        float f6 = n3;
        float f7 = f5 * f6;
        float f8 = n4;
        int n7 = Math.round(f7 / f8);
        float f9 = n5 - n7;
        float f10 = this.mOffset;
        float f11 = f9 * f10;
        float f12 = n4 - n3;
        int n8 = Math.round(f11 / f12);
        int n9 = n6 * 2;
        if (n7 < n9) {
            int n10 = n9;
        }
        if ((n2 = n8 + n7) > (n = n5)) {
            int n11 = n5 - n7;
        }
        ScrollBarDrawable scrollBarDrawable = this;
        Canvas canvas3 = canvas;
        Rect rect3 = rect;
        boolean bl5 = bl;
        scrollBarDrawable.drawThumb(canvas3, rect3, n8, n7, bl5);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void drawThumb(Canvas canvas, Rect rect, int n, int n2, boolean bl) {
        Rect rect2 = this.mTempBounds;
        boolean bl2 = this.mRangeChanged || this.mChanged;
        if (bl2) {
            if (bl) {
                int n3 = rect.left;
                int n4 = rect.top + n;
                int n5 = rect.right;
                int n6 = rect.top + n + n2;
                rect2.set(n3, n4, n5, n6);
            } else {
                int n7 = rect.left + n;
                int n8 = rect.top;
                int n9 = rect.left + n + n2;
                int n10 = rect.bottom;
                rect2.set(n7, n8, n9, n10);
            }
        }
        if (bl) {
            Drawable drawable2 = this.mVerticalThumb;
            if (bl2) {
                drawable2.setBounds(rect2);
            }
            drawable2.draw(canvas);
            return;
        }
        Drawable drawable3 = this.mHorizontalThumb;
        if (bl2) {
            drawable3.setBounds(rect2);
        }
        drawable3.draw(canvas);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void drawTrack(Canvas canvas, Rect rect, boolean bl) {
        Drawable drawable2 = bl ? this.mVerticalTrack : this.mHorizontalTrack;
        if (drawable2 == null) {
            return;
        }
        if (this.mChanged) {
            drawable2.setBounds(rect);
        }
        drawable2.draw(canvas);
    }

    public boolean getAlwaysDrawHorizontalTrack() {
        return this.mAlwaysDrawHorizontalTrack;
    }

    public boolean getAlwaysDrawVerticalTrack() {
        return this.mAlwaysDrawVerticalTrack;
    }

    @Override
    public int getOpacity() {
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getSize(boolean bl) {
        Drawable drawable2;
        if (bl) {
            Drawable drawable3;
            if (this.mVerticalTrack != null) {
                drawable3 = this.mVerticalTrack;
                return drawable3.getIntrinsicWidth();
            }
            drawable3 = this.mVerticalThumb;
            return drawable3.getIntrinsicWidth();
        }
        if (this.mHorizontalTrack != null) {
            drawable2 = this.mHorizontalTrack;
            return drawable2.getIntrinsicHeight();
        }
        drawable2 = this.mHorizontalThumb;
        return drawable2.getIntrinsicHeight();
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        super.onBoundsChange(rect);
        this.mChanged = true;
    }

    @Override
    public void setAlpha(int n) {
        if (this.mVerticalTrack != null) {
            this.mVerticalTrack.setAlpha(n);
        }
        this.mVerticalThumb.setAlpha(n);
        if (this.mHorizontalTrack != null) {
            this.mHorizontalTrack.setAlpha(n);
        }
        this.mHorizontalThumb.setAlpha(n);
    }

    public void setAlwaysDrawHorizontalTrack(boolean bl) {
        this.mAlwaysDrawHorizontalTrack = bl;
    }

    public void setAlwaysDrawVerticalTrack(boolean bl) {
        this.mAlwaysDrawVerticalTrack = bl;
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        if (this.mVerticalTrack != null) {
            this.mVerticalTrack.setColorFilter(colorFilter);
        }
        this.mVerticalThumb.setColorFilter(colorFilter);
        if (this.mHorizontalTrack != null) {
            this.mHorizontalTrack.setColorFilter(colorFilter);
        }
        this.mHorizontalThumb.setColorFilter(colorFilter);
    }

    public void setHorizontalThumbDrawable(Drawable drawable2) {
        if (drawable2 == null) {
            return;
        }
        this.mHorizontalThumb = drawable2;
    }

    public void setHorizontalTrackDrawable(Drawable drawable2) {
        this.mHorizontalTrack = drawable2;
    }

    public void setParameters(int n, int n2, int n3, boolean bl) {
        if (this.mVertical != bl) {
            this.mChanged = true;
        }
        if (this.mRange == n || this.mOffset == n2 || this.mExtent != n3) {
            this.mRangeChanged = true;
        }
        this.mRange = n;
        this.mOffset = n2;
        this.mExtent = n3;
        this.mVertical = bl;
    }

    public void setVerticalThumbDrawable(Drawable drawable2) {
        if (drawable2 == null) {
            return;
        }
        this.mVerticalThumb = drawable2;
    }

    public void setVerticalTrackDrawable(Drawable drawable2) {
        this.mVerticalTrack = drawable2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        String string2;
        StringBuilder stringBuilder = new StringBuilder().append("ScrollBarDrawable: range=");
        int n = this.mRange;
        StringBuilder stringBuilder2 = stringBuilder.append(n).append(" offset=");
        int n2 = this.mOffset;
        StringBuilder stringBuilder3 = stringBuilder2.append(n2).append(" extent=");
        int n3 = this.mExtent;
        StringBuilder stringBuilder4 = stringBuilder3.append(n3);
        if (this.mVertical) {
            string2 = " V";
            return stringBuilder4.append(string2).toString();
        }
        string2 = " H";
        return stringBuilder4.append(string2).toString();
    }
}

