/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.view.ViewConfiguration;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;

public class Scroller {
    private static final int DEFAULT_DURATION = 250;
    private static final int FLING_MODE = 1;
    private static final int SCROLL_MODE;
    private static float sViscousFluidNormalize;
    private static float sViscousFluidScale;
    private float mCoeffX = 0.0f;
    private float mCoeffY = 1.0f;
    private int mCurrX;
    private int mCurrY;
    private final float mDeceleration;
    private float mDeltaX;
    private float mDeltaY;
    private int mDuration;
    private float mDurationReciprocal;
    private int mFinalX;
    private int mFinalY;
    private boolean mFinished = true;
    private Interpolator mInterpolator;
    private int mMaxX;
    private int mMaxY;
    private int mMinX;
    private int mMinY;
    private int mMode;
    private long mStartTime;
    private int mStartX;
    private int mStartY;
    private float mVelocity;

    static {
        sViscousFluidScale = 8.0f;
        sViscousFluidNormalize = 1.0f;
        float f = Scroller.viscousFluid(1.0f);
        sViscousFluidNormalize = 1.0f / f;
    }

    public Scroller(Context context) {
        this(context, null);
    }

    public Scroller(Context context, Interpolator interpolator) {
        float f;
        this.mInterpolator = interpolator;
        float f2 = context.getResources().getDisplayMetrics().density * 160.0f;
        float f3 = 386.0878f * f2;
        float f4 = ViewConfiguration.getScrollFriction();
        this.mDeceleration = f = f3 * f4;
    }

    /*
     * Enabled aggressive block sorting
     */
    static float viscousFluid(float f) {
        float f2;
        float f3 = sViscousFluidScale;
        float f4 = f * f3;
        if (f4 < 1.0f) {
            float f5 = (float)Math.exp(-f4);
            float f6 = 1.0f - f5;
            f2 = f4 - f6;
        } else {
            float f7 = (float)Math.exp(1.0f - f4);
            float f8 = 1.0f - f7;
            float f9 = (1.0f - 0.36787945f) * f8;
            f2 = 0.36787945f + f9;
        }
        float f10 = sViscousFluidNormalize;
        return f2 * f10;
    }

    public void abortAnimation() {
        int n;
        int n2;
        this.mCurrX = n2 = this.mFinalX;
        this.mCurrY = n = this.mFinalY;
        this.mFinished = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean computeScrollOffset() {
        int n;
        long l;
        if (this.mFinished) {
            return false;
        }
        long l2 = AnimationUtils.currentAnimationTimeMillis();
        int n2 = (int)(l2 - (l = this.mStartTime));
        if (n2 < (n = this.mDuration)) {
            switch (this.mMode) {
                case 0: {
                    int n3;
                    int n4;
                    float f = n2;
                    float f2 = this.mDurationReciprocal;
                    float f3 = f * f2;
                    float f4 = this.mInterpolator == null ? Scroller.viscousFluid(f3) : this.mInterpolator.getInterpolation(f3);
                    int n5 = this.mStartX;
                    int n6 = Math.round(this.mDeltaX * f4);
                    this.mCurrX = n4 = n5 + n6;
                    int n7 = this.mStartY;
                    int n8 = Math.round(this.mDeltaY * f4);
                    this.mCurrY = n3 = n7 + n8;
                }
                default: {
                    return true;
                }
                case 1: {
                    int n9;
                    int n10;
                    int n11;
                    int n12;
                    int n13;
                    int n14;
                    float f = (float)n2 / 1000.0f;
                    float f5 = this.mVelocity * f;
                    float f6 = this.mDeceleration * f * f / 2.0f;
                    float f7 = f5 - f6;
                    int n15 = this.mStartX;
                    int n16 = Math.round(this.mCoeffX * f7);
                    int n17 = this.mCurrX = (n14 = n15 + n16);
                    int n18 = this.mMaxX;
                    int n19 = this.mCurrX = (n13 = Math.min(n17, n18));
                    int n20 = this.mMinX;
                    this.mCurrX = n12 = Math.max(n19, n20);
                    int n21 = this.mStartY;
                    int n22 = Math.round(this.mCoeffY * f7);
                    int n23 = this.mCurrY = (n11 = n21 + n22);
                    int n24 = this.mMaxY;
                    int n25 = this.mCurrY = (n10 = Math.min(n23, n24));
                    int n26 = this.mMinY;
                    this.mCurrY = n9 = Math.max(n25, n26);
                    int n27 = this.mCurrX;
                    int n28 = this.mFinalX;
                    if (n27 == n28) return true;
                    int n29 = this.mCurrY;
                    int n30 = this.mFinalY;
                    if (n29 == n30) return true;
                    this.mFinished = true;
                    return true;
                }
            }
        } else {
            int n31;
            int n32;
            this.mCurrX = n32 = this.mFinalX;
            this.mCurrY = n31 = this.mFinalY;
            this.mFinished = true;
        }
        return true;
    }

    public void extendDuration(int n) {
        float f;
        int n2;
        this.mDuration = n2 = this.timePassed() + n;
        float f2 = this.mDuration;
        this.mDurationReciprocal = f = 1.0f / f2;
        this.mFinished = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void fling(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        long l;
        int n15;
        float f;
        this.mMode = 1;
        this.mFinished = false;
        double d = n3;
        double d2 = n4;
        this.mVelocity = f = (float)Math.hypot(d, d2);
        float f2 = 1000.0f * f;
        float f3 = this.mDeceleration;
        this.mDuration = n15 = (int)(f2 / f3);
        this.mStartTime = l = AnimationUtils.currentAnimationTimeMillis();
        this.mStartX = n;
        this.mStartY = n2;
        float f4 = f == 0.0f ? 1.0f : (float)n3 / f;
        this.mCoeffX = f4;
        float f5 = f == 0.0f ? 1.0f : (float)n4 / f;
        this.mCoeffY = f5;
        float f6 = f * f;
        float f7 = this.mDeceleration;
        float f8 = 2.0f * f7;
        int n16 = (int)(f6 / f8);
        this.mMinX = n5;
        this.mMaxX = n6;
        this.mMinY = n7;
        this.mMaxY = n8;
        float f9 = n16;
        float f10 = this.mCoeffX;
        int n17 = this.mFinalX = (n14 = Math.round(f9 * f10) + n);
        int n18 = this.mMaxX;
        int n19 = this.mFinalX = (n13 = Math.min(n17, n18));
        int n20 = this.mMinX;
        this.mFinalX = n12 = Math.max(n19, n20);
        float f11 = n16;
        float f12 = this.mCoeffY;
        int n21 = this.mFinalY = (n11 = Math.round(f11 * f12) + n2);
        int n22 = this.mMaxY;
        int n23 = this.mFinalY = (n10 = Math.min(n21, n22));
        int n24 = this.mMinY;
        this.mFinalY = n9 = Math.max(n23, n24);
    }

    public final void forceFinished(boolean bl) {
        this.mFinished = bl;
    }

    public float getCurrVelocity() {
        float f = this.mVelocity;
        float f2 = this.mDeceleration;
        float f3 = this.timePassed();
        float f4 = f2 * f3 / 2000.0f;
        return f - f4;
    }

    public final int getCurrX() {
        return this.mCurrX;
    }

    public final int getCurrY() {
        return this.mCurrY;
    }

    public final int getDuration() {
        return this.mDuration;
    }

    public final int getFinalX() {
        return this.mFinalX;
    }

    public final int getFinalY() {
        return this.mFinalY;
    }

    public final int getStartX() {
        return this.mStartX;
    }

    public final int getStartY() {
        return this.mStartY;
    }

    public final boolean isFinished() {
        return this.mFinished;
    }

    public void setFinalX(int n) {
        float f;
        int n2 = this.mFinalX = n;
        int n3 = this.mStartX;
        this.mDeltaX = f = (float)(n2 - n3);
        this.mFinished = false;
    }

    public void setFinalY(int n) {
        float f;
        int n2 = this.mFinalY = n;
        int n3 = this.mStartY;
        this.mDeltaY = f = (float)(n2 - n3);
        this.mFinished = false;
    }

    public void startScroll(int n, int n2, int n3, int n4) {
        Scroller scroller = this;
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        scroller.startScroll(n5, n6, n7, n8, 250);
    }

    public void startScroll(int n, int n2, int n3, int n4, int n5) {
        float f;
        float f2;
        float f3;
        int n6;
        int n7;
        long l;
        this.mMode = 0;
        this.mFinished = false;
        this.mDuration = n5;
        this.mStartTime = l = AnimationUtils.currentAnimationTimeMillis();
        this.mStartX = n;
        this.mStartY = n2;
        this.mFinalX = n7 = n + n3;
        this.mFinalY = n6 = n2 + n4;
        this.mDeltaX = f3 = (float)n3;
        this.mDeltaY = f2 = (float)n4;
        float f4 = this.mDuration;
        this.mDurationReciprocal = f = 1.0f / f4;
    }

    public int timePassed() {
        long l = AnimationUtils.currentAnimationTimeMillis();
        long l2 = this.mStartTime;
        return (int)(l - l2);
    }
}

