/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.view.View;
import android.widget.ImageView;
import android.widget.ResourceCursorAdapter;
import android.widget.TextView;

public class SimpleCursorAdapter
extends ResourceCursorAdapter {
    private CursorToStringConverter mCursorToStringConverter;
    protected int[] mFrom;
    private String[] mOriginalFrom;
    private int mStringConversionColumn = -1;
    protected int[] mTo;
    private ViewBinder mViewBinder;

    public SimpleCursorAdapter(Context context, int n, Cursor cursor, String[] stringArray, int[] nArray) {
        super(context, n, cursor);
        this.mTo = nArray;
        this.mOriginalFrom = stringArray;
        this.findColumns(stringArray);
    }

    private void findColumns(String[] stringArray) {
        if (this.mCursor != null) {
            int n = stringArray.length;
            if (this.mFrom == null || this.mFrom.length != n) {
                int[] nArray = new int[n];
                this.mFrom = nArray;
            }
            int n2 = 0;
            while (true) {
                int n3;
                if (n2 >= n) {
                    return;
                }
                int[] nArray = this.mFrom;
                Cursor cursor = this.mCursor;
                String string2 = stringArray[n2];
                nArray[n2] = n3 = cursor.getColumnIndexOrThrow(string2);
                ++n2;
            }
        }
        this.mFrom = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void bindView(View view, Context context, Cursor cursor) {
        ViewBinder viewBinder = this.mViewBinder;
        int n = this.mTo.length;
        int[] nArray = this.mFrom;
        int[] nArray2 = this.mTo;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            View view2 = view.findViewById(n3);
            if (view2 != null) {
                boolean bl = false;
                if (viewBinder != null) {
                    int n4 = nArray[n2];
                    bl = viewBinder.setViewValue(view2, cursor, n4);
                }
                if (!bl) {
                    int n5 = nArray[n2];
                    String string2 = cursor.getString(n5);
                    if (string2 == null) {
                        string2 = "";
                    }
                    if (view2 instanceof TextView) {
                        TextView textView = (TextView)view2;
                        this.setViewText(textView, string2);
                    } else {
                        if (!(view2 instanceof ImageView)) {
                            StringBuilder stringBuilder = new StringBuilder();
                            String string3 = view2.getClass().getName();
                            String string4 = stringBuilder.append(string3).append(" is not a ").append(" view that can be bounds by this SimpleCursorAdapter").toString();
                            throw new IllegalStateException(string4);
                        }
                        ImageView imageView = (ImageView)view2;
                        this.setViewImage(imageView, string2);
                    }
                }
            }
            ++n2;
        }
        return;
    }

    @Override
    public void changeCursor(Cursor cursor) {
        super.changeCursor(cursor);
        String[] stringArray = this.mOriginalFrom;
        this.findColumns(stringArray);
    }

    public void changeCursorAndColumns(Cursor cursor, String[] stringArray, int[] nArray) {
        this.mOriginalFrom = stringArray;
        this.mTo = nArray;
        super.changeCursor(cursor);
        String[] stringArray2 = this.mOriginalFrom;
        this.findColumns(stringArray2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CharSequence convertToString(Cursor cursor) {
        if (this.mCursorToStringConverter != null) {
            return this.mCursorToStringConverter.convertToString(cursor);
        }
        if (this.mStringConversionColumn <= -1) return super.convertToString(cursor);
        int n = this.mStringConversionColumn;
        return cursor.getString(n);
    }

    public CursorToStringConverter getCursorToStringConverter() {
        return this.mCursorToStringConverter;
    }

    public int getStringConversionColumn() {
        return this.mStringConversionColumn;
    }

    public ViewBinder getViewBinder() {
        return this.mViewBinder;
    }

    public void setCursorToStringConverter(CursorToStringConverter cursorToStringConverter) {
        this.mCursorToStringConverter = cursorToStringConverter;
    }

    public void setStringConversionColumn(int n) {
        this.mStringConversionColumn = n;
    }

    public void setViewBinder(ViewBinder viewBinder) {
        this.mViewBinder = viewBinder;
    }

    public void setViewImage(ImageView imageView, String string2) {
        try {
            int n = Integer.parseInt(string2);
            imageView.setImageResource(n);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            Uri uri = Uri.parse(string2);
            imageView.setImageURI(uri);
            return;
        }
    }

    public void setViewText(TextView textView, String string2) {
        textView.setText(string2);
    }

    public static interface CursorToStringConverter {
        public CharSequence convertToString(Cursor var1);
    }

    public static interface ViewBinder {
        public boolean setViewValue(View var1, Cursor var2, int var3);
    }
}

