/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.R;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewGroup;

public class SlidingDrawer
extends ViewGroup {
    private static final int ANIMATION_FRAME_DURATION = 16;
    private static final int COLLAPSED_FULL_CLOSED = 55534;
    private static final int EXPANDED_FULL_OPEN = 55535;
    private static final float MAXIMUM_ACCELERATION = 2000.0f;
    private static final float MAXIMUM_MAJOR_VELOCITY = 200.0f;
    private static final float MAXIMUM_MINOR_VELOCITY = 150.0f;
    private static final float MAXIMUM_TAP_VELOCITY = 100.0f;
    private static final int MSG_ANIMATE = 1000;
    public static final int ORIENTATION_HORIZONTAL = 0;
    public static final int ORIENTATION_VERTICAL = 1;
    private static final int TAP_THRESHOLD = 6;
    private static final int VELOCITY_UNITS = 1000;
    private boolean mAllowSingleTap;
    private boolean mAnimateOnClick;
    private float mAnimatedAcceleration;
    private float mAnimatedVelocity;
    private boolean mAnimating;
    private long mAnimationLastTime;
    private float mAnimationPosition;
    private int mBottomOffset;
    private View mContent;
    private final int mContentId;
    private long mCurrentAnimationTime;
    private boolean mExpanded;
    private final Rect mFrame;
    private View mHandle;
    private int mHandleHeight;
    private final int mHandleId;
    private int mHandleWidth;
    private final Handler mHandler;
    private final Rect mInvalidate;
    private boolean mLocked;
    private final int mMaximumAcceleration;
    private final int mMaximumMajorVelocity;
    private final int mMaximumMinorVelocity;
    private final int mMaximumTapVelocity;
    private OnDrawerCloseListener mOnDrawerCloseListener;
    private OnDrawerOpenListener mOnDrawerOpenListener;
    private OnDrawerScrollListener mOnDrawerScrollListener;
    private final int mTapThreshold;
    private int mTopOffset;
    private int mTouchDelta;
    private boolean mTracking;
    private VelocityTracker mVelocityTracker;
    private final int mVelocityUnits;
    private boolean mVertical;

    public SlidingDrawer(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public SlidingDrawer(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        boolean bl;
        boolean bl2;
        int n8;
        int n9;
        Rect rect;
        Rect rect2;
        this.mFrame = rect2 = new Rect();
        this.mInvalidate = rect = new Rect();
        SlidingHandler slidingHandler = new SlidingHandler();
        this.mHandler = slidingHandler;
        int[] nArray = R.styleable.SlidingDrawer;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, n, 0);
        boolean bl3 = typedArray.getInt(0, 1) == 1;
        this.mVertical = bl3;
        this.mBottomOffset = n9 = (int)typedArray.getDimension(1, 0.0f);
        this.mTopOffset = n8 = (int)typedArray.getDimension(2, 0.0f);
        this.mAllowSingleTap = bl2 = typedArray.getBoolean(3, true);
        this.mAnimateOnClick = bl = typedArray.getBoolean(6, true);
        int n10 = typedArray.getResourceId(4, 0);
        if (n10 == 0) {
            throw new IllegalArgumentException("The handle attribute is required and must refer to a valid child.");
        }
        int n11 = typedArray.getResourceId(5, 0);
        if (n11 == 0) {
            throw new IllegalArgumentException("The content attribute is required and must refer to a valid child.");
        }
        if (n10 != n11) {
            throw new IllegalArgumentException("The content and handle attributes must refer to different children.");
        }
        this.mHandleId = n10;
        this.mContentId = n11;
        float f = this.getResources().getDisplayMetrics().density;
        this.mTapThreshold = n7 = (int)(6.0f * f + 0.5f);
        this.mMaximumTapVelocity = n6 = (int)(100.0f * f + 0.5f);
        this.mMaximumMinorVelocity = n5 = (int)(150.0f * f + 0.5f);
        this.mMaximumMajorVelocity = n4 = (int)(200.0f * f + 0.5f);
        this.mMaximumAcceleration = n3 = (int)(2000.0f * f + 0.5f);
        this.mVelocityUnits = n2 = (int)(1000.0f * f + 0.5f);
        typedArray.recycle();
        this.setAlwaysDrawnWithCacheEnabled(false);
    }

    private void animateClose(int n) {
        this.prepareTracking(n);
        float f = this.mMaximumAcceleration;
        this.performFling(n, f, true);
    }

    private void animateOpen(int n) {
        this.prepareTracking(n);
        float f = -this.mMaximumAcceleration;
        this.performFling(n, f, true);
    }

    private void closeDrawer() {
        this.moveHandle(55534);
        this.mContent.setVisibility(8);
        this.mContent.destroyDrawingCache();
        if (!this.mExpanded) {
            return;
        }
        this.mExpanded = false;
        if (this.mOnDrawerCloseListener == null) {
            return;
        }
        this.mOnDrawerCloseListener.onDrawerClosed();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doAnimation() {
        long l;
        if (!this.mAnimating) {
            return;
        }
        this.incrementAnimation();
        float f = this.mAnimationPosition;
        int n = this.mBottomOffset;
        int n2 = this.mVertical ? this.getHeight() : this.getWidth();
        float f2 = n + n2 - 1;
        if (f >= f2) {
            this.mAnimating = false;
            this.closeDrawer();
            return;
        }
        float f3 = this.mAnimationPosition;
        float f4 = this.mTopOffset;
        if (f3 < f4) {
            this.mAnimating = false;
            this.openDrawer();
            return;
        }
        int n3 = (int)this.mAnimationPosition;
        this.moveHandle(n3);
        this.mCurrentAnimationTime = l = this.mCurrentAnimationTime + 16L;
        Handler handler = this.mHandler;
        Message message = this.mHandler.obtainMessage(1000);
        long l2 = this.mCurrentAnimationTime;
        boolean bl = handler.sendMessageAtTime(message, l2);
    }

    private void incrementAnimation() {
        float f;
        float f2;
        long l = SystemClock.uptimeMillis();
        long l2 = this.mAnimationLastTime;
        float f3 = (float)(l - l2) / 1000.0f;
        float f4 = this.mAnimationPosition;
        float f5 = this.mAnimatedVelocity;
        float f6 = this.mAnimatedAcceleration;
        float f7 = f5 * f3 + f4;
        float f8 = 0.5f * f6 * f3 * f3;
        this.mAnimationPosition = f2 = f7 + f8;
        this.mAnimatedVelocity = f = f6 * f3 + f5;
        this.mAnimationLastTime = l;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void moveHandle(int n) {
        View view = this.mHandle;
        if (this.mVertical) {
            if (n == 55535) {
                int n2 = this.mTopOffset;
                int n3 = view.getTop();
                int n4 = n2 - n3;
                view.offsetTopAndBottom(n4);
                this.invalidate();
                return;
            }
            if (n == 55534) {
                int n5 = this.mBottomOffset;
                int n6 = this.mBottom;
                int n7 = n5 + n6;
                int n8 = this.mTop;
                int n9 = n7 - n8;
                int n10 = this.mHandleHeight;
                int n11 = n9 - n10;
                int n12 = view.getTop();
                int n13 = n11 - n12;
                view.offsetTopAndBottom(n13);
                this.invalidate();
                return;
            }
            int n14 = view.getTop();
            int n15 = n - n14;
            int n16 = this.mTopOffset;
            if (n < n16) {
                n15 = this.mTopOffset - n14;
            } else {
                int n17 = this.mBottomOffset;
                int n18 = this.mBottom;
                int n19 = n17 + n18;
                int n20 = this.mTop;
                int n21 = n19 - n20;
                int n22 = this.mHandleHeight;
                int n23 = n21 - n22 - n14;
                if (n15 > n23) {
                    int n24 = this.mBottomOffset;
                    int n25 = this.mBottom;
                    int n26 = n24 + n25;
                    int n27 = this.mTop;
                    int n28 = n26 - n27;
                    int n29 = this.mHandleHeight;
                    n15 = n28 - n29 - n14;
                }
            }
            view.offsetTopAndBottom(n15);
            Rect rect = this.mFrame;
            Rect rect2 = this.mInvalidate;
            view.getHitRect(rect);
            rect2.set(rect);
            int n30 = rect.left;
            int n31 = rect.top - n15;
            int n32 = rect.right;
            int n33 = rect.bottom - n15;
            rect2.union(n30, n31, n32, n33);
            int n34 = rect.bottom - n15;
            int n35 = this.getWidth();
            int n36 = rect.bottom - n15;
            int n37 = this.mContent.getHeight();
            int n38 = n36 + n37;
            rect2.union(0, n34, n35, n38);
            this.invalidate(rect2);
            return;
        }
        if (n == 55535) {
            int n39 = this.mTopOffset;
            int n40 = view.getLeft();
            int n41 = n39 - n40;
            view.offsetLeftAndRight(n41);
            this.invalidate();
            return;
        }
        if (n == 55534) {
            int n42 = this.mBottomOffset;
            int n43 = this.mRight;
            int n44 = n42 + n43;
            int n45 = this.mLeft;
            int n46 = n44 - n45;
            int n47 = this.mHandleWidth;
            int n48 = n46 - n47;
            int n49 = view.getLeft();
            int n50 = n48 - n49;
            view.offsetLeftAndRight(n50);
            this.invalidate();
            return;
        }
        int n51 = view.getLeft();
        int n52 = n - n51;
        int n53 = this.mTopOffset;
        if (n < n53) {
            n52 = this.mTopOffset - n51;
        } else {
            int n54 = this.mBottomOffset;
            int n55 = this.mRight;
            int n56 = n54 + n55;
            int n57 = this.mLeft;
            int n58 = n56 - n57;
            int n59 = this.mHandleWidth;
            int n60 = n58 - n59 - n51;
            if (n52 > n60) {
                int n61 = this.mBottomOffset;
                int n62 = this.mRight;
                int n63 = n61 + n62;
                int n64 = this.mLeft;
                int n65 = n63 - n64;
                int n66 = this.mHandleWidth;
                n52 = n65 - n66 - n51;
            }
        }
        view.offsetLeftAndRight(n52);
        Rect rect = this.mFrame;
        Rect rect3 = this.mInvalidate;
        view.getHitRect(rect);
        rect3.set(rect);
        int n67 = rect.left - n52;
        int n68 = rect.top;
        int n69 = rect.right - n52;
        int n70 = rect.bottom;
        rect3.union(n67, n68, n69, n70);
        int n71 = rect.right - n52;
        int n72 = rect.right - n52;
        int n73 = this.mContent.getWidth();
        int n74 = n72 + n73;
        int n75 = this.getHeight();
        rect3.union(n71, 0, n74, n75);
        this.invalidate(rect3);
    }

    private void openDrawer() {
        this.moveHandle(55535);
        this.mContent.setVisibility(0);
        if (this.mExpanded) {
            return;
        }
        this.mExpanded = true;
        if (this.mOnDrawerOpenListener == null) {
            return;
        }
        this.mOnDrawerOpenListener.onDrawerOpened();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void performFling(int n, float f, boolean bl) {
        long l;
        long l2;
        block9: {
            float f2;
            int n2;
            int n3;
            float f3;
            block8: {
                float f4;
                int n4;
                int n5;
                int n6;
                float f5;
                float f6;
                this.mAnimationPosition = f6 = (float)n;
                this.mAnimatedVelocity = f;
                if (!this.mExpanded) break block8;
                if (bl || f > (f5 = (float)this.mMaximumMajorVelocity) || n > (n6 = (n5 = this.mTopOffset) + (n4 = this.mVertical ? this.mHandleHeight : this.mHandleWidth)) && f > (f4 = (float)(-this.mMaximumMajorVelocity))) {
                    float f7;
                    this.mAnimatedAcceleration = f7 = (float)this.mMaximumAcceleration;
                    if (f < 0.0f) {
                        this.mAnimatedVelocity = 0.0f;
                    }
                    break block9;
                } else {
                    float f8;
                    this.mAnimatedAcceleration = f8 = (float)(-this.mMaximumAcceleration);
                    if (f > 0.0f) {
                        this.mAnimatedVelocity = 0.0f;
                    }
                }
                break block9;
            }
            if (!bl && (f > (f3 = (float)this.mMaximumMajorVelocity) || n > (n3 = (n2 = this.mVertical ? this.getHeight() : this.getWidth()) / 2) && f > (f2 = (float)(-this.mMaximumMajorVelocity)))) {
                float f9;
                this.mAnimatedAcceleration = f9 = (float)this.mMaximumAcceleration;
                if (f < 0.0f) {
                    this.mAnimatedVelocity = 0.0f;
                }
            } else {
                float f10;
                this.mAnimatedAcceleration = f10 = (float)(-this.mMaximumAcceleration);
                if (f > 0.0f) {
                    this.mAnimatedVelocity = 0.0f;
                }
            }
        }
        this.mAnimationLastTime = l2 = SystemClock.uptimeMillis();
        this.mCurrentAnimationTime = l = 16L + l2;
        this.mAnimating = true;
        this.mHandler.removeMessages(1000);
        Handler handler = this.mHandler;
        Message message = this.mHandler.obtainMessage(1000);
        long l3 = this.mCurrentAnimationTime;
        boolean bl2 = handler.sendMessageAtTime(message, l3);
        this.stopTracking();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void prepareContent() {
        if (this.mAnimating) {
            return;
        }
        View view = this.mContent;
        if (view.isLayoutRequested()) {
            if (this.mVertical) {
                int n = this.mHandleHeight;
                int n2 = this.mBottom;
                int n3 = this.mTop;
                int n4 = n2 - n3 - n;
                int n5 = this.mTopOffset;
                int n6 = n4 - n5;
                int n7 = this.mRight;
                int n8 = this.mLeft;
                int n9 = View.MeasureSpec.makeMeasureSpec(n7 - n8, 0x40000000);
                int n10 = View.MeasureSpec.makeMeasureSpec(n6, 0x40000000);
                view.measure(n9, n10);
                int n11 = this.mTopOffset + n;
                int n12 = view.getMeasuredWidth();
                int n13 = this.mTopOffset + n;
                int n14 = view.getMeasuredHeight();
                int n15 = n13 + n14;
                view.layout(0, n11, n12, n15);
            } else {
                int n = this.mHandle.getWidth();
                int n16 = this.mRight;
                int n17 = this.mLeft;
                int n18 = n16 - n17 - n;
                int n19 = this.mTopOffset;
                int n20 = View.MeasureSpec.makeMeasureSpec(n18 - n19, 0x40000000);
                int n21 = this.mBottom;
                int n22 = this.mTop;
                int n23 = View.MeasureSpec.makeMeasureSpec(n21 - n22, 0x40000000);
                view.measure(n20, n23);
                int n24 = this.mTopOffset + n;
                int n25 = this.mTopOffset + n;
                int n26 = view.getMeasuredWidth();
                int n27 = n25 + n26;
                int n28 = view.getMeasuredHeight();
                view.layout(n24, 0, n27, n28);
            }
        }
        boolean bl = view.getViewTreeObserver().dispatchOnPreDraw();
        view.buildDrawingCache();
        view.setVisibility(8);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void prepareTracking(int n) {
        VelocityTracker velocityTracker;
        this.mTracking = true;
        this.mVelocityTracker = velocityTracker = VelocityTracker.obtain();
        boolean bl = !this.mExpanded;
        if (bl) {
            long l;
            long l2;
            float f;
            int n2;
            float f2;
            float f3;
            this.mAnimatedAcceleration = f3 = (float)this.mMaximumAcceleration;
            this.mAnimatedVelocity = f2 = (float)this.mMaximumMajorVelocity;
            int n3 = this.mBottomOffset;
            if (this.mVertical) {
                int n4 = this.getHeight();
                int n5 = this.mHandleHeight;
                n2 = n4 - n5;
            } else {
                int n6 = this.getWidth();
                int n7 = this.mHandleWidth;
                n2 = n6 - n7;
            }
            this.mAnimationPosition = f = (float)(n3 + n2);
            int n8 = (int)this.mAnimationPosition;
            this.moveHandle(n8);
            this.mAnimating = true;
            this.mHandler.removeMessages(1000);
            this.mAnimationLastTime = l2 = SystemClock.uptimeMillis();
            this.mCurrentAnimationTime = l = 16L + l2;
            this.mAnimating = true;
            return;
        }
        if (this.mAnimating) {
            this.mAnimating = false;
            this.mHandler.removeMessages(1000);
        }
        this.moveHandle(n);
    }

    private void stopTracking() {
        this.mHandle.setPressed(false);
        this.mTracking = false;
        if (this.mOnDrawerScrollListener != null) {
            this.mOnDrawerScrollListener.onScrollEnded();
        }
        if (this.mVelocityTracker == null) {
            return;
        }
        this.mVelocityTracker.recycle();
        this.mVelocityTracker = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void animateClose() {
        this.prepareContent();
        OnDrawerScrollListener onDrawerScrollListener = this.mOnDrawerScrollListener;
        if (onDrawerScrollListener != null) {
            onDrawerScrollListener.onScrollStarted();
        }
        int n = this.mVertical ? this.mHandle.getTop() : this.mHandle.getLeft();
        this.animateClose(n);
        if (onDrawerScrollListener == null) {
            return;
        }
        onDrawerScrollListener.onScrollEnded();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void animateOpen() {
        this.prepareContent();
        OnDrawerScrollListener onDrawerScrollListener = this.mOnDrawerScrollListener;
        if (onDrawerScrollListener != null) {
            onDrawerScrollListener.onScrollStarted();
        }
        int n = this.mVertical ? this.mHandle.getTop() : this.mHandle.getLeft();
        this.animateOpen(n);
        this.sendAccessibilityEvent(32);
        if (onDrawerScrollListener == null) {
            return;
        }
        onDrawerScrollListener.onScrollEnded();
    }

    public void animateToggle() {
        if (!this.mExpanded) {
            this.animateOpen();
            return;
        }
        this.animateClose();
    }

    public void close() {
        this.closeDrawer();
        this.invalidate();
        this.requestLayout();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void dispatchDraw(Canvas canvas) {
        long l = this.getDrawingTime();
        View view = this.mHandle;
        boolean bl = this.mVertical;
        boolean bl2 = this.drawChild(canvas, view, l);
        if (this.mTracking || this.mAnimating) {
            float f;
            float f2;
            Bitmap bitmap = this.mContent.getDrawingCache();
            if (bitmap != null) {
                if (bl) {
                    float f3 = view.getBottom();
                    canvas.drawBitmap(bitmap, 0.0f, f3, null);
                    return;
                }
                float f4 = view.getRight();
                canvas.drawBitmap(bitmap, f4, 0.0f, null);
                return;
            }
            int n = canvas.save();
            if (bl) {
                f2 = 0.0f;
            } else {
                int n2 = view.getLeft();
                int n3 = this.mTopOffset;
                f2 = n2 - n3;
            }
            if (bl) {
                int n4 = view.getTop();
                int n5 = this.mTopOffset;
                f = n4 - n5;
            } else {
                f = 0.0f;
            }
            canvas.translate(f2, f);
            View view2 = this.mContent;
            boolean bl3 = this.drawChild(canvas, view2, l);
            canvas.restore();
            return;
        }
        if (!this.mExpanded) {
            return;
        }
        View view3 = this.mContent;
        boolean bl4 = this.drawChild(canvas, view3, l);
    }

    public View getContent() {
        return this.mContent;
    }

    public View getHandle() {
        return this.mHandle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isMoving() {
        if (this.mTracking) return true;
        if (!this.mAnimating) return false;
        return true;
    }

    public boolean isOpened() {
        return this.mExpanded;
    }

    public void lock() {
        this.mLocked = true;
    }

    @Override
    protected void onFinishInflate() {
        View view;
        View view2;
        int n = this.mHandleId;
        this.mHandle = view2 = this.findViewById(n);
        if (this.mHandle == null) {
            throw new IllegalArgumentException("The handle attribute is must refer to an existing child.");
        }
        View view3 = this.mHandle;
        DrawerToggler drawerToggler = new DrawerToggler();
        view3.setOnClickListener(drawerToggler);
        int n2 = this.mContentId;
        this.mContent = view = this.findViewById(n2);
        if (this.mContent == null) {
            throw new IllegalArgumentException("The content attribute is must refer to an existing child.");
        }
        this.mContent.setVisibility(8);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        int n;
        int n2;
        if (this.mLocked) {
            return false;
        }
        int n3 = motionEvent.getAction();
        float f = motionEvent.getX();
        float f2 = motionEvent.getY();
        Rect rect = this.mFrame;
        View view = this.mHandle;
        view.getHitRect(rect);
        if (!this.mTracking && !rect.contains(n2 = (int)f, n = (int)f2)) {
            return false;
        }
        if (n3 != 0) return true;
        this.mTracking = true;
        view.setPressed(true);
        this.prepareContent();
        if (this.mOnDrawerScrollListener != null) {
            this.mOnDrawerScrollListener.onScrollStarted();
        }
        if (this.mVertical) {
            int n4;
            int n5 = this.mHandle.getTop();
            this.mTouchDelta = n4 = (int)f2 - n5;
            this.prepareTracking(n5);
        } else {
            int n6;
            int n7 = this.mHandle.getLeft();
            this.mTouchDelta = n6 = (int)f - n7;
            this.prepareTracking(n7);
        }
        this.mVelocityTracker.addMovement(motionEvent);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        if (this.mTracking) {
            return;
        }
        int n9 = n3 - n;
        int n10 = n4 - n2;
        View view = this.mHandle;
        int n11 = view.getMeasuredWidth();
        int n12 = view.getMeasuredHeight();
        View view2 = this.mContent;
        if (this.mVertical) {
            n8 = (n9 - n11) / 2;
            if (this.mExpanded) {
                n7 = this.mTopOffset;
            } else {
                int n13 = n10 - n12;
                int n14 = this.mBottomOffset;
                n7 = n13 + n14;
            }
            int n15 = this.mTopOffset + n12;
            int n16 = view2.getMeasuredWidth();
            int n17 = this.mTopOffset + n12;
            int n18 = view2.getMeasuredHeight();
            int n19 = n17 + n18;
            view2.layout(0, n15, n16, n19);
        } else {
            if (this.mExpanded) {
                n8 = this.mTopOffset;
            } else {
                int n20 = n9 - n11;
                int n21 = this.mBottomOffset;
                n8 = n20 + n21;
            }
            n7 = (n10 - n12) / 2;
            int n22 = this.mTopOffset + n11;
            int n23 = this.mTopOffset + n11;
            int n24 = view2.getMeasuredWidth();
            int n25 = n23 + n24;
            int n26 = view2.getMeasuredHeight();
            view2.layout(n22, 0, n25, n26);
        }
        int n27 = n8 + n11;
        int n28 = n7 + n12;
        view.layout(n8, n7, n27, n28);
        this.mHandleHeight = n6 = view.getHeight();
        this.mHandleWidth = n5 = view.getWidth();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        int n3 = View.MeasureSpec.getMode(n);
        int n4 = View.MeasureSpec.getSize(n);
        int n5 = View.MeasureSpec.getMode(n2);
        int n6 = View.MeasureSpec.getSize(n2);
        if (n3 == 0 || n5 == 0) {
            throw new RuntimeException("SlidingDrawer cannot have UNSPECIFIED dimensions");
        }
        View view = this.mHandle;
        this.measureChild(view, n, n2);
        if (this.mVertical) {
            int n7 = view.getMeasuredHeight();
            int n8 = n6 - n7;
            int n9 = this.mTopOffset;
            int n10 = n8 - n9;
            View view2 = this.mContent;
            int n11 = View.MeasureSpec.makeMeasureSpec(n4, 0x40000000);
            int n12 = View.MeasureSpec.makeMeasureSpec(n10, 0x40000000);
            view2.measure(n11, n12);
        } else {
            int n13 = view.getMeasuredWidth();
            int n14 = n4 - n13;
            int n15 = this.mTopOffset;
            int n16 = n14 - n15;
            View view3 = this.mContent;
            int n17 = View.MeasureSpec.makeMeasureSpec(n16, 0x40000000);
            int n18 = View.MeasureSpec.makeMeasureSpec(n6, 0x40000000);
            view3.measure(n17, n18);
        }
        this.setMeasuredDimension(n4, n6);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean onTouchEvent(MotionEvent var1_1) {
        if (this.mLocked) {
            var2_2 = true;
lbl3:
            // 3 sources

            return var2_2;
        }
        if (!this.mTracking) ** GOTO lbl-1000
        this.mVelocityTracker.addMovement(var1_1);
        switch (var1_1.getAction()) lbl-1000:
        // 7 sources

        {
            default: lbl-1000:
            // 2 sources

            {
                if (!this.mTracking && !this.mAnimating && !super.onTouchEvent(var1_1)) break;
                var2_2 = true;
                ** GOTO lbl3
            }
            case 2: {
                if (!this.mVertical) ** GOTO lbl21
                var3_3 = var1_1.getY();
lbl15:
                // 2 sources

                while (true) {
                    var4_4 = (int)var3_3;
                    var5_5 = this.mTouchDelta;
                    var6_6 = var4_4 - var5_5;
                    this.moveHandle(var6_6);
                    ** GOTO lbl-1000
                    break;
                }
lbl21:
                // 1 sources

                var3_3 = var1_1.getX();
                ** continue;
            }
            case 1: 
            case 3: {
                var7_7 = this.mVelocityTracker;
                var8_8 = this.mVelocityUnits;
                var7_7.computeCurrentVelocity(var8_8);
                var9_9 = var7_7.getYVelocity();
                var10_10 = var7_7.getXVelocity();
                var11_11 = this.mVertical;
                if (!var11_11) ** GOTO lbl61
                if (!(var9_9 < 0.0f)) ** GOTO lbl59
                var12_12 = true;
lbl33:
                // 2 sources

                while (true) {
                    if (var10_10 < 0.0f) {
                        var10_10 = -var10_10;
                    }
                    if (var10_10 > (var13_13 = (float)this.mMaximumMinorVelocity)) {
                        var10_10 = this.mMaximumMinorVelocity;
                    }
lbl38:
                    // 5 sources

                    while (true) {
                        var14_14 = var10_10;
                        var16_15 = var9_9;
                        var18_16 = (float)Math.hypot(var14_14, var16_15);
                        if (var12_12) {
                            var18_16 = -var18_16;
                        }
                        var19_17 = this.mHandle.getTop();
                        var20_18 = this.mHandle.getLeft();
                        var21_19 = Math.abs(var18_16);
                        if (!(var21_19 < (var22_20 = (float)this.mMaximumTapVelocity))) ** GOTO lbl95
                        if (!var11_11) ** GOTO lbl71
                        if ((!this.mExpanded || var19_17 >= (var25_23 = (var23_21 = this.mTapThreshold) + (var24_22 = this.mTopOffset))) && (this.mExpanded || var19_17 <= (var34_32 = (var32_30 = (var30_28 = (var28_26 = (var26_24 = this.mBottomOffset) + (var27_25 = this.mBottom)) - (var29_27 = this.mTop)) - (var31_29 = this.mHandleHeight)) - (var33_31 = this.mTapThreshold)))) ** GOTO lbl72
lbl50:
                        // 2 sources

                        while (this.mAllowSingleTap) {
                            this.playSoundEffect(0);
                            if (!this.mExpanded) ** GOTO lbl79
                            if (!var11_11) ** GOTO lbl77
                            var35_33 = var19_17;
lbl55:
                            // 2 sources

                            while (true) {
                                this.animateClose(var35_33);
                                ** GOTO lbl-1000
                                break;
                            }
                        }
                        ** GOTO lbl86
                        break;
                    }
                    break;
                }
lbl59:
                // 1 sources

                var12_12 = false;
                ** continue;
lbl61:
                // 1 sources

                if (!(var10_10 < 0.0f)) ** GOTO lbl69
                var12_12 = true;
lbl63:
                // 2 sources

                while (true) {
                    if (var9_9 < 0.0f) {
                        var9_9 = -var9_9;
                    }
                    if (!(var9_9 > (var36_38 = (float)this.mMaximumMinorVelocity))) ** GOTO lbl38
                    var9_9 = this.mMaximumMinorVelocity;
                    ** continue;
                    break;
                }
lbl69:
                // 1 sources

                var12_12 = false;
                ** continue;
lbl71:
                // 1 sources

                if (this.mExpanded && var20_18 < (var39_41 = (var37_39 = this.mTapThreshold) + (var38_40 = this.mTopOffset)) || !this.mExpanded && var20_18 > (var48_50 = (var46_48 = (var44_46 = (var42_44 = (var40_42 = this.mBottomOffset) + (var41_43 = this.mRight)) - (var43_45 = this.mLeft)) - (var45_47 = this.mHandleWidth)) - (var47_49 = this.mTapThreshold))) ** GOTO lbl50
lbl72:
                // 2 sources

                if (!var11_11) ** GOTO lbl93
                var35_34 = var19_17;
lbl74:
                // 2 sources

                while (true) {
                    this.performFling(var35_34, var18_16, false);
                    ** GOTO lbl-1000
                    break;
                }
lbl77:
                // 1 sources

                var35_33 = var20_18;
                ** continue;
lbl79:
                // 1 sources

                if (!var11_11) ** GOTO lbl84
                var35_35 = var19_17;
lbl81:
                // 2 sources

                while (true) {
                    this.animateOpen(var35_35);
                    ** GOTO lbl-1000
                    break;
                }
lbl84:
                // 1 sources

                var35_35 = var20_18;
                ** continue;
lbl86:
                // 1 sources

                if (!var11_11) ** GOTO lbl91
                var35_36 = var19_17;
lbl88:
                // 2 sources

                while (true) {
                    this.performFling(var35_36, var18_16, false);
                    ** GOTO lbl-1000
                    break;
                }
lbl91:
                // 1 sources

                var35_36 = var20_18;
                ** continue;
lbl93:
                // 1 sources

                var35_34 = var20_18;
                ** continue;
lbl95:
                // 1 sources

                if (!var11_11) ** GOTO lbl100
                var35_37 = var19_17;
lbl97:
                // 2 sources

                while (true) {
                    this.performFling(var35_37, var18_16, false);
                    ** GOTO lbl-1000
                    break;
                }
lbl100:
                // 1 sources

                var35_37 = var20_18;
                ** continue;
            }
        }
        var2_2 = false;
        ** while (true)
    }

    public void open() {
        this.openDrawer();
        this.invalidate();
        this.requestLayout();
        this.sendAccessibilityEvent(32);
    }

    public void setOnDrawerCloseListener(OnDrawerCloseListener onDrawerCloseListener) {
        this.mOnDrawerCloseListener = onDrawerCloseListener;
    }

    public void setOnDrawerOpenListener(OnDrawerOpenListener onDrawerOpenListener) {
        this.mOnDrawerOpenListener = onDrawerOpenListener;
    }

    public void setOnDrawerScrollListener(OnDrawerScrollListener onDrawerScrollListener) {
        this.mOnDrawerScrollListener = onDrawerScrollListener;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void toggle() {
        if (!this.mExpanded) {
            this.openDrawer();
        } else {
            this.closeDrawer();
        }
        this.invalidate();
        this.requestLayout();
    }

    public void unlock() {
        this.mLocked = false;
    }

    private class SlidingHandler
    extends Handler {
        private SlidingHandler() {
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case 1000: 
            }
            SlidingDrawer.this.doAnimation();
        }
    }

    private class DrawerToggler
    implements View.OnClickListener {
        private DrawerToggler() {
        }

        @Override
        public void onClick(View view) {
            if (SlidingDrawer.this.mLocked) {
                return;
            }
            if (SlidingDrawer.this.mAnimateOnClick) {
                SlidingDrawer.this.animateToggle();
                return;
            }
            SlidingDrawer.this.toggle();
        }
    }

    public static interface OnDrawerScrollListener {
        public void onScrollEnded();

        public void onScrollStarted();
    }

    public static interface OnDrawerCloseListener {
        public void onDrawerClosed();
    }

    public static interface OnDrawerOpenListener {
        public void onDrawerOpened();
    }
}

