/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsSpinner;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.SpinnerAdapter;
import com.android.internal.R;

public class Spinner
extends AbsSpinner
implements DialogInterface.OnClickListener {
    private AlertDialog mPopup;
    private CharSequence mPrompt;

    public Spinner(Context context) {
        this(context, null);
    }

    public Spinner(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0x1010081);
    }

    public Spinner(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        int[] nArray = R.styleable.Spinner;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, n, 0);
        String string2 = typedArray.getString(0);
        this.mPrompt = string2;
        typedArray.recycle();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private View makeAndAddView(int n) {
        View view;
        if (!this.mDataChanged && (view = this.mRecycler.get(n)) != null) {
            this.setUpChild(view);
            return view;
        }
        View view2 = this.mAdapter.getView(n, null, this);
        this.setUpChild(view2);
        return view2;
    }

    private void setUpChild(View view) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = this.generateDefaultLayoutParams();
        }
        boolean bl = this.addViewInLayout(view, 0, layoutParams);
        boolean bl2 = this.hasFocus();
        view.setSelected(bl2);
        int n = this.mHeightMeasureSpec;
        int n2 = this.mSpinnerPadding.top;
        int n3 = this.mSpinnerPadding.bottom;
        int n4 = n2 + n3;
        int n5 = layoutParams.height;
        int n6 = ViewGroup.getChildMeasureSpec(n, n4, n5);
        int n7 = this.mWidthMeasureSpec;
        int n8 = this.mSpinnerPadding.left;
        int n9 = this.mSpinnerPadding.right;
        int n10 = n8 + n9;
        int n11 = layoutParams.width;
        int n12 = ViewGroup.getChildMeasureSpec(n7, n10, n11);
        view.measure(n12, n6);
        int n13 = this.mSpinnerPadding.top;
        int n14 = this.mMeasuredHeight;
        int n15 = this.mSpinnerPadding.bottom;
        int n16 = n14 - n15;
        int n17 = this.mSpinnerPadding.top;
        int n18 = n16 - n17;
        int n19 = view.getMeasuredHeight();
        int n20 = (n18 - n19) / 2;
        int n21 = n13 + n20;
        int n22 = view.getMeasuredHeight();
        int n23 = n21 + n22;
        int n24 = view.getMeasuredWidth();
        int n25 = 0 + n24;
        view.layout(0, n21, n25, n23);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getBaseline() {
        View view = null;
        if (this.getChildCount() > 0) {
            view = this.getChildAt(0);
        } else if (this.mAdapter != null && this.mAdapter.getCount() > 0) {
            view = this.makeAndAddView(0);
        }
        if (view == null) return -1;
        int n = view.getTop();
        int n2 = view.getBaseline();
        return n + n2;
    }

    public CharSequence getPrompt() {
        return this.mPrompt;
    }

    @Override
    void layout(int n, boolean bl) {
        int n2;
        int n3 = this.mSpinnerPadding.left;
        int n4 = this.mRight;
        int n5 = this.mLeft;
        int n6 = n4 - n5;
        int n7 = this.mSpinnerPadding.left;
        int n8 = n6 - n7;
        int n9 = this.mSpinnerPadding.right;
        int n10 = n8 - n9;
        if (this.mDataChanged) {
            this.handleDataChanged();
        }
        if (this.mItemCount == 0) {
            this.resetList();
            return;
        }
        if (this.mNextSelectedPosition >= 0) {
            int n11 = this.mNextSelectedPosition;
            this.setSelectedPositionInt(n11);
        }
        this.recycleAllViews();
        this.removeAllViewsInLayout();
        this.mFirstPosition = n2 = this.mSelectedPosition;
        int n12 = this.mSelectedPosition;
        View view = this.makeAndAddView(n12);
        int n13 = view.getMeasuredWidth();
        int n14 = n10 / 2 + n3;
        int n15 = n13 / 2;
        int n16 = n14 - n15;
        view.offsetLeftAndRight(n16);
        this.mRecycler.clear();
        this.invalidate();
        this.checkSelectionChanged();
        this.mDataChanged = false;
        this.mNeedSync = false;
        int n17 = this.mSelectedPosition;
        this.setNextSelectedPositionInt(n17);
    }

    @Override
    public void onClick(DialogInterface dialogInterface, int n) {
        this.setSelection(n);
        dialogInterface.dismiss();
        this.mPopup = null;
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mPopup == null) {
            return;
        }
        if (!this.mPopup.isShowing()) {
            return;
        }
        this.mPopup.dismiss();
        this.mPopup = null;
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        this.mInLayout = true;
        this.layout(0, false);
        this.mInLayout = false;
    }

    @Override
    public boolean performClick() {
        boolean bl = super.performClick();
        if (!bl) {
            AlertDialog alertDialog;
            bl = true;
            Context context = this.getContext();
            Adapter adapter = this.getAdapter();
            DropDownAdapter dropDownAdapter = new DropDownAdapter((SpinnerAdapter)adapter);
            AlertDialog.Builder builder = new AlertDialog.Builder(context);
            if (this.mPrompt != null) {
                CharSequence charSequence = this.mPrompt;
                AlertDialog.Builder builder2 = builder.setTitle(charSequence);
            }
            int n = this.getSelectedItemPosition();
            this.mPopup = alertDialog = builder.setSingleChoiceItems(dropDownAdapter, n, (DialogInterface.OnClickListener)this).show();
        }
        return bl;
    }

    @Override
    public void setOnItemClickListener(AdapterView.OnItemClickListener onItemClickListener) {
        throw new RuntimeException("setOnItemClickListener cannot be used with a spinner.");
    }

    public void setPrompt(CharSequence charSequence) {
        this.mPrompt = charSequence;
    }

    public void setPromptId(int n) {
        CharSequence charSequence;
        this.mPrompt = charSequence = this.getContext().getText(n);
    }

    private static class DropDownAdapter
    implements ListAdapter,
    SpinnerAdapter {
        private SpinnerAdapter mAdapter;
        private ListAdapter mListAdapter;

        public DropDownAdapter(SpinnerAdapter spinnerAdapter) {
            ListAdapter listAdapter;
            this.mAdapter = spinnerAdapter;
            if (!(spinnerAdapter instanceof ListAdapter)) {
                return;
            }
            this.mListAdapter = listAdapter = (ListAdapter)((Object)spinnerAdapter);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean areAllItemsEnabled() {
            ListAdapter listAdapter = this.mListAdapter;
            if (listAdapter == null) return true;
            return listAdapter.areAllItemsEnabled();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int getCount() {
            if (this.mAdapter != null) return this.mAdapter.getCount();
            return 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public View getDropDownView(int n, View view, ViewGroup viewGroup) {
            if (this.mAdapter != null) return this.mAdapter.getDropDownView(n, view, viewGroup);
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object getItem(int n) {
            if (this.mAdapter != null) return this.mAdapter.getItem(n);
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public long getItemId(int n) {
            if (this.mAdapter != null) return this.mAdapter.getItemId(n);
            return 65535L;
        }

        @Override
        public int getItemViewType(int n) {
            return 0;
        }

        @Override
        public View getView(int n, View view, ViewGroup viewGroup) {
            return this.getDropDownView(n, view, viewGroup);
        }

        @Override
        public int getViewTypeCount() {
            return 1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean hasStableIds() {
            if (this.mAdapter == null) return false;
            if (!this.mAdapter.hasStableIds()) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isEmpty() {
            if (this.getCount() != 0) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isEnabled(int n) {
            ListAdapter listAdapter = this.mListAdapter;
            if (listAdapter == null) return true;
            return listAdapter.isEnabled(n);
        }

        @Override
        public void registerDataSetObserver(DataSetObserver dataSetObserver) {
            if (this.mAdapter == null) {
                return;
            }
            this.mAdapter.registerDataSetObserver(dataSetObserver);
        }

        @Override
        public void unregisterDataSetObserver(DataSetObserver dataSetObserver) {
            if (this.mAdapter == null) {
                return;
            }
            this.mAdapter.unregisterDataSetObserver(dataSetObserver);
        }
    }
}

