/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.LocalActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TabWidget;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;

public class TabHost
extends FrameLayout
implements ViewTreeObserver.OnTouchModeChangeListener {
    protected int mCurrentTab;
    private View mCurrentView;
    protected LocalActivityManager mLocalActivityManager;
    private OnTabChangeListener mOnTabChangeListener;
    private FrameLayout mTabContent;
    private View.OnKeyListener mTabKeyListener;
    private List<TabSpec> mTabSpecs;
    private TabWidget mTabWidget;

    public TabHost(Context context) {
        super(context);
        ArrayList<TabSpec> arrayList = new ArrayList<TabSpec>(2);
        this.mTabSpecs = arrayList;
        this.mCurrentTab = -1;
        this.mCurrentView = null;
        this.mLocalActivityManager = null;
        this.initTabHost();
    }

    public TabHost(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        ArrayList<TabSpec> arrayList = new ArrayList<TabSpec>(2);
        this.mTabSpecs = arrayList;
        this.mCurrentTab = -1;
        this.mCurrentView = null;
        this.mLocalActivityManager = null;
        this.initTabHost();
    }

    private void initTabHost() {
        this.setFocusableInTouchMode(true);
        this.setDescendantFocusability(262144);
        this.mCurrentTab = -1;
        this.mCurrentView = null;
    }

    private void invokeOnTabChangeListener() {
        if (this.mOnTabChangeListener == null) {
            return;
        }
        OnTabChangeListener onTabChangeListener = this.mOnTabChangeListener;
        String string2 = this.getCurrentTabTag();
        onTabChangeListener.onTabChanged(string2);
    }

    public void addTab(TabSpec tabSpec) {
        if (tabSpec.mIndicatorStrategy == null) {
            throw new IllegalArgumentException("you must specify a way to create the tab indicator.");
        }
        if (tabSpec.mContentStrategy == null) {
            throw new IllegalArgumentException("you must specify a way to create the tab content");
        }
        View view = tabSpec.mIndicatorStrategy.createIndicatorView();
        View.OnKeyListener onKeyListener = this.mTabKeyListener;
        view.setOnKeyListener(onKeyListener);
        if (tabSpec.mIndicatorStrategy instanceof ViewIndicatorStrategy) {
            this.mTabWidget.setStripEnabled(false);
        }
        this.mTabWidget.addView(view);
        boolean bl = this.mTabSpecs.add(tabSpec);
        if (this.mCurrentTab != -1) {
            return;
        }
        this.setCurrentTab(0);
    }

    public void clearAllTabs() {
        this.mTabWidget.removeAllViews();
        this.initTabHost();
        this.mTabContent.removeAllViews();
        this.mTabSpecs.clear();
        this.requestLayout();
        this.invalidate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        boolean bl = super.dispatchKeyEvent(keyEvent);
        if (bl) return bl;
        if (keyEvent.getAction() != 0) return bl;
        if (keyEvent.getKeyCode() != 19) return bl;
        if (this.mCurrentView == null) return bl;
        if (!this.mCurrentView.isRootNamespace()) return bl;
        if (!this.mCurrentView.hasFocus()) return bl;
        if (this.mCurrentView.findFocus().focusSearch(33) != null) return bl;
        TabWidget tabWidget = this.mTabWidget;
        int n = this.mCurrentTab;
        boolean bl2 = tabWidget.getChildTabViewAt(n).requestFocus();
        this.playSoundEffect(2);
        return true;
    }

    @Override
    public void dispatchWindowFocusChanged(boolean bl) {
        if (this.mCurrentView == null) {
            return;
        }
        this.mCurrentView.dispatchWindowFocusChanged(bl);
    }

    public int getCurrentTab() {
        return this.mCurrentTab;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getCurrentTabTag() {
        if (this.mCurrentTab < 0) return null;
        int n = this.mCurrentTab;
        int n2 = this.mTabSpecs.size();
        if (n >= n2) return null;
        List<TabSpec> list = this.mTabSpecs;
        int n3 = this.mCurrentTab;
        return list.get(n3).getTag();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public View getCurrentTabView() {
        if (this.mCurrentTab < 0) return null;
        int n = this.mCurrentTab;
        int n2 = this.mTabSpecs.size();
        if (n >= n2) return null;
        TabWidget tabWidget = this.mTabWidget;
        int n3 = this.mCurrentTab;
        return tabWidget.getChildTabViewAt(n3);
    }

    public View getCurrentView() {
        return this.mCurrentView;
    }

    public FrameLayout getTabContentView() {
        return this.mTabContent;
    }

    public TabWidget getTabWidget() {
        return this.mTabWidget;
    }

    public TabSpec newTabSpec(String string2) {
        return new TabSpec(string2);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        ViewTreeObserver viewTreeObserver = this.getViewTreeObserver();
        if (viewTreeObserver == null) {
            return;
        }
        viewTreeObserver.addOnTouchModeChangeListener(this);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        ViewTreeObserver viewTreeObserver = this.getViewTreeObserver();
        if (viewTreeObserver == null) {
            return;
        }
        viewTreeObserver.removeOnTouchModeChangeListener(this);
    }

    @Override
    public void onTouchModeChanged(boolean bl) {
        if (bl) {
            return;
        }
        if (this.mCurrentView == null) {
            return;
        }
        if (this.mCurrentView.hasFocus() && !this.mCurrentView.isFocused()) {
            return;
        }
        TabWidget tabWidget = this.mTabWidget;
        int n = this.mCurrentTab;
        boolean bl2 = tabWidget.getChildTabViewAt(n).requestFocus();
    }

    public void setCurrentTab(int n) {
        View view;
        if (n < 0) {
            return;
        }
        int n2 = this.mTabSpecs.size();
        if (n >= n2) {
            return;
        }
        int n3 = this.mCurrentTab;
        if (n != n3) {
            return;
        }
        if (this.mCurrentTab != -1) {
            List<TabSpec> list = this.mTabSpecs;
            int n4 = this.mCurrentTab;
            list.get(n4).mContentStrategy.tabClosed();
        }
        this.mCurrentTab = n;
        TabSpec tabSpec = this.mTabSpecs.get(n);
        TabWidget tabWidget = this.mTabWidget;
        int n5 = this.mCurrentTab;
        tabWidget.focusCurrentTab(n5);
        this.mCurrentView = view = tabSpec.mContentStrategy.getContentView();
        if (this.mCurrentView.getParent() == null) {
            FrameLayout frameLayout = this.mTabContent;
            View view2 = this.mCurrentView;
            ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
            frameLayout.addView(view2, layoutParams);
        }
        if (!this.mTabWidget.hasFocus()) {
            boolean bl = this.mCurrentView.requestFocus();
        }
        this.invokeOnTabChangeListener();
    }

    public void setCurrentTabByTag(String string2) {
        int n = 0;
        int n2;
        while (n < (n2 = this.mTabSpecs.size())) {
            if (this.mTabSpecs.get(n).getTag().equals(string2)) {
                this.setCurrentTab(n);
                return;
            }
            ++n;
        }
        return;
    }

    public void setOnTabChangedListener(OnTabChangeListener onTabChangeListener) {
        this.mOnTabChangeListener = onTabChangeListener;
    }

    public void setup() {
        FrameLayout frameLayout;
        View.OnKeyListener onKeyListener;
        TabWidget tabWidget;
        this.mTabWidget = tabWidget = (TabWidget)this.findViewById(16908307);
        if (this.mTabWidget == null) {
            throw new RuntimeException("Your TabHost must have a TabWidget whose id attribute is 'android.R.id.tabs'");
        }
        this.mTabKeyListener = onKeyListener = new View.OnKeyListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean onKey(View view, int n, KeyEvent keyEvent) {
                switch (n) {
                    default: {
                        boolean bl = TabHost.this.mTabContent.requestFocus(2);
                        return TabHost.this.mTabContent.dispatchKeyEvent(keyEvent);
                    }
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 66: 
                }
                return false;
            }
        };
        TabWidget tabWidget2 = this.mTabWidget;
        TabWidget.OnTabSelectionChanged onTabSelectionChanged = new TabWidget.OnTabSelectionChanged(){

            @Override
            public void onTabSelectionChanged(int n, boolean bl) {
                TabHost.this.setCurrentTab(n);
                if (!bl) {
                    return;
                }
                boolean bl2 = TabHost.this.mTabContent.requestFocus(2);
            }
        };
        tabWidget2.setTabSelectionListener(onTabSelectionChanged);
        this.mTabContent = frameLayout = (FrameLayout)this.findViewById(0x1020011);
        if (this.mTabContent != null) {
            return;
        }
        throw new RuntimeException("Your TabHost must have a FrameLayout whose id attribute is 'android.R.id.tabcontent'");
    }

    public void setup(LocalActivityManager localActivityManager) {
        this.setup();
        this.mLocalActivityManager = localActivityManager;
    }

    private class IntentContentStrategy
    implements ContentStrategy {
        private final Intent mIntent;
        private View mLaunchedView;
        private final String mTag;

        private IntentContentStrategy(String string2, Intent intent) {
            this.mTag = string2;
            this.mIntent = intent;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public View getContentView() {
            if (TabHost.this.mLocalActivityManager == null) {
                throw new IllegalStateException("Did you forget to call 'public void setup(LocalActivityManager activityGroup)'?");
            }
            LocalActivityManager localActivityManager = TabHost.this.mLocalActivityManager;
            String string2 = this.mTag;
            Intent intent = this.mIntent;
            Window window = localActivityManager.startActivity(string2, intent);
            View view = window != null ? window.getDecorView() : null;
            if (this.mLaunchedView != view && this.mLaunchedView != null && this.mLaunchedView.getParent() != null) {
                FrameLayout frameLayout = TabHost.this.mTabContent;
                View view2 = this.mLaunchedView;
                frameLayout.removeView(view2);
            }
            this.mLaunchedView = view;
            if (this.mLaunchedView != null) {
                this.mLaunchedView.setVisibility(0);
                this.mLaunchedView.setFocusableInTouchMode(true);
                ((ViewGroup)this.mLaunchedView).setDescendantFocusability(262144);
            }
            return this.mLaunchedView;
        }

        @Override
        public void tabClosed() {
            if (this.mLaunchedView == null) {
                return;
            }
            this.mLaunchedView.setVisibility(8);
        }
    }

    private class FactoryContentStrategy
    implements ContentStrategy {
        private TabContentFactory mFactory;
        private View mTabContent;
        private final CharSequence mTag;

        public FactoryContentStrategy(CharSequence charSequence, TabContentFactory tabContentFactory) {
            this.mTag = charSequence;
            this.mFactory = tabContentFactory;
        }

        @Override
        public View getContentView() {
            if (this.mTabContent == null) {
                View view;
                TabContentFactory tabContentFactory = this.mFactory;
                String string2 = ((Object)this.mTag).toString();
                this.mTabContent = view = tabContentFactory.createTabContent(string2);
            }
            this.mTabContent.setVisibility(0);
            return this.mTabContent;
        }

        @Override
        public void tabClosed() {
            this.mTabContent.setVisibility(8);
        }
    }

    private class ViewIdContentStrategy
    implements ContentStrategy {
        private final View mView;

        private ViewIdContentStrategy(int n) {
            View view;
            this.mView = view = TabHost.this.mTabContent.findViewById(n);
            if (this.mView != null) {
                this.mView.setVisibility(8);
                return;
            }
            String string2 = "Could not create tab content because could not find view with id " + n;
            throw new RuntimeException(string2);
        }

        @Override
        public View getContentView() {
            this.mView.setVisibility(0);
            return this.mView;
        }

        @Override
        public void tabClosed() {
            this.mView.setVisibility(8);
        }
    }

    private class ViewIndicatorStrategy
    implements IndicatorStrategy {
        private final View mView;

        private ViewIndicatorStrategy(View view) {
            this.mView = view;
        }

        @Override
        public View createIndicatorView() {
            return this.mView;
        }
    }

    private class LabelAndIconIndicatorStrategy
    implements IndicatorStrategy {
        private final Drawable mIcon;
        private final CharSequence mLabel;

        private LabelAndIconIndicatorStrategy(CharSequence charSequence, Drawable drawable2) {
            this.mLabel = charSequence;
            this.mIcon = drawable2;
        }

        @Override
        public View createIndicatorView() {
            Context context = TabHost.this.getContext();
            LayoutInflater layoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
            TabWidget tabWidget = TabHost.this.mTabWidget;
            View view = layoutInflater.inflate(17367139, (ViewGroup)tabWidget, false);
            TextView textView = (TextView)view.findViewById(16908310);
            CharSequence charSequence = this.mLabel;
            textView.setText(charSequence);
            ImageView imageView = (ImageView)view.findViewById(16908294);
            Drawable drawable2 = this.mIcon;
            imageView.setImageDrawable(drawable2);
            if (context.getApplicationInfo().targetSdkVersion <= 4) {
                view.setBackgroundResource(17302278);
                ColorStateList colorStateList = context.getResources().getColorStateList(17170488);
                textView.setTextColor(colorStateList);
            }
            return view;
        }
    }

    private class LabelIndicatorStrategy
    implements IndicatorStrategy {
        private final CharSequence mLabel;

        private LabelIndicatorStrategy(CharSequence charSequence) {
            this.mLabel = charSequence;
        }

        @Override
        public View createIndicatorView() {
            Context context = TabHost.this.getContext();
            LayoutInflater layoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
            TabWidget tabWidget = TabHost.this.mTabWidget;
            View view = layoutInflater.inflate(17367139, (ViewGroup)tabWidget, false);
            TextView textView = (TextView)view.findViewById(16908310);
            CharSequence charSequence = this.mLabel;
            textView.setText(charSequence);
            if (context.getApplicationInfo().targetSdkVersion <= 4) {
                view.setBackgroundResource(17302278);
                ColorStateList colorStateList = context.getResources().getColorStateList(17170488);
                textView.setTextColor(colorStateList);
            }
            return view;
        }
    }

    private static interface ContentStrategy {
        public View getContentView();

        public void tabClosed();
    }

    private static interface IndicatorStrategy {
        public View createIndicatorView();
    }

    public class TabSpec {
        private ContentStrategy mContentStrategy;
        private IndicatorStrategy mIndicatorStrategy;
        private String mTag;

        private TabSpec(String string2) {
            this.mTag = string2;
        }

        public String getTag() {
            return this.mTag;
        }

        public TabSpec setContent(int n) {
            TabHost tabHost = TabHost.this;
            ViewIdContentStrategy viewIdContentStrategy = tabHost.new ViewIdContentStrategy(n);
            this.mContentStrategy = viewIdContentStrategy;
            return this;
        }

        public TabSpec setContent(Intent intent) {
            TabHost tabHost = TabHost.this;
            String string2 = this.mTag;
            IntentContentStrategy intentContentStrategy = tabHost.new IntentContentStrategy(string2, intent);
            this.mContentStrategy = intentContentStrategy;
            return this;
        }

        public TabSpec setContent(TabContentFactory tabContentFactory) {
            TabHost tabHost = TabHost.this;
            String string2 = this.mTag;
            FactoryContentStrategy factoryContentStrategy = tabHost.new FactoryContentStrategy(string2, tabContentFactory);
            this.mContentStrategy = factoryContentStrategy;
            return this;
        }

        public TabSpec setIndicator(View view) {
            TabHost tabHost = TabHost.this;
            ViewIndicatorStrategy viewIndicatorStrategy = tabHost.new ViewIndicatorStrategy(view);
            this.mIndicatorStrategy = viewIndicatorStrategy;
            return this;
        }

        public TabSpec setIndicator(CharSequence charSequence) {
            TabHost tabHost = TabHost.this;
            LabelIndicatorStrategy labelIndicatorStrategy = tabHost.new LabelIndicatorStrategy(charSequence);
            this.mIndicatorStrategy = labelIndicatorStrategy;
            return this;
        }

        public TabSpec setIndicator(CharSequence charSequence, Drawable drawable2) {
            TabHost tabHost = TabHost.this;
            LabelAndIconIndicatorStrategy labelAndIconIndicatorStrategy = tabHost.new LabelAndIconIndicatorStrategy(charSequence, drawable2);
            this.mIndicatorStrategy = labelAndIconIndicatorStrategy;
            return this;
        }
    }

    public static interface TabContentFactory {
        public View createTabContent(String var1);
    }

    public static interface OnTabChangeListener {
        public void onTabChanged(String var1);
    }
}

