/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.android.internal.R;

public class TabWidget
extends LinearLayout
implements View.OnFocusChangeListener {
    private final Rect mBounds;
    private Drawable mDividerDrawable;
    private boolean mDrawBottomStrips = true;
    private Drawable mLeftStrip;
    private Drawable mRightStrip;
    private int mSelectedTab = 0;
    private OnTabSelectionChanged mSelectionChangedListener;
    private boolean mStripMoved;

    public TabWidget(Context context) {
        this(context, null);
    }

    public TabWidget(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842883);
    }

    public TabWidget(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet);
        Drawable drawable2;
        Drawable drawable3;
        Drawable drawable4;
        boolean bl;
        Rect rect;
        this.mBounds = rect = new Rect();
        int[] nArray = R.styleable.TabWidget;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, n, 0);
        this.mDrawBottomStrips = bl = typedArray.getBoolean(3, true);
        this.mDividerDrawable = drawable4 = typedArray.getDrawable(0);
        this.mLeftStrip = drawable3 = typedArray.getDrawable(1);
        this.mRightStrip = drawable2 = typedArray.getDrawable(2);
        typedArray.recycle();
        this.initTabWidget();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initTabWidget() {
        int n;
        this.setOrientation(0);
        this.mGroupFlags = n = this.mGroupFlags | 0x400;
        Context context = this.mContext;
        Resources resources = context.getResources();
        if (context.getApplicationInfo().targetSdkVersion <= 4) {
            if (this.mLeftStrip == null) {
                Drawable drawable2;
                this.mLeftStrip = drawable2 = resources.getDrawable(17302271);
            }
            if (this.mRightStrip == null) {
                Drawable drawable3;
                this.mRightStrip = drawable3 = resources.getDrawable(17302273);
            }
        } else {
            if (this.mLeftStrip == null) {
                Drawable drawable4;
                this.mLeftStrip = drawable4 = resources.getDrawable(17302270);
            }
            if (this.mRightStrip == null) {
                Drawable drawable5;
                this.mRightStrip = drawable5 = resources.getDrawable(17302272);
            }
        }
        this.setFocusable(true);
        this.setOnFocusChangeListener(this);
    }

    @Override
    public void addView(View view) {
        if (view.getLayoutParams() == null) {
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(0, -1, 1.0f);
            layoutParams.setMargins(0, 0, 0, 0);
            view.setLayoutParams(layoutParams);
        }
        view.setFocusable(true);
        view.setClickable(true);
        if (this.mDividerDrawable != null && this.getTabCount() > 0) {
            Context context = this.mContext;
            ImageView imageView = new ImageView(context);
            int n = this.mDividerDrawable.getIntrinsicWidth();
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(n, -1);
            layoutParams.setMargins(0, 0, 0, 0);
            imageView.setLayoutParams(layoutParams);
            Drawable drawable2 = this.mDividerDrawable;
            imageView.setBackgroundDrawable(drawable2);
            super.addView(imageView);
        }
        super.addView(view);
        int n = this.getTabCount() - 1;
        TabClickListener tabClickListener = new TabClickListener(n);
        view.setOnClickListener(tabClickListener);
        view.setOnFocusChangeListener(this);
    }

    @Override
    public void childDrawableStateChanged(View view) {
        int n;
        View view2;
        if (this.getTabCount() > 0 && view == (view2 = this.getChildTabViewAt(n = this.mSelectedTab))) {
            this.invalidate();
        }
        super.childDrawableStateChanged(view);
    }

    @Override
    public void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.getTabCount() == 0) {
            return;
        }
        if (!this.mDrawBottomStrips) {
            return;
        }
        int n = this.mSelectedTab;
        View view = this.getChildTabViewAt(n);
        Drawable drawable2 = this.mLeftStrip;
        Drawable drawable3 = this.mRightStrip;
        int[] nArray = view.getDrawableState();
        boolean bl = drawable2.setState(nArray);
        int[] nArray2 = view.getDrawableState();
        boolean bl2 = drawable3.setState(nArray2);
        if (this.mStripMoved) {
            int n2;
            int n3;
            Rect rect = this.mBounds;
            rect.left = n3 = view.getLeft();
            rect.right = n2 = view.getRight();
            int n4 = this.getHeight();
            int n5 = rect.left;
            int n6 = drawable2.getIntrinsicWidth();
            int n7 = n5 - n6;
            int n8 = Math.min(0, n7);
            int n9 = drawable2.getIntrinsicHeight();
            int n10 = n4 - n9;
            int n11 = rect.left;
            drawable2.setBounds(n8, n10, n11, n4);
            int n12 = rect.right;
            int n13 = drawable3.getIntrinsicHeight();
            int n14 = n4 - n13;
            int n15 = this.getWidth();
            int n16 = rect.right;
            int n17 = drawable3.getIntrinsicWidth();
            int n18 = n16 + n17;
            int n19 = Math.max(n15, n18);
            drawable3.setBounds(n12, n14, n19, n4);
            this.mStripMoved = false;
        }
        drawable2.draw(canvas);
        drawable3.draw(canvas);
    }

    public void focusCurrentTab(int n) {
        int n2 = this.mSelectedTab;
        this.setCurrentTab(n);
        if (n2 != n) {
            return;
        }
        boolean bl = this.getChildTabViewAt(n).requestFocus();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int getChildDrawingOrder(int n, int n2) {
        int n3 = n - 1;
        if (n2 != n3) {
            return this.mSelectedTab;
        }
        int n4 = this.mSelectedTab;
        if (n2 < n4) return n2;
        return n2 + 1;
    }

    public View getChildTabViewAt(int n) {
        if (this.mDividerDrawable != null) {
            n *= 2;
        }
        return this.getChildAt(n);
    }

    public int getTabCount() {
        int n = this.getChildCount();
        if (this.mDividerDrawable != null) {
            n = (n + 1) / 2;
        }
        return n;
    }

    public boolean isStripEnabled() {
        return this.mDrawBottomStrips;
    }

    @Override
    public void onFocusChange(View view, boolean bl) {
        if (view == this && bl && this.getTabCount() > 0) {
            int n = this.mSelectedTab;
            boolean bl2 = this.getChildTabViewAt(n).requestFocus();
            return;
        }
        if (!bl) {
            return;
        }
        int n = 0;
        int n2 = this.getTabCount();
        while (n < n2) {
            if (this.getChildTabViewAt(n) == view) {
                this.setCurrentTab(n);
                this.mSelectionChangedListener.onTabSelectionChanged(n, false);
                return;
            }
            ++n;
        }
        return;
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        this.mStripMoved = true;
        super.onSizeChanged(n, n2, n3, n4);
    }

    public void setCurrentTab(int n) {
        if (n < 0) {
            return;
        }
        int n2 = this.getTabCount();
        if (n >= n2) {
            return;
        }
        int n3 = this.mSelectedTab;
        this.getChildTabViewAt(n3).setSelected(false);
        int n4 = this.mSelectedTab = n;
        this.getChildTabViewAt(n4).setSelected(true);
        this.mStripMoved = true;
    }

    public void setDividerDrawable(int n) {
        Drawable drawable2;
        this.mDividerDrawable = drawable2 = this.mContext.getResources().getDrawable(n);
        this.requestLayout();
        this.invalidate();
    }

    public void setDividerDrawable(Drawable drawable2) {
        this.mDividerDrawable = drawable2;
        this.requestLayout();
        this.invalidate();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        int n = this.getTabCount();
        int n2 = 0;
        while (n2 < n) {
            this.getChildTabViewAt(n2).setEnabled(bl);
            ++n2;
        }
        return;
    }

    public void setLeftStripDrawable(int n) {
        Drawable drawable2;
        this.mLeftStrip = drawable2 = this.mContext.getResources().getDrawable(n);
        this.requestLayout();
        this.invalidate();
    }

    public void setLeftStripDrawable(Drawable drawable2) {
        this.mLeftStrip = drawable2;
        this.requestLayout();
        this.invalidate();
    }

    public void setRightStripDrawable(int n) {
        Drawable drawable2;
        this.mRightStrip = drawable2 = this.mContext.getResources().getDrawable(n);
        this.requestLayout();
        this.invalidate();
    }

    public void setRightStripDrawable(Drawable drawable2) {
        this.mRightStrip = drawable2;
        this.requestLayout();
        this.invalidate();
    }

    public void setStripEnabled(boolean bl) {
        this.mDrawBottomStrips = bl;
        this.invalidate();
    }

    void setTabSelectionListener(OnTabSelectionChanged onTabSelectionChanged) {
        this.mSelectionChangedListener = onTabSelectionChanged;
    }

    static interface OnTabSelectionChanged {
        public void onTabSelectionChanged(int var1, boolean var2);
    }

    private class TabClickListener
    implements View.OnClickListener {
        private final int mTabIndex;

        private TabClickListener(int n) {
            this.mTabIndex = n;
        }

        @Override
        public void onClick(View view) {
            OnTabSelectionChanged onTabSelectionChanged = TabWidget.this.mSelectionChangedListener;
            int n = this.mTabIndex;
            onTabSelectionChanged.onTabSelectionChanged(n, true);
        }
    }
}

