/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.SparseBooleanArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TableRow;
import com.android.internal.R;
import java.util.regex.Pattern;

public class TableLayout
extends LinearLayout {
    private SparseBooleanArray mCollapsedColumns;
    private boolean mInitialized;
    private int[] mMaxWidths;
    private PassThroughHierarchyChangeListener mPassThroughListener;
    private boolean mShrinkAllColumns;
    private SparseBooleanArray mShrinkableColumns;
    private boolean mStretchAllColumns;
    private SparseBooleanArray mStretchableColumns;

    public TableLayout(Context context) {
        super(context);
        this.initTableLayout();
    }

    /*
     * Enabled aggressive block sorting
     */
    public TableLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        String string2;
        String string3;
        int[] nArray = R.styleable.TableLayout;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray);
        String string4 = typedArray.getString(0);
        if (string4 != null) {
            if (string4.charAt(0) == '*') {
                this.mStretchAllColumns = true;
            } else {
                SparseBooleanArray sparseBooleanArray;
                this.mStretchableColumns = sparseBooleanArray = TableLayout.parseColumns(string4);
            }
        }
        if ((string3 = typedArray.getString(1)) != null) {
            if (string3.charAt(0) == '*') {
                this.mShrinkAllColumns = true;
            } else {
                SparseBooleanArray sparseBooleanArray;
                this.mShrinkableColumns = sparseBooleanArray = TableLayout.parseColumns(string3);
            }
        }
        if ((string2 = typedArray.getString(2)) != null) {
            SparseBooleanArray sparseBooleanArray;
            this.mCollapsedColumns = sparseBooleanArray = TableLayout.parseColumns(string2);
        }
        typedArray.recycle();
        this.initTableLayout();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void findLargestCells(int n) {
        int n2 = this.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            TableLayout tableLayout = this;
            int n5 = n3;
            View view = tableLayout.getChildAt(n5);
            int n6 = view.getVisibility();
            if (n6 != (n4 = 8) && view instanceof TableRow) {
                int n7;
                int n8;
                int n9;
                TableRow tableRow = (TableRow)view;
                ViewGroup.LayoutParams layoutParams = tableRow.getLayoutParams();
                layoutParams.height = n9 = 65534;
                TableRow tableRow2 = tableRow;
                int n10 = n;
                int[] nArray = tableRow2.getColumnsWidths(n10);
                int n11 = nArray.length;
                if (this.mMaxWidths == null || (n8 = this.mMaxWidths.length) != (n7 = n11)) {
                    int[] nArray2 = new int[n11];
                    this.mMaxWidths = nArray2;
                }
                int[] nArray3 = this.mMaxWidths;
                int[] nArray4 = nArray;
                int n12 = 0;
                int[] nArray5 = nArray3;
                int n13 = 0;
                int n14 = n11;
                System.arraycopy(nArray4, n12, nArray5, n13, n14);
            }
            ++n3;
        }
        return;
    }

    private void initTableLayout() {
        PassThroughHierarchyChangeListener passThroughHierarchyChangeListener;
        if (this.mCollapsedColumns == null) {
            SparseBooleanArray sparseBooleanArray;
            this.mCollapsedColumns = sparseBooleanArray = new SparseBooleanArray();
        }
        if (this.mStretchableColumns == null) {
            SparseBooleanArray sparseBooleanArray;
            this.mStretchableColumns = sparseBooleanArray = new SparseBooleanArray();
        }
        if (this.mShrinkableColumns == null) {
            SparseBooleanArray sparseBooleanArray;
            this.mShrinkableColumns = sparseBooleanArray = new SparseBooleanArray();
        }
        PassThroughHierarchyChangeListener passThroughHierarchyChangeListener2 = this.mPassThroughListener = (passThroughHierarchyChangeListener = new PassThroughHierarchyChangeListener());
        super.setOnHierarchyChangeListener(passThroughHierarchyChangeListener2);
        this.mInitialized = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void mutateColumnsWidth(SparseBooleanArray sparseBooleanArray, boolean bl, int n, int n2) {
        int n3;
        int n4 = 0;
        int[] nArray = this.mMaxWidths;
        int n5 = nArray.length;
        int n6 = bl ? n5 : sparseBooleanArray.size();
        int n7 = (n - n2) / n6;
        int n8 = this.getChildCount();
        for (int i = 0; i < n8; ++i) {
            View view = this.getChildAt(i);
            if (!(view instanceof TableRow)) continue;
            view.forceLayout();
        }
        if (!bl) {
            for (n3 = 0; n3 < n6; ++n3) {
                int n9 = sparseBooleanArray.keyAt(n3);
                if (!sparseBooleanArray.valueAt(n3)) continue;
                if (n9 < n5) {
                    int n10;
                    nArray[n9] = n10 = nArray[n9] + n7;
                    continue;
                }
                ++n4;
            }
            if (n4 <= 0) {
                return;
            }
            if (n4 >= n6) {
                return;
            }
        } else {
            int n11 = 0;
            while (true) {
                int n12;
                if (n11 >= n6) {
                    return;
                }
                nArray[n11] = n12 = nArray[n11] + n7;
                ++n11;
            }
        }
        int n13 = n4 * n7;
        int n14 = n6 - n4;
        n7 = n13 / n14;
        n3 = 0;
        while (n3 < n6) {
            int n15 = sparseBooleanArray.keyAt(n3);
            if (sparseBooleanArray.valueAt(n3) && n15 < n5) {
                int n16;
                int n17 = nArray[n15];
                nArray[n15] = n7 > n17 ? 0 : (n16 = nArray[n15] + n7);
            }
            ++n3;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SparseBooleanArray parseColumns(String string2) {
        SparseBooleanArray sparseBooleanArray = new SparseBooleanArray();
        String[] stringArray = Pattern.compile("\\s*,\\s*").split(string2);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string3 = stringArray[n2];
            try {
                int n3 = Integer.parseInt(string3);
                if (n3 >= 0) {
                    sparseBooleanArray.put(n3, true);
                }
            }
            catch (NumberFormatException numberFormatException) {}
            ++n2;
        }
        return sparseBooleanArray;
    }

    private void requestRowsLayout() {
        if (!this.mInitialized) {
            return;
        }
        int n = this.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            this.getChildAt(n2).requestLayout();
            ++n2;
        }
        return;
    }

    private void shrinkAndStretchColumns(int n) {
        int n2;
        int n3;
        if (this.mMaxWidths == null) {
            return;
        }
        int n4 = 0;
        for (int n5 : this.mMaxWidths) {
            n4 += n5;
        }
        int n6 = View.MeasureSpec.getSize(n);
        int n7 = n6 - (n3 = this.mPaddingLeft);
        int n8 = n7 - (n2 = this.mPaddingRight);
        if (n4 > n8 && (this.mShrinkAllColumns || this.mShrinkableColumns.size() > 0)) {
            SparseBooleanArray sparseBooleanArray = this.mShrinkableColumns;
            boolean bl = this.mShrinkAllColumns;
            this.mutateColumnsWidth(sparseBooleanArray, bl, n8, n4);
            return;
        }
        if (n4 >= n8) {
            return;
        }
        if (!this.mStretchAllColumns && this.mStretchableColumns.size() <= 0) {
            return;
        }
        SparseBooleanArray sparseBooleanArray = this.mStretchableColumns;
        boolean bl = this.mStretchAllColumns;
        this.mutateColumnsWidth(sparseBooleanArray, bl, n8, n4);
    }

    private void trackCollapsedColumns(View view) {
        if (!(view instanceof TableRow)) {
            return;
        }
        TableRow tableRow = (TableRow)view;
        SparseBooleanArray sparseBooleanArray = this.mCollapsedColumns;
        int n = sparseBooleanArray.size();
        int n2 = 0;
        while (n2 < n) {
            int n3 = sparseBooleanArray.keyAt(n2);
            boolean bl = sparseBooleanArray.valueAt(n2);
            if (bl) {
                tableRow.setColumnCollapsed(n3, bl);
            }
            ++n2;
        }
        return;
    }

    @Override
    public void addView(View view) {
        super.addView(view);
        this.requestRowsLayout();
    }

    @Override
    public void addView(View view, int n) {
        super.addView(view, n);
        this.requestRowsLayout();
    }

    @Override
    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        super.addView(view, n, layoutParams);
        this.requestRowsLayout();
    }

    @Override
    public void addView(View view, ViewGroup.LayoutParams layoutParams) {
        super.addView(view, layoutParams);
        this.requestRowsLayout();
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    @Override
    protected LinearLayout.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    @Override
    protected LinearLayout.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new LayoutParams(layoutParams);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        Context context = this.getContext();
        return new LayoutParams(context, attributeSet);
    }

    public boolean isColumnCollapsed(int n) {
        return this.mCollapsedColumns.get(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isColumnShrinkable(int n) {
        if (this.mShrinkAllColumns) return true;
        if (!this.mShrinkableColumns.get(n)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isColumnStretchable(int n) {
        if (this.mStretchAllColumns) return true;
        if (!this.mStretchableColumns.get(n)) return false;
        return true;
    }

    public boolean isShrinkAllColumns() {
        return this.mShrinkAllColumns;
    }

    public boolean isStretchAllColumns() {
        return this.mStretchAllColumns;
    }

    @Override
    void measureChildBeforeLayout(View view, int n, int n2, int n3, int n4, int n5) {
        if (view instanceof TableRow) {
            TableRow tableRow = (TableRow)view;
            int[] nArray = this.mMaxWidths;
            tableRow.setColumnsWidthConstraints(nArray);
        }
        super.measureChildBeforeLayout(view, n, n2, n3, n4, n5);
    }

    @Override
    void measureVertical(int n, int n2) {
        this.findLargestCells(n);
        this.shrinkAndStretchColumns(n);
        super.measureVertical(n, n2);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        this.layoutVertical();
    }

    @Override
    protected void onMeasure(int n, int n2) {
        this.measureVertical(n, n2);
    }

    @Override
    public void requestLayout() {
        if (this.mInitialized) {
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                this.getChildAt(i).forceLayout();
            }
        }
        super.requestLayout();
    }

    public void setColumnCollapsed(int n, boolean bl) {
        this.mCollapsedColumns.put(n, bl);
        int n2 = this.getChildCount();
        for (int i = 0; i < n2; ++i) {
            View view = this.getChildAt(i);
            if (!(view instanceof TableRow)) continue;
            ((TableRow)view).setColumnCollapsed(n, bl);
        }
        this.requestRowsLayout();
    }

    public void setColumnShrinkable(int n, boolean bl) {
        this.mShrinkableColumns.put(n, bl);
        this.requestRowsLayout();
    }

    public void setColumnStretchable(int n, boolean bl) {
        this.mStretchableColumns.put(n, bl);
        this.requestRowsLayout();
    }

    @Override
    public void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener) {
        ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener2 = PassThroughHierarchyChangeListener.access$102(this.mPassThroughListener, onHierarchyChangeListener);
    }

    public void setShrinkAllColumns(boolean bl) {
        this.mShrinkAllColumns = bl;
    }

    public void setStretchAllColumns(boolean bl) {
        this.mStretchAllColumns = bl;
    }

    private class PassThroughHierarchyChangeListener
    implements ViewGroup.OnHierarchyChangeListener {
        private ViewGroup.OnHierarchyChangeListener mOnHierarchyChangeListener;

        private PassThroughHierarchyChangeListener() {
        }

        static /* synthetic */ ViewGroup.OnHierarchyChangeListener access$102(PassThroughHierarchyChangeListener passThroughHierarchyChangeListener, ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener) {
            passThroughHierarchyChangeListener.mOnHierarchyChangeListener = onHierarchyChangeListener;
            return onHierarchyChangeListener;
        }

        @Override
        public void onChildViewAdded(View view, View view2) {
            TableLayout.this.trackCollapsedColumns(view2);
            if (this.mOnHierarchyChangeListener == null) {
                return;
            }
            this.mOnHierarchyChangeListener.onChildViewAdded(view, view2);
        }

        @Override
        public void onChildViewRemoved(View view, View view2) {
            if (this.mOnHierarchyChangeListener == null) {
                return;
            }
            this.mOnHierarchyChangeListener.onChildViewRemoved(view, view2);
        }
    }

    public static class LayoutParams
    extends LinearLayout.LayoutParams {
        public LayoutParams() {
            super(-1, -1);
        }

        public LayoutParams(int n, int n2) {
            super(-1, n2);
        }

        public LayoutParams(int n, int n2, float f) {
            super(-1, n2, f);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }

        @Override
        protected void setBaseAttributes(TypedArray typedArray, int n, int n2) {
            this.width = -1;
            if (typedArray.hasValue(n2)) {
                int n3;
                this.height = n3 = typedArray.getLayoutDimension(n2, "layout_height");
                return;
            }
            this.height = -1;
        }
    }
}

