/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.SparseIntArray;
import android.view.Gravity;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.android.internal.R;

public class TableRow
extends LinearLayout {
    private ChildrenTracker mChildrenTracker;
    private SparseIntArray mColumnToChildIndex;
    private int[] mColumnWidths;
    private int[] mConstrainedColumnWidths;
    private int mNumColumns = 0;

    public TableRow(Context context) {
        super(context);
        this.initTableRow();
    }

    public TableRow(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initTableRow();
    }

    static /* synthetic */ SparseIntArray access$302(TableRow tableRow, SparseIntArray sparseIntArray) {
        tableRow.mColumnToChildIndex = sparseIntArray;
        return sparseIntArray;
    }

    private void initTableRow() {
        ChildrenTracker childrenTracker;
        ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener = this.mOnHierarchyChangeListener;
        this.mChildrenTracker = childrenTracker = new ChildrenTracker();
        if (onHierarchyChangeListener != null) {
            this.mChildrenTracker.setOnHierarchyChangeListener(onHierarchyChangeListener);
        }
        ChildrenTracker childrenTracker2 = this.mChildrenTracker;
        super.setOnHierarchyChangeListener(childrenTracker2);
    }

    private void mapIndexAndColumns() {
        SparseIntArray sparseIntArray;
        if (this.mColumnToChildIndex != null) {
            return;
        }
        int n = 0;
        int n2 = this.getChildCount();
        SparseIntArray sparseIntArray2 = this.mColumnToChildIndex = (sparseIntArray = new SparseIntArray());
        for (int i = 0; i < n2; ++i) {
            int n3;
            LayoutParams layoutParams = (LayoutParams)this.getChildAt(i).getLayoutParams();
            if (layoutParams.column >= n) {
                n = layoutParams.column;
            }
            for (int j = 0; j < (n3 = layoutParams.span); ++j) {
                int n4 = n + 1;
                sparseIntArray2.put(n, i);
                n = n4;
            }
        }
        this.mNumColumns = n;
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    @Override
    protected LinearLayout.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    @Override
    protected LinearLayout.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new LayoutParams(layoutParams);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        Context context = this.getContext();
        return new LayoutParams(context, attributeSet);
    }

    @Override
    int getChildrenSkipCount(View view, int n) {
        return ((LayoutParams)view.getLayoutParams()).span - 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    int[] getColumnsWidths(int n) {
        int n2;
        int n3 = this.getVirtualChildCount();
        if (this.mColumnWidths == null || n3 != (n2 = this.mColumnWidths.length)) {
            int[] nArray = new int[n3];
            this.mColumnWidths = nArray;
        }
        int[] nArray = this.mColumnWidths;
        int n4 = 0;
        while (n4 < n3) {
            View view = this.getVirtualChildAt(n4);
            if (view != null && view.getVisibility() != 8) {
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                if (layoutParams.span == 1) {
                    int n5;
                    int n6;
                    switch (layoutParams.width) {
                        default: {
                            n6 = View.MeasureSpec.makeMeasureSpec(layoutParams.width, 0x40000000);
                            break;
                        }
                        case -2: {
                            n6 = TableRow.getChildMeasureSpec(n, 0, -1);
                            break;
                        }
                        case -1: {
                            n6 = View.MeasureSpec.makeMeasureSpec(0, 0);
                        }
                    }
                    view.measure(n6, n6);
                    int n7 = view.getMeasuredWidth();
                    int n8 = layoutParams.leftMargin;
                    int n9 = n7 + n8;
                    int n10 = layoutParams.rightMargin;
                    nArray[n4] = n5 = n9 + n10;
                } else {
                    nArray[n4] = 0;
                }
            } else {
                nArray[n4] = 0;
            }
            ++n4;
        }
        return nArray;
    }

    @Override
    int getLocationOffset(View view) {
        return ((LayoutParams)view.getLayoutParams()).mOffset[0];
    }

    @Override
    int getNextLocationOffset(View view) {
        return ((LayoutParams)view.getLayoutParams()).mOffset[1];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public View getVirtualChildAt(int n) {
        int n2;
        if (this.mColumnToChildIndex == null) {
            this.mapIndexAndColumns();
        }
        if ((n2 = this.mColumnToChildIndex.get(n, -1)) == -1) return null;
        return this.getChildAt(n2);
    }

    @Override
    public int getVirtualChildCount() {
        if (this.mColumnToChildIndex == null) {
            this.mapIndexAndColumns();
        }
        return this.mNumColumns;
    }

    @Override
    void measureChildBeforeLayout(View view, int n, int n2, int n3, int n4, int n5) {
        if (this.mConstrainedColumnWidths != null) {
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            int n6 = 0x40000000;
            int n7 = 0;
            int n8 = layoutParams.span;
            int[] nArray = this.mConstrainedColumnWidths;
            for (int i = 0; i < n8; ++i) {
                int n9 = n + i;
                int n10 = nArray[n9];
                n7 += n10;
            }
            int n11 = layoutParams.gravity;
            boolean bl = Gravity.isHorizontal(n11);
            if (bl) {
                n6 = Integer.MIN_VALUE;
            }
            int n12 = layoutParams.leftMargin;
            int n13 = n7 - n12;
            int n14 = layoutParams.rightMargin;
            int n15 = n13 - n14;
            int n16 = View.MeasureSpec.makeMeasureSpec(Math.max(0, n15), n6);
            int n17 = this.mPaddingTop;
            int n18 = this.mPaddingBottom;
            int n19 = n17 + n18;
            int n20 = layoutParams.topMargin;
            int n21 = n19 + n20;
            int n22 = layoutParams.bottomMargin;
            int n23 = n21 + n22 + n5;
            int n24 = layoutParams.height;
            int n25 = n4;
            int n26 = n23;
            int n27 = n24;
            int n28 = TableRow.getChildMeasureSpec(n25, n26, n27);
            View view2 = view;
            int n29 = n16;
            int n30 = n28;
            view2.measure(n29, n30);
            if (bl) {
                int n31;
                int n32;
                int n33 = view.getMeasuredWidth();
                int[] nArray2 = layoutParams.mOffset;
                nArray2[1] = n32 = n7 - n33;
                switch (n11 & 7) {
                    default: {
                        return;
                    }
                    case 5: {
                        int n34;
                        int[] nArray3 = layoutParams.mOffset;
                        nArray3[0] = n34 = layoutParams.mOffset[1];
                        return;
                    }
                    case 1: 
                }
                int[] nArray4 = layoutParams.mOffset;
                nArray4[0] = n31 = layoutParams.mOffset[1] / 2;
                return;
            }
            int[] nArray5 = layoutParams.mOffset;
            ((LayoutParams)layoutParams).mOffset[1] = 0;
            nArray5[0] = 0;
            return;
        }
        super.measureChildBeforeLayout(view, n, n2, n3, n4, n5);
    }

    @Override
    int measureNullChild(int n) {
        return this.mConstrainedColumnWidths[n];
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        this.layoutHorizontal();
    }

    @Override
    protected void onMeasure(int n, int n2) {
        this.measureHorizontal(n, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    void setColumnCollapsed(int n, boolean bl) {
        View view = this.getVirtualChildAt(n);
        if (view == null) {
            return;
        }
        int n2 = bl ? 8 : 0;
        view.setVisibility(n2);
    }

    void setColumnsWidthConstraints(int[] nArray) {
        int n;
        int n2;
        if (nArray == null || (n2 = nArray.length) < (n = this.getVirtualChildCount())) {
            throw new IllegalArgumentException("columnWidths should be >= getVirtualChildCount()");
        }
        this.mConstrainedColumnWidths = nArray;
    }

    @Override
    public void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener) {
        this.mChildrenTracker.setOnHierarchyChangeListener(onHierarchyChangeListener);
    }

    private class ChildrenTracker
    implements ViewGroup.OnHierarchyChangeListener {
        private ViewGroup.OnHierarchyChangeListener listener;

        private ChildrenTracker() {
        }

        private void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener) {
            this.listener = onHierarchyChangeListener;
        }

        @Override
        public void onChildViewAdded(View view, View view2) {
            SparseIntArray sparseIntArray = TableRow.access$302(TableRow.this, null);
            if (this.listener == null) {
                return;
            }
            this.listener.onChildViewAdded(view, view2);
        }

        @Override
        public void onChildViewRemoved(View view, View view2) {
            SparseIntArray sparseIntArray = TableRow.access$302(TableRow.this, null);
            if (this.listener == null) {
                return;
            }
            this.listener.onChildViewRemoved(view, view2);
        }
    }

    public static class LayoutParams
    extends LinearLayout.LayoutParams {
        private static final int LOCATION = 0;
        private static final int LOCATION_NEXT = 1;
        @ViewDebug.ExportedProperty(category="layout")
        public int column;
        private int[] mOffset;
        @ViewDebug.ExportedProperty(category="layout")
        public int span;

        public LayoutParams() {
            super(-1, -1);
            int[] nArray = new int[2];
            this.mOffset = nArray;
            this.column = -1;
            this.span = 1;
        }

        public LayoutParams(int n) {
            this();
            this.column = n;
        }

        public LayoutParams(int n, int n2) {
            super(n, n2);
            int[] nArray = new int[2];
            this.mOffset = nArray;
            this.column = -1;
            this.span = 1;
        }

        public LayoutParams(int n, int n2, float f) {
            super(n, n2, f);
            int[] nArray = new int[2];
            this.mOffset = nArray;
            this.column = -1;
            this.span = 1;
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            int n;
            int n2;
            int[] nArray = new int[2];
            this.mOffset = nArray;
            int[] nArray2 = R.styleable.TableRow_Cell;
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray2);
            this.column = n2 = typedArray.getInt(0, -1);
            this.span = n = typedArray.getInt(1, 1);
            if (this.span <= 1) {
                this.span = 1;
            }
            typedArray.recycle();
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
            int[] nArray = new int[2];
            this.mOffset = nArray;
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
            int[] nArray = new int[2];
            this.mOffset = nArray;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected void setBaseAttributes(TypedArray typedArray, int n, int n2) {
            int n3;
            this.width = typedArray.hasValue(n) ? (n3 = typedArray.getLayoutDimension(n, "layout_width")) : -1;
            if (typedArray.hasValue(n2)) {
                int n4;
                this.height = n4 = typedArray.getLayoutDimension(n2, "layout_height");
                return;
            }
            this.height = -1;
        }
    }
}

