/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.INotificationManager;
import android.app.ITransientNotification;
import android.content.Context;
import android.content.res.Resources;
import android.os.Handler;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.view.WindowManagerImpl;
import android.widget.TextView;

public class Toast {
    public static final int LENGTH_LONG = 1;
    public static final int LENGTH_SHORT = 0;
    static final String TAG = "Toast";
    static final boolean localLOGV;
    private static INotificationManager sService;
    final Context mContext;
    int mDuration;
    int mGravity;
    final Handler mHandler;
    float mHorizontalMargin;
    View mNextView;
    final TN mTN;
    float mVerticalMargin;
    View mView;
    int mX;
    int mY;

    public Toast(Context context) {
        int n;
        TN tN;
        Handler handler;
        this.mHandler = handler = new Handler();
        this.mGravity = 81;
        this.mContext = context;
        this.mTN = tN = new TN();
        this.mY = n = context.getResources().getDimensionPixelSize(17104899);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static INotificationManager getService() {
        if (sService == null) return sService = INotificationManager.Stub.asInterface(ServiceManager.getService("notification"));
        return sService;
    }

    public static Toast makeText(Context context, int n, int n2) throws Resources.NotFoundException {
        CharSequence charSequence = context.getResources().getText(n);
        return Toast.makeText(context, charSequence, n2);
    }

    public static Toast makeText(Context context, CharSequence charSequence, int n) {
        Toast toast = new Toast(context);
        View view = ((LayoutInflater)context.getSystemService("layout_inflater")).inflate(17367143, null);
        ((TextView)view.findViewById(16908299)).setText(charSequence);
        toast.mNextView = view;
        toast.mDuration = n;
        return toast;
    }

    public void cancel() {
        this.mTN.hide();
    }

    public int getDuration() {
        return this.mDuration;
    }

    public int getGravity() {
        return this.mGravity;
    }

    public float getHorizontalMargin() {
        return this.mHorizontalMargin;
    }

    public float getVerticalMargin() {
        return this.mVerticalMargin;
    }

    public View getView() {
        return this.mNextView;
    }

    public int getXOffset() {
        return this.mX;
    }

    public int getYOffset() {
        return this.mY;
    }

    public void setDuration(int n) {
        this.mDuration = n;
    }

    public void setGravity(int n, int n2, int n3) {
        this.mGravity = n;
        this.mX = n2;
        this.mY = n3;
    }

    public void setMargin(float f, float f2) {
        this.mHorizontalMargin = f;
        this.mVerticalMargin = f2;
    }

    public void setText(int n) {
        CharSequence charSequence = this.mContext.getText(n);
        this.setText(charSequence);
    }

    public void setText(CharSequence charSequence) {
        if (this.mNextView == null) {
            throw new RuntimeException("This Toast was not created with Toast.makeText()");
        }
        TextView textView = (TextView)this.mNextView.findViewById(16908299);
        if (textView == null) {
            throw new RuntimeException("This Toast was not created with Toast.makeText()");
        }
        textView.setText(charSequence);
    }

    public void setView(View view) {
        this.mNextView = view;
    }

    public void show() {
        if (this.mNextView == null) {
            throw new RuntimeException("setView must have been called");
        }
        INotificationManager iNotificationManager = Toast.getService();
        String string2 = this.mContext.getPackageName();
        TN tN = this.mTN;
        try {
            int n = this.mDuration;
            iNotificationManager.enqueueToast(string2, tN, n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    private class TN
    extends ITransientNotification.Stub {
        final Runnable mHide;
        private final WindowManager.LayoutParams mParams;
        final Runnable mShow;
        WindowManagerImpl mWM;

        TN() {
            WindowManager.LayoutParams layoutParams;
            Runnable runnable;
            Runnable runnable2;
            this.mShow = runnable2 = new Runnable(){

                @Override
                public void run() {
                    TN.this.handleShow();
                }
            };
            this.mHide = runnable = new Runnable(){

                @Override
                public void run() {
                    TN.this.handleHide();
                }
            };
            WindowManager.LayoutParams layoutParams2 = this.mParams = (layoutParams = new WindowManager.LayoutParams());
            layoutParams2.height = -1;
            layoutParams2.width = -1;
            layoutParams2.flags = 152;
            layoutParams2.format = -1;
            layoutParams2.windowAnimations = 16973828;
            layoutParams2.type = 2005;
            layoutParams2.setTitle(Toast.TAG);
        }

        public void handleHide() {
            if (Toast.this.mView == null) {
                return;
            }
            if (Toast.this.mView.getParent() != null) {
                WindowManagerImpl windowManagerImpl = this.mWM;
                View view = Toast.this.mView;
                windowManagerImpl.removeView(view);
            }
            Toast.this.mView = null;
        }

        public void handleShow() {
            float f;
            float f2;
            int n;
            int n2;
            int n3;
            WindowManagerImpl windowManagerImpl;
            View view;
            View view2 = Toast.this.mView;
            View view3 = Toast.this.mNextView;
            if (view2 == view3) {
                return;
            }
            this.handleHide();
            Toast toast = Toast.this;
            toast.mView = view = Toast.this.mNextView;
            this.mWM = windowManagerImpl = WindowManagerImpl.getDefault();
            this.mParams.gravity = n3 = Toast.this.mGravity;
            if ((n3 & 7) == 7) {
                this.mParams.horizontalWeight = 1.0f;
            }
            if ((n3 & 0x70) == 112) {
                this.mParams.verticalWeight = 1.0f;
            }
            WindowManager.LayoutParams layoutParams = this.mParams;
            layoutParams.x = n2 = Toast.this.mX;
            WindowManager.LayoutParams layoutParams2 = this.mParams;
            layoutParams2.y = n = Toast.this.mY;
            WindowManager.LayoutParams layoutParams3 = this.mParams;
            layoutParams3.verticalMargin = f2 = Toast.this.mVerticalMargin;
            WindowManager.LayoutParams layoutParams4 = this.mParams;
            layoutParams4.horizontalMargin = f = Toast.this.mHorizontalMargin;
            if (Toast.this.mView.getParent() != null) {
                WindowManagerImpl windowManagerImpl2 = this.mWM;
                View view4 = Toast.this.mView;
                windowManagerImpl2.removeView(view4);
            }
            WindowManagerImpl windowManagerImpl3 = this.mWM;
            View view5 = Toast.this.mView;
            WindowManager.LayoutParams layoutParams5 = this.mParams;
            windowManagerImpl3.addView(view5, layoutParams5);
        }

        @Override
        public void hide() {
            Handler handler = Toast.this.mHandler;
            Runnable runnable = this.mHide;
            boolean bl = handler.post(runnable);
        }

        @Override
        public void show() {
            Handler handler = Toast.this.mHandler;
            Runnable runnable = this.mShow;
            boolean bl = handler.post(runnable);
        }
    }
}

