/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.util.AttributeSet;
import android.widget.CompoundButton;
import com.android.internal.R;

public class ToggleButton
extends CompoundButton {
    private static final int NO_ALPHA = 255;
    private float mDisabledAlpha;
    private Drawable mIndicatorDrawable;
    private CharSequence mTextOff;
    private CharSequence mTextOn;

    public ToggleButton(Context context) {
        this(context, null);
    }

    public ToggleButton(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842827);
    }

    public ToggleButton(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        float f;
        CharSequence charSequence;
        CharSequence charSequence2;
        int[] nArray = R.styleable.ToggleButton;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, n, 0);
        this.mTextOn = charSequence2 = typedArray.getText(1);
        this.mTextOff = charSequence = typedArray.getText(2);
        this.mDisabledAlpha = f = typedArray.getFloat(0, 0.5f);
        this.syncTextState();
        typedArray.recycle();
    }

    private void syncTextState() {
        boolean bl = this.isChecked();
        if (bl && this.mTextOn != null) {
            CharSequence charSequence = this.mTextOn;
            this.setText(charSequence);
            return;
        }
        if (bl) {
            return;
        }
        if (this.mTextOff == null) {
            return;
        }
        CharSequence charSequence = this.mTextOff;
        this.setText(charSequence);
    }

    private void updateReferenceToIndicatorDrawable(Drawable drawable2) {
        Drawable drawable3;
        if (!(drawable2 instanceof LayerDrawable)) {
            return;
        }
        this.mIndicatorDrawable = drawable3 = ((LayerDrawable)drawable2).findDrawableByLayerId(16908311);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void drawableStateChanged() {
        int n;
        super.drawableStateChanged();
        if (this.mIndicatorDrawable == null) {
            return;
        }
        Drawable drawable2 = this.mIndicatorDrawable;
        if (this.isEnabled()) {
            n = 255;
        } else {
            float f = this.mDisabledAlpha;
            n = (int)(255.0f * f);
        }
        drawable2.setAlpha(n);
    }

    public CharSequence getTextOff() {
        return this.mTextOff;
    }

    public CharSequence getTextOn() {
        return this.mTextOn;
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        Drawable drawable2 = this.getBackground();
        this.updateReferenceToIndicatorDrawable(drawable2);
    }

    @Override
    public void setBackgroundDrawable(Drawable drawable2) {
        super.setBackgroundDrawable(drawable2);
        this.updateReferenceToIndicatorDrawable(drawable2);
    }

    @Override
    public void setChecked(boolean bl) {
        super.setChecked(bl);
        this.syncTextState();
    }

    public void setTextOff(CharSequence charSequence) {
        this.mTextOff = charSequence;
    }

    public void setTextOn(CharSequence charSequence) {
        this.mTextOn = charSequence;
    }
}

