/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.media.MediaPlayer;
import android.media.Metadata;
import android.net.Uri;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.widget.MediaController;
import java.io.IOException;
import java.util.Map;

public class VideoView
extends SurfaceView
implements MediaController.MediaPlayerControl {
    private static final int STATE_ERROR = 255;
    private static final int STATE_IDLE = 0;
    private static final int STATE_PAUSED = 4;
    private static final int STATE_PLAYBACK_COMPLETED = 5;
    private static final int STATE_PLAYING = 3;
    private static final int STATE_PREPARED = 2;
    private static final int STATE_PREPARING = 1;
    private static final int STATE_RESUME = 7;
    private static final int STATE_SUSPEND = 6;
    private static final int STATE_SUSPEND_UNSUPPORTED = 8;
    private String TAG = "VideoView";
    private MediaPlayer.OnBufferingUpdateListener mBufferingUpdateListener;
    private boolean mCanPause;
    private boolean mCanSeekBack;
    private boolean mCanSeekForward;
    private MediaPlayer.OnCompletionListener mCompletionListener;
    private int mCurrentBufferPercentage;
    private int mCurrentState = 0;
    private int mDuration;
    private MediaPlayer.OnErrorListener mErrorListener;
    private Map<String, String> mHeaders;
    private MediaController mMediaController;
    private MediaPlayer mMediaPlayer = null;
    private MediaPlayer.OnCompletionListener mOnCompletionListener;
    private MediaPlayer.OnErrorListener mOnErrorListener;
    private MediaPlayer.OnPreparedListener mOnPreparedListener;
    MediaPlayer.OnPreparedListener mPreparedListener;
    SurfaceHolder.Callback mSHCallback;
    private int mSeekWhenPrepared;
    MediaPlayer.OnVideoSizeChangedListener mSizeChangedListener;
    private int mStateWhenSuspended;
    private int mSurfaceHeight;
    private SurfaceHolder mSurfaceHolder = null;
    private int mSurfaceWidth;
    private int mTargetState = 0;
    private Uri mUri;
    private int mVideoHeight;
    private int mVideoWidth;

    public VideoView(Context context) {
        super(context);
        SurfaceHolder.Callback callback;
        MediaPlayer.OnBufferingUpdateListener onBufferingUpdateListener;
        MediaPlayer.OnErrorListener onErrorListener;
        MediaPlayer.OnCompletionListener onCompletionListener;
        MediaPlayer.OnPreparedListener onPreparedListener;
        MediaPlayer.OnVideoSizeChangedListener onVideoSizeChangedListener;
        this.mSizeChangedListener = onVideoSizeChangedListener = new MediaPlayer.OnVideoSizeChangedListener(){

            @Override
            public void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
                VideoView videoView = VideoView.this;
                int n3 = mediaPlayer.getVideoWidth();
                int n4 = VideoView.access$002(videoView, n3);
                VideoView videoView2 = VideoView.this;
                int n5 = mediaPlayer.getVideoHeight();
                int n6 = VideoView.access$102(videoView2, n5);
                if (VideoView.this.mVideoWidth == 0) {
                    return;
                }
                if (VideoView.this.mVideoHeight == 0) {
                    return;
                }
                SurfaceHolder surfaceHolder = VideoView.this.getHolder();
                int n7 = VideoView.this.mVideoWidth;
                int n8 = VideoView.this.mVideoHeight;
                surfaceHolder.setFixedSize(n7, n8);
            }
        };
        this.mPreparedListener = onPreparedListener = new MediaPlayer.OnPreparedListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onPrepared(MediaPlayer mediaPlayer) {
                int n = VideoView.access$202(VideoView.this, 2);
                Metadata metadata = mediaPlayer.getMetadata(false, false);
                if (metadata != null) {
                    VideoView videoView = VideoView.this;
                    boolean bl = !metadata.has(29) || metadata.getBoolean(29);
                    boolean bl2 = VideoView.access$302(videoView, bl);
                    VideoView videoView2 = VideoView.this;
                    boolean bl3 = !metadata.has(30) || metadata.getBoolean(30);
                    boolean bl4 = VideoView.access$402(videoView2, bl3);
                    VideoView videoView3 = VideoView.this;
                    boolean bl5 = !metadata.has(31) || metadata.getBoolean(31);
                    boolean bl6 = VideoView.access$502(videoView3, bl5);
                } else {
                    VideoView videoView = VideoView.this;
                    VideoView videoView4 = VideoView.this;
                    boolean bl = VideoView.access$502(VideoView.this, true);
                    boolean bl7 = VideoView.access$402(videoView4, bl);
                    boolean bl8 = VideoView.access$302(videoView, bl7);
                }
                if (VideoView.this.mOnPreparedListener != null) {
                    MediaPlayer.OnPreparedListener onPreparedListener = VideoView.this.mOnPreparedListener;
                    MediaPlayer mediaPlayer2 = VideoView.this.mMediaPlayer;
                    onPreparedListener.onPrepared(mediaPlayer2);
                }
                if (VideoView.this.mMediaController != null) {
                    VideoView.this.mMediaController.setEnabled(true);
                }
                VideoView videoView = VideoView.this;
                int n2 = mediaPlayer.getVideoWidth();
                int n3 = VideoView.access$002(videoView, n2);
                VideoView videoView5 = VideoView.this;
                int n4 = mediaPlayer.getVideoHeight();
                int n5 = VideoView.access$102(videoView5, n4);
                int n6 = VideoView.this.mSeekWhenPrepared;
                if (n6 != 0) {
                    VideoView.this.seekTo(n6);
                }
                if (VideoView.this.mVideoWidth != 0 && VideoView.this.mVideoHeight != 0) {
                    int n7;
                    SurfaceHolder surfaceHolder = VideoView.this.getHolder();
                    int n8 = VideoView.this.mVideoWidth;
                    int n9 = VideoView.this.mVideoHeight;
                    surfaceHolder.setFixedSize(n8, n9);
                    int n10 = VideoView.this.mSurfaceWidth;
                    int n11 = VideoView.this.mVideoWidth;
                    if (n10 != n11) {
                        return;
                    }
                    int n12 = VideoView.this.mSurfaceHeight;
                    if (n12 != (n7 = VideoView.this.mVideoHeight)) {
                        return;
                    }
                    if (VideoView.this.mTargetState == 3) {
                        VideoView.this.start();
                        if (VideoView.this.mMediaController == null) {
                            return;
                        }
                        VideoView.this.mMediaController.show();
                        return;
                    }
                    if (VideoView.this.isPlaying()) {
                        return;
                    }
                    if (n6 == 0 && VideoView.this.getCurrentPosition() <= 0) {
                        return;
                    }
                    if (VideoView.this.mMediaController == null) {
                        return;
                    }
                    VideoView.this.mMediaController.show(0);
                    return;
                }
                if (VideoView.this.mTargetState != 3) {
                    return;
                }
                VideoView.this.start();
            }
        };
        this.mCompletionListener = onCompletionListener = new MediaPlayer.OnCompletionListener(){

            @Override
            public void onCompletion(MediaPlayer mediaPlayer) {
                int n = VideoView.access$202(VideoView.this, 5);
                int n2 = VideoView.access$1202(VideoView.this, 5);
                if (VideoView.this.mMediaController != null) {
                    VideoView.this.mMediaController.hide();
                }
                if (VideoView.this.mOnCompletionListener == null) {
                    return;
                }
                MediaPlayer.OnCompletionListener onCompletionListener = VideoView.this.mOnCompletionListener;
                MediaPlayer mediaPlayer2 = VideoView.this.mMediaPlayer;
                onCompletionListener.onCompletion(mediaPlayer2);
            }
        };
        this.mErrorListener = onErrorListener = new MediaPlayer.OnErrorListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
                MediaPlayer mediaPlayer2;
                MediaPlayer.OnErrorListener onErrorListener;
                String string2 = VideoView.this.TAG;
                String string3 = "Error: " + n + "," + n2;
                int n3 = Log.d(string2, string3);
                int n4 = VideoView.access$202(VideoView.this, -1);
                int n5 = VideoView.access$1202(VideoView.this, -1);
                if (VideoView.this.mMediaController != null) {
                    VideoView.this.mMediaController.hide();
                }
                if (VideoView.this.mOnErrorListener != null && (onErrorListener = VideoView.this.mOnErrorListener).onError(mediaPlayer2 = VideoView.this.mMediaPlayer, n, n2)) {
                    return true;
                }
                if (VideoView.this.getWindowToken() == null) return true;
                Resources resources = VideoView.this.mContext.getResources();
                int n6 = n == 200 ? 17039381 : 0x1040011;
                Context context = VideoView.this.mContext;
                AlertDialog.Builder builder = new AlertDialog.Builder(context).setTitle(17039378).setMessage(n6);
                DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

                    @Override
                    public void onClick(DialogInterface dialogInterface, int n) {
                        if (VideoView.this.mOnCompletionListener == null) {
                            return;
                        }
                        MediaPlayer.OnCompletionListener onCompletionListener = VideoView.this.mOnCompletionListener;
                        MediaPlayer mediaPlayer = VideoView.this.mMediaPlayer;
                        onCompletionListener.onCompletion(mediaPlayer);
                    }
                };
                AlertDialog alertDialog = builder.setPositiveButton(0x1040010, onClickListener).setCancelable(false).show();
                return true;
            }
        };
        this.mBufferingUpdateListener = onBufferingUpdateListener = new MediaPlayer.OnBufferingUpdateListener(){

            @Override
            public void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
                int n2 = VideoView.access$1802(VideoView.this, n);
            }
        };
        this.mSHCallback = callback = new SurfaceHolder.Callback(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
                int n4 = VideoView.access$1002(VideoView.this, n2);
                int n5 = VideoView.access$1102(VideoView.this, n3);
                boolean bl = VideoView.this.mTargetState == 3;
                boolean bl2 = VideoView.this.mVideoWidth != n2 && VideoView.this.mVideoHeight != n3;
                if (VideoView.this.mMediaPlayer == null) {
                    return;
                }
                if (!bl) {
                    return;
                }
                if (!bl2) {
                    return;
                }
                if (VideoView.this.mSeekWhenPrepared != 0) {
                    VideoView videoView = VideoView.this;
                    int n6 = VideoView.this.mSeekWhenPrepared;
                    videoView.seekTo(n6);
                }
                VideoView.this.start();
                if (VideoView.this.mMediaController == null) {
                    return;
                }
                if (VideoView.this.mMediaController.isShowing()) {
                    VideoView.this.mMediaController.hide();
                }
                VideoView.this.mMediaController.show();
            }

            @Override
            public void surfaceCreated(SurfaceHolder surfaceHolder) {
                SurfaceHolder surfaceHolder2 = VideoView.access$1902(VideoView.this, surfaceHolder);
                if (VideoView.this.mMediaPlayer != null && VideoView.this.mCurrentState == 6 && VideoView.this.mTargetState == 7) {
                    MediaPlayer mediaPlayer = VideoView.this.mMediaPlayer;
                    SurfaceHolder surfaceHolder3 = VideoView.this.mSurfaceHolder;
                    mediaPlayer.setDisplay(surfaceHolder3);
                    VideoView.this.resume();
                    return;
                }
                VideoView.this.openVideo();
            }

            @Override
            public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
                SurfaceHolder surfaceHolder2 = VideoView.access$1902(VideoView.this, null);
                if (VideoView.this.mMediaController != null) {
                    VideoView.this.mMediaController.hide();
                }
                if (VideoView.this.mCurrentState == 6) {
                    return;
                }
                VideoView.this.release(true);
            }
        };
        this.initVideoView();
    }

    public VideoView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.initVideoView();
    }

    public VideoView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        SurfaceHolder.Callback callback;
        MediaPlayer.OnBufferingUpdateListener onBufferingUpdateListener;
        MediaPlayer.OnErrorListener onErrorListener;
        MediaPlayer.OnCompletionListener onCompletionListener;
        MediaPlayer.OnPreparedListener onPreparedListener;
        MediaPlayer.OnVideoSizeChangedListener onVideoSizeChangedListener;
        this.mSizeChangedListener = onVideoSizeChangedListener = new /* invalid duplicate definition of identical inner class */;
        this.mPreparedListener = onPreparedListener = new /* invalid duplicate definition of identical inner class */;
        this.mCompletionListener = onCompletionListener = new /* invalid duplicate definition of identical inner class */;
        this.mErrorListener = onErrorListener = new /* invalid duplicate definition of identical inner class */;
        this.mBufferingUpdateListener = onBufferingUpdateListener = new /* invalid duplicate definition of identical inner class */;
        this.mSHCallback = callback = new /* invalid duplicate definition of identical inner class */;
        this.initVideoView();
    }

    static /* synthetic */ int access$002(VideoView videoView, int n) {
        videoView.mVideoWidth = n;
        return n;
    }

    static /* synthetic */ int access$1002(VideoView videoView, int n) {
        videoView.mSurfaceWidth = n;
        return n;
    }

    static /* synthetic */ int access$102(VideoView videoView, int n) {
        videoView.mVideoHeight = n;
        return n;
    }

    static /* synthetic */ int access$1102(VideoView videoView, int n) {
        videoView.mSurfaceHeight = n;
        return n;
    }

    static /* synthetic */ int access$1202(VideoView videoView, int n) {
        videoView.mTargetState = n;
        return n;
    }

    static /* synthetic */ int access$1802(VideoView videoView, int n) {
        videoView.mCurrentBufferPercentage = n;
        return n;
    }

    static /* synthetic */ SurfaceHolder access$1902(VideoView videoView, SurfaceHolder surfaceHolder) {
        videoView.mSurfaceHolder = surfaceHolder;
        return surfaceHolder;
    }

    static /* synthetic */ int access$202(VideoView videoView, int n) {
        videoView.mCurrentState = n;
        return n;
    }

    static /* synthetic */ boolean access$302(VideoView videoView, boolean bl) {
        videoView.mCanPause = bl;
        return bl;
    }

    static /* synthetic */ boolean access$402(VideoView videoView, boolean bl) {
        videoView.mCanSeekBack = bl;
        return bl;
    }

    static /* synthetic */ boolean access$502(VideoView videoView, boolean bl) {
        videoView.mCanSeekForward = bl;
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void attachMediaController() {
        void var1_2;
        if (this.mMediaPlayer == null) {
            return;
        }
        if (this.mMediaController == null) {
            return;
        }
        this.mMediaController.setMediaPlayer(this);
        if (this.getParent() instanceof View) {
            View view = (View)((Object)this.getParent());
        } else {
            VideoView videoView = this;
        }
        this.mMediaController.setAnchorView((View)var1_2);
        MediaController mediaController = this.mMediaController;
        boolean bl = this.isInPlaybackState();
        mediaController.setEnabled(bl);
    }

    private void initVideoView() {
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
        SurfaceHolder surfaceHolder = this.getHolder();
        SurfaceHolder.Callback callback = this.mSHCallback;
        surfaceHolder.addCallback(callback);
        this.getHolder().setType(3);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        boolean bl = this.requestFocus();
        this.mCurrentState = 0;
        this.mTargetState = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isInPlaybackState() {
        if (this.mMediaPlayer == null) return false;
        if (this.mCurrentState == -1) return false;
        if (this.mCurrentState == 0) return false;
        if (this.mCurrentState == 1) return false;
        return true;
    }

    private void openVideo() {
        if (this.mUri == null) {
            return;
        }
        if (this.mSurfaceHolder == null) {
            return;
        }
        Intent intent = new Intent("com.android.music.musicservicecommand");
        Intent intent2 = intent.putExtra("command", "pause");
        this.mContext.sendBroadcast(intent);
        this.release(false);
        try {
            MediaPlayer mediaPlayer;
            MediaPlayer mediaPlayer2 = this.mMediaPlayer = (mediaPlayer = new MediaPlayer());
            MediaPlayer.OnPreparedListener onPreparedListener = this.mPreparedListener;
            mediaPlayer2.setOnPreparedListener(onPreparedListener);
            MediaPlayer mediaPlayer3 = this.mMediaPlayer;
            MediaPlayer.OnVideoSizeChangedListener onVideoSizeChangedListener = this.mSizeChangedListener;
            mediaPlayer3.setOnVideoSizeChangedListener(onVideoSizeChangedListener);
            this.mDuration = -1;
            MediaPlayer mediaPlayer4 = this.mMediaPlayer;
            MediaPlayer.OnCompletionListener onCompletionListener = this.mCompletionListener;
            mediaPlayer4.setOnCompletionListener(onCompletionListener);
            MediaPlayer mediaPlayer5 = this.mMediaPlayer;
            MediaPlayer.OnErrorListener onErrorListener = this.mErrorListener;
            mediaPlayer5.setOnErrorListener(onErrorListener);
            MediaPlayer mediaPlayer6 = this.mMediaPlayer;
            MediaPlayer.OnBufferingUpdateListener onBufferingUpdateListener = this.mBufferingUpdateListener;
            mediaPlayer6.setOnBufferingUpdateListener(onBufferingUpdateListener);
            this.mCurrentBufferPercentage = 0;
            MediaPlayer mediaPlayer7 = this.mMediaPlayer;
            Context context = this.mContext;
            Uri uri = this.mUri;
            Map<String, String> map = this.mHeaders;
            mediaPlayer7.setDataSource(context, uri, map);
            MediaPlayer mediaPlayer8 = this.mMediaPlayer;
            SurfaceHolder surfaceHolder = this.mSurfaceHolder;
            mediaPlayer8.setDisplay(surfaceHolder);
            this.mMediaPlayer.setAudioStreamType(3);
            this.mMediaPlayer.setScreenOnWhilePlaying(true);
            this.mMediaPlayer.prepareAsync();
            this.mCurrentState = 1;
            this.attachMediaController();
            return;
        }
        catch (IOException iOException) {
            String string2 = this.TAG;
            StringBuilder stringBuilder = new StringBuilder().append("Unable to open content: ");
            Uri uri = this.mUri;
            String string3 = stringBuilder.append(uri).toString();
            int n = Log.w(string2, string3, iOException);
            this.mCurrentState = -1;
            this.mTargetState = -1;
            MediaPlayer.OnErrorListener onErrorListener = this.mErrorListener;
            MediaPlayer mediaPlayer = this.mMediaPlayer;
            boolean bl = onErrorListener.onError(mediaPlayer, 1, 0);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string4 = this.TAG;
            StringBuilder stringBuilder = new StringBuilder().append("Unable to open content: ");
            Uri uri = this.mUri;
            String string5 = stringBuilder.append(uri).toString();
            int n = Log.w(string4, string5, illegalArgumentException);
            this.mCurrentState = -1;
            this.mTargetState = -1;
            MediaPlayer.OnErrorListener onErrorListener = this.mErrorListener;
            MediaPlayer mediaPlayer = this.mMediaPlayer;
            boolean bl = onErrorListener.onError(mediaPlayer, 1, 0);
            return;
        }
    }

    private void release(boolean bl) {
        if (this.mMediaPlayer == null) {
            return;
        }
        this.mMediaPlayer.reset();
        this.mMediaPlayer.release();
        this.mMediaPlayer = null;
        this.mCurrentState = 0;
        if (!bl) {
            return;
        }
        this.mTargetState = 0;
    }

    private void toggleMediaControlsVisiblity() {
        if (this.mMediaController.isShowing()) {
            this.mMediaController.hide();
            return;
        }
        this.mMediaController.show();
    }

    @Override
    public boolean canPause() {
        return this.mCanPause;
    }

    @Override
    public boolean canSeekBackward() {
        return this.mCanSeekBack;
    }

    @Override
    public boolean canSeekForward() {
        return this.mCanSeekForward;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getBufferPercentage() {
        if (this.mMediaPlayer == null) return 0;
        return this.mCurrentBufferPercentage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getCurrentPosition() {
        if (!this.isInPlaybackState()) return 0;
        return this.mMediaPlayer.getCurrentPosition();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getDuration() {
        if (!this.isInPlaybackState()) return this.mDuration = -1;
        int n = this.mMediaPlayer.getDuration();
        this.mDuration = n;
        if (this.mDuration <= 0) return this.mDuration;
        return this.mDuration;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isPlaying() {
        if (!this.isInPlaybackState()) return false;
        if (!this.mMediaPlayer.isPlaying()) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        boolean bl = n != 4 && n != 24 && n != 25 && n != 82 && n != 5 && n != 6;
        if (!this.isInPlaybackState()) return super.onKeyDown(n, keyEvent);
        if (!bl) return super.onKeyDown(n, keyEvent);
        if (this.mMediaController == null) return super.onKeyDown(n, keyEvent);
        if (n == 79 || n == 85) {
            if (this.mMediaPlayer.isPlaying()) {
                this.pause();
                this.mMediaController.show();
                return true;
            } else {
                this.start();
                this.mMediaController.hide();
            }
            return true;
        }
        if (n == 86 && this.mMediaPlayer.isPlaying()) {
            this.pause();
            this.mMediaController.show();
            return super.onKeyDown(n, keyEvent);
        } else {
            this.toggleMediaControlsVisiblity();
        }
        return super.onKeyDown(n, keyEvent);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        int n3 = VideoView.getDefaultSize(this.mVideoWidth, n);
        int n4 = VideoView.getDefaultSize(this.mVideoHeight, n2);
        if (this.mVideoWidth > 0 && this.mVideoHeight > 0) {
            int n5 = this.mVideoWidth * n4;
            int n6 = this.mVideoHeight * n3;
            if (n5 > n6) {
                int n7 = this.mVideoHeight * n3;
                int n8 = this.mVideoWidth;
                n4 = n7 / n8;
            } else {
                int n9 = this.mVideoWidth * n4;
                int n10 = this.mVideoHeight * n3;
                if (n9 < n10) {
                    int n11 = this.mVideoWidth * n4;
                    int n12 = this.mVideoHeight;
                    n3 = n11 / n12;
                }
            }
        }
        this.setMeasuredDimension(n3, n4);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.isInPlaybackState() && this.mMediaController != null) {
            this.toggleMediaControlsVisiblity();
        }
        return false;
    }

    @Override
    public boolean onTrackballEvent(MotionEvent motionEvent) {
        if (this.isInPlaybackState() && this.mMediaController != null) {
            this.toggleMediaControlsVisiblity();
        }
        return false;
    }

    @Override
    public void pause() {
        if (this.isInPlaybackState() && this.mMediaPlayer.isPlaying()) {
            this.mMediaPlayer.pause();
            this.mCurrentState = 4;
        }
        this.mTargetState = 4;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int resolveAdjustedSize(int n, int n2) {
        int n3 = n;
        int n4 = View.MeasureSpec.getMode(n2);
        int n5 = View.MeasureSpec.getSize(n2);
        switch (n4) {
            case 0: {
                return n;
            }
            case -2147483648: {
                return Math.min(n, n5);
            }
            case 0x40000000: {
                return n5;
            }
        }
        return n3;
    }

    public void resume() {
        if (this.mSurfaceHolder == null && this.mCurrentState == 6) {
            this.mTargetState = 7;
            return;
        }
        if (this.mMediaPlayer != null && this.mCurrentState == 6) {
            if (this.mMediaPlayer.resume()) {
                int n;
                int n2;
                this.mCurrentState = n2 = this.mStateWhenSuspended;
                this.mTargetState = n = this.mStateWhenSuspended;
                return;
            }
            int n = Log.w(this.TAG, "Unable to resume video");
            return;
        }
        if (this.mCurrentState != 8) {
            return;
        }
        this.openVideo();
    }

    @Override
    public void seekTo(int n) {
        if (this.isInPlaybackState()) {
            this.mMediaPlayer.seekTo(n);
            this.mSeekWhenPrepared = 0;
            return;
        }
        this.mSeekWhenPrepared = n;
    }

    public void setMediaController(MediaController mediaController) {
        if (this.mMediaController != null) {
            this.mMediaController.hide();
        }
        this.mMediaController = mediaController;
        this.attachMediaController();
    }

    public void setOnCompletionListener(MediaPlayer.OnCompletionListener onCompletionListener) {
        this.mOnCompletionListener = onCompletionListener;
    }

    public void setOnErrorListener(MediaPlayer.OnErrorListener onErrorListener) {
        this.mOnErrorListener = onErrorListener;
    }

    public void setOnPreparedListener(MediaPlayer.OnPreparedListener onPreparedListener) {
        this.mOnPreparedListener = onPreparedListener;
    }

    public void setVideoPath(String string2) {
        Uri uri = Uri.parse(string2);
        this.setVideoURI(uri);
    }

    public void setVideoURI(Uri uri) {
        this.setVideoURI(uri, null);
    }

    public void setVideoURI(Uri uri, Map<String, String> map) {
        this.mUri = uri;
        this.mHeaders = map;
        this.mSeekWhenPrepared = 0;
        this.openVideo();
        this.requestLayout();
        this.invalidate();
    }

    @Override
    public void start() {
        if (this.isInPlaybackState()) {
            this.mMediaPlayer.start();
            this.mCurrentState = 3;
        }
        this.mTargetState = 3;
    }

    public void stopPlayback() {
        if (this.mMediaPlayer == null) {
            return;
        }
        this.mMediaPlayer.stop();
        this.mMediaPlayer.release();
        this.mMediaPlayer = null;
        this.mCurrentState = 0;
        this.mTargetState = 0;
    }

    public void suspend() {
        if (!this.isInPlaybackState()) {
            return;
        }
        if (this.mMediaPlayer.suspend()) {
            int n;
            this.mStateWhenSuspended = n = this.mCurrentState;
            this.mCurrentState = 6;
            this.mTargetState = 6;
            return;
        }
        this.release(false);
        this.mCurrentState = 8;
        int n = Log.w(this.TAG, "Unable to suspend video. Release MediaPlayer.");
    }
}

