/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import com.android.internal.R;

public class ViewAnimator
extends FrameLayout {
    boolean mAnimateFirstTime = true;
    boolean mFirstTime = true;
    Animation mInAnimation;
    Animation mOutAnimation;
    int mWhichChild = 0;

    public ViewAnimator(Context context) {
        super(context);
        this.initViewAnimator(context, null);
    }

    public ViewAnimator(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        int n;
        int[] nArray = R.styleable.ViewAnimator;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray);
        int n2 = typedArray.getResourceId(0, 0);
        if (n2 > 0) {
            this.setInAnimation(context, n2);
        }
        if ((n = typedArray.getResourceId(1, 0)) > 0) {
            this.setOutAnimation(context, n);
        }
        typedArray.recycle();
        this.initViewAnimator(context, attributeSet);
    }

    private void initViewAnimator(Context context, AttributeSet attributeSet) {
        if (attributeSet == null) {
            this.mMeasureAllChildren = true;
            return;
        }
        int[] nArray = R.styleable.FrameLayout;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray);
        boolean bl = typedArray.getBoolean(1, true);
        this.setMeasureAllChildren(bl);
        typedArray.recycle();
    }

    @Override
    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        super.addView(view, n, layoutParams);
        if (this.getChildCount() == 1) {
            view.setVisibility(0);
            return;
        }
        view.setVisibility(8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getBaseline() {
        if (this.getCurrentView() == null) return super.getBaseline();
        return this.getCurrentView().getBaseline();
    }

    public View getCurrentView() {
        int n = this.mWhichChild;
        return this.getChildAt(n);
    }

    public int getDisplayedChild() {
        return this.mWhichChild;
    }

    public Animation getInAnimation() {
        return this.mInAnimation;
    }

    public Animation getOutAnimation() {
        return this.mOutAnimation;
    }

    @Override
    public void removeAllViews() {
        super.removeAllViews();
        this.mWhichChild = 0;
        this.mFirstTime = true;
    }

    @Override
    public void removeView(View view) {
        int n = this.indexOfChild(view);
        if (n < 0) {
            return;
        }
        this.removeViewAt(n);
    }

    @Override
    public void removeViewAt(int n) {
        super.removeViewAt(n);
        int n2 = this.getChildCount();
        if (n2 == 0) {
            this.mWhichChild = 0;
            this.mFirstTime = true;
            return;
        }
        if (this.mWhichChild >= n2) {
            int n3 = n2 - 1;
            this.setDisplayedChild(n3);
            return;
        }
        if (this.mWhichChild != n) {
            return;
        }
        int n4 = this.mWhichChild;
        this.setDisplayedChild(n4);
    }

    @Override
    public void removeViewInLayout(View view) {
        this.removeView(view);
    }

    @Override
    public void removeViews(int n, int n2) {
        super.removeViews(n, n2);
        if (this.getChildCount() == 0) {
            this.mWhichChild = 0;
            this.mFirstTime = true;
            return;
        }
        if (this.mWhichChild < n) {
            return;
        }
        int n3 = this.mWhichChild;
        int n4 = n + n2;
        if (n3 >= n4) {
            return;
        }
        int n5 = this.mWhichChild;
        this.setDisplayedChild(n5);
    }

    @Override
    public void removeViewsInLayout(int n, int n2) {
        this.removeViews(n, n2);
    }

    public void setAnimateFirstView(boolean bl) {
        this.mAnimateFirstTime = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDisplayedChild(int n) {
        this.mWhichChild = n;
        int n2 = this.getChildCount();
        if (n >= n2) {
            this.mWhichChild = 0;
        } else if (n < 0) {
            int n3;
            this.mWhichChild = n3 = this.getChildCount() - 1;
        }
        boolean bl = this.getFocusedChild() != null;
        int n4 = this.mWhichChild;
        this.showOnly(n4);
        if (!bl) {
            return;
        }
        boolean bl2 = this.requestFocus(2);
    }

    public void setInAnimation(Context context, int n) {
        Animation animation = AnimationUtils.loadAnimation(context, n);
        this.setInAnimation(animation);
    }

    public void setInAnimation(Animation animation) {
        this.mInAnimation = animation;
    }

    public void setOutAnimation(Context context, int n) {
        Animation animation = AnimationUtils.loadAnimation(context, n);
        this.setOutAnimation(animation);
    }

    public void setOutAnimation(Animation animation) {
        this.mOutAnimation = animation;
    }

    public void showNext() {
        int n = this.mWhichChild + 1;
        this.setDisplayedChild(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    void showOnly(int n) {
        int n2 = this.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            View view = this.getChildAt(n3);
            boolean bl = !this.mFirstTime || this.mAnimateFirstTime;
            if (n3 != n) {
                if (bl && this.mInAnimation != null) {
                    Animation animation = this.mInAnimation;
                    view.startAnimation(animation);
                }
                view.setVisibility(0);
                this.mFirstTime = false;
            } else {
                if (bl && this.mOutAnimation != null && view.getVisibility() == 0) {
                    Animation animation = this.mOutAnimation;
                    view.startAnimation(animation);
                } else {
                    Animation animation;
                    Animation animation2 = view.getAnimation();
                    if (animation2 == (animation = this.mInAnimation)) {
                        view.clearAnimation();
                    }
                }
                view.setVisibility(8);
            }
            ++n3;
        }
        return;
    }

    public void showPrevious() {
        int n = this.mWhichChild - 1;
        this.setDisplayedChild(n);
    }
}

