/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.widget.RemoteViews;
import android.widget.ViewAnimator;
import com.android.internal.R;

@RemoteViews.RemoteView
public class ViewFlipper
extends ViewAnimator {
    private static final int DEFAULT_INTERVAL = 3000;
    private static final boolean LOGD = false;
    private static final String TAG = "ViewFlipper";
    private final int FLIP_MSG;
    private boolean mAutoStart = false;
    private int mFlipInterval = 3000;
    private final Handler mHandler;
    private final BroadcastReceiver mReceiver;
    private boolean mRunning = false;
    private boolean mStarted = false;
    private boolean mUserPresent = true;
    private boolean mVisible = false;

    public ViewFlipper(Context context) {
        super(context);
        Handler handler;
        BroadcastReceiver broadcastReceiver;
        this.mReceiver = broadcastReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                String string2 = intent.getAction();
                if ("android.intent.action.SCREEN_OFF".equals(string2)) {
                    boolean bl = ViewFlipper.access$002(ViewFlipper.this, false);
                    ViewFlipper.this.updateRunning();
                    return;
                }
                if (!"android.intent.action.USER_PRESENT".equals(string2)) {
                    return;
                }
                boolean bl = ViewFlipper.access$002(ViewFlipper.this, true);
                ViewFlipper.this.updateRunning();
            }
        };
        this.FLIP_MSG = 1;
        this.mHandler = handler = new Handler(){

            @Override
            public void handleMessage(Message message) {
                if (message.what != 1) {
                    return;
                }
                if (!ViewFlipper.this.mRunning) {
                    return;
                }
                ViewFlipper.this.showNext();
                Message message2 = this.obtainMessage(1);
                long l = ViewFlipper.this.mFlipInterval;
                boolean bl = this.sendMessageDelayed(message2, l);
            }
        };
    }

    public ViewFlipper(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        boolean bl;
        int n;
        Handler handler;
        BroadcastReceiver broadcastReceiver;
        this.mReceiver = broadcastReceiver = new /* invalid duplicate definition of identical inner class */;
        this.FLIP_MSG = 1;
        this.mHandler = handler = new /* invalid duplicate definition of identical inner class */;
        int[] nArray = R.styleable.ViewFlipper;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray);
        this.mFlipInterval = n = typedArray.getInt(0, 3000);
        this.mAutoStart = bl = typedArray.getBoolean(1, false);
        typedArray.recycle();
    }

    static /* synthetic */ boolean access$002(ViewFlipper viewFlipper, boolean bl) {
        viewFlipper.mUserPresent = bl;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateRunning() {
        boolean bl;
        boolean bl2 = this.mVisible && this.mStarted && this.mUserPresent;
        if (bl2 != (bl = this.mRunning)) {
            return;
        }
        if (bl2) {
            int n = this.mWhichChild;
            this.showOnly(n);
            Message message = this.mHandler.obtainMessage(1);
            Handler handler = this.mHandler;
            long l = this.mFlipInterval;
            boolean bl3 = handler.sendMessageDelayed(message, l);
        } else {
            this.mHandler.removeMessages(1);
        }
        this.mRunning = bl2;
    }

    public boolean isAutoStart() {
        return this.mAutoStart;
    }

    public boolean isFlipping() {
        return this.mStarted;
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        Context context = this.getContext();
        BroadcastReceiver broadcastReceiver = this.mReceiver;
        Intent intent = context.registerReceiver(broadcastReceiver, intentFilter);
        if (!this.mAutoStart) {
            return;
        }
        this.startFlipping();
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mVisible = false;
        Context context = this.getContext();
        BroadcastReceiver broadcastReceiver = this.mReceiver;
        context.unregisterReceiver(broadcastReceiver);
        this.updateRunning();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onWindowVisibilityChanged(int n) {
        super.onWindowVisibilityChanged(n);
        boolean bl = n == 0;
        this.mVisible = bl;
        this.updateRunning();
    }

    public void setAutoStart(boolean bl) {
        this.mAutoStart = bl;
    }

    @RemotableViewMethod
    public void setFlipInterval(int n) {
        this.mFlipInterval = n;
    }

    public void startFlipping() {
        this.mStarted = true;
        this.updateRunning();
    }

    public void stopFlipping() {
        this.mStarted = false;
        this.updateRunning();
    }
}

