/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ViewAnimator;

public class ViewSwitcher
extends ViewAnimator {
    ViewFactory mFactory;

    public ViewSwitcher(Context context) {
        super(context);
    }

    public ViewSwitcher(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    private View obtainView() {
        View view = this.mFactory.makeView();
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = new FrameLayout.LayoutParams(-1, -1);
        }
        this.addView(view, layoutParams);
        return view;
    }

    @Override
    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        if (this.getChildCount() >= 2) {
            throw new IllegalStateException("Can't add more than 2 views to a ViewSwitcher");
        }
        super.addView(view, n, layoutParams);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public View getNextView() {
        int n;
        if (this.mWhichChild == 0) {
            n = 1;
            return this.getChildAt(n);
        }
        n = 0;
        return this.getChildAt(n);
    }

    public void reset() {
        View view;
        this.mFirstTime = true;
        View view2 = this.getChildAt(0);
        if (view2 != null) {
            view2.setVisibility(8);
        }
        if ((view = this.getChildAt(1)) == null) {
            return;
        }
        view.setVisibility(8);
    }

    public void setFactory(ViewFactory viewFactory) {
        this.mFactory = viewFactory;
        View view = this.obtainView();
        View view2 = this.obtainView();
    }

    public static interface ViewFactory {
        public View makeView();
    }
}

