/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageButton;

public class ZoomButton
extends ImageButton
implements View.OnLongClickListener {
    private final Handler mHandler;
    private boolean mIsInLongpress;
    private final Runnable mRunnable;
    private long mZoomSpeed;

    public ZoomButton(Context context) {
        this(context, null);
    }

    public ZoomButton(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ZoomButton(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        Handler handler;
        Runnable runnable;
        this.mRunnable = runnable = new Runnable(){

            @Override
            public void run() {
                if (ZoomButton.this.mOnClickListener == null) {
                    return;
                }
                if (!ZoomButton.this.mIsInLongpress) {
                    return;
                }
                if (!ZoomButton.this.isEnabled()) {
                    return;
                }
                View.OnClickListener onClickListener = ZoomButton.this.mOnClickListener;
                ZoomButton zoomButton = ZoomButton.this;
                onClickListener.onClick(zoomButton);
                Handler handler = ZoomButton.this.mHandler;
                long l = ZoomButton.this.mZoomSpeed;
                boolean bl = handler.postDelayed(this, l);
            }
        };
        this.mZoomSpeed = 1000L;
        this.mHandler = handler = new Handler();
        this.setOnLongClickListener(this);
    }

    @Override
    public boolean dispatchUnhandledMove(View view, int n) {
        this.clearFocus();
        return super.dispatchUnhandledMove(view, n);
    }

    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        this.mIsInLongpress = false;
        return super.onKeyUp(n, keyEvent);
    }

    @Override
    public boolean onLongClick(View view) {
        this.mIsInLongpress = true;
        Handler handler = this.mHandler;
        Runnable runnable = this.mRunnable;
        boolean bl = handler.post(runnable);
        return true;
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (motionEvent.getAction() == 3 || motionEvent.getAction() == 1) {
            this.mIsInLongpress = false;
        }
        return super.onTouchEvent(motionEvent);
    }

    @Override
    public void setEnabled(boolean bl) {
        if (!bl) {
            this.setPressed(false);
        }
        super.setEnabled(bl);
    }

    public void setZoomSpeed(long l) {
        this.mZoomSpeed = l;
    }
}

