/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewRoot;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ZoomControls;

public class ZoomButtonsController
implements View.OnTouchListener {
    private static final int MSG_DISMISS_ZOOM_CONTROLS = 3;
    private static final int MSG_POST_CONFIGURATION_CHANGED = 2;
    private static final int MSG_POST_SET_VISIBLE = 4;
    private static final String TAG = "ZoomButtonsController";
    private static final int ZOOM_CONTROLS_TIMEOUT = 0;
    private static final int ZOOM_CONTROLS_TOUCH_PADDING = 20;
    private boolean mAutoDismissControls = true;
    private OnZoomListener mCallback;
    private final IntentFilter mConfigurationChangedFilter;
    private final BroadcastReceiver mConfigurationChangedReceiver;
    private final FrameLayout mContainer;
    private WindowManager.LayoutParams mContainerLayoutParams;
    private final int[] mContainerRawLocation;
    private final Context mContext;
    private ZoomControls mControls;
    private final Handler mHandler;
    private boolean mIsVisible;
    private final View mOwnerView;
    private final int[] mOwnerViewRawLocation;
    private Runnable mPostedVisibleInitializer;
    private boolean mReleaseTouchListenerOnUp;
    private final int[] mTempIntArray;
    private final Rect mTempRect;
    private int mTouchPaddingScaledSq;
    private View mTouchTargetView;
    private final int[] mTouchTargetWindowLocation;
    private final WindowManager mWindowManager;

    static {
        ZOOM_CONTROLS_TIMEOUT = (int)ViewConfiguration.getZoomControlsTimeout();
    }

    public ZoomButtonsController(View view) {
        FrameLayout frameLayout;
        int n;
        int n2;
        WindowManager windowManager;
        Context context;
        Handler handler;
        BroadcastReceiver broadcastReceiver;
        IntentFilter intentFilter;
        Rect rect;
        int[] nArray = new int[2];
        this.mOwnerViewRawLocation = nArray;
        int[] nArray2 = new int[2];
        this.mContainerRawLocation = nArray2;
        int[] nArray3 = new int[2];
        this.mTouchTargetWindowLocation = nArray3;
        this.mTempRect = rect = new Rect();
        int[] nArray4 = new int[2];
        this.mTempIntArray = nArray4;
        this.mConfigurationChangedFilter = intentFilter = new IntentFilter("android.intent.action.CONFIGURATION_CHANGED");
        this.mConfigurationChangedReceiver = broadcastReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                if (!ZoomButtonsController.this.mIsVisible) {
                    return;
                }
                ZoomButtonsController.this.mHandler.removeMessages(2);
                boolean bl = ZoomButtonsController.this.mHandler.sendEmptyMessage(2);
            }
        };
        this.mHandler = handler = new Handler(){

            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 2: {
                        ZoomButtonsController.this.onPostConfigurationChanged();
                        return;
                    }
                    case 3: {
                        ZoomButtonsController.this.setVisible(false);
                        return;
                    }
                    case 4: 
                }
                if (ZoomButtonsController.this.mOwnerView.getWindowToken() == null) {
                    int n = Log.e(ZoomButtonsController.TAG, "Cannot make the zoom controller visible if the owner view is not attached to a window.");
                    return;
                }
                ZoomButtonsController.this.setVisible(true);
            }
        };
        this.mContext = context = view.getContext();
        this.mWindowManager = windowManager = (WindowManager)this.mContext.getSystemService("window");
        this.mOwnerView = view;
        float f = this.mContext.getResources().getDisplayMetrics().density;
        int n3 = this.mTouchPaddingScaledSq = (n2 = (int)(20.0f * f));
        int n4 = this.mTouchPaddingScaledSq;
        this.mTouchPaddingScaledSq = n = n3 * n4;
        this.mContainer = frameLayout = this.createContainer();
    }

    private FrameLayout createContainer() {
        ZoomControls zoomControls;
        WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams(-1, -1);
        layoutParams.gravity = 51;
        layoutParams.flags = 131608;
        layoutParams.height = -1;
        layoutParams.width = -1;
        layoutParams.type = 1000;
        layoutParams.format = -1;
        layoutParams.windowAnimations = 16973944;
        this.mContainerLayoutParams = layoutParams;
        Context context = this.mContext;
        Container container = new Container(context);
        container.setLayoutParams(layoutParams);
        container.setMeasureAllChildren(true);
        View view = ((LayoutInflater)this.mContext.getSystemService("layout_inflater")).inflate(17367149, (ViewGroup)container);
        ZoomControls zoomControls2 = this.mControls = (zoomControls = (ZoomControls)container.findViewById(16908847));
        View.OnClickListener onClickListener = new View.OnClickListener(){

            @Override
            public void onClick(View view) {
                ZoomButtonsController zoomButtonsController = ZoomButtonsController.this;
                int n = ZOOM_CONTROLS_TIMEOUT;
                zoomButtonsController.dismissControlsDelayed(n);
                if (ZoomButtonsController.this.mCallback == null) {
                    return;
                }
                ZoomButtonsController.this.mCallback.onZoom(true);
            }
        };
        zoomControls2.setOnZoomInClickListener(onClickListener);
        ZoomControls zoomControls3 = this.mControls;
        View.OnClickListener onClickListener2 = new View.OnClickListener(){

            @Override
            public void onClick(View view) {
                ZoomButtonsController zoomButtonsController = ZoomButtonsController.this;
                int n = ZOOM_CONTROLS_TIMEOUT;
                zoomButtonsController.dismissControlsDelayed(n);
                if (ZoomButtonsController.this.mCallback == null) {
                    return;
                }
                ZoomButtonsController.this.mCallback.onZoom(false);
            }
        };
        zoomControls3.setOnZoomOutClickListener(onClickListener2);
        return container;
    }

    private void dismissControlsDelayed(int n) {
        if (!this.mAutoDismissControls) {
            return;
        }
        this.mHandler.removeMessages(3);
        Handler handler = this.mHandler;
        long l = n;
        boolean bl = handler.sendEmptyMessageDelayed(3, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    private View findViewForTouch(int n, int n2) {
        int n3 = this.mContainerRawLocation[0];
        int n4 = n - n3;
        int n5 = this.mContainerRawLocation[1];
        int n6 = n2 - n5;
        Rect rect = this.mTempRect;
        View view = null;
        int n7 = this.mContainer.getChildCount() - 1;
        while (n7 >= 0) {
            View view2 = this.mContainer.getChildAt(n7);
            if (view2.getVisibility() == 0) {
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                int n13;
                int n14;
                int n15;
                int n16;
                view2.getHitRect(rect);
                if (rect.contains(n4, n6)) {
                    return view2;
                }
                int n17 = rect.left;
                if (n4 >= n17 && n4 <= (n16 = rect.right)) {
                    n15 = 0;
                } else {
                    int n18 = Math.abs(rect.left - n4);
                    int n19 = rect.right;
                    int n20 = Math.abs(n4 - n19);
                    n15 = Math.min(n18, n20);
                }
                if (n6 >= (n14 = rect.top) && n6 <= (n13 = rect.bottom)) {
                    n12 = 0;
                } else {
                    int n21 = Math.abs(rect.top - n6);
                    int n22 = rect.bottom;
                    int n23 = Math.abs(n6 - n22);
                    n12 = Math.min(n21, n23);
                }
                if ((n11 = (n10 = n15 * n15) + (n9 = n12 * n12)) < (n8 = this.mTouchPaddingScaledSq) && n11 < Integer.MAX_VALUE) {
                    view = view2;
                    int n24 = n11;
                }
            }
            n7 += -1;
        }
        return view;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ViewRoot getOwnerViewRoot() {
        View view = this.mOwnerView.getRootView();
        if (view == null) {
            return null;
        }
        ViewParent viewParent = view.getParent();
        if (!(viewParent instanceof ViewRoot)) return null;
        return (ViewRoot)viewParent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isInterestingKey(int n) {
        switch (n) {
            default: {
                return false;
            }
            case 4: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 66: 
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean onContainerKey(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (this.isInterestingKey(n)) {
            if (n == 4) {
                if (keyEvent.getAction() == 0 && keyEvent.getRepeatCount() == 0) {
                    if (this.mOwnerView == null) return true;
                    KeyEvent.DispatcherState dispatcherState = this.mOwnerView.getKeyDispatcherState();
                    if (dispatcherState == null) return true;
                    dispatcherState.startTracking(keyEvent, this);
                    return true;
                }
                if (keyEvent.getAction() != 1) return false;
                if (!keyEvent.isTracking()) return false;
                if (keyEvent.isCanceled()) return false;
                this.setVisible(false);
                return true;
            }
            int n2 = ZOOM_CONTROLS_TIMEOUT;
            this.dismissControlsDelayed(n2);
            return false;
        }
        ViewRoot viewRoot = this.getOwnerViewRoot();
        if (viewRoot == null) return true;
        viewRoot.dispatchKey(keyEvent);
        return true;
    }

    private void onPostConfigurationChanged() {
        int n = ZOOM_CONTROLS_TIMEOUT;
        this.dismissControlsDelayed(n);
        this.refreshPositioningVariables();
    }

    private void refreshPositioningVariables() {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.mOwnerView.getWindowToken() == null) {
            return;
        }
        int n5 = this.mOwnerView.getHeight();
        int n6 = this.mOwnerView.getWidth();
        int n7 = this.mContainer.getHeight();
        int n8 = n5 - n7;
        View view = this.mOwnerView;
        int[] nArray = this.mOwnerViewRawLocation;
        view.getLocationOnScreen(nArray);
        int[] nArray2 = this.mContainerRawLocation;
        nArray2[0] = n4 = this.mOwnerViewRawLocation[0];
        int[] nArray3 = this.mContainerRawLocation;
        nArray3[1] = n3 = this.mOwnerViewRawLocation[1] + n8;
        int[] nArray4 = this.mTempIntArray;
        this.mOwnerView.getLocationInWindow(nArray4);
        WindowManager.LayoutParams layoutParams = this.mContainerLayoutParams;
        layoutParams.x = n2 = nArray4[0];
        this.mContainerLayoutParams.width = n6;
        WindowManager.LayoutParams layoutParams2 = this.mContainerLayoutParams;
        layoutParams2.y = n = nArray4[1] + n8;
        if (!this.mIsVisible) {
            return;
        }
        WindowManager windowManager = this.mWindowManager;
        FrameLayout frameLayout = this.mContainer;
        WindowManager.LayoutParams layoutParams3 = this.mContainerLayoutParams;
        windowManager.updateViewLayout(frameLayout, layoutParams3);
    }

    private void setTouchTargetView(View view) {
        this.mTouchTargetView = view;
        if (view == null) {
            return;
        }
        int[] nArray = this.mTouchTargetWindowLocation;
        view.getLocationInWindow(nArray);
    }

    public ViewGroup getContainer() {
        return this.mContainer;
    }

    public View getZoomControls() {
        return this.mControls;
    }

    public boolean isAutoDismissed() {
        return this.mAutoDismissControls;
    }

    public boolean isVisible() {
        return this.mIsVisible;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTouch(View view, MotionEvent motionEvent) {
        int n = motionEvent.getAction();
        if (motionEvent.getPointerCount() > 1) {
            return false;
        }
        if (this.mReleaseTouchListenerOnUp) {
            if (n != 1) {
                if (n != 3) return true;
            }
            this.mOwnerView.setOnTouchListener(null);
            this.setTouchTargetView(null);
            this.mReleaseTouchListenerOnUp = false;
            return true;
        }
        int n2 = ZOOM_CONTROLS_TIMEOUT;
        this.dismissControlsDelayed(n2);
        View view2 = this.mTouchTargetView;
        switch (n) {
            case 0: {
                int n3 = (int)motionEvent.getRawX();
                int n4 = (int)motionEvent.getRawY();
                view2 = this.findViewForTouch(n3, n4);
                this.setTouchTargetView(view2);
                break;
            }
            case 1: 
            case 3: {
                this.setTouchTargetView(null);
            }
        }
        if (view2 == null) return false;
        int n5 = this.mContainerRawLocation[0];
        int n6 = this.mTouchTargetWindowLocation[0];
        int n7 = n5 + n6;
        int n8 = this.mContainerRawLocation[1];
        int n9 = this.mTouchTargetWindowLocation[1];
        int n10 = n8 + n9;
        MotionEvent motionEvent2 = MotionEvent.obtain(motionEvent);
        float f = this.mOwnerViewRawLocation[0] - n7;
        float f2 = this.mOwnerViewRawLocation[1] - n10;
        motionEvent2.offsetLocation(f, f2);
        float f3 = motionEvent2.getX();
        float f4 = motionEvent2.getY();
        if (f3 < 0.0f && f3 > -20.0f) {
            float f5 = -f3;
            motionEvent2.offsetLocation(f5, 0.0f);
        }
        if (f4 < 0.0f && f4 > -20.0f) {
            float f6 = -f4;
            motionEvent2.offsetLocation(0.0f, f6);
        }
        boolean bl = view2.dispatchTouchEvent(motionEvent2);
        motionEvent2.recycle();
        return bl;
    }

    public void setAutoDismissed(boolean bl) {
        if (this.mAutoDismissControls != bl) {
            return;
        }
        this.mAutoDismissControls = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setFocusable(boolean bl) {
        int n = this.mContainerLayoutParams.flags;
        if (bl) {
            int n2;
            WindowManager.LayoutParams layoutParams = this.mContainerLayoutParams;
            layoutParams.flags = n2 = layoutParams.flags & 0xFFFFFFF7;
        } else {
            int n3;
            WindowManager.LayoutParams layoutParams = this.mContainerLayoutParams;
            layoutParams.flags = n3 = layoutParams.flags | 8;
        }
        if (this.mContainerLayoutParams.flags != n) {
            return;
        }
        if (!this.mIsVisible) {
            return;
        }
        WindowManager windowManager = this.mWindowManager;
        FrameLayout frameLayout = this.mContainer;
        WindowManager.LayoutParams layoutParams = this.mContainerLayoutParams;
        windowManager.updateViewLayout(frameLayout, layoutParams);
    }

    public void setOnZoomListener(OnZoomListener onZoomListener) {
        this.mCallback = onZoomListener;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setVisible(boolean bl) {
        if (bl) {
            if (this.mOwnerView.getWindowToken() == null) {
                if (this.mHandler.hasMessages(4)) {
                    return;
                }
                boolean bl2 = this.mHandler.sendEmptyMessage(4);
                return;
            }
            int n = ZOOM_CONTROLS_TIMEOUT;
            this.dismissControlsDelayed(n);
        }
        if (this.mIsVisible != bl) {
            return;
        }
        this.mIsVisible = bl;
        if (bl) {
            if (this.mContainerLayoutParams.token == null) {
                IBinder iBinder;
                WindowManager.LayoutParams layoutParams = this.mContainerLayoutParams;
                layoutParams.token = iBinder = this.mOwnerView.getWindowToken();
            }
            WindowManager windowManager = this.mWindowManager;
            FrameLayout frameLayout = this.mContainer;
            WindowManager.LayoutParams layoutParams = this.mContainerLayoutParams;
            windowManager.addView(frameLayout, layoutParams);
            if (this.mPostedVisibleInitializer == null) {
                Runnable runnable;
                this.mPostedVisibleInitializer = runnable = new Runnable(){

                    @Override
                    public void run() {
                        ZoomButtonsController.this.refreshPositioningVariables();
                        if (ZoomButtonsController.this.mCallback == null) {
                            return;
                        }
                        ZoomButtonsController.this.mCallback.onVisibilityChanged(true);
                    }
                };
            }
            Handler handler = this.mHandler;
            Runnable runnable = this.mPostedVisibleInitializer;
            boolean bl3 = handler.post(runnable);
            Context context = this.mContext;
            BroadcastReceiver broadcastReceiver = this.mConfigurationChangedReceiver;
            IntentFilter intentFilter = this.mConfigurationChangedFilter;
            Intent intent = context.registerReceiver(broadcastReceiver, intentFilter);
            this.mOwnerView.setOnTouchListener(this);
            this.mReleaseTouchListenerOnUp = false;
            return;
        }
        if (this.mTouchTargetView != null) {
            this.mReleaseTouchListenerOnUp = true;
        } else {
            this.mOwnerView.setOnTouchListener(null);
        }
        Context context = this.mContext;
        BroadcastReceiver broadcastReceiver = this.mConfigurationChangedReceiver;
        context.unregisterReceiver(broadcastReceiver);
        WindowManager windowManager = this.mWindowManager;
        FrameLayout frameLayout = this.mContainer;
        windowManager.removeView(frameLayout);
        Handler handler = this.mHandler;
        Runnable runnable = this.mPostedVisibleInitializer;
        handler.removeCallbacks(runnable);
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.onVisibilityChanged(false);
    }

    public void setZoomInEnabled(boolean bl) {
        this.mControls.setIsZoomInEnabled(bl);
    }

    public void setZoomOutEnabled(boolean bl) {
        this.mControls.setIsZoomOutEnabled(bl);
    }

    public void setZoomSpeed(long l) {
        this.mControls.setZoomSpeed(l);
    }

    private class Container
    extends FrameLayout {
        public Container(Context context) {
            super(context);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            if (!ZoomButtonsController.this.onContainerKey(keyEvent)) return super.dispatchKeyEvent(keyEvent);
            return true;
        }
    }

    public static interface OnZoomListener {
        public void onVisibilityChanged(boolean var1);

        public void onZoom(boolean var1);
    }
}

