/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.widget.LinearLayout;
import android.widget.ZoomButton;

public class ZoomControls
extends LinearLayout {
    private final ZoomButton mZoomIn;
    private final ZoomButton mZoomOut;

    public ZoomControls(Context context) {
        this(context, null);
    }

    public ZoomControls(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        ZoomButton zoomButton;
        ZoomButton zoomButton2;
        this.setFocusable(false);
        View view = ((LayoutInflater)context.getSystemService("layout_inflater")).inflate(17367150, (ViewGroup)this, true);
        this.mZoomIn = zoomButton2 = (ZoomButton)this.findViewById(16908849);
        this.mZoomOut = zoomButton = (ZoomButton)this.findViewById(16908848);
    }

    private void fade(int n, float f, float f2) {
        AlphaAnimation alphaAnimation = new AlphaAnimation(f, f2);
        alphaAnimation.setDuration(500L);
        this.startAnimation(alphaAnimation);
        this.setVisibility(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasFocus() {
        if (this.mZoomIn.hasFocus()) return true;
        if (!this.mZoomOut.hasFocus()) return false;
        return true;
    }

    public void hide() {
        this.fade(8, 1.0f, 0.0f);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return true;
    }

    public void setIsZoomInEnabled(boolean bl) {
        this.mZoomIn.setEnabled(bl);
    }

    public void setIsZoomOutEnabled(boolean bl) {
        this.mZoomOut.setEnabled(bl);
    }

    public void setOnZoomInClickListener(View.OnClickListener onClickListener) {
        this.mZoomIn.setOnClickListener(onClickListener);
    }

    public void setOnZoomOutClickListener(View.OnClickListener onClickListener) {
        this.mZoomOut.setOnClickListener(onClickListener);
    }

    public void setZoomSpeed(long l) {
        this.mZoomIn.setZoomSpeed(l);
        this.mZoomOut.setZoomSpeed(l);
    }

    public void show() {
        this.fade(0, 0.0f, 1.0f);
    }
}

