/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ScrollView;
import android.widget.SimpleCursorAdapter;
import android.widget.TextView;
import com.android.internal.R;
import java.lang.ref.WeakReference;

public class AlertController {
    private ListAdapter mAdapter;
    View.OnClickListener mButtonHandler;
    private Button mButtonNegative;
    private Message mButtonNegativeMessage;
    private CharSequence mButtonNegativeText;
    private Button mButtonNeutral;
    private Message mButtonNeutralMessage;
    private CharSequence mButtonNeutralText;
    private Button mButtonPositive;
    private Message mButtonPositiveMessage;
    private CharSequence mButtonPositiveText;
    private int mCheckedItem = -1;
    private final Context mContext;
    private View mCustomTitleView;
    private final DialogInterface mDialogInterface;
    private boolean mForceInverseBackground;
    private Handler mHandler;
    private Drawable mIcon;
    private int mIconId = -1;
    private ImageView mIconView;
    private ListView mListView;
    private CharSequence mMessage;
    private TextView mMessageView;
    private ScrollView mScrollView;
    private CharSequence mTitle;
    private TextView mTitleView;
    private View mView;
    private int mViewSpacingBottom;
    private int mViewSpacingLeft;
    private int mViewSpacingRight;
    private boolean mViewSpacingSpecified = false;
    private int mViewSpacingTop;
    private final Window mWindow;

    public AlertController(Context context, DialogInterface dialogInterface, Window window) {
        View.OnClickListener onClickListener;
        this.mButtonHandler = onClickListener = new View.OnClickListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onClick(View view) {
                Message message = null;
                Button button = AlertController.this.mButtonPositive;
                if (view == button && AlertController.this.mButtonPositiveMessage != null) {
                    message = Message.obtain(AlertController.this.mButtonPositiveMessage);
                } else {
                    Button button2 = AlertController.this.mButtonNegative;
                    if (view == button2 && AlertController.this.mButtonNegativeMessage != null) {
                        message = Message.obtain(AlertController.this.mButtonNegativeMessage);
                    } else {
                        Button button3 = AlertController.this.mButtonNeutral;
                        if (view == button3 && AlertController.this.mButtonNeutralMessage != null) {
                            message = Message.obtain(AlertController.this.mButtonNeutralMessage);
                        }
                    }
                }
                if (message != null) {
                    message.sendToTarget();
                }
                Handler handler = AlertController.this.mHandler;
                DialogInterface dialogInterface = AlertController.this.mDialogInterface;
                handler.obtainMessage(1, dialogInterface).sendToTarget();
            }
        };
        this.mContext = context;
        this.mDialogInterface = dialogInterface;
        this.mWindow = window;
        ButtonHandler buttonHandler = new ButtonHandler(dialogInterface);
        this.mHandler = buttonHandler;
    }

    static /* synthetic */ ListView access$1002(AlertController alertController, ListView listView) {
        alertController.mListView = listView;
        return listView;
    }

    static /* synthetic */ ListAdapter access$802(AlertController alertController, ListAdapter listAdapter) {
        alertController.mAdapter = listAdapter;
        return listAdapter;
    }

    static /* synthetic */ int access$902(AlertController alertController, int n) {
        alertController.mCheckedItem = n;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean canTextInput(View view) {
        if (view.onCheckIsTextEditor()) {
            return true;
        }
        if (!(view instanceof ViewGroup)) {
            return false;
        }
        ViewGroup viewGroup = (ViewGroup)view;
        int n = viewGroup.getChildCount();
        do {
            if (n <= 0) return false;
        } while (!AlertController.canTextInput(viewGroup.getChildAt(n += -1)));
        return true;
    }

    private void centerButton(Button button) {
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)button.getLayoutParams();
        layoutParams.gravity = 1;
        layoutParams.weight = 0.5f;
        button.setLayoutParams(layoutParams);
        this.mWindow.findViewById(16908675).setVisibility(0);
        this.mWindow.findViewById(16908676).setVisibility(0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setBackground(LinearLayout linearLayout, LinearLayout linearLayout2, View view, boolean bl, TypedArray typedArray, boolean bl2, View view2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        TypedArray typedArray2 = typedArray;
        int n6 = 0;
        int n7 = 17302089;
        int n8 = typedArray2.getResourceId(n6, n7);
        TypedArray typedArray3 = typedArray;
        int n9 = 1;
        int n10 = 17302093;
        int n11 = typedArray3.getResourceId(n9, n10);
        TypedArray typedArray4 = typedArray;
        int n12 = 2;
        int n13 = 17302086;
        int n14 = typedArray4.getResourceId(n12, n13);
        TypedArray typedArray5 = typedArray;
        int n15 = 3;
        int n16 = 17302083;
        int n17 = typedArray5.getResourceId(n15, n16);
        TypedArray typedArray6 = typedArray;
        int n18 = 4;
        int n19 = 17302088;
        int n20 = typedArray6.getResourceId(n18, n19);
        TypedArray typedArray7 = typedArray;
        int n21 = 5;
        int n22 = 17302092;
        int n23 = typedArray7.getResourceId(n21, n22);
        TypedArray typedArray8 = typedArray;
        int n24 = 6;
        int n25 = 17302085;
        int n26 = typedArray8.getResourceId(n24, n25);
        TypedArray typedArray9 = typedArray;
        int n27 = 7;
        int n28 = 17302082;
        int n29 = typedArray9.getResourceId(n27, n28);
        TypedArray typedArray10 = typedArray;
        int n30 = 8;
        int n31 = 17302084;
        int n32 = typedArray10.getResourceId(n30, n31);
        View[] viewArray = new View[4];
        boolean[] blArray = new boolean[4];
        View view3 = null;
        boolean bl3 = false;
        int n33 = 0;
        if (bl2) {
            viewArray[0] = linearLayout;
            blArray[0] = false;
            n33 = 0 + 1;
        }
        LinearLayout linearLayout3 = (n5 = linearLayout2.getVisibility()) == (n4 = 8) ? null : linearLayout2;
        viewArray[n33] = linearLayout3;
        int n34 = this.mListView != null ? 1 : 0;
        blArray[n33] = n34;
        int n35 = n33 + 1;
        if (view != null) {
            boolean bl4;
            viewArray[n35] = view;
            blArray[n35] = bl4 = this.mForceInverseBackground;
            ++n35;
        }
        if (bl) {
            viewArray[n35] = view2;
            blArray[n35] = true;
        }
        boolean bl5 = false;
        int n36 = 0;
        while ((n3 = ++n36) < (n2 = (n = viewArray.length))) {
            View view4 = viewArray[n36];
            if (view4 == null) continue;
            if (view3 != null) {
                if (!bl5) {
                    n34 = bl3 != null ? n23 : n11;
                    View view5 = view3;
                    int n37 = n34;
                    view5.setBackgroundResource(n37);
                } else {
                    n34 = bl3 != null ? n26 : n14;
                    View view6 = view3;
                    int n38 = n34;
                    view6.setBackgroundResource(n38);
                }
                bl5 = true;
            }
            view3 = view4;
            bl3 = blArray[n36];
        }
        if (view3 != null) {
            if (bl5) {
                n34 = bl3 != null ? (bl ? n32 : n29) : n17;
                View view7 = view3;
                int n39 = n34;
                view7.setBackgroundResource(n39);
            } else {
                n34 = bl3 != null ? n20 : n8;
                View view8 = view3;
                int n40 = n34;
                view8.setBackgroundResource(n40);
            }
        }
        if (this.mListView == null) {
            return;
        }
        if (this.mAdapter == null) {
            return;
        }
        ListView listView = this.mListView;
        ListAdapter listAdapter = this.mAdapter;
        listView.setAdapter(listAdapter);
        int n41 = this.mCheckedItem;
        int n42 = 65535;
        if (n41 <= n42) {
            return;
        }
        ListView listView2 = this.mListView;
        int n43 = this.mCheckedItem;
        listView2.setItemChecked(n43, true);
        ListView listView3 = this.mListView;
        int n44 = this.mCheckedItem;
        listView3.setSelection(n44);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean setupButtons() {
        Button button;
        Button button2;
        Button button3;
        int n = 0;
        Button button4 = this.mButtonPositive = (button3 = (Button)this.mWindow.findViewById(16908313));
        View.OnClickListener onClickListener = this.mButtonHandler;
        button4.setOnClickListener(onClickListener);
        if (TextUtils.isEmpty(this.mButtonPositiveText)) {
            this.mButtonPositive.setVisibility(8);
        } else {
            Button button5 = this.mButtonPositive;
            CharSequence charSequence = this.mButtonPositiveText;
            button5.setText(charSequence);
            this.mButtonPositive.setVisibility(0);
            n = 0 | 1;
        }
        Button button6 = this.mButtonNegative = (button2 = (Button)this.mWindow.findViewById(16908314));
        View.OnClickListener onClickListener2 = this.mButtonHandler;
        button6.setOnClickListener(onClickListener2);
        if (TextUtils.isEmpty(this.mButtonNegativeText)) {
            this.mButtonNegative.setVisibility(8);
        } else {
            Button button7 = this.mButtonNegative;
            CharSequence charSequence = this.mButtonNegativeText;
            button7.setText(charSequence);
            this.mButtonNegative.setVisibility(0);
            n |= 2;
        }
        Button button8 = this.mButtonNeutral = (button = (Button)this.mWindow.findViewById(16908315));
        View.OnClickListener onClickListener3 = this.mButtonHandler;
        button8.setOnClickListener(onClickListener3);
        if (TextUtils.isEmpty(this.mButtonNeutralText)) {
            this.mButtonNeutral.setVisibility(8);
        } else {
            Button button9 = this.mButtonNeutral;
            CharSequence charSequence = this.mButtonNeutralText;
            button9.setText(charSequence);
            this.mButtonNeutral.setVisibility(0);
            n |= 4;
        }
        if (n == 1) {
            Button button10 = this.mButtonPositive;
            this.centerButton(button10);
        } else if (n == 2) {
            Button button11 = this.mButtonNeutral;
            this.centerButton(button11);
        } else if (n == 4) {
            Button button12 = this.mButtonNeutral;
            this.centerButton(button12);
        }
        if (n == 0) return false;
        return true;
    }

    private void setupContent(LinearLayout linearLayout) {
        TextView textView;
        ScrollView scrollView;
        this.mScrollView = scrollView = (ScrollView)this.mWindow.findViewById(16908672);
        this.mScrollView.setFocusable(false);
        this.mMessageView = textView = (TextView)this.mWindow.findViewById(16908299);
        if (this.mMessageView == null) {
            return;
        }
        if (this.mMessage != null) {
            TextView textView2 = this.mMessageView;
            CharSequence charSequence = this.mMessage;
            textView2.setText(charSequence);
            return;
        }
        this.mMessageView.setVisibility(8);
        ScrollView scrollView2 = this.mScrollView;
        TextView textView3 = this.mMessageView;
        scrollView2.removeView(textView3);
        if (this.mListView != null) {
            View view = this.mWindow.findViewById(16908672);
            linearLayout.removeView(view);
            ListView listView = this.mListView;
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -1);
            linearLayout.addView((View)listView, layoutParams);
            LinearLayout.LayoutParams layoutParams2 = new LinearLayout.LayoutParams(-1, 0, 1.0f);
            linearLayout.setLayoutParams(layoutParams2);
            return;
        }
        linearLayout.setVisibility(8);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean setupTitle(LinearLayout linearLayout) {
        TextView textView;
        ImageView imageView;
        boolean bl = true;
        if (this.mCustomTitleView != null) {
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -1);
            View view = this.mCustomTitleView;
            linearLayout.addView(view, layoutParams);
            this.mWindow.findViewById(16908668).setVisibility(8);
            return bl;
        }
        boolean bl2 = !TextUtils.isEmpty(this.mTitle);
        this.mIconView = imageView = (ImageView)this.mWindow.findViewById(16908294);
        if (!bl2) {
            this.mWindow.findViewById(16908668).setVisibility(8);
            this.mIconView.setVisibility(8);
            return false;
        }
        TextView textView2 = this.mTitleView = (textView = (TextView)this.mWindow.findViewById(16908669));
        CharSequence charSequence = this.mTitle;
        textView2.setText(charSequence);
        if (this.mIconId > 0) {
            ImageView imageView2 = this.mIconView;
            int n = this.mIconId;
            imageView2.setImageResource(n);
            return bl;
        }
        if (this.mIcon != null) {
            ImageView imageView3 = this.mIconView;
            Drawable drawable2 = this.mIcon;
            imageView3.setImageDrawable(drawable2);
            return bl;
        }
        if (this.mIconId != 0) return bl;
        TextView textView3 = this.mTitleView;
        int n = this.mIconView.getPaddingLeft();
        int n2 = this.mIconView.getPaddingTop();
        int n3 = this.mIconView.getPaddingRight();
        int n4 = this.mIconView.getPaddingBottom();
        textView3.setPadding(n, n2, n3, n4);
        this.mIconView.setVisibility(8);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setupView() {
        LinearLayout linearLayout = (LinearLayout)this.mWindow.findViewById(16908671);
        this.setupContent(linearLayout);
        boolean bl = this.setupButtons();
        LinearLayout linearLayout2 = (LinearLayout)this.mWindow.findViewById(16908667);
        Context context = this.mContext;
        int[] nArray = R.styleable.AlertDialog;
        TypedArray typedArray = context.obtainStyledAttributes(null, nArray, 16842845, 0);
        boolean bl2 = this.setupTitle(linearLayout2);
        View view = this.mWindow.findViewById(16908674);
        if (!bl) {
            view.setVisibility(8);
        }
        FrameLayout frameLayout = null;
        if (this.mView != null) {
            frameLayout = (FrameLayout)this.mWindow.findViewById(16908673);
            FrameLayout frameLayout2 = (FrameLayout)this.mWindow.findViewById(16908331);
            View view2 = this.mView;
            ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
            frameLayout2.addView(view2, layoutParams);
            if (this.mViewSpacingSpecified) {
                int n = this.mViewSpacingLeft;
                int n2 = this.mViewSpacingTop;
                int n3 = this.mViewSpacingRight;
                int n4 = this.mViewSpacingBottom;
                frameLayout2.setPadding(n, n2, n3, n4);
            }
            if (this.mListView != null) {
                ((LinearLayout.LayoutParams)frameLayout.getLayoutParams()).weight = 0.0f;
            }
        } else {
            this.mWindow.findViewById(16908673).setVisibility(8);
        }
        if (bl2 && (this.mMessage != null || this.mView != null)) {
            this.mWindow.findViewById(16908670).setVisibility(0);
        }
        this.setBackground(linearLayout2, linearLayout, frameLayout, bl, typedArray, bl2, view);
        typedArray.recycle();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Button getButton(int n) {
        switch (n) {
            default: {
                return null;
            }
            case -1: {
                return this.mButtonPositive;
            }
            case -2: {
                return this.mButtonNegative;
            }
            case -3: 
        }
        return this.mButtonNeutral;
    }

    public ListView getListView() {
        return this.mListView;
    }

    public void installContent() {
        boolean bl = this.mWindow.requestFeature(1);
        if (this.mView == null || !AlertController.canTextInput(this.mView)) {
            this.mWindow.setFlags(131072, 131072);
        }
        this.mWindow.setContentView(17367062);
        this.setupView();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (this.mScrollView == null) return false;
        if (!this.mScrollView.executeKeyEvent(keyEvent)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        if (this.mScrollView == null) return false;
        if (!this.mScrollView.executeKeyEvent(keyEvent)) return false;
        return true;
    }

    public void setButton(int n, CharSequence charSequence, DialogInterface.OnClickListener onClickListener, Message message) {
        if (message == null && onClickListener != null) {
            message = this.mHandler.obtainMessage(n, onClickListener);
        }
        switch (n) {
            default: {
                throw new IllegalArgumentException("Button does not exist");
            }
            case -1: {
                this.mButtonPositiveText = charSequence;
                this.mButtonPositiveMessage = message;
                return;
            }
            case -2: {
                this.mButtonNegativeText = charSequence;
                this.mButtonNegativeMessage = message;
                return;
            }
            case -3: 
        }
        this.mButtonNeutralText = charSequence;
        this.mButtonNeutralMessage = message;
    }

    public void setCustomTitle(View view) {
        this.mCustomTitleView = view;
    }

    public void setIcon(int n) {
        this.mIconId = n;
        if (this.mIconView == null) {
            return;
        }
        if (n > 0) {
            ImageView imageView = this.mIconView;
            int n2 = this.mIconId;
            imageView.setImageResource(n2);
            return;
        }
        if (n != 0) {
            return;
        }
        this.mIconView.setVisibility(8);
    }

    public void setIcon(Drawable drawable2) {
        this.mIcon = drawable2;
        if (this.mIconView == null) {
            return;
        }
        if (this.mIcon == null) {
            return;
        }
        this.mIconView.setImageDrawable(drawable2);
    }

    public void setInverseBackgroundForced(boolean bl) {
        this.mForceInverseBackground = bl;
    }

    public void setMessage(CharSequence charSequence) {
        this.mMessage = charSequence;
        if (this.mMessageView == null) {
            return;
        }
        this.mMessageView.setText(charSequence);
    }

    public void setTitle(CharSequence charSequence) {
        this.mTitle = charSequence;
        if (this.mTitleView == null) {
            return;
        }
        this.mTitleView.setText(charSequence);
    }

    public void setView(View view) {
        this.mView = view;
        this.mViewSpacingSpecified = false;
    }

    public void setView(View view, int n, int n2, int n3, int n4) {
        this.mView = view;
        this.mViewSpacingSpecified = true;
        this.mViewSpacingLeft = n;
        this.mViewSpacingTop = n2;
        this.mViewSpacingRight = n3;
        this.mViewSpacingBottom = n4;
    }

    public static class AlertParams {
        public ListAdapter mAdapter;
        public boolean mCancelable;
        public int mCheckedItem = -1;
        public boolean[] mCheckedItems;
        public final Context mContext;
        public Cursor mCursor;
        public View mCustomTitleView;
        public boolean mForceInverseBackground;
        public Drawable mIcon;
        public int mIconId = 0;
        public final LayoutInflater mInflater;
        public String mIsCheckedColumn;
        public boolean mIsMultiChoice;
        public boolean mIsSingleChoice;
        public CharSequence[] mItems;
        public String mLabelColumn;
        public CharSequence mMessage;
        public DialogInterface.OnClickListener mNegativeButtonListener;
        public CharSequence mNegativeButtonText;
        public DialogInterface.OnClickListener mNeutralButtonListener;
        public CharSequence mNeutralButtonText;
        public DialogInterface.OnCancelListener mOnCancelListener;
        public DialogInterface.OnMultiChoiceClickListener mOnCheckboxClickListener;
        public DialogInterface.OnClickListener mOnClickListener;
        public AdapterView.OnItemSelectedListener mOnItemSelectedListener;
        public DialogInterface.OnKeyListener mOnKeyListener;
        public OnPrepareListViewListener mOnPrepareListViewListener;
        public DialogInterface.OnClickListener mPositiveButtonListener;
        public CharSequence mPositiveButtonText;
        public boolean mRecycleOnMeasure = true;
        public CharSequence mTitle;
        public View mView;
        public int mViewSpacingBottom;
        public int mViewSpacingLeft;
        public int mViewSpacingRight;
        public boolean mViewSpacingSpecified = false;
        public int mViewSpacingTop;

        public AlertParams(Context context) {
            LayoutInflater layoutInflater;
            this.mContext = context;
            this.mCancelable = true;
            this.mInflater = layoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        private void createListView(final AlertController alertController) {
            boolean bl;
            void var6_7;
            final RecycleListView recycleListView = (RecycleListView)this.mInflater.inflate(17367134, null);
            if (this.mIsMultiChoice) {
                if (this.mCursor == null) {
                    Context context = this.mContext;
                    CharSequence[] charSequenceArray = this.mItems;
                    AlertParams alertParams = this;
                    ArrayAdapter<CharSequence> arrayAdapter = new ArrayAdapter<CharSequence>(context, 17367059, 16908308, charSequenceArray){

                        @Override
                        public View getView(int n, View view, ViewGroup viewGroup) {
                            View view2 = super.getView(n, view, viewGroup);
                            if (AlertParams.this.mCheckedItems != null && AlertParams.this.mCheckedItems[n] != null) {
                                recycleListView.setItemChecked(n, true);
                            }
                            return view2;
                        }
                    };
                } else {
                    2 var6_8;
                    Context context = this.mContext;
                    Cursor cursor = this.mCursor;
                    2 var16_22 = var6_8;
                    AlertParams alertParams = this;
                    var16_22(context, cursor, false, recycleListView);
                }
            } else {
                int n = this.mIsSingleChoice ? 17367058 : 0x1090011;
                if (this.mCursor == null) {
                    if (this.mAdapter != null) {
                        ListAdapter listAdapter = this.mAdapter;
                    } else {
                        Context context = this.mContext;
                        CharSequence[] charSequenceArray = this.mItems;
                        ArrayAdapter<CharSequence> arrayAdapter = new ArrayAdapter<CharSequence>(context, n, 16908308, charSequenceArray);
                    }
                } else {
                    Context context = this.mContext;
                    Cursor cursor = this.mCursor;
                    String string2 = this.mLabelColumn;
                    String[] stringArray = new String[]{string2};
                    int[] nArray = new int[]{16908308};
                    String[] stringArray2 = stringArray;
                    int[] nArray2 = nArray;
                    SimpleCursorAdapter simpleCursorAdapter = new SimpleCursorAdapter(context, n, cursor, stringArray2, nArray2);
                }
            }
            if (this.mOnPrepareListViewListener != null) {
                this.mOnPrepareListViewListener.onPrepareListView(recycleListView);
            }
            ListAdapter listAdapter = AlertController.access$802(alertController, (ListAdapter)var6_7);
            int n = this.mCheckedItem;
            int n2 = AlertController.access$902(alertController, n);
            if (this.mOnClickListener != null) {
                AdapterView.OnItemClickListener onItemClickListener = new AdapterView.OnItemClickListener(){

                    public void onItemClick(AdapterView adapterView, View view, int n, long l) {
                        DialogInterface.OnClickListener onClickListener = AlertParams.this.mOnClickListener;
                        DialogInterface dialogInterface = alertController.mDialogInterface;
                        onClickListener.onClick(dialogInterface, n);
                        if (AlertParams.this.mIsSingleChoice) {
                            return;
                        }
                        alertController.mDialogInterface.dismiss();
                    }
                };
                recycleListView.setOnItemClickListener(onItemClickListener);
            } else if (this.mOnCheckboxClickListener != null) {
                AdapterView.OnItemClickListener onItemClickListener = new AdapterView.OnItemClickListener(){

                    public void onItemClick(AdapterView adapterView, View view, int n, long l) {
                        if (AlertParams.this.mCheckedItems != null) {
                            boolean bl;
                            boolean[] blArray = AlertParams.this.mCheckedItems;
                            blArray[n] = bl = recycleListView.isItemChecked(n);
                        }
                        DialogInterface.OnMultiChoiceClickListener onMultiChoiceClickListener = AlertParams.this.mOnCheckboxClickListener;
                        DialogInterface dialogInterface = alertController.mDialogInterface;
                        boolean bl = recycleListView.isItemChecked(n);
                        onMultiChoiceClickListener.onClick(dialogInterface, n, bl);
                    }
                };
                recycleListView.setOnItemClickListener(onItemClickListener);
            }
            if (this.mOnItemSelectedListener != null) {
                AdapterView.OnItemSelectedListener onItemSelectedListener = this.mOnItemSelectedListener;
                recycleListView.setOnItemSelectedListener(onItemSelectedListener);
            }
            if (this.mIsSingleChoice) {
                recycleListView.setChoiceMode(1);
            } else if (this.mIsMultiChoice) {
                recycleListView.setChoiceMode(2);
            }
            recycleListView.mRecycleOnMeasure = bl = this.mRecycleOnMeasure;
            ListView listView = AlertController.access$1002(alertController, recycleListView);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void apply(AlertController alertController) {
            if (this.mCustomTitleView != null) {
                View view = this.mCustomTitleView;
                alertController.setCustomTitle(view);
            } else {
                if (this.mTitle != null) {
                    CharSequence charSequence = this.mTitle;
                    alertController.setTitle(charSequence);
                }
                if (this.mIcon != null) {
                    Drawable drawable2 = this.mIcon;
                    alertController.setIcon(drawable2);
                }
                if (this.mIconId >= 0) {
                    int n = this.mIconId;
                    alertController.setIcon(n);
                }
            }
            if (this.mMessage != null) {
                CharSequence charSequence = this.mMessage;
                alertController.setMessage(charSequence);
            }
            if (this.mPositiveButtonText != null) {
                CharSequence charSequence = this.mPositiveButtonText;
                DialogInterface.OnClickListener onClickListener = this.mPositiveButtonListener;
                alertController.setButton(-1, charSequence, onClickListener, null);
            }
            if (this.mNegativeButtonText != null) {
                CharSequence charSequence = this.mNegativeButtonText;
                DialogInterface.OnClickListener onClickListener = this.mNegativeButtonListener;
                alertController.setButton(-1, charSequence, onClickListener, null);
            }
            if (this.mNeutralButtonText != null) {
                CharSequence charSequence = this.mNeutralButtonText;
                DialogInterface.OnClickListener onClickListener = this.mNeutralButtonListener;
                alertController.setButton(-1, charSequence, onClickListener, null);
            }
            if (this.mForceInverseBackground) {
                alertController.setInverseBackgroundForced(true);
            }
            if (this.mItems != null || this.mCursor != null || this.mAdapter != null) {
                this.createListView(alertController);
            }
            if (this.mView == null) {
                return;
            }
            if (this.mViewSpacingSpecified) {
                View view = this.mView;
                int n = this.mViewSpacingLeft;
                int n2 = this.mViewSpacingTop;
                int n3 = this.mViewSpacingRight;
                int n4 = this.mViewSpacingBottom;
                alertController.setView(view, n, n2, n3, n4);
                return;
            }
            View view = this.mView;
            alertController.setView(view);
        }

        public static interface OnPrepareListViewListener {
            public void onPrepareListView(ListView var1);
        }
    }

    public static class RecycleListView
    extends ListView {
        boolean mRecycleOnMeasure = true;

        public RecycleListView(Context context) {
            super(context);
        }

        public RecycleListView(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public RecycleListView(Context context, AttributeSet attributeSet, int n) {
            super(context, attributeSet, n);
        }

        @Override
        protected boolean recycleOnMeasure() {
            return this.mRecycleOnMeasure;
        }
    }

    private static final class ButtonHandler
    extends Handler {
        private static final int MSG_DISMISS_DIALOG = 1;
        private WeakReference<DialogInterface> mDialog;

        public ButtonHandler(DialogInterface dialogInterface) {
            WeakReference<DialogInterface> weakReference = new WeakReference<DialogInterface>(dialogInterface);
            this.mDialog = weakReference;
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case -3: 
                case -2: 
                case -1: {
                    DialogInterface.OnClickListener onClickListener = (DialogInterface.OnClickListener)message.obj;
                    DialogInterface dialogInterface = (DialogInterface)this.mDialog.get();
                    int n = message.what;
                    onClickListener.onClick(dialogInterface, n);
                    return;
                }
                case 1: 
            }
            ((DialogInterface)message.obj).dismiss();
        }
    }
}

