/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.pm.PackageInfoLite;
import android.content.res.ObbInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;

public interface IMediaContainerService
extends IInterface {
    public boolean checkFreeStorage(boolean var1, Uri var2) throws RemoteException;

    public boolean copyResource(Uri var1, ParcelFileDescriptor var2) throws RemoteException;

    public String copyResourceToContainer(Uri var1, String var2, String var3, String var4) throws RemoteException;

    public PackageInfoLite getMinimalPackageInfo(Uri var1, int var2) throws RemoteException;

    public ObbInfo getObbInfo(String var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMediaContainerService {
        private static final String DESCRIPTOR = "com.android.internal.app.IMediaContainerService";
        static final int TRANSACTION_checkFreeStorage = 4;
        static final int TRANSACTION_copyResource = 2;
        static final int TRANSACTION_copyResourceToContainer = 1;
        static final int TRANSACTION_getMinimalPackageInfo = 3;
        static final int TRANSACTION_getObbInfo = 5;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static IMediaContainerService asInterface(IBinder iBinder) {
            void var1_2;
            if (iBinder == null) {
                return var1_2;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IMediaContainerService) {
                IMediaContainerService iMediaContainerService = (IMediaContainerService)iInterface;
                return var1_2;
            }
            Proxy proxy = new Proxy(iBinder);
            return var1_2;
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Uri uri = parcel.readInt() != 0 ? Uri.CREATOR.createFromParcel(parcel) : null;
                    String string2 = parcel.readString();
                    String string3 = parcel.readString();
                    String string4 = parcel.readString();
                    String string5 = this.copyResourceToContainer(uri, string2, string3, string4);
                    parcel2.writeNoException();
                    parcel2.writeString(string5);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Uri uri = parcel.readInt() != 0 ? Uri.CREATOR.createFromParcel(parcel) : null;
                    ParcelFileDescriptor parcelFileDescriptor = parcel.readInt() != 0 ? ParcelFileDescriptor.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.copyResource(uri, parcelFileDescriptor);
                    parcel2.writeNoException();
                    int n3 = bl ? 1 : 0;
                    parcel2.writeInt(n3);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Uri uri = parcel.readInt() != 0 ? Uri.CREATOR.createFromParcel(parcel) : null;
                    int n4 = parcel.readInt();
                    PackageInfoLite packageInfoLite = this.getMinimalPackageInfo(uri, n4);
                    parcel2.writeNoException();
                    if (packageInfoLite != null) {
                        parcel2.writeInt(1);
                        packageInfoLite.writeToParcel(parcel2, 1);
                        return true;
                    } else {
                        parcel2.writeInt(0);
                    }
                    return true;
                }
                case 4: {
                    Uri uri;
                    parcel.enforceInterface(DESCRIPTOR);
                    if (parcel.readInt() != 0) {
                        Object var6_9 = null;
                    } else {
                        boolean bl = false;
                    }
                    Uri uri2 = parcel.readInt() != 0 ? Uri.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.checkFreeStorage((boolean)uri, uri2);
                    parcel2.writeNoException();
                    int n5 = bl ? 1 : 0;
                    parcel2.writeInt(n5);
                    return true;
                }
                case 5: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            String string6 = parcel.readString();
            ObbInfo obbInfo = this.getObbInfo(string6);
            parcel2.writeNoException();
            if (obbInfo != null) {
                parcel2.writeInt(1);
                obbInfo.writeToParcel(parcel2, 1);
                return true;
            } else {
                parcel2.writeInt(0);
            }
            return true;
        }

        private static class Proxy
        implements IMediaContainerService {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean checkFreeStorage(boolean bl, Uri uri) throws RemoteException {
                boolean bl2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    int n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    if (uri != null) {
                        parcel.writeInt(1);
                        uri.writeToParcel(parcel, 0);
                    } else {
                        n = 0;
                        parcel.writeInt(n);
                    }
                    boolean bl3 = this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    bl2 = n2 != 0;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                parcel2.recycle();
                parcel.recycle();
                return bl2;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean copyResource(Uri uri, ParcelFileDescriptor parcelFileDescriptor) throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    int n;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (uri != null) {
                        parcel.writeInt(1);
                        uri.writeToParcel(parcel, 0);
                    } else {
                        n = 0;
                        parcel.writeInt(n);
                    }
                    if (parcelFileDescriptor != null) {
                        parcel.writeInt(1);
                        parcelFileDescriptor.writeToParcel(parcel, 0);
                    } else {
                        n = 0;
                        parcel.writeInt(n);
                    }
                    boolean bl2 = this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    bl = n2 != 0;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                parcel2.recycle();
                parcel.recycle();
                return bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public String copyResourceToContainer(Uri uri, String string2, String string3, String string4) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    String string5;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (uri != null) {
                        parcel.writeInt(1);
                        uri.writeToParcel(parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    parcel.writeString(string4);
                    boolean bl = this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    String string6 = string5 = parcel2.readString();
                    parcel2.recycle();
                    parcel.recycle();
                    return string6;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public PackageInfoLite getMinimalPackageInfo(Uri uri, int n) throws RemoteException {
                PackageInfoLite packageInfoLite;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (uri != null) {
                        parcel.writeInt(1);
                        uri.writeToParcel(parcel, 0);
                    } else {
                        int n2 = 0;
                        parcel.writeInt(n2);
                    }
                    parcel.writeInt(n);
                    boolean bl = this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    packageInfoLite = parcel2.readInt() != 0 ? PackageInfoLite.CREATOR.createFromParcel(parcel2) : null;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                parcel2.recycle();
                parcel.recycle();
                return packageInfoLite;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ObbInfo getObbInfo(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    ObbInfo obbInfo = parcel2.readInt() != 0 ? ObbInfo.CREATOR.createFromParcel(parcel2) : null;
                    return obbInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

