/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.ComponentName;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.android.internal.os.PkgUsageStats;

public interface IUsageStats
extends IInterface {
    public PkgUsageStats[] getAllPkgUsageStats() throws RemoteException;

    public PkgUsageStats getPkgUsageStats(ComponentName var1) throws RemoteException;

    public void noteLaunchTime(ComponentName var1, int var2) throws RemoteException;

    public void notePauseComponent(ComponentName var1) throws RemoteException;

    public void noteResumeComponent(ComponentName var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IUsageStats {
        private static final String DESCRIPTOR = "com.android.internal.app.IUsageStats";
        static final int TRANSACTION_getAllPkgUsageStats = 5;
        static final int TRANSACTION_getPkgUsageStats = 4;
        static final int TRANSACTION_noteLaunchTime = 3;
        static final int TRANSACTION_notePauseComponent = 2;
        static final int TRANSACTION_noteResumeComponent = 1;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static IUsageStats asInterface(IBinder iBinder) {
            void var1_2;
            if (iBinder == null) {
                return var1_2;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IUsageStats) {
                IUsageStats iUsageStats = (IUsageStats)iInterface;
                return var1_2;
            }
            Proxy proxy = new Proxy(iBinder);
            return var1_2;
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ComponentName componentName = parcel.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel) : null;
                    this.noteResumeComponent(componentName);
                    parcel2.writeNoException();
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ComponentName componentName = parcel.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel) : null;
                    this.notePauseComponent(componentName);
                    parcel2.writeNoException();
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ComponentName componentName = parcel.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel) : null;
                    int n3 = parcel.readInt();
                    this.noteLaunchTime(componentName, n3);
                    parcel2.writeNoException();
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ComponentName componentName = parcel.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel) : null;
                    PkgUsageStats pkgUsageStats = this.getPkgUsageStats(componentName);
                    parcel2.writeNoException();
                    if (pkgUsageStats != null) {
                        parcel2.writeInt(1);
                        pkgUsageStats.writeToParcel(parcel2, 1);
                        return true;
                    } else {
                        parcel2.writeInt(0);
                    }
                    return true;
                }
                case 5: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            Parcelable[] parcelableArray = this.getAllPkgUsageStats();
            parcel2.writeNoException();
            parcel2.writeTypedArray(parcelableArray, 1);
            return true;
        }

        private static class Proxy
        implements IUsageStats {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override
            public PkgUsageStats[] getAllPkgUsageStats() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    Parcelable.Creator<PkgUsageStats> creator = PkgUsageStats.CREATOR;
                    PkgUsageStats[] pkgUsageStatsArray = parcel2.createTypedArray(creator);
                    return pkgUsageStatsArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public PkgUsageStats getPkgUsageStats(ComponentName componentName) throws RemoteException {
                PkgUsageStats pkgUsageStats;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    boolean bl = this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    pkgUsageStats = parcel2.readInt() != 0 ? PkgUsageStats.CREATOR.createFromParcel(parcel2) : null;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                parcel2.recycle();
                parcel.recycle();
                return pkgUsageStats;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void noteLaunchTime(ComponentName componentName, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        int n2 = 0;
                        parcel.writeInt(n2);
                    }
                    parcel.writeInt(n);
                    boolean bl = this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void notePauseComponent(ComponentName componentName) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    boolean bl = this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void noteResumeComponent(ComponentName componentName) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    boolean bl = this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

