/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.LocationManager;
import android.os.Bundle;
import android.util.Log;
import android.widget.Toast;
import com.android.internal.app.AlertActivity;
import com.android.internal.app.AlertController;

public class NetInitiatedActivity
extends AlertActivity
implements DialogInterface.OnClickListener {
    public static final String BUTTON_TEXT_ACCEPT = "Accept";
    public static final String BUTTON_TEXT_DENY = "Deny";
    private static final boolean DEBUG = true;
    private static final int NEGATIVE_BUTTON = 254;
    private static final int POSITIVE_BUTTON = 255;
    private static final String TAG = "NetInitiatedActivity";
    private static final boolean VERBOSE;
    private BroadcastReceiver mNetInitiatedReceiver;
    private int notificationId = -1;

    public NetInitiatedActivity() {
        BroadcastReceiver broadcastReceiver;
        this.mNetInitiatedReceiver = broadcastReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                StringBuilder stringBuilder = new StringBuilder().append("NetInitiatedReceiver onReceive: ");
                String string2 = intent.getAction();
                String string3 = stringBuilder.append(string2).toString();
                int n = Log.d(NetInitiatedActivity.TAG, string3);
                if (intent.getAction() != "android.intent.action.NETWORK_INITIATED_VERIFY") {
                    return;
                }
                NetInitiatedActivity.this.handleNIVerify(intent);
            }
        };
    }

    private void handleNIVerify(Intent intent) {
        int n;
        this.notificationId = n = intent.getIntExtra("notif_id", -1);
        StringBuilder stringBuilder = new StringBuilder().append("handleNIVerify action: ");
        String string2 = intent.getAction();
        String string3 = stringBuilder.append(string2).toString();
        int n2 = Log.d(TAG, string3);
    }

    private void sendUserResponse(int n) {
        String string2 = "sendUserResponse, response: " + n;
        int n2 = Log.d(TAG, string2);
        LocationManager locationManager = (LocationManager)this.getSystemService("location");
        int n3 = this.notificationId;
        boolean bl = locationManager.sendNiResponse(n3, n);
    }

    private void showNIError() {
        Toast.makeText((Context)this, "NI error", 1).show();
    }

    @Override
    public void onClick(DialogInterface dialogInterface, int n) {
        if (n == -1) {
            this.sendUserResponse(1);
        }
        if (n == -1) {
            this.sendUserResponse(2);
        }
        this.finish();
        this.notificationId = -1;
    }

    @Override
    protected void onCreate(Bundle bundle) {
        int n;
        super.onCreate(bundle);
        Intent intent = this.getIntent();
        AlertController.AlertParams alertParams = this.mAlertParams;
        alertParams.mIconId = 17301909;
        String string2 = intent.getStringExtra("title");
        alertParams.mTitle = string2;
        String string3 = intent.getStringExtra("message");
        alertParams.mMessage = string3;
        alertParams.mPositiveButtonText = BUTTON_TEXT_ACCEPT;
        alertParams.mPositiveButtonListener = this;
        alertParams.mNegativeButtonText = BUTTON_TEXT_DENY;
        alertParams.mNegativeButtonListener = this;
        this.notificationId = n = intent.getIntExtra("notif_id", -1);
        StringBuilder stringBuilder = new StringBuilder().append("onCreate, notifId: ");
        int n2 = this.notificationId;
        String string4 = stringBuilder.append(n2).toString();
        int n3 = Log.d(TAG, string4);
        this.setupAlert();
    }

    @Override
    protected void onPause() {
        super.onPause();
        int n = Log.d(TAG, "onPause");
        BroadcastReceiver broadcastReceiver = this.mNetInitiatedReceiver;
        this.unregisterReceiver(broadcastReceiver);
    }

    @Override
    protected void onResume() {
        super.onResume();
        int n = Log.d(TAG, "onResume");
        BroadcastReceiver broadcastReceiver = this.mNetInitiatedReceiver;
        IntentFilter intentFilter = new IntentFilter("android.intent.action.NETWORK_INITIATED_VERIFY");
        Intent intent = this.registerReceiver(broadcastReceiver, intentFilter);
    }
}

