/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.provider.Settings;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListView;
import android.widget.TextView;
import com.android.internal.app.AlertActivity;
import com.android.internal.app.AlertController;

public final class RingtonePickerActivity
extends AlertActivity
implements AdapterView.OnItemSelectedListener,
Runnable,
DialogInterface.OnClickListener,
AlertController.AlertParams.OnPrepareListViewListener {
    private static final int DELAY_MS_SELECTION_PLAYED = 300;
    private static final String TAG = "RingtonePickerActivity";
    private int mClickedPos = -1;
    private Cursor mCursor;
    private Ringtone mDefaultRingtone;
    private int mDefaultRingtonePos = -1;
    private Uri mExistingUri;
    private Handler mHandler;
    private boolean mHasDefaultItem;
    private boolean mHasSilentItem;
    private DialogInterface.OnClickListener mRingtoneClickListener;
    private RingtoneManager mRingtoneManager;
    private int mSampleRingtonePos = -1;
    private int mSilentPos = -1;
    private int mStaticItemCount;
    private Uri mUriForDefaultItem;

    public RingtonePickerActivity() {
        DialogInterface.OnClickListener onClickListener;
        this.mRingtoneClickListener = onClickListener = new DialogInterface.OnClickListener(){

            @Override
            public void onClick(DialogInterface dialogInterface, int n) {
                int n2 = RingtonePickerActivity.access$002(RingtonePickerActivity.this, n);
                RingtonePickerActivity.this.playRingtone(n, 0);
            }
        };
    }

    static /* synthetic */ int access$002(RingtonePickerActivity ringtonePickerActivity, int n) {
        ringtonePickerActivity.mClickedPos = n;
        return n;
    }

    private int addDefaultRingtoneItem(ListView listView) {
        return this.addStaticItem(listView, 17040144);
    }

    private int addSilentItem(ListView listView) {
        return this.addStaticItem(listView, 17040146);
    }

    private int addStaticItem(ListView listView, int n) {
        int n2;
        TextView textView = (TextView)this.getLayoutInflater().inflate(17367058, (ViewGroup)listView, false);
        textView.setText(n);
        listView.addHeaderView(textView);
        this.mStaticItemCount = n2 = this.mStaticItemCount + 1;
        return listView.getHeaderViewsCount() - 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getListPosition(int n) {
        if (n >= 0) return this.mStaticItemCount + n;
        return n;
    }

    private int getRingtoneManagerPosition(int n) {
        int n2 = this.mStaticItemCount;
        return n - n2;
    }

    private void playRingtone(int n, int n2) {
        this.mHandler.removeCallbacks(this);
        this.mSampleRingtonePos = n;
        Handler handler = this.mHandler;
        long l = n2;
        boolean bl = handler.postDelayed(this, l);
    }

    private void stopAnyPlayingRingtone() {
        if (this.mDefaultRingtone != null && this.mDefaultRingtone.isPlaying()) {
            this.mDefaultRingtone.stop();
        }
        if (this.mRingtoneManager == null) {
            return;
        }
        this.mRingtoneManager.stopPreviousRingtone();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onClick(DialogInterface dialogInterface, int n) {
        boolean bl = n == -1;
        this.mRingtoneManager.stopPreviousRingtone();
        if (bl) {
            Uri uri;
            Intent intent = new Intent();
            int n2 = this.mClickedPos;
            int n3 = this.mDefaultRingtonePos;
            if (n2 != n3) {
                uri = this.mUriForDefaultItem;
            } else {
                int n4 = this.mClickedPos;
                int n5 = this.mSilentPos;
                if (n4 != n5) {
                    uri = null;
                } else {
                    RingtoneManager ringtoneManager = this.mRingtoneManager;
                    int n6 = this.mClickedPos;
                    int n7 = this.getRingtoneManagerPosition(n6);
                    uri = ringtoneManager.getRingtoneUri(n7);
                }
            }
            Intent intent2 = intent.putExtra("android.intent.extra.ringtone.PICKED_URI", uri);
            this.setResult(-1, intent);
        } else {
            this.setResult(0);
        }
        View view = this.getWindow().getDecorView();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                RingtonePickerActivity.this.mCursor.deactivate();
            }
        };
        boolean bl2 = view.post(runnable);
        this.finish();
    }

    @Override
    protected void onCreate(Bundle bundle) {
        CharSequence charSequence;
        DialogInterface.OnClickListener onClickListener;
        Cursor cursor;
        Uri uri;
        Cursor cursor2;
        RingtoneManager ringtoneManager;
        boolean bl;
        Uri uri2;
        boolean bl2;
        Handler handler;
        super.onCreate(bundle);
        this.mHandler = handler = new Handler();
        Intent intent = this.getIntent();
        this.mHasDefaultItem = bl2 = intent.getBooleanExtra("android.intent.extra.ringtone.SHOW_DEFAULT", true);
        this.mUriForDefaultItem = uri2 = (Uri)intent.getParcelableExtra("android.intent.extra.ringtone.DEFAULT_URI");
        if (this.mUriForDefaultItem == null) {
            Uri uri3;
            this.mUriForDefaultItem = uri3 = Settings.System.DEFAULT_RINGTONE_URI;
        }
        this.mHasSilentItem = bl = intent.getBooleanExtra("android.intent.extra.ringtone.SHOW_SILENT", true);
        this.mRingtoneManager = ringtoneManager = new RingtoneManager(this);
        boolean bl3 = intent.getBooleanExtra("android.intent.extra.ringtone.INCLUDE_DRM", true);
        this.mRingtoneManager.setIncludeDrm(bl3);
        int n = intent.getIntExtra("android.intent.extra.ringtone.TYPE", -1);
        if (n != -1) {
            this.mRingtoneManager.setType(n);
        }
        this.mCursor = cursor2 = this.mRingtoneManager.getCursor();
        int n2 = this.mRingtoneManager.inferStreamType();
        this.setVolumeControlStream(n2);
        this.mExistingUri = uri = (Uri)intent.getParcelableExtra("android.intent.extra.ringtone.EXISTING_URI");
        AlertController.AlertParams alertParams = this.mAlertParams;
        alertParams.mCursor = cursor = this.mCursor;
        alertParams.mOnClickListener = onClickListener = this.mRingtoneClickListener;
        alertParams.mLabelColumn = "title";
        alertParams.mIsSingleChoice = true;
        alertParams.mOnItemSelectedListener = this;
        String string2 = this.getString(17039370);
        alertParams.mPositiveButtonText = string2;
        alertParams.mPositiveButtonListener = this;
        String string3 = this.getString(0x1040000);
        alertParams.mNegativeButtonText = string3;
        alertParams.mPositiveButtonListener = this;
        alertParams.mOnPrepareListViewListener = this;
        alertParams.mTitle = charSequence = intent.getCharSequenceExtra("android.intent.extra.ringtone.TITLE");
        if (alertParams.mTitle == null) {
            String string4 = this.getString(17040147);
            alertParams.mTitle = string4;
        }
        this.setupAlert();
    }

    public void onItemSelected(AdapterView adapterView, View view, int n, long l) {
        this.playRingtone(n, 300);
    }

    public void onNothingSelected(AdapterView adapterView) {
    }

    @Override
    protected void onPause() {
        super.onPause();
        this.stopAnyPlayingRingtone();
    }

    @Override
    public void onPrepareListView(ListView listView) {
        int n;
        if (this.mHasDefaultItem) {
            int n2;
            this.mDefaultRingtonePos = n2 = this.addDefaultRingtoneItem(listView);
            if (RingtoneManager.isDefault(this.mExistingUri)) {
                int n3;
                this.mClickedPos = n3 = this.mDefaultRingtonePos;
            }
        }
        if (this.mHasSilentItem) {
            int n4;
            this.mSilentPos = n4 = this.addSilentItem(listView);
            if (this.mExistingUri == null) {
                int n5;
                this.mClickedPos = n5 = this.mSilentPos;
            }
        }
        if (this.mClickedPos == -1) {
            int n6;
            RingtoneManager ringtoneManager = this.mRingtoneManager;
            Uri uri = this.mExistingUri;
            int n7 = ringtoneManager.getRingtonePosition(uri);
            this.mClickedPos = n6 = this.getListPosition(n7);
        }
        AlertController.AlertParams alertParams = this.mAlertParams;
        alertParams.mCheckedItem = n = this.mClickedPos;
    }

    @Override
    protected void onStop() {
        super.onStop();
        this.stopAnyPlayingRingtone();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void run() {
        Ringtone ringtone;
        int n;
        int n2;
        int n3 = this.mSampleRingtonePos;
        int n4 = this.mSilentPos;
        if (n3 != n4) {
            this.mRingtoneManager.stopPreviousRingtone();
            return;
        }
        if (this.mDefaultRingtone != null && this.mDefaultRingtone.isPlaying()) {
            this.mDefaultRingtone.stop();
            this.mDefaultRingtone = null;
        }
        if ((n2 = this.mSampleRingtonePos) != (n = this.mDefaultRingtonePos)) {
            if (this.mDefaultRingtone == null) {
                Ringtone ringtone2;
                Uri uri = this.mUriForDefaultItem;
                this.mDefaultRingtone = ringtone2 = RingtoneManager.getRingtone(this, uri);
            }
            ringtone = this.mDefaultRingtone;
            this.mRingtoneManager.stopPreviousRingtone();
        } else {
            RingtoneManager ringtoneManager = this.mRingtoneManager;
            int n5 = this.mSampleRingtonePos;
            int n6 = this.getRingtoneManagerPosition(n5);
            ringtone = ringtoneManager.getRingtone(n6);
        }
        if (ringtone == null) {
            return;
        }
        ringtone.play();
    }
}

