/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Handler;
import android.os.Power;
import android.os.PowerManager;
import android.os.Vibrator;
import android.util.Log;

public final class ShutdownThread
extends Thread {
    private static final int MAX_BROADCAST_TIME = 10000;
    private static final int MAX_NUM_PHONE_STATE_READS = 16;
    private static final int MAX_SHUTDOWN_WAIT_TIME = 20000;
    private static final int PHONE_STATE_POLL_SLEEP_MSEC = 500;
    public static final String SHUTDOWN_ACTION_PROPERTY = "sys.shutdown.requested";
    private static final int SHUTDOWN_VIBRATE_MS = 500;
    private static final String TAG = "ShutdownThread";
    private static boolean mReboot;
    private static String mRebootReason;
    private static final ShutdownThread sInstance;
    private static boolean sIsStarted;
    private static Object sIsStartedGuard;
    private boolean mActionDone;
    private final Object mActionDoneSync;
    private Context mContext;
    private Handler mHandler;
    private PowerManager mPowerManager;
    private PowerManager.WakeLock mWakeLock;

    static {
        sIsStartedGuard = new Object();
        sIsStarted = false;
        sInstance = new ShutdownThread();
    }

    private ShutdownThread() {
        Object object;
        this.mActionDoneSync = object = new Object();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void beginShutdownSequence(Context context) {
        Handler handler;
        PowerManager powerManager;
        Object object = sIsStartedGuard;
        synchronized (object) {
            if (sIsStarted) {
                int n = Log.d(TAG, "Request to shutdown already running, returning.");
                return;
            }
            sIsStarted = true;
        }
        ProgressDialog progressDialog = new ProgressDialog(context);
        CharSequence charSequence = context.getText(17039635);
        progressDialog.setTitle(charSequence);
        CharSequence charSequence2 = context.getText(0x1040114);
        progressDialog.setMessage(charSequence2);
        progressDialog.setIndeterminate(true);
        progressDialog.setCancelable(false);
        progressDialog.getWindow().setType(2009);
        if (!context.getResources().getBoolean(0x10D0001)) {
            progressDialog.getWindow().addFlags(4);
        }
        progressDialog.show();
        ShutdownThread.sInstance.mContext = context;
        ShutdownThread shutdownThread = sInstance;
        shutdownThread.mPowerManager = powerManager = (PowerManager)context.getSystemService("power");
        ShutdownThread.sInstance.mWakeLock = null;
        if (ShutdownThread.sInstance.mPowerManager.isScreenOn()) {
            try {
                PowerManager.WakeLock wakeLock;
                ShutdownThread shutdownThread2 = sInstance;
                shutdownThread2.mWakeLock = wakeLock = ShutdownThread.sInstance.mPowerManager.newWakeLock(26, "Shutdown");
                ShutdownThread.sInstance.mWakeLock.acquire();
            }
            catch (SecurityException securityException) {
                int n = Log.w(TAG, "No permission to acquire wake lock", securityException);
                ShutdownThread.sInstance.mWakeLock = null;
            }
        }
        ShutdownThread shutdownThread3 = sInstance;
        shutdownThread3.mHandler = handler = new Handler(){};
        sInstance.start();
    }

    public static void reboot(Context context, String string2, boolean bl) {
        mReboot = true;
        mRebootReason = string2;
        ShutdownThread.shutdown(context, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void rebootOrShutdown(boolean bl, String string2) {
        if (bl) {
            String string3 = "Rebooting, reason: " + string2;
            int n = Log.i(TAG, string3);
            try {
                Power.reboot(string2);
            }
            catch (Exception exception) {
                int n2 = Log.e(TAG, "Reboot failed, will attempt shutdown instead", exception);
            }
        } else {
            Vibrator vibrator = new Vibrator();
            long l = 500L;
            try {
                vibrator.vibrate(l);
            }
            catch (Exception exception) {
                int n = Log.w(TAG, "Failed to vibrate during shutdown.", exception);
            }
            long l2 = 500L;
            try {
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {}
        }
        int n = Log.i(TAG, "Performing low-level shutdown...");
        Power.shutdown();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void shutdown(final Context context, boolean bl) {
        Object object = sIsStartedGuard;
        synchronized (object) {
            if (sIsStarted) {
                int n = Log.d(TAG, "Request to shutdown already running, returning.");
                return;
            }
        }
        int n = Log.d(TAG, "Notifying thread to start radio shutdown");
        if (!bl) {
            ShutdownThread.beginShutdownSequence(context);
            return;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(context).setIcon(17301543).setTitle(17039635).setMessage(17039637);
        DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

            @Override
            public void onClick(DialogInterface dialogInterface, int n) {
                ShutdownThread.beginShutdownSequence(context);
            }
        };
        AlertDialog alertDialog = builder.setPositiveButton(17039379, onClickListener).setNegativeButton(17039369, null).create();
        alertDialog.getWindow().setType(2009);
        if (!context.getResources().getBoolean(0x10D0001)) {
            alertDialog.getWindow().addFlags(4);
        }
        alertDialog.show();
    }

    void actionDone() {
        Object object = this.mActionDoneSync;
        synchronized (object) {
            this.mActionDone = true;
            this.mActionDoneSync.notifyAll();
            return;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 9[TRYBLOCK] [11 : 625->628)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

