/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content;

import android.os.Build;
import android.os.FileUtils;
import android.os.SystemProperties;
import android.util.Log;
import android.util.Pair;
import android.util.Slog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class NativeLibraryHelper {
    private static final String APK_LIB = "lib/";
    private static final int APK_LIB_LENGTH = 0;
    private static final boolean DEBUG_NATIVE = false;
    private static final String GDBSERVER = "gdbserver";
    private static final String LIB_PREFIX = "lib";
    private static final int LIB_PREFIX_LENGTH = 0;
    private static final String LIB_SUFFIX = ".so";
    private static final int LIB_SUFFIX_LENGTH = 0;
    private static final int MIN_ENTRY_LENGTH = 0;
    private static final int PACKAGE_INSTALL_NATIVE_ABI_MISMATCH = 2;
    private static final int PACKAGE_INSTALL_NATIVE_FOUND_LIBRARIES = 0;
    private static final int PACKAGE_INSTALL_NATIVE_NO_LIBRARIES = 1;
    private static final String TAG = "NativeHelper";

    static {
        APK_LIB_LENGTH = APK_LIB.length();
        LIB_PREFIX_LENGTH = LIB_PREFIX.length();
        LIB_SUFFIX_LENGTH = LIB_SUFFIX.length();
        int n = APK_LIB_LENGTH + 2;
        int n2 = LIB_PREFIX_LENGTH;
        int n3 = n + n2 + 1;
        int n4 = LIB_SUFFIX_LENGTH;
        MIN_ENTRY_LENGTH = n3 + n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int copyNativeBinariesLI(File file, File file2) {
        try {
            ZipFile zipFile = new ZipFile(file);
            LinkedList<Pair<ZipEntry, String>> linkedList = new LinkedList<Pair<ZipEntry, String>>();
            int n = NativeLibraryHelper.listPackageNativeBinariesLI(zipFile, linkedList);
            int n2 = linkedList.size();
            int n3 = 0;
            while (n3 < n2) {
                Pair pair = (Pair)linkedList.get(n3);
                String string2 = (String)pair.second;
                File file3 = new File(file2, string2);
                ZipEntry zipEntry = (ZipEntry)pair.first;
                NativeLibraryHelper.copyNativeBinaryLI(zipFile, zipEntry, file2, file3);
                ++n3;
            }
            return 1;
        }
        catch (ZipException zipException) {
            int n = Slog.w(TAG, "Failed to extract data from package file", zipException);
            return -1;
        }
        catch (IOException iOException) {
            int n = Slog.w(TAG, "Failed to cache package shared libs", iOException);
            return -1;
        }
    }

    private static void copyNativeBinaryLI(ZipFile zipFile, ZipEntry zipEntry, File file, File file2) throws IOException {
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        try {
            long l;
            File file3 = File.createTempFile("tmp", "tmp", file);
            String string2 = file3.getPath();
            if (!(FileUtils.copyToFile(inputStream, file3) && file3.setLastModified(l = zipEntry.getTime()) && FileUtils.setPermissions(string2, 493, -1, -1) == 0 && file3.renameTo(file2))) {
                boolean bl = file3.delete();
                String string3 = "Couldn't create cached binary " + file2 + " in " + file;
                throw new IOException(string3);
            }
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int listPackageGdbServerLI(ZipFile zipFile, String string2, List<Pair<ZipEntry, String>> list) throws IOException, ZipException {
        ZipEntry zipEntry;
        String string3 = APK_LIB + string2 + "/" + GDBSERVER;
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        do {
            if (!enumeration.hasMoreElements()) return 1;
        } while ((zipEntry = enumeration.nextElement()).isDirectory() || !zipEntry.getName().equals(string3));
        StringBuilder stringBuilder = new StringBuilder().append("Found gdbserver: ");
        String string4 = zipEntry.getName();
        String string5 = stringBuilder.append(string4).toString();
        int n = Log.d(TAG, string5);
        Pair<ZipEntry, String> pair = Pair.create(zipEntry, GDBSERVER);
        boolean bl = list.add(pair);
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int listPackageNativeBinariesLI(ZipFile zipFile, List<Pair<ZipEntry, String>> list) throws ZipException, IOException {
        String string2 = Build.CPU_ABI;
        int n = NativeLibraryHelper.listPackageSharedLibsForAbiLI(zipFile, string2, list);
        if (n == 2) {
            String string3 = SystemProperties.get("ro.product.cpu.abi2", null);
            if (string3 != null) {
                n = NativeLibraryHelper.listPackageSharedLibsForAbiLI(zipFile, string3, list);
            }
            if (n == 2) {
                int n2 = Slog.w(TAG, "Native ABI mismatch from package file");
                return -1;
            }
            if (n == 0) {
                string2 = string3;
            }
        }
        if (n != 0) return 1;
        int n3 = NativeLibraryHelper.listPackageGdbServerLI(zipFile, string2, list);
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int listPackageSharedLibsForAbiLI(ZipFile zipFile, String string2, List<Pair<ZipEntry, String>> list) throws IOException, ZipException {
        int n = string2.length();
        boolean bl = false;
        boolean bl2 = false;
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            int n2;
            String string3;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            String string4;
            int n8;
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || (n8 = (string4 = zipEntry.getName()).length()) < (n7 = MIN_ENTRY_LENGTH) || !string4.endsWith(LIB_SUFFIX) || !string4.startsWith(APK_LIB) || (n6 = string4.lastIndexOf(47)) < 0 || !string4.regionMatches(n5 = n6 + 1, LIB_PREFIX, 0, n4 = LIB_PREFIX_LENGTH)) continue;
            bl = true;
            int n9 = APK_LIB_LENGTH + n;
            if (n6 == n9 || !string4.regionMatches(n3 = APK_LIB_LENGTH, string2, 0, n) || !FileUtils.isFilenameSafe(new File(string3 = string4.substring(n2 = n6 + 1)))) continue;
            bl2 = true;
            Pair<ZipEntry, String> pair = Pair.create(zipEntry, string3);
            boolean bl3 = list.add(pair);
        }
        if (!bl) {
            return 1;
        }
        if (bl2) return 0;
        return 2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean removeNativeBinariesFromDirLI(File file) {
        File[] fileArray;
        boolean bl = false;
        if (file.exists() && (fileArray = file.listFiles()) != null) {
            int n;
            for (int i = 0; i < (n = fileArray.length); ++i) {
                if (!fileArray[i].delete()) {
                    StringBuilder stringBuilder = new StringBuilder().append("Could not delete native binary: ");
                    String string2 = fileArray[i].getPath();
                    String string3 = stringBuilder.append(string2).toString();
                    int n2 = Slog.w(TAG, string3);
                    continue;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static boolean removeNativeBinariesLI(String string2) {
        return NativeLibraryHelper.removeNativeBinariesFromDirLI(new File(string2));
    }
}

