/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content;

import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.storage.IMountService;
import android.util.Log;

public class PackageHelper {
    public static final int APP_INSTALL_AUTO = 0;
    public static final int APP_INSTALL_EXTERNAL = 2;
    public static final int APP_INSTALL_INTERNAL = 1;
    public static final int RECOMMEND_FAILED_ALREADY_EXISTS = 252;
    public static final int RECOMMEND_FAILED_INSUFFICIENT_STORAGE = 255;
    public static final int RECOMMEND_FAILED_INVALID_APK = 254;
    public static final int RECOMMEND_FAILED_INVALID_LOCATION = 253;
    public static final int RECOMMEND_INSTALL_EXTERNAL = 2;
    public static final int RECOMMEND_INSTALL_INTERNAL = 1;
    public static final int RECOMMEND_MEDIA_UNAVAILABLE = 251;
    private static final String TAG = "PackageHelper";
    private static final boolean localLOGV = true;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String createSdDir(long l, String string2, String string3, int n) {
        IMountService iMountService = PackageHelper.getMountService();
        int n2 = (int)(l >> 20);
        long l2 = n2 * 1024 * 1024;
        if (l - l2 > 0L) {
            ++n2;
        }
        int n3 = n2 + 1;
        String string4 = "Size of container " + n3 + " MB " + l + " bytes";
        int n4 = Log.i(TAG, string4);
        try {
            String string5 = string2;
            String string6 = string3;
            int n5 = n;
            if (iMountService.createSecureContainer(string5, n3, "fat", string6, n5) != 0) {
                String string7 = "Failed to create secure container " + string2;
                int n6 = Log.e(TAG, string7);
                return null;
            }
            String string8 = iMountService.getSecureContainerPath(string2);
            String string9 = "Created secure container " + string2 + " at " + string8;
            int n7 = Log.i(TAG, string9);
            return string8;
        }
        catch (RemoteException remoteException) {
            int n8 = Log.e(TAG, "MountService running?");
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean destroySdDir(String string2) {
        try {
            String string3 = "Forcibly destroying container " + string2;
            int n = Log.i(TAG, string3);
            if (PackageHelper.getMountService().destroySecureContainer(string2, true) == 0) return true;
            String string4 = "Failed to destroy container " + string2;
            int n2 = Log.i(TAG, string4);
            return false;
        }
        catch (RemoteException remoteException) {
            String string5 = "Failed to destroy container " + string2 + " with exception " + remoteException;
            int n = Log.e(TAG, string5);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean finalizeSdDir(String string2) {
        try {
            if (PackageHelper.getMountService().finalizeSecureContainer(string2) == 0) return true;
            String string3 = "Failed to finalize container " + string2;
            int n = Log.i(TAG, string3);
            return false;
        }
        catch (RemoteException remoteException) {
            String string4 = "Failed to finalize container " + string2 + " with exception " + remoteException;
            int n = Log.e(TAG, string4);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IMountService getMountService() {
        IBinder iBinder = ServiceManager.getService("mount");
        if (iBinder != null) {
            return IMountService.Stub.asInterface(iBinder);
        }
        int n = Log.e(TAG, "Can't get mount service");
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getSdDir(String string2) {
        try {
            String string3 = PackageHelper.getMountService().getSecureContainerPath(string2);
            return string3;
        }
        catch (RemoteException remoteException) {
            String string4 = "Failed to get container path for " + string2 + " with exception " + remoteException;
            int n = Log.e(TAG, string4);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] getSecureContainerList() {
        try {
            String[] stringArray = PackageHelper.getMountService().getSecureContainerList();
            return stringArray;
        }
        catch (RemoteException remoteException) {
            String string2 = "Failed to get secure container list with exception" + remoteException;
            int n = Log.e(TAG, string2);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isContainerMounted(String string2) {
        try {
            boolean bl = PackageHelper.getMountService().isSecureContainerMounted(string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            String string3 = "Failed to find out if container " + string2 + " mounted";
            int n = Log.e(TAG, string3);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String mountSdDir(String string2, String string3, int n) {
        try {
            int n2 = PackageHelper.getMountService().mountSecureContainer(string2, string3, n);
            String string4 = PackageHelper.getMountService().getSecureContainerPath(string2);
            if (n2 == 0) return string4;
            String string5 = "Failed to mount container " + string2 + " rc : " + n2;
            int n3 = Log.i(TAG, string5);
            return null;
        }
        catch (RemoteException remoteException) {
            int n4 = Log.e(TAG, "MountService running?");
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean renameSdDir(String string2, String string3) {
        try {
            int n = PackageHelper.getMountService().renameSecureContainer(string2, string3);
            if (n == 0) return true;
            String string4 = "Failed to rename " + string2 + " to " + string3 + "with rc " + n;
            int n2 = Log.e(TAG, string4);
            return false;
        }
        catch (RemoteException remoteException) {
            String string5 = "Failed ot rename  " + string2 + " to " + string3 + " with exception : " + remoteException;
            int n = Log.i(TAG, string5);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean unMountSdDir(String string2) {
        try {
            int n = PackageHelper.getMountService().unmountSecureContainer(string2, true);
            if (n == 0) return true;
            String string3 = "Failed to unmount " + string2 + " with rc " + n;
            int n2 = Log.e(TAG, string3);
            return false;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "MountService running?");
            return false;
        }
    }
}

