/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import java.util.HashSet;

public abstract class PackageMonitor
extends BroadcastReceiver {
    public static final int PACKAGE_PERMANENT_CHANGE = 3;
    public static final int PACKAGE_TEMPORARY_CHANGE = 2;
    public static final int PACKAGE_UNCHANGED = 0;
    public static final int PACKAGE_UPDATING = 1;
    static final IntentFilter sExternalFilt;
    static final IntentFilter sNonDataFilt;
    static final IntentFilter sPackageFilt;
    String[] mAppearingPackages;
    int mChangeType;
    String[] mDisappearingPackages;
    String[] mModifiedPackages;
    Context mRegisteredContext;
    boolean mSomePackagesChanged;
    String[] mTempArray;
    final HashSet<String> mUpdatingPackages;

    static {
        sPackageFilt = new IntentFilter();
        sNonDataFilt = new IntentFilter();
        sExternalFilt = new IntentFilter();
        sPackageFilt.addAction("android.intent.action.PACKAGE_ADDED");
        sPackageFilt.addAction("android.intent.action.PACKAGE_REMOVED");
        sPackageFilt.addAction("android.intent.action.PACKAGE_CHANGED");
        sPackageFilt.addAction("android.intent.action.QUERY_PACKAGE_RESTART");
        sPackageFilt.addAction("android.intent.action.PACKAGE_RESTARTED");
        sPackageFilt.addAction("android.intent.action.UID_REMOVED");
        sPackageFilt.addDataScheme("package");
        sNonDataFilt.addAction("android.intent.action.UID_REMOVED");
        sExternalFilt.addAction("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE");
        sExternalFilt.addAction("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
    }

    public PackageMonitor() {
        HashSet hashSet = new HashSet();
        this.mUpdatingPackages = hashSet;
        String[] stringArray = new String[1];
        this.mTempArray = stringArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean anyPackagesAppearing() {
        if (this.mAppearingPackages == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean anyPackagesDisappearing() {
        if (this.mDisappearingPackages == null) return false;
        return true;
    }

    public boolean didSomePackagesChange() {
        return this.mSomePackagesChanged;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getPackageName(Intent intent) {
        Uri uri = intent.getData();
        if (uri == null) return null;
        return uri.getSchemeSpecificPart();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int isPackageAppearing(String string2) {
        if (this.mAppearingPackages == null) return 0;
        int n = this.mAppearingPackages.length - 1;
        while (n >= 0) {
            String string3 = this.mAppearingPackages[n];
            if (string2.equals(string3)) {
                return this.mChangeType;
            }
            n += -1;
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int isPackageDisappearing(String string2) {
        if (this.mDisappearingPackages == null) return 0;
        int n = this.mDisappearingPackages.length - 1;
        while (n >= 0) {
            String string3 = this.mDisappearingPackages[n];
            if (string2.equals(string3)) {
                return this.mChangeType;
            }
            n += -1;
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isPackageModified(String string2) {
        if (this.mModifiedPackages == null) return false;
        int n = this.mModifiedPackages.length - 1;
        while (n >= 0) {
            String string3 = this.mModifiedPackages[n];
            if (string2.equals(string3)) {
                return true;
            }
            n += -1;
        }
        return false;
    }

    boolean isPackageUpdating(String string2) {
        HashSet<String> hashSet = this.mUpdatingPackages;
        synchronized (hashSet) {
            boolean bl = this.mUpdatingPackages.contains(string2);
            return bl;
        }
    }

    public void onBeginPackageChanges() {
    }

    public void onFinishPackageChanges() {
    }

    public boolean onHandleForceStop(Intent intent, String[] stringArray, int n, boolean bl) {
        return false;
    }

    public void onPackageAdded(String string2, int n) {
    }

    public void onPackageAppeared(String string2, int n) {
    }

    public void onPackageChanged(String string2, int n, String[] stringArray) {
    }

    public void onPackageDisappeared(String string2, int n) {
    }

    public void onPackageModified(String string2) {
    }

    public void onPackageRemoved(String string2, int n) {
    }

    public void onPackageUpdateFinished(String string2, int n) {
    }

    public void onPackageUpdateStarted(String string2, int n) {
    }

    public void onPackagesAvailable(String[] stringArray) {
    }

    public void onPackagesUnavailable(String[] stringArray) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void onReceive(Context context, Intent intent) {
        block21: {
            String string2;
            block27: {
                block26: {
                    block25: {
                        block24: {
                            block23: {
                                block22: {
                                    block20: {
                                        Object var3_3 = null;
                                        this.onBeginPackageChanges();
                                        this.mAppearingPackages = null;
                                        this.mDisappearingPackages = null;
                                        this.mSomePackagesChanged = false;
                                        string2 = intent.getAction();
                                        if (!"android.intent.action.PACKAGE_ADDED".equals(string2)) break block20;
                                        String string3 = this.getPackageName(intent);
                                        int n = intent.getIntExtra("android.intent.extra.UID", 0);
                                        this.mSomePackagesChanged = true;
                                        if (string3 == null) break block21;
                                        String[] stringArray = this.mTempArray;
                                        this.mAppearingPackages = stringArray;
                                        this.mTempArray[0] = string3;
                                        if (intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                                            String[] stringArray2 = this.mTempArray;
                                            this.mModifiedPackages = stringArray2;
                                            this.mChangeType = 1;
                                            this.onPackageUpdateFinished(string3, n);
                                            this.onPackageModified(string3);
                                        } else {
                                            this.mChangeType = 3;
                                            this.onPackageAdded(string3, n);
                                        }
                                        int n2 = this.mChangeType;
                                        this.onPackageAppeared(string3, n2);
                                        if (this.mChangeType == 1) {
                                            HashSet<String> hashSet = this.mUpdatingPackages;
                                            // MONITORENTER : hashSet
                                            boolean bl = this.mUpdatingPackages.remove(string3);
                                            // MONITOREXIT : hashSet
                                        }
                                        break block21;
                                    }
                                    if (!"android.intent.action.PACKAGE_REMOVED".equals(string2)) break block22;
                                    String string4 = this.getPackageName(intent);
                                    int n = intent.getIntExtra("android.intent.extra.UID", 0);
                                    if (string4 != null) {
                                        String[] stringArray = this.mTempArray;
                                        this.mDisappearingPackages = stringArray;
                                        this.mTempArray[0] = string4;
                                        if (intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                                            this.mChangeType = 1;
                                            HashSet<String> hashSet = this.mUpdatingPackages;
                                            // MONITORENTER : hashSet
                                            // MONITOREXIT : hashSet
                                            this.onPackageUpdateStarted(string4, n);
                                        } else {
                                            this.mChangeType = 3;
                                            this.mSomePackagesChanged = true;
                                            this.onPackageRemoved(string4, n);
                                        }
                                        int n3 = this.mChangeType;
                                        this.onPackageDisappeared(string4, n3);
                                    }
                                    break block21;
                                }
                                if (!"android.intent.action.PACKAGE_CHANGED".equals(string2)) break block23;
                                String string5 = this.getPackageName(intent);
                                int n = intent.getIntExtra("android.intent.extra.UID", 0);
                                String[] stringArray = intent.getStringArrayExtra("android.intent.extra.changed_component_name_list");
                                if (string5 != null) {
                                    String[] stringArray3 = this.mTempArray;
                                    this.mModifiedPackages = stringArray3;
                                    this.mTempArray[0] = string5;
                                    this.onPackageChanged(string5, n, stringArray);
                                    this.onPackageModified(string5);
                                }
                                break block21;
                            }
                            if (!"android.intent.action.QUERY_PACKAGE_RESTART".equals(string2)) break block24;
                            String[] stringArray = intent.getStringArrayExtra("android.intent.extra.PACKAGES");
                            this.mDisappearingPackages = stringArray;
                            this.mChangeType = 2;
                            String[] stringArray4 = this.mDisappearingPackages;
                            int n = intent.getIntExtra("android.intent.extra.UID", 0);
                            if (this.onHandleForceStop(intent, stringArray4, n, false)) {
                                this.setResultCode(-1);
                            }
                            break block21;
                        }
                        if (!"android.intent.action.PACKAGE_RESTARTED".equals(string2)) break block25;
                        String string6 = this.getPackageName(intent);
                        String[] stringArray = new String[]{string6};
                        this.mDisappearingPackages = stringArray;
                        this.mChangeType = 2;
                        String[] stringArray5 = this.mDisappearingPackages;
                        int n = intent.getIntExtra("android.intent.extra.UID", 0);
                        boolean bl = this.onHandleForceStop(intent, stringArray5, n, true);
                        break block21;
                    }
                    if (!"android.intent.action.UID_REMOVED".equals(string2)) break block26;
                    int n = intent.getIntExtra("android.intent.extra.UID", 0);
                    this.onUidRemoved(n);
                    break block21;
                }
                if (!"android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE".equals(string2)) break block27;
                String[] stringArray = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                this.mAppearingPackages = stringArray;
                this.mChangeType = 2;
                this.mSomePackagesChanged = true;
                if (stringArray != null) {
                    int n;
                    this.onPackagesAvailable(stringArray);
                    for (int i = 0; i < (n = stringArray.length); ++i) {
                        String string7 = stringArray[i];
                        this.onPackageAppeared(string7, 2);
                    }
                }
                break block21;
            }
            if ("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(string2)) {
                String[] stringArray = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                this.mDisappearingPackages = stringArray;
                this.mChangeType = 2;
                this.mSomePackagesChanged = true;
                if (stringArray != null) {
                    int n;
                    this.onPackagesUnavailable(stringArray);
                    for (int i = 0; i < (n = stringArray.length); ++i) {
                        String string8 = stringArray[i];
                        this.onPackageDisappeared(string8, 2);
                    }
                }
            }
        }
        if (this.mSomePackagesChanged) {
            this.onSomePackagesChanged();
        }
        this.onFinishPackageChanges();
    }

    public void onSomePackagesChanged() {
    }

    public void onUidRemoved(int n) {
    }

    public void register(Context context, boolean bl) {
        if (this.mRegisteredContext != null) {
            throw new IllegalStateException("Already registered");
        }
        this.mRegisteredContext = context;
        IntentFilter intentFilter = sPackageFilt;
        Intent intent = context.registerReceiver(this, intentFilter);
        IntentFilter intentFilter2 = sNonDataFilt;
        Intent intent2 = context.registerReceiver(this, intentFilter2);
        if (!bl) {
            return;
        }
        IntentFilter intentFilter3 = sExternalFilt;
        Intent intent3 = context.registerReceiver(this, intentFilter3);
    }

    public void unregister() {
        if (this.mRegisteredContext == null) {
            throw new IllegalStateException("Not registered");
        }
        this.mRegisteredContext.unregisterReceiver(this);
        this.mRegisteredContext = null;
    }
}

