/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content;

import android.accounts.Account;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import com.android.internal.util.ArrayUtils;

public class SyncStateContentProviderHelper {
    private static final String[] ACCOUNT_PROJECTION;
    private static long DB_VERSION = 0L;
    public static final String PATH = "syncstate";
    private static final String QUERY_COUNT_SYNC_STATE_ROWS = "SELECT count(*) FROM _sync_state WHERE _id=?";
    private static final String SELECT_BY_ACCOUNT = "account_name=? AND account_type=?";
    private static final String SYNC_STATE_META_TABLE = "_sync_state_metadata";
    private static final String SYNC_STATE_META_VERSION_COLUMN = "version";
    private static final String SYNC_STATE_TABLE = "_sync_state";

    static {
        DB_VERSION = 1L;
        String[] stringArray = new String[]{"account_name", "account_type"};
        ACCOUNT_PROJECTION = stringArray;
    }

    public void createDatabase(SQLiteDatabase sQLiteDatabase) {
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS _sync_state");
        sQLiteDatabase.execSQL("CREATE TABLE _sync_state (_id INTEGER PRIMARY KEY,account_name TEXT NOT NULL,account_type TEXT NOT NULL,data TEXT,UNIQUE(account_name, account_type));");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS _sync_state_metadata");
        sQLiteDatabase.execSQL("CREATE TABLE _sync_state_metadata (version INTEGER);");
        ContentValues contentValues = new ContentValues();
        Long l = DB_VERSION;
        contentValues.put(SYNC_STATE_META_VERSION_COLUMN, l);
        long l2 = sQLiteDatabase.insert(SYNC_STATE_META_TABLE, SYNC_STATE_META_VERSION_COLUMN, contentValues);
    }

    public int delete(SQLiteDatabase sQLiteDatabase, String string2, String[] stringArray) {
        return sQLiteDatabase.delete(SYNC_STATE_TABLE, string2, stringArray);
    }

    public long insert(SQLiteDatabase sQLiteDatabase, ContentValues contentValues) {
        return sQLiteDatabase.replace(SYNC_STATE_TABLE, "account_name", contentValues);
    }

    public void onAccountsChanged(SQLiteDatabase sQLiteDatabase, Account[] accountArray) {
        String[] stringArray = ACCOUNT_PROJECTION;
        SQLiteDatabase sQLiteDatabase2 = sQLiteDatabase;
        String[] stringArray2 = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Cursor cursor = sQLiteDatabase2.query(SYNC_STATE_TABLE, stringArray, null, stringArray2, string2, string3, string4);
        try {
            while (cursor.moveToNext()) {
                String string5;
                String string6 = cursor.getString(0);
                Account account = new Account(string6, string5 = cursor.getString(1));
                if (ArrayUtils.contains(accountArray, account)) continue;
                String[] stringArray3 = new String[]{string6, string5};
                int n = sQLiteDatabase.delete(SYNC_STATE_TABLE, SELECT_BY_ACCOUNT, stringArray3);
            }
        }
        finally {
            cursor.close();
        }
    }

    public void onDatabaseOpened(SQLiteDatabase sQLiteDatabase) {
        long l;
        long l2 = DatabaseUtils.longForQuery(sQLiteDatabase, "SELECT version FROM _sync_state_metadata", null);
        if (l2 == (l = DB_VERSION)) {
            return;
        }
        this.createDatabase(sQLiteDatabase);
    }

    public Cursor query(SQLiteDatabase sQLiteDatabase, String[] stringArray, String string2, String[] stringArray2, String string3) {
        SQLiteDatabase sQLiteDatabase2 = sQLiteDatabase;
        String[] stringArray3 = stringArray;
        String string4 = string2;
        String[] stringArray4 = stringArray2;
        String string5 = null;
        String string6 = string3;
        return sQLiteDatabase2.query(SYNC_STATE_TABLE, stringArray3, string4, stringArray4, null, string5, string6);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int update(SQLiteDatabase sQLiteDatabase, long l, Object object) {
        String string2 = Long.toString(l);
        String[] stringArray = new String[]{string2};
        if (DatabaseUtils.longForQuery(sQLiteDatabase, QUERY_COUNT_SYNC_STATE_ROWS, stringArray) < 1L) {
            return 0;
        }
        String string3 = "UPDATE _sync_state SET data=? WHERE _id=" + l;
        Object[] objectArray = new Object[]{object};
        sQLiteDatabase.execSQL(string3, objectArray);
        return 1;
    }

    public int update(SQLiteDatabase sQLiteDatabase, ContentValues contentValues, String string2, String[] stringArray) {
        return sQLiteDatabase.update(SYNC_STATE_TABLE, contentValues, string2, stringArray);
    }
}

