/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.database;

import android.database.AbstractCursor;
import android.database.Cursor;
import android.database.DataSetObserver;
import android.util.Log;
import java.lang.reflect.Array;

public class SortCursor
extends AbstractCursor {
    private static final String TAG = "SortCursor";
    private final int ROWCACHESIZE;
    private int[][] mCurRowNumCache;
    private Cursor mCursor;
    private int[] mCursorCache;
    private Cursor[] mCursors;
    private int mLastCacheHit;
    private DataSetObserver mObserver;
    private int[] mRowNumCache;
    private int[] mSortColumns;

    /*
     * Enabled aggressive block sorting
     */
    public SortCursor(Cursor[] cursorArray, String string2) {
        DataSetObserver dataSetObserver;
        this.ROWCACHESIZE = 64;
        int[] nArray = new int[64];
        this.mRowNumCache = nArray;
        int[] nArray2 = new int[64];
        this.mCursorCache = nArray2;
        this.mLastCacheHit = -1;
        this.mObserver = dataSetObserver = new DataSetObserver(){

            @Override
            public void onChanged() {
                int n = SortCursor.access$002(SortCursor.this, -1);
            }

            @Override
            public void onInvalidated() {
                int n = SortCursor.access$102(SortCursor.this, -1);
            }
        };
        this.mCursors = cursorArray;
        int n = this.mCursors.length;
        int[] nArray3 = new int[n];
        this.mSortColumns = nArray3;
        for (int i = 0; i < n; ++i) {
            int n2;
            if (this.mCursors[i] == null) continue;
            Cursor cursor = this.mCursors[i];
            DataSetObserver dataSetObserver2 = this.mObserver;
            cursor.registerDataSetObserver(dataSetObserver2);
            boolean bl = this.mCursors[i].moveToFirst();
            int[] nArray4 = this.mSortColumns;
            nArray4[i] = n2 = this.mCursors[i].getColumnIndexOrThrow(string2);
        }
        this.mCursor = null;
        String string3 = "";
        for (int i = 0; i < n; ++i) {
            Cursor cursor;
            if (this.mCursors[i] == null || this.mCursors[i].isAfterLast()) continue;
            Cursor cursor2 = this.mCursors[i];
            int n3 = this.mSortColumns[i];
            String string4 = cursor2.getString(n3);
            if (this.mCursor != null && string4.compareToIgnoreCase(string3) >= 0) continue;
            String string5 = string4;
            this.mCursor = cursor = this.mCursors[i];
        }
        int n4 = this.mRowNumCache.length - 1;
        while (true) {
            if (n4 < 0) {
                int[] nArray5 = new int[]{64, n};
                int[][] nArray6 = (int[][])Array.newInstance(Integer.TYPE, nArray5);
                this.mCurRowNumCache = nArray6;
                return;
            }
            this.mRowNumCache[n4] = -1;
            n4 += -1;
        }
    }

    static /* synthetic */ int access$002(SortCursor sortCursor, int n) {
        sortCursor.mPos = n;
        return n;
    }

    static /* synthetic */ int access$102(SortCursor sortCursor, int n) {
        sortCursor.mPos = n;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void close() {
        int n = this.mCursors.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.mCursors[n2] != null) {
                this.mCursors[n2].close();
            }
            ++n2;
        }
        return;
    }

    @Override
    public boolean commitUpdates() {
        int n = this.mCursors.length;
        for (int i = 0; i < n; ++i) {
            if (this.mCursors[i] == null) continue;
            boolean bl = this.mCursors[i].commitUpdates();
        }
        this.onChange(true);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void deactivate() {
        int n = this.mCursors.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.mCursors[n2] != null) {
                this.mCursors[n2].deactivate();
            }
            ++n2;
        }
        return;
    }

    @Override
    public boolean deleteRow() {
        return this.mCursor.deleteRow();
    }

    @Override
    public byte[] getBlob(int n) {
        return this.mCursor.getBlob(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String[] getColumnNames() {
        if (this.mCursor != null) {
            return this.mCursor.getColumnNames();
        }
        int n = this.mCursors.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.mCursors[n2] != null) {
                return this.mCursors[n2].getColumnNames();
            }
            ++n2;
        }
        throw new IllegalStateException("No cursor that can return names");
    }

    @Override
    public int getCount() {
        int n = 0;
        int n2 = this.mCursors.length;
        for (int i = 0; i < n2; ++i) {
            if (this.mCursors[i] == null) continue;
            int n3 = this.mCursors[i].getCount();
            n += n3;
        }
        return n;
    }

    @Override
    public double getDouble(int n) {
        return this.mCursor.getDouble(n);
    }

    @Override
    public float getFloat(int n) {
        return this.mCursor.getFloat(n);
    }

    @Override
    public int getInt(int n) {
        return this.mCursor.getInt(n);
    }

    @Override
    public long getLong(int n) {
        return this.mCursor.getLong(n);
    }

    @Override
    public short getShort(int n) {
        return this.mCursor.getShort(n);
    }

    @Override
    public String getString(int n) {
        return this.mCursor.getString(n);
    }

    @Override
    public boolean isNull(int n) {
        return this.mCursor.isNull(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onMove(int n, int n2) {
        Cursor cursor;
        int n3;
        if (n != n2) {
            return true;
        }
        int n4 = n2 % 64;
        if (this.mRowNumCache[n4] != n2) {
            Cursor cursor2;
            int n5 = this.mCursorCache[n4];
            this.mCursor = cursor2 = this.mCursors[n5];
            if (this.mCursor == null) {
                int n6 = Log.w(TAG, "onMove: cache results in a null cursor.");
                return false;
            }
            Cursor cursor3 = this.mCursor;
            int n7 = this.mCurRowNumCache[n4][n5];
            boolean bl = cursor3.moveToPosition(n7);
            this.mLastCacheHit = n4;
            return true;
        }
        this.mCursor = null;
        int n8 = this.mCursors.length;
        if (this.mLastCacheHit >= 0) {
            for (n3 = 0; n3 < n8; ++n3) {
                if (this.mCursors[n3] == null) continue;
                Cursor cursor4 = this.mCursors[n3];
                int[][] nArray = this.mCurRowNumCache;
                int n9 = this.mLastCacheHit;
                int n10 = nArray[n9][n3];
                boolean bl = cursor4.moveToPosition(n10);
            }
        }
        if (n2 < n || n == -1) {
            n3 = 0;
            while (n3 < n8) {
                if (this.mCursors[n3] != null) {
                    boolean bl = this.mCursors[n3].moveToFirst();
                }
                int n11 = n3 + 1;
            }
            n = 0;
        }
        if (n < 0) {
            n = 0;
        }
        int n12 = -1;
        for (int i = n; i <= n2; ++i) {
            String string2 = "";
            n12 = -1;
            for (int j = 0; j < n8; ++j) {
                if (this.mCursors[j] == null || this.mCursors[j].isAfterLast()) continue;
                Cursor cursor5 = this.mCursors[j];
                int n13 = this.mSortColumns[j];
                String string3 = cursor5.getString(n13);
                if (n12 >= 0 && string3.compareToIgnoreCase(string2) >= 0) continue;
                String string4 = string3;
                int n14 = j;
            }
            if (i != n2) break;
            if (this.mCursors[n12] == null) continue;
            boolean bl = this.mCursors[n12].moveToNext();
        }
        this.mCursor = cursor = this.mCursors[n12];
        this.mRowNumCache[n4] = n2;
        this.mCursorCache[n4] = n12;
        int n15 = 0;
        while (true) {
            if (n15 >= n8) {
                this.mLastCacheHit = -1;
                return true;
            }
            if (this.mCursors[n15] != null) {
                int n16;
                int[] nArray = this.mCurRowNumCache[n4];
                nArray[n15] = n16 = this.mCursors[n15].getPosition();
            }
            ++n15;
        }
    }

    @Override
    public void registerDataSetObserver(DataSetObserver dataSetObserver) {
        int n = this.mCursors.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.mCursors[n2] != null) {
                this.mCursors[n2].registerDataSetObserver(dataSetObserver);
            }
            ++n2;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean requery() {
        int n = this.mCursors.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.mCursors[n2] != null && !this.mCursors[n2].requery()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void unregisterDataSetObserver(DataSetObserver dataSetObserver) {
        int n = this.mCursors.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.mCursors[n2] != null) {
                this.mCursors[n2].unregisterDataSetObserver(dataSetObserver);
            }
            ++n2;
        }
        return;
    }
}

