/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.http;

import android.text.format.Time;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HttpDateTime {
    private static final Pattern HTTP_DATE_ANSIC_PATTERN;
    private static final String HTTP_DATE_ANSIC_REGEXP = "[ ]([A-Za-z]{3,9})[ ]+([0-9]{1,2})[ ]([0-9]{1,2}:[0-9][0-9]:[0-9][0-9])[ ]([0-9]{2,4})";
    private static final Pattern HTTP_DATE_RFC_PATTERN;
    private static final String HTTP_DATE_RFC_REGEXP = "([0-9]{1,2})[- ]([A-Za-z]{3,9})[- ]([0-9]{2,4})[ ]([0-9]{1,2}:[0-9][0-9]:[0-9][0-9])";

    static {
        HTTP_DATE_RFC_PATTERN = Pattern.compile(HTTP_DATE_RFC_REGEXP);
        HTTP_DATE_ANSIC_PATTERN = Pattern.compile(HTTP_DATE_ANSIC_REGEXP);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getDate(String string2) {
        if (string2.length() != 2) return string2.charAt(0) - 48;
        int n = (string2.charAt(0) - 48) * 10;
        int n2 = string2.charAt(1) - 48;
        return n + n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getMonth(String string2) {
        char c = Character.toLowerCase(string2.charAt(0));
        char c2 = Character.toLowerCase(string2.charAt(1));
        int n = c + c2;
        char c3 = Character.toLowerCase(string2.charAt(2));
        switch (n + c3 - 291) {
            default: {
                throw new IllegalArgumentException();
            }
            case 22: {
                return 0;
            }
            case 10: {
                return 1;
            }
            case 29: {
                return 2;
            }
            case 32: {
                return 3;
            }
            case 36: {
                return 4;
            }
            case 42: {
                return 5;
            }
            case 40: {
                return 6;
            }
            case 26: {
                return 7;
            }
            case 37: {
                return 8;
            }
            case 35: {
                return 9;
            }
            case 48: {
                return 10;
            }
            case 9: 
        }
        return 11;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static TimeOfDay getTime(String string2) {
        int n;
        int n2 = 0 + 1;
        int n3 = string2.charAt(0) - 48;
        if (string2.charAt(n2) != ':') {
            int n4 = n3 * 10;
            n = n2 + 1;
            int n5 = string2.charAt(n2) - 48;
            n3 = n4 + n5;
        } else {
            n = n2;
        }
        int n6 = n + 1;
        int n7 = n6 + 1;
        int n8 = (string2.charAt(n6) - 48) * 10;
        int n9 = n7 + 1;
        int n10 = string2.charAt(n7) - 48;
        int n11 = n8 + n10;
        int n12 = n9 + 1;
        int n13 = n12 + 1;
        int n14 = (string2.charAt(n12) - 48) * 10;
        int n15 = n13 + 1;
        int n16 = string2.charAt(n13) - 48;
        int n17 = n14 + n16;
        return new TimeOfDay(n3, n11, n17);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getYear(String string2) {
        if (string2.length() == 2) {
            int n;
            int n2 = (string2.charAt(0) - 48) * 10;
            int n3 = n2 + (n = string2.charAt(1) - 48);
            if (n3 < 70) return n3 + 2000;
            return n3 + 1900;
        }
        if (string2.length() == 3) {
            int n = (string2.charAt(0) - 48) * 100;
            int n4 = (string2.charAt(1) - 48) * 10;
            int n5 = n + n4;
            int n6 = string2.charAt(2) - 48;
            return n5 + n6 + 1900;
        }
        if (string2.length() != 4) return 1970;
        int n = (string2.charAt(0) - 48) * 1000;
        int n7 = (string2.charAt(1) - 48) * 100;
        int n8 = n + n7;
        int n9 = (string2.charAt(2) - 48) * 10;
        int n10 = n8 + n9;
        int n11 = string2.charAt(3) - 48;
        return n10 + n11;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static long parse(String string2) throws IllegalArgumentException {
        TimeOfDay timeOfDay;
        int n;
        int n2;
        int n3;
        Matcher matcher = HTTP_DATE_RFC_PATTERN.matcher(string2);
        if (matcher.find()) {
            n3 = HttpDateTime.getDate(matcher.group(1));
            n2 = HttpDateTime.getMonth(matcher.group(2));
            n = HttpDateTime.getYear(matcher.group(3));
            timeOfDay = HttpDateTime.getTime(matcher.group(4));
        } else {
            Matcher matcher2 = HTTP_DATE_ANSIC_PATTERN.matcher(string2);
            if (!matcher2.find()) {
                throw new IllegalArgumentException();
            }
            n2 = HttpDateTime.getMonth(matcher2.group(1));
            n3 = HttpDateTime.getDate(matcher2.group(2));
            timeOfDay = HttpDateTime.getTime(matcher2.group(3));
            n = HttpDateTime.getYear(matcher2.group(4));
        }
        if (n >= 2038) {
            n = 2038;
            n2 = 0;
            n3 = 1;
        }
        Time time = new Time("UTC");
        int n4 = timeOfDay.second;
        int n5 = timeOfDay.minute;
        int n6 = timeOfDay.hour;
        time.set(n4, n5, n6, n3, n2, n);
        return time.toMillis(false);
    }

    private static class TimeOfDay {
        int hour;
        int minute;
        int second;

        TimeOfDay(int n, int n2, int n3) {
            this.hour = n;
            this.minute = n2;
            this.second = n3;
        }
    }
}

