/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.http.multipart;

import com.android.internal.http.multipart.FilePartSource;
import com.android.internal.http.multipart.PartBase;
import com.android.internal.http.multipart.PartSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.util.EncodingUtils;

public class FilePart
extends PartBase {
    public static final String DEFAULT_CHARSET = "ISO-8859-1";
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    public static final String DEFAULT_TRANSFER_ENCODING = "binary";
    protected static final String FILE_NAME = "; filename=";
    private static final byte[] FILE_NAME_BYTES;
    private static final Log LOG;
    private PartSource source;

    static {
        LOG = LogFactory.getLog(FilePart.class);
        FILE_NAME_BYTES = EncodingUtils.getAsciiBytes(FILE_NAME);
    }

    public FilePart(String string2, PartSource partSource) {
        this(string2, partSource, null, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public FilePart(String string2, PartSource partSource, String string3, String string4) {
        String string5 = string3 == null ? DEFAULT_CONTENT_TYPE : string3;
        String string6 = string4 == null ? DEFAULT_CHARSET : string4;
        super(string2, string5, string6, DEFAULT_TRANSFER_ENCODING);
        if (partSource == null) {
            throw new IllegalArgumentException("Source may not be null");
        }
        this.source = partSource;
    }

    public FilePart(String string2, File file) throws FileNotFoundException {
        FilePartSource filePartSource = new FilePartSource(file);
        this(string2, filePartSource, null, null);
    }

    public FilePart(String string2, File file, String string3, String string4) throws FileNotFoundException {
        FilePartSource filePartSource = new FilePartSource(file);
        this(string2, filePartSource, string3, string4);
    }

    public FilePart(String string2, String string3, File file) throws FileNotFoundException {
        FilePartSource filePartSource = new FilePartSource(string3, file);
        this(string2, filePartSource, null, null);
    }

    public FilePart(String string2, String string3, File file, String string4, String string5) throws FileNotFoundException {
        FilePartSource filePartSource = new FilePartSource(string3, file);
        this(string2, filePartSource, string4, string5);
    }

    protected PartSource getSource() {
        LOG.trace("enter getSource()");
        return this.source;
    }

    @Override
    protected long lengthOfData() {
        LOG.trace("enter lengthOfData()");
        return this.source.getLength();
    }

    @Override
    protected void sendData(OutputStream outputStream) throws IOException {
        LOG.trace("enter sendData(OutputStream out)");
        if (this.lengthOfData() == 0L) {
            LOG.debug("No data to send.");
            return;
        }
        byte[] byArray = new byte[4096];
        InputStream inputStream = this.source.createInputStream();
        try {
            int n;
            while ((n = inputStream.read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            inputStream.close();
        }
    }

    @Override
    protected void sendDispositionHeader(OutputStream outputStream) throws IOException {
        LOG.trace("enter sendDispositionHeader(OutputStream out)");
        super.sendDispositionHeader(outputStream);
        String string2 = this.source.getFileName();
        if (string2 == null) {
            return;
        }
        byte[] byArray = FILE_NAME_BYTES;
        outputStream.write(byArray);
        byte[] byArray2 = QUOTE_BYTES;
        outputStream.write(byArray2);
        byte[] byArray3 = EncodingUtils.getAsciiBytes(string2);
        outputStream.write(byArray3);
        byte[] byArray4 = QUOTE_BYTES;
        outputStream.write(byArray4);
    }
}

