/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.http.multipart;

import com.android.internal.http.multipart.Part;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EncodingUtils;

public class MultipartEntity
extends AbstractHttpEntity {
    public static final String MULTIPART_BOUNDARY = "http.method.multipart.boundary";
    private static byte[] MULTIPART_CHARS;
    private static final String MULTIPART_FORM_CONTENT_TYPE = "multipart/form-data";
    private static final Log log;
    private boolean contentConsumed = false;
    private byte[] multipartBoundary;
    private HttpParams params;
    protected Part[] parts;

    static {
        log = LogFactory.getLog(MultipartEntity.class);
        MULTIPART_CHARS = EncodingUtils.getAsciiBytes("-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ");
    }

    public MultipartEntity(Part[] partArray) {
        this.setContentType(MULTIPART_FORM_CONTENT_TYPE);
        if (partArray == null) {
            throw new IllegalArgumentException("parts cannot be null");
        }
        this.parts = partArray;
        this.params = null;
    }

    public MultipartEntity(Part[] partArray, HttpParams httpParams) {
        if (partArray == null) {
            throw new IllegalArgumentException("parts cannot be null");
        }
        if (httpParams == null) {
            throw new IllegalArgumentException("params cannot be null");
        }
        this.parts = partArray;
        this.params = httpParams;
    }

    private static byte[] generateMultipartBoundary() {
        int n;
        Random random = new Random();
        byte[] byArray = new byte[random.nextInt(11) + 30];
        for (int i = 0; i < (n = byArray.length); ++i) {
            byte by;
            byte[] byArray2 = MULTIPART_CHARS;
            int n2 = MULTIPART_CHARS.length;
            int n3 = random.nextInt(n2);
            byArray[i] = by = byArray2[n3];
        }
        return byArray;
    }

    @Override
    public InputStream getContent() throws IOException, IllegalStateException {
        if (!this.isRepeatable() && this.contentConsumed) {
            throw new IllegalStateException("Content has been consumed");
        }
        this.contentConsumed = true;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Part[] partArray = this.parts;
        byte[] byArray = this.multipartBoundary;
        Part.sendParts(byteArrayOutputStream, partArray, byArray);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return new ByteArrayInputStream(byArray2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long getContentLength() {
        try {
            Part[] partArray = this.parts;
            byte[] byArray = this.getMultipartBoundary();
            long l = Part.getLengthOfParts(partArray, byArray);
            return l;
        }
        catch (Exception exception) {
            log.error("An exception occurred while getting the length of the parts", exception);
            return 0L;
        }
    }

    @Override
    public Header getContentType() {
        StringBuffer stringBuffer = new StringBuffer(MULTIPART_FORM_CONTENT_TYPE);
        StringBuffer stringBuffer2 = stringBuffer.append("; boundary=");
        String string2 = EncodingUtils.getAsciiString(this.getMultipartBoundary());
        StringBuffer stringBuffer3 = stringBuffer.append(string2);
        String string3 = stringBuffer.toString();
        return new BasicHeader("Content-Type", string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] getMultipartBoundary() {
        block6: {
            block5: {
                if (this.multipartBoundary != null) break block5;
                String string2 = null;
                if (this.params != null) {
                    string2 = (String)this.params.getParameter(MULTIPART_BOUNDARY);
                }
                if (string2 == null) break block6;
                byte[] byArray = EncodingUtils.getAsciiBytes(string2);
                this.multipartBoundary = byArray;
            }
            return this.multipartBoundary;
        }
        byte[] byArray = MultipartEntity.generateMultipartBoundary();
        this.multipartBoundary = byArray;
        return this.multipartBoundary;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isRepeatable() {
        int n;
        int n2 = 0;
        while (n2 < (n = this.parts.length)) {
            if (!this.parts[n2].isRepeatable()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean isStreaming() {
        return false;
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        Part[] partArray = this.parts;
        byte[] byArray = this.getMultipartBoundary();
        Part.sendParts(outputStream, partArray, byArray);
    }
}

