/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.http.multipart;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.util.EncodingUtils;

public abstract class Part {
    protected static final String BOUNDARY = "----------------314159265358979323846";
    protected static final byte[] BOUNDARY_BYTES;
    protected static final String CHARSET = "; charset=";
    protected static final byte[] CHARSET_BYTES;
    protected static final String CONTENT_DISPOSITION = "Content-Disposition: form-data; name=";
    protected static final byte[] CONTENT_DISPOSITION_BYTES;
    protected static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding: ";
    protected static final byte[] CONTENT_TRANSFER_ENCODING_BYTES;
    protected static final String CONTENT_TYPE = "Content-Type: ";
    protected static final byte[] CONTENT_TYPE_BYTES;
    protected static final String CRLF = "\r\n";
    protected static final byte[] CRLF_BYTES;
    private static final byte[] DEFAULT_BOUNDARY_BYTES;
    protected static final String EXTRA = "--";
    protected static final byte[] EXTRA_BYTES;
    private static final Log LOG;
    protected static final String QUOTE = "\"";
    protected static final byte[] QUOTE_BYTES;
    private byte[] boundaryBytes;

    static {
        LOG = LogFactory.getLog(Part.class);
        BOUNDARY_BYTES = EncodingUtils.getAsciiBytes(BOUNDARY);
        DEFAULT_BOUNDARY_BYTES = BOUNDARY_BYTES;
        CRLF_BYTES = EncodingUtils.getAsciiBytes(CRLF);
        QUOTE_BYTES = EncodingUtils.getAsciiBytes(QUOTE);
        EXTRA_BYTES = EncodingUtils.getAsciiBytes(EXTRA);
        CONTENT_DISPOSITION_BYTES = EncodingUtils.getAsciiBytes(CONTENT_DISPOSITION);
        CONTENT_TYPE_BYTES = EncodingUtils.getAsciiBytes(CONTENT_TYPE);
        CHARSET_BYTES = EncodingUtils.getAsciiBytes(CHARSET);
        CONTENT_TRANSFER_ENCODING_BYTES = EncodingUtils.getAsciiBytes(CONTENT_TRANSFER_ENCODING);
    }

    public static String getBoundary() {
        return BOUNDARY;
    }

    public static long getLengthOfParts(Part[] partArray) throws IOException {
        byte[] byArray = DEFAULT_BOUNDARY_BYTES;
        return Part.getLengthOfParts(partArray, byArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long getLengthOfParts(Part[] partArray, byte[] byArray) throws IOException {
        int n;
        LOG.trace("getLengthOfParts(Parts[])");
        if (partArray == null) {
            throw new IllegalArgumentException("Parts may not be null");
        }
        long l = 0L;
        for (int i = 0; i < (n = partArray.length); ++i) {
            partArray[i].setPartBoundary(byArray);
            long l2 = partArray[i].length();
            if (l2 < 0L) {
                return 65535L;
            }
            l += l2;
        }
        long l3 = EXTRA_BYTES.length;
        long l4 = l + l3;
        long l5 = byArray.length;
        long l6 = l4 + l5;
        long l7 = EXTRA_BYTES.length;
        long l8 = l6 + l7;
        long l9 = CRLF_BYTES.length;
        return l8 + l9;
    }

    public static void sendParts(OutputStream outputStream, Part[] partArray) throws IOException {
        byte[] byArray = DEFAULT_BOUNDARY_BYTES;
        Part.sendParts(outputStream, partArray, byArray);
    }

    public static void sendParts(OutputStream outputStream, Part[] partArray, byte[] byArray) throws IOException {
        int n;
        if (partArray == null) {
            throw new IllegalArgumentException("Parts may not be null");
        }
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("partBoundary may not be empty");
        }
        for (int i = 0; i < (n = partArray.length); ++i) {
            partArray[i].setPartBoundary(byArray);
            partArray[i].send(outputStream);
        }
        byte[] byArray2 = EXTRA_BYTES;
        outputStream.write(byArray2);
        outputStream.write(byArray);
        byte[] byArray3 = EXTRA_BYTES;
        outputStream.write(byArray3);
        byte[] byArray4 = CRLF_BYTES;
        outputStream.write(byArray4);
    }

    public abstract String getCharSet();

    public abstract String getContentType();

    public abstract String getName();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] getPartBoundary() {
        if (this.boundaryBytes != null) return this.boundaryBytes;
        return DEFAULT_BOUNDARY_BYTES;
    }

    public abstract String getTransferEncoding();

    public boolean isRepeatable() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long length() throws IOException {
        LOG.trace("enter length()");
        if (this.lengthOfData() < 0L) {
            return 65535L;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.sendStart(byteArrayOutputStream);
        this.sendDispositionHeader(byteArrayOutputStream);
        this.sendContentTypeHeader(byteArrayOutputStream);
        this.sendTransferEncodingHeader(byteArrayOutputStream);
        this.sendEndOfHeader(byteArrayOutputStream);
        this.sendEnd(byteArrayOutputStream);
        long l = byteArrayOutputStream.size();
        long l2 = this.lengthOfData();
        return l + l2;
    }

    protected abstract long lengthOfData() throws IOException;

    public void send(OutputStream outputStream) throws IOException {
        LOG.trace("enter send(OutputStream out)");
        this.sendStart(outputStream);
        this.sendDispositionHeader(outputStream);
        this.sendContentTypeHeader(outputStream);
        this.sendTransferEncodingHeader(outputStream);
        this.sendEndOfHeader(outputStream);
        this.sendData(outputStream);
        this.sendEnd(outputStream);
    }

    protected void sendContentTypeHeader(OutputStream outputStream) throws IOException {
        LOG.trace("enter sendContentTypeHeader(OutputStream out)");
        String string2 = this.getContentType();
        if (string2 == null) {
            return;
        }
        byte[] byArray = CRLF_BYTES;
        outputStream.write(byArray);
        byte[] byArray2 = CONTENT_TYPE_BYTES;
        outputStream.write(byArray2);
        byte[] byArray3 = EncodingUtils.getAsciiBytes(string2);
        outputStream.write(byArray3);
        String string3 = this.getCharSet();
        if (string3 == null) {
            return;
        }
        byte[] byArray4 = CHARSET_BYTES;
        outputStream.write(byArray4);
        byte[] byArray5 = EncodingUtils.getAsciiBytes(string3);
        outputStream.write(byArray5);
    }

    protected abstract void sendData(OutputStream var1) throws IOException;

    protected void sendDispositionHeader(OutputStream outputStream) throws IOException {
        LOG.trace("enter sendDispositionHeader(OutputStream out)");
        byte[] byArray = CONTENT_DISPOSITION_BYTES;
        outputStream.write(byArray);
        byte[] byArray2 = QUOTE_BYTES;
        outputStream.write(byArray2);
        byte[] byArray3 = EncodingUtils.getAsciiBytes(this.getName());
        outputStream.write(byArray3);
        byte[] byArray4 = QUOTE_BYTES;
        outputStream.write(byArray4);
    }

    protected void sendEnd(OutputStream outputStream) throws IOException {
        LOG.trace("enter sendEnd(OutputStream out)");
        byte[] byArray = CRLF_BYTES;
        outputStream.write(byArray);
    }

    protected void sendEndOfHeader(OutputStream outputStream) throws IOException {
        LOG.trace("enter sendEndOfHeader(OutputStream out)");
        byte[] byArray = CRLF_BYTES;
        outputStream.write(byArray);
        byte[] byArray2 = CRLF_BYTES;
        outputStream.write(byArray2);
    }

    protected void sendStart(OutputStream outputStream) throws IOException {
        LOG.trace("enter sendStart(OutputStream out)");
        byte[] byArray = EXTRA_BYTES;
        outputStream.write(byArray);
        byte[] byArray2 = this.getPartBoundary();
        outputStream.write(byArray2);
        byte[] byArray3 = CRLF_BYTES;
        outputStream.write(byArray3);
    }

    protected void sendTransferEncodingHeader(OutputStream outputStream) throws IOException {
        LOG.trace("enter sendTransferEncodingHeader(OutputStream out)");
        String string2 = this.getTransferEncoding();
        if (string2 == null) {
            return;
        }
        byte[] byArray = CRLF_BYTES;
        outputStream.write(byArray);
        byte[] byArray2 = CONTENT_TRANSFER_ENCODING_BYTES;
        outputStream.write(byArray2);
        byte[] byArray3 = EncodingUtils.getAsciiBytes(string2);
        outputStream.write(byArray3);
    }

    void setPartBoundary(byte[] byArray) {
        this.boundaryBytes = byArray;
    }

    public String toString() {
        return this.getName();
    }
}

