/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.http.multipart;

import com.android.internal.http.multipart.PartBase;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.util.EncodingUtils;

public class StringPart
extends PartBase {
    public static final String DEFAULT_CHARSET = "US-ASCII";
    public static final String DEFAULT_CONTENT_TYPE = "text/plain";
    public static final String DEFAULT_TRANSFER_ENCODING = "8bit";
    private static final Log LOG = LogFactory.getLog(StringPart.class);
    private byte[] content;
    private String value;

    public StringPart(String string2, String string3) {
        this(string2, string3, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public StringPart(String string2, String string3, String string4) {
        String string5 = string4 == null ? DEFAULT_CHARSET : string4;
        super(string2, DEFAULT_CONTENT_TYPE, string5, DEFAULT_TRANSFER_ENCODING);
        if (string3 == null) {
            throw new IllegalArgumentException("Value may not be null");
        }
        if (string3.indexOf(0) != -1) {
            throw new IllegalArgumentException("NULs may not be present in string parts");
        }
        this.value = string3;
    }

    private byte[] getContent() {
        if (this.content == null) {
            String string2 = this.value;
            String string3 = this.getCharSet();
            byte[] byArray = EncodingUtils.getBytes(string2, string3);
            this.content = byArray;
        }
        return this.content;
    }

    @Override
    protected long lengthOfData() {
        LOG.trace("enter lengthOfData()");
        return this.getContent().length;
    }

    @Override
    protected void sendData(OutputStream outputStream) throws IOException {
        LOG.trace("enter sendData(OutputStream)");
        byte[] byArray = this.getContent();
        outputStream.write(byArray);
    }

    @Override
    public void setCharSet(String string2) {
        super.setCharSet(string2);
        this.content = null;
    }
}

