/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.location;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.location.LocationManager;
import android.os.Bundle;
import android.util.Log;
import com.android.internal.app.NetInitiatedActivity;
import java.io.UnsupportedEncodingException;

public class GpsNetInitiatedHandler {
    public static final String ACTION_NI_VERIFY = "android.intent.action.NETWORK_INITIATED_VERIFY";
    private static final boolean DEBUG = true;
    public static final int GPS_ENC_NONE = 0;
    public static final int GPS_ENC_SUPL_GSM_DEFAULT = 1;
    public static final int GPS_ENC_SUPL_UCS2 = 3;
    public static final int GPS_ENC_SUPL_UTF8 = 2;
    public static final int GPS_ENC_UNKNOWN = 255;
    public static final int GPS_NI_NEED_NOTIFY = 1;
    public static final int GPS_NI_NEED_VERIFY = 2;
    public static final int GPS_NI_PRIVACY_OVERRIDE = 4;
    public static final int GPS_NI_RESPONSE_ACCEPT = 1;
    public static final int GPS_NI_RESPONSE_DENY = 2;
    public static final int GPS_NI_RESPONSE_NORESP = 3;
    public static final int GPS_NI_TYPE_UMTS_CTRL_PLANE = 3;
    public static final int GPS_NI_TYPE_UMTS_SUPL = 2;
    public static final int GPS_NI_TYPE_VOICE = 1;
    public static final String NI_EXTRA_CMD_NOTIF_ID = "notif_id";
    public static final String NI_EXTRA_CMD_RESPONSE = "response";
    public static final String NI_INTENT_KEY_DEFAULT_RESPONSE = "default_resp";
    public static final String NI_INTENT_KEY_MESSAGE = "message";
    public static final String NI_INTENT_KEY_NOTIF_ID = "notif_id";
    public static final String NI_INTENT_KEY_TIMEOUT = "timeout";
    public static final String NI_INTENT_KEY_TITLE = "title";
    public static final String NI_RESPONSE_EXTRA_CMD = "send_ni_response";
    private static final String TAG = "GpsNetInitiatedHandler";
    private static final boolean VERBOSE;
    private static boolean mIsHexInput;
    private final Context mContext;
    private final LocationManager mLocationManager;
    private Notification mNiNotification;
    private boolean mPlaySounds = false;
    private boolean mPopupImmediately = true;
    private boolean visible = true;

    static {
        mIsHexInput = true;
    }

    public GpsNetInitiatedHandler(Context context) {
        LocationManager locationManager;
        this.mContext = context;
        this.mLocationManager = locationManager = (LocationManager)context.getSystemService("location");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String decodeGSMPackedString(byte[] byArray) {
        int n;
        byte[] byArray2;
        block7: {
            int n2 = byArray.length;
            int n3 = 0;
            int n4 = 0;
            byArray2 = new byte[byArray.length * 2];
            int n5 = 0;
            int n6 = 0;
            while (n6 < n2) {
                int n7;
                int n8;
                block9: {
                    block8: {
                        int n9 = n5 & 7;
                        n8 = n6 + 1;
                        n4 = byArray[n6];
                        if (n4 < 0) {
                            int n10 = n4 + 256;
                        }
                        int n11 = n4 << n9;
                        int n12 = 8 - n9;
                        n6 = (byte)((n3 >> n12 | n11) & 0x7F);
                        n = n5 + 1;
                        byArray2[n5] = n6;
                        n5 = 6;
                        if (n9 == n5) break block8;
                        if (n8 != n2) {
                            n6 = n4 >> 1;
                            if (n6 == 13) {
                                int n13 = n4;
                                int n14 = n8;
                                break block7;
                            }
                            byte by = (byte)(n4 >> 1);
                            n7 = n + 1;
                            byArray2[n] = by;
                            byte by2 = by;
                            break block9;
                        } else {
                            int n15 = n4;
                            int n16 = n8;
                            break block7;
                        }
                    }
                    int n17 = n6;
                    n7 = n;
                    int n18 = n17;
                }
                n3 = n4;
                int n19 = n7;
                int n20 = n8;
            }
            int n21 = n4;
            n = n5;
            int n22 = n6;
        }
        try {
            return new String(byArray2, 0, n, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string2 = unsupportedEncodingException.getMessage();
            int n23 = Log.e(TAG, string2);
            return "";
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String decodeString(String string2, boolean bl, int n) {
        String string3 = string2;
        byte[] byArray = GpsNetInitiatedHandler.stringToByteArray(string2, bl);
        switch (n) {
            default: {
                String string4 = "Unknown encoding " + n + " for NI text " + string2;
                int n2 = Log.e(TAG, string4);
                return string3;
            }
            case 0: {
                return string2;
            }
            case 1: {
                return GpsNetInitiatedHandler.decodeGSMPackedString(byArray);
            }
            case 2: {
                return GpsNetInitiatedHandler.decodeUTF8String(byArray);
            }
            case 3: {
                return GpsNetInitiatedHandler.decodeUCS2String(byArray);
            }
            case -1: 
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String decodeUCS2String(byte[] byArray) {
        String string2 = "";
        try {
            String string3 = new String(byArray, "UTF-16");
            return string3;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string4 = unsupportedEncodingException.getMessage();
            int n = Log.e(TAG, string4);
            return string2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String decodeUTF8String(byte[] byArray) {
        String string2 = "";
        try {
            String string3 = new String(byArray, "UTF-8");
            return string3;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string4 = unsupportedEncodingException.getMessage();
            int n = Log.e(TAG, string4);
            return string2;
        }
    }

    private static String getDialogMessage(GpsNiNotification gpsNiNotification) {
        return GpsNetInitiatedHandler.getNotifMessage(gpsNiNotification);
    }

    public static String getDialogTitle(GpsNiNotification gpsNiNotification) {
        return GpsNetInitiatedHandler.getNotifTitle(gpsNiNotification);
    }

    private Intent getDlgIntent(GpsNiNotification gpsNiNotification) {
        Intent intent = new Intent();
        String string2 = GpsNetInitiatedHandler.getDialogTitle(gpsNiNotification);
        String string3 = GpsNetInitiatedHandler.getDialogMessage(gpsNiNotification);
        Intent intent2 = intent.setFlags(0x10000000);
        Context context = this.mContext;
        Intent intent3 = intent.setClass(context, NetInitiatedActivity.class);
        int n = gpsNiNotification.notificationId;
        Intent intent4 = intent.putExtra("notif_id", n);
        Intent intent5 = intent.putExtra(NI_INTENT_KEY_TITLE, string2);
        Intent intent6 = intent.putExtra(NI_INTENT_KEY_MESSAGE, string3);
        int n2 = gpsNiNotification.timeout;
        Intent intent7 = intent.putExtra(NI_INTENT_KEY_TIMEOUT, n2);
        int n3 = gpsNiNotification.defaultResponse;
        Intent intent8 = intent.putExtra(NI_INTENT_KEY_DEFAULT_RESPONSE, n3);
        StringBuilder stringBuilder = new StringBuilder().append("generateIntent, title: ").append(string2).append(", message: ").append(string3).append(", timeout: ");
        int n4 = gpsNiNotification.timeout;
        String string4 = stringBuilder.append(n4).toString();
        int n5 = Log.d(TAG, string4);
        return intent;
    }

    private static String getNotifMessage(GpsNiNotification gpsNiNotification) {
        Object[] objectArray = new Object[2];
        String string2 = gpsNiNotification.requestorId;
        boolean bl = mIsHexInput;
        int n = gpsNiNotification.requestorIdEncoding;
        String string3 = GpsNetInitiatedHandler.decodeString(string2, bl, n);
        objectArray[0] = string3;
        String string4 = gpsNiNotification.text;
        boolean bl2 = mIsHexInput;
        int n2 = gpsNiNotification.textEncoding;
        String string5 = GpsNetInitiatedHandler.decodeString(string4, bl2, n2);
        objectArray[1] = string5;
        return String.format("NI Request received from [%s] for client [%s]!", objectArray);
    }

    private static String getNotifTicker(GpsNiNotification gpsNiNotification) {
        Object[] objectArray = new Object[2];
        String string2 = gpsNiNotification.requestorId;
        boolean bl = mIsHexInput;
        int n = gpsNiNotification.requestorIdEncoding;
        String string3 = GpsNetInitiatedHandler.decodeString(string2, bl, n);
        objectArray[0] = string3;
        String string4 = gpsNiNotification.text;
        boolean bl2 = mIsHexInput;
        int n2 = gpsNiNotification.textEncoding;
        String string5 = GpsNetInitiatedHandler.decodeString(string4, bl2, n2);
        objectArray[1] = string5;
        return String.format("Position request! ReqId: [%s] ClientName: [%s]", objectArray);
    }

    private static String getNotifTitle(GpsNiNotification gpsNiNotification) {
        Object[] objectArray = new Object[]{};
        return String.format("Position Request", objectArray);
    }

    private void openNiDialog(GpsNiNotification gpsNiNotification) {
        Intent intent = this.getDlgIntent(gpsNiNotification);
        StringBuilder stringBuilder = new StringBuilder().append("openNiDialog, notifyId: ");
        int n = gpsNiNotification.notificationId;
        StringBuilder stringBuilder2 = stringBuilder.append(n).append(", requestorId: ");
        String string2 = gpsNiNotification.requestorId;
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append(", text: ");
        String string3 = gpsNiNotification.text;
        String string4 = stringBuilder3.append(string3).toString();
        int n2 = Log.d(TAG, string4);
        this.mContext.startActivity(intent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setNiNotification(GpsNiNotification gpsNiNotification) {
        synchronized (this) {
            NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
            if (notificationManager != null) {
                String string2 = GpsNetInitiatedHandler.getNotifTitle(gpsNiNotification);
                String string3 = GpsNetInitiatedHandler.getNotifMessage(gpsNiNotification);
                StringBuilder stringBuilder = new StringBuilder().append("setNiNotification, notifyId: ");
                int n = gpsNiNotification.notificationId;
                String string4 = stringBuilder.append(n).append(", title: ").append(string2).append(", message: ").append(string3).toString();
                int n2 = Log.d(TAG, string4);
                if (this.mNiNotification == null) {
                    Notification notification;
                    this.mNiNotification = notification = new Notification();
                    this.mNiNotification.icon = 17302203;
                    this.mNiNotification.when = 0L;
                }
                if (this.mPlaySounds) {
                    int n3;
                    Notification notification = this.mNiNotification;
                    notification.defaults = n3 = notification.defaults | 1;
                } else {
                    int n4;
                    Notification notification = this.mNiNotification;
                    notification.defaults = n4 = notification.defaults & 0xFFFFFFFE;
                }
                this.mNiNotification.flags = 2;
                Notification notification = this.mNiNotification;
                String string5 = GpsNetInitiatedHandler.getNotifTicker(gpsNiNotification);
                notification.tickerText = string5;
                Intent intent = !this.mPopupImmediately ? this.getDlgIntent(gpsNiNotification) : new Intent();
                PendingIntent pendingIntent = PendingIntent.getBroadcast(this.mContext, 0, intent, 0);
                Notification notification2 = this.mNiNotification;
                Context context = this.mContext;
                notification2.setLatestEventInfo(context, string2, string3, pendingIntent);
                if (this.visible) {
                    int n5 = gpsNiNotification.notificationId;
                    Notification notification3 = this.mNiNotification;
                    notificationManager.notify(n5, notification3);
                } else {
                    int n6 = gpsNiNotification.notificationId;
                    notificationManager.cancel(n6);
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static byte[] stringToByteArray(String string2, boolean bl) {
        int n = bl ? string2.length() / 2 : string2.length();
        byte[] byArray = new byte[n];
        if (bl) {
            for (int i = 0; i < n; ++i) {
                byte by;
                int n2 = i * 2;
                int n3 = i * 2 + 2;
                byArray[i] = by = (byte)Integer.parseInt(string2.substring(n2, n3), 16);
            }
            return byArray;
        } else {
            for (int i = 0; i < n; ++i) {
                byte by;
                byArray[i] = by = (byte)string2.charAt(i);
            }
        }
        return byArray;
    }

    public void handleNiNotification(GpsNiNotification gpsNiNotification) {
        StringBuilder stringBuilder = new StringBuilder().append("handleNiNotification notificationId: ");
        int n = gpsNiNotification.notificationId;
        StringBuilder stringBuilder2 = stringBuilder.append(n).append(" requestorId: ");
        String string2 = gpsNiNotification.requestorId;
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append(" text: ");
        String string3 = gpsNiNotification.text;
        String string4 = stringBuilder3.append(string3).toString();
        int n2 = Log.d(TAG, string4);
        if (gpsNiNotification.needNotify && gpsNiNotification.needVerify && this.mPopupImmediately) {
            this.openNiDialog(gpsNiNotification);
        }
        if (gpsNiNotification.needNotify && !gpsNiNotification.needVerify || gpsNiNotification.needNotify && gpsNiNotification.needVerify && !this.mPopupImmediately) {
            this.setNiNotification(gpsNiNotification);
        }
        if (!(gpsNiNotification.needNotify && !gpsNiNotification.needVerify || !gpsNiNotification.needNotify && !gpsNiNotification.needVerify || gpsNiNotification.privacyOverride)) {
            return;
        }
        LocationManager locationManager = this.mLocationManager;
        int n3 = gpsNiNotification.notificationId;
        boolean bl = locationManager.sendNiResponse(n3, 1);
    }

    public static class GpsNiResponse {
        Bundle extras;
        int userResponse;
    }

    public static class GpsNiNotification {
        public int defaultResponse;
        public Bundle extras;
        public boolean needNotify;
        public boolean needVerify;
        public int niType;
        public int notificationId;
        public boolean privacyOverride;
        public String requestorId;
        public int requestorIdEncoding;
        public String text;
        public int textEncoding;
        public int timeout;
    }
}

