/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.net;

import android.util.Log;
import java.io.IOException;
import javax.security.auth.x500.X500Principal;

public final class DNParser {
    private static final String ERROR_PARSE_ERROR = "Failed to parse DN";
    private static final String TAG = "DNParser";
    private int beg;
    private char[] chars;
    private int cur;
    private final String dn;
    private int end;
    private final int length;
    private int pos;

    public DNParser(X500Principal x500Principal) {
        int n;
        String string2;
        this.dn = string2 = x500Principal.getName("RFC2253");
        this.length = n = this.dn.length();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String escapedAV() throws IOException {
        int n;
        int n2;
        this.beg = n2 = this.pos;
        this.end = n = this.pos;
        block5: while (true) {
            int n3;
            char[] cArray;
            int n4;
            char[] cArray2;
            int n5;
            char[] cArray3;
            int n6;
            char[] cArray4;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            if ((n13 = this.pos) >= (n12 = this.length)) {
                char[] cArray5 = this.chars;
                int n14 = this.beg;
                int n15 = this.end;
                int n16 = this.beg;
                int n17 = n15 - n16;
                return new String(cArray5, n14, n17);
            }
            char[] cArray6 = this.chars;
            int n18 = this.pos;
            switch (cArray6[n18]) {
                default: {
                    int n19;
                    char c;
                    int n20;
                    char[] cArray7 = this.chars;
                    int n21 = this.end;
                    this.end = n20 = n21 + 1;
                    char[] cArray8 = this.chars;
                    int n22 = this.pos;
                    cArray7[n21] = c = cArray8[n22];
                    this.pos = n19 = this.pos + 1;
                    continue block5;
                }
                case '+': 
                case ',': 
                case ';': {
                    char[] cArray9 = this.chars;
                    int n23 = this.beg;
                    int n24 = this.end;
                    int n25 = this.beg;
                    int n26 = n24 - n25;
                    return new String(cArray9, n23, n26);
                }
                case '\\': {
                    int n27;
                    char c;
                    int n28;
                    char[] cArray10 = this.chars;
                    int n29 = this.end;
                    this.end = n28 = n29 + 1;
                    cArray10[n29] = c = this.getEscaped();
                    this.pos = n27 = this.pos + 1;
                    continue block5;
                }
                case ' ': 
            }
            this.cur = n11 = this.end;
            this.pos = n10 = this.pos + 1;
            char[] cArray11 = this.chars;
            int n30 = this.end;
            this.end = n9 = n30 + 1;
            cArray11[n30] = 32;
            while ((n8 = this.pos) < (n7 = this.length) && (cArray4 = this.chars)[n6 = this.pos] == ' ') {
                int n31;
                int n32;
                char[] cArray12 = this.chars;
                int n33 = this.end;
                this.end = n32 = n33 + 1;
                cArray12[n33] = 32;
                this.pos = n31 = this.pos + 1;
            }
            int n34 = this.pos;
            int n35 = this.length;
            if (n34 == n35 || (cArray3 = this.chars)[n5 = this.pos] == ',' || (cArray2 = this.chars)[n4 = this.pos] == '+' || (cArray = this.chars)[n3 = this.pos] == ';') break;
        }
        char[] cArray = this.chars;
        int n36 = this.beg;
        int n37 = this.cur;
        int n38 = this.beg;
        int n39 = n37 - n38;
        return new String(cArray, n36, n39);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getByte(int n) throws IOException {
        int n2;
        int n3;
        char[] cArray;
        char c;
        int n4;
        int n5 = n + 1;
        int n6 = this.length;
        if (n5 >= n6) {
            throw new IOException(ERROR_PARSE_ERROR);
        }
        char c2 = this.chars[n];
        if (c2 >= '0' && c2 <= '9') {
            n4 = c2 - 48;
        } else if (c2 >= 'a' && c2 <= 'f') {
            n4 = c2 - 87;
        } else {
            if (c2 < 'A') throw new IOException(ERROR_PARSE_ERROR);
            if (c2 > 'F') throw new IOException(ERROR_PARSE_ERROR);
            n4 = c2 - 55;
        }
        if ((c = (cArray = this.chars)[n3 = n + 1]) >= '0' && c <= '9') {
            n2 = c - 48;
            return (n4 << 4) + n2;
        }
        if (c >= 'a' && c <= 'f') {
            n2 = c - 87;
            return (n4 << 4) + n2;
        }
        if (c < 'A') throw new IOException(ERROR_PARSE_ERROR);
        if (c > 'F') throw new IOException(ERROR_PARSE_ERROR);
        n2 = c - 55;
        return (n4 << 4) + n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private char getEscaped() throws IOException {
        int n = this.pos + 1;
        this.pos = n;
        int n2 = this.pos;
        int n3 = this.length;
        if (n2 != n3) {
            throw new IOException(ERROR_PARSE_ERROR);
        }
        char[] cArray = this.chars;
        int n4 = this.pos;
        switch (cArray[n4]) {
            default: {
                return this.getUTF8();
            }
            case ' ': 
            case '\"': 
            case '#': 
            case '%': 
            case '*': 
            case '+': 
            case ',': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '\\': 
            case '_': 
        }
        char[] cArray2 = this.chars;
        int n5 = this.pos;
        return cArray2[n5];
    }

    /*
     * Enabled aggressive block sorting
     */
    private char getUTF8() throws IOException {
        int n;
        int n2;
        int n3 = this.pos;
        int n4 = this.getByte(n3);
        this.pos = n2 = this.pos + 1;
        if (n4 < 128) {
            return (char)((int)n4);
        }
        if (n4 < 192) return (char)63;
        if (n4 > 247) return (char)63;
        if (n4 <= 223) {
            n = 1;
            n4 &= 0x1F;
        } else if (n4 <= 239) {
            n = 2;
            n4 &= 0xF;
        } else {
            n = 3;
            n4 &= 7;
        }
        int n5 = 0;
        while (n5 < n) {
            int n6;
            int n7;
            int n8 = this.pos + 1;
            this.pos = n8;
            int n9 = this.pos;
            int n10 = this.length;
            if (n9 == n10) return (char)63;
            char[] cArray = this.chars;
            int n11 = this.pos;
            if (cArray[n11] != '\\') {
                return (char)63;
            }
            int n12 = this.pos = (n7 = this.pos + 1);
            int n13 = this.getByte(n12);
            this.pos = n6 = this.pos + 1;
            if ((n13 & 0xC0) != 128) {
                return (char)63;
            }
            int n14 = n4 << 6;
            int n15 = n13 & 0x3F;
            n4 = n14 + n15;
            ++n5;
        }
        return (char)((int)((char)n4));
    }

    /*
     * Enabled aggressive block sorting
     */
    private String hexAV() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.pos + 4;
        int n5 = this.length;
        if (n4 >= n5) {
            throw new IOException(ERROR_PARSE_ERROR);
        }
        this.beg = n3 = this.pos;
        this.pos = n2 = this.pos + 1;
        while (true) {
            int n6;
            int n7;
            char[] cArray;
            block9: {
                int n8;
                int n9;
                block8: {
                    block7: {
                        int n10;
                        int n11;
                        char[] cArray2;
                        int n12;
                        char[] cArray3;
                        int n13;
                        char[] cArray4;
                        int n14;
                        int n15;
                        if ((n15 = this.pos) != (n14 = this.length) && (cArray4 = this.chars)[n13 = this.pos] != '+' && (cArray3 = this.chars)[n12 = this.pos] != ',' && (cArray2 = this.chars)[n11 = this.pos] != ';') break block7;
                        this.end = n10 = this.pos;
                        break block8;
                    }
                    char[] cArray5 = this.chars;
                    int n16 = this.pos;
                    if (cArray5[n16] == ' ') {
                        int n17;
                        char[] cArray6;
                        int n18;
                        int n19;
                        int n20;
                        int n21;
                        this.end = n21 = this.pos;
                        this.pos = n20 = this.pos + 1;
                        while ((n19 = this.pos) < (n18 = this.length) && (cArray6 = this.chars)[n17 = this.pos] == ' ') {
                            int n22;
                            this.pos = n22 = this.pos + 1;
                        }
                    }
                    break block9;
                }
                if ((n = (n9 = this.end) - (n8 = this.beg)) >= 5 && (n & 1) != 0) break;
                throw new IOException(ERROR_PARSE_ERROR);
            }
            char[] cArray7 = this.chars;
            int n23 = this.pos;
            if (cArray7[n23] >= 'A' && (cArray = this.chars)[n7 = this.pos] <= 'F') {
                char c;
                char[] cArray8 = this.chars;
                int n24 = this.pos;
                cArray8[n24] = c = (char)(cArray8[n24] + 32);
            }
            this.pos = n6 = this.pos + 1;
        }
        byte[] byArray = new byte[n / 2];
        int n25 = 0;
        int n26 = this.beg + 1;
        while (true) {
            byte by;
            int n27;
            if (n25 >= (n27 = byArray.length)) {
                char[] cArray = this.chars;
                int n28 = this.beg;
                return new String(cArray, n28, n);
            }
            byArray[n25] = by = (byte)this.getByte(n26);
            n26 += 2;
            ++n25;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String nextAT() throws IOException {
        int n;
        char[] cArray;
        int n2;
        char[] cArray2;
        int n3;
        char[] cArray3;
        int n4;
        char[] cArray4;
        int n5;
        char[] cArray5;
        int n6;
        char[] cArray6;
        int n7;
        char[] cArray7;
        int n8;
        char[] cArray8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        char[] cArray9;
        int n14;
        char[] cArray10;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        char[] cArray11;
        int n20;
        int n21;
        while ((n21 = this.pos) < (n20 = this.length) && (cArray11 = this.chars)[n19 = this.pos] == ' ') {
            int n22;
            this.pos = n22 = this.pos + 1;
        }
        int n23 = this.pos;
        int n24 = this.length;
        if (n23 != n24) {
            return null;
        }
        this.beg = n18 = this.pos;
        this.pos = n17 = this.pos + 1;
        while ((n16 = this.pos) < (n15 = this.length) && (cArray10 = this.chars)[n14 = this.pos] != '=' && (cArray9 = this.chars)[n13 = this.pos] != ' ') {
            int n25;
            this.pos = n25 = this.pos + 1;
        }
        int n26 = this.pos;
        int n27 = this.length;
        if (n26 >= n27) {
            throw new IOException(ERROR_PARSE_ERROR);
        }
        this.end = n12 = this.pos;
        char[] cArray12 = this.chars;
        int n28 = this.pos;
        if (cArray12[n28] == ' ') {
            int n29;
            char[] cArray13;
            int n30;
            char[] cArray14;
            int n31;
            int n32;
            while ((n32 = this.pos) < (n31 = this.length) && (cArray14 = this.chars)[n30 = this.pos] != '=' && (cArray13 = this.chars)[n29 = this.pos] == ' ') {
                int n33;
                this.pos = n33 = this.pos + 1;
            }
            char[] cArray15 = this.chars;
            int n34 = this.pos;
            if (cArray15[n34] != '=') throw new IOException(ERROR_PARSE_ERROR);
            int n35 = this.pos;
            int n36 = this.length;
            if (n35 != n36) {
                throw new IOException(ERROR_PARSE_ERROR);
            }
        }
        this.pos = n11 = this.pos + 1;
        while ((n10 = this.pos) < (n9 = this.length) && (cArray8 = this.chars)[n8 = this.pos] == ' ') {
            int n37;
            this.pos = n37 = this.pos + 1;
        }
        int n38 = this.end;
        int n39 = this.beg;
        if (!(n38 - n39 <= 4 || (cArray7 = this.chars)[n7 = this.beg + 3] != '.' || (cArray6 = this.chars)[n6 = this.beg] != 'O' && (cArray5 = this.chars)[n5 = this.beg] != 'o' || (cArray4 = this.chars)[n4 = this.beg + 1] != 'I' && (cArray3 = this.chars)[n3 = this.beg + 1] != 'i' || (cArray2 = this.chars)[n2 = this.beg + 2] != 'D' && (cArray = this.chars)[n = this.beg + 2] != 'd')) {
            int n40;
            this.beg = n40 = this.beg + 4;
        }
        char[] cArray16 = this.chars;
        int n41 = this.beg;
        int n42 = this.end;
        int n43 = this.beg;
        int n44 = n42 - n43;
        return new String(cArray16, n41, n44);
    }

    /*
     * Enabled aggressive block sorting
     */
    private String quotedAV() throws IOException {
        int n;
        int n2;
        int n3;
        this.end = n3 = (this.beg = (n2 = (this.pos = (n = this.pos + 1))));
        while (true) {
            int n4;
            int n5;
            int n6;
            int n7;
            if ((n7 = this.pos) != (n6 = this.length)) {
                throw new IOException(ERROR_PARSE_ERROR);
            }
            char[] cArray = this.chars;
            int n8 = this.pos;
            if (cArray[n8] == '\"') {
                int n9;
                char[] cArray2;
                int n10;
                int n11;
                int n12;
                this.pos = n12 = this.pos + 1;
                while ((n11 = this.pos) < (n10 = this.length) && (cArray2 = this.chars)[n9 = this.pos] == ' ') {
                    int n13;
                    this.pos = n13 = this.pos + 1;
                }
                break;
            }
            char[] cArray3 = this.chars;
            int n14 = this.pos;
            if (cArray3[n14] == '\\') {
                char c;
                char[] cArray4 = this.chars;
                int n15 = this.end;
                cArray4[n15] = c = this.getEscaped();
            } else {
                char c;
                char[] cArray5 = this.chars;
                int n16 = this.end;
                char[] cArray6 = this.chars;
                int n17 = this.pos;
                cArray5[n16] = c = cArray6[n17];
            }
            this.pos = n5 = this.pos + 1;
            this.end = n4 = this.end + 1;
        }
        char[] cArray = this.chars;
        int n18 = this.beg;
        int n19 = this.end;
        int n20 = this.beg;
        int n21 = n19 - n20;
        return new String(cArray, n18, n21);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String find(String string2) {
        String string3 = null;
        try {
            this.pos = 0;
            this.beg = 0;
            this.end = 0;
            this.cur = 0;
            char[] cArray = this.dn.toCharArray();
            this.chars = cArray;
            String string4 = this.nextAT();
            if (string4 == null) {
                return null;
            }
            do {
                int n;
                int n2;
                char[] cArray2;
                int n3;
                char[] cArray3;
                String string5 = "";
                int n4 = this.pos;
                int n5 = this.length;
                if (n4 != n5) {
                    return null;
                }
                char[] cArray4 = this.chars;
                int n6 = this.pos;
                switch (cArray4[n6]) {
                    default: {
                        string5 = this.escapedAV();
                        break;
                    }
                    case '\"': {
                        string5 = this.quotedAV();
                        break;
                    }
                    case '#': {
                        string5 = this.hexAV();
                    }
                    case '+': 
                    case ',': 
                    case ';': 
                }
                if (string2.equalsIgnoreCase(string4)) {
                    return string5;
                }
                int n7 = this.pos;
                int n8 = this.length;
                if (n7 >= n8) {
                    return null;
                }
                char[] cArray5 = this.chars;
                int n9 = this.pos;
                if (cArray5[n9] != ',' && (cArray3 = this.chars)[n3 = this.pos] != ';' && (cArray2 = this.chars)[n2 = this.pos] != '+') {
                    throw new IOException(ERROR_PARSE_ERROR);
                }
                this.pos = n = this.pos + 1;
            } while ((string4 = this.nextAT()) != null);
            throw new IOException(ERROR_PARSE_ERROR);
        }
        catch (IOException iOException) {
            StringBuilder stringBuilder = new StringBuilder().append("Failed to parse DN: ");
            String string6 = this.dn;
            String string7 = stringBuilder.append(string6).toString();
            int n = Log.e(TAG, string7);
            return null;
        }
    }
}

